/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.ChgActionMappedBean;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.EmpBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.common.constants.HpfsChgNew;
import kd.sdk.hr.hpfs.business.Repository.PersonEntityConfRepository;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.AttachmentEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.common.constants.PerModelConstants;
import kd.sdk.hr.hpfs.utils.HpfsDynamicObjectUtils;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;

public class PersonParamsUtils {
    private static final Log LOG = LogFactory.getLog(PersonParamsUtils.class);
    private static DynamicObjectType CMPEMPTYPE = EntityMetadataCache.getDataEntityType((String)"hrpi_cmpemp");
    private static String[] ENTITYNAMES = new String[]{"hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall", "hspm_ermanfile"};
    private static List<String> MODEL_ENTITY = new ArrayList<String>(Arrays.asList("hrpi_depemp", "hrpi_employee", "hrpi_person"));
    private static List<String> BENTRYNUM = new ArrayList<String>(16);
    private static List<String> AENTRYNUM = new ArrayList<String>(16);
    private static Map<String, List<Map<String, String>>> ENTITYNEEDCOPY = new HashMap<String, List<Map<String, String>>>(16);
    private static List<Map<String, String>> EMPPOS_TMP_NEEDCOPY = new ArrayList<Map<String, String>>(16);
    private static List<Map<String, String>> EMP_TMP_NEEDCOPY = new ArrayList<Map<String, String>>(16);
    private static Map<String, String> DEPEMPENTITY = new HashMap<String, String>(16);
    private static Map<String, String> EMPORGERLALLENTITY = new HashMap<String, String>(16);
    private static Map<String, String> EMPENTITY = new HashMap<String, String>(16);
    private static Map<Long, Long> HCFEDUIDHRPIEDUID = new HashMap<Long, Long>(16);
    private static final HRBaseServiceHelper PER_ENTITY_CONF_HELPER = new HRBaseServiceHelper("hrpi_personentityconf");
    private static Map<String, String> A_MAIN_ENTRY = new HashMap<String, String>(16);
    private static Map<String, String> B_MAIN_ENTRY = new HashMap<String, String>(16);

    public static void validMustInput(List<PerChgBizInfoNew> allPerList) {
        for (PerChgBizInfoNew perChgBizInfoNew : allPerList) {
            StringBuilder sb = new StringBuilder();
            if (perChgBizInfoNew.getBillId() == null || perChgBizInfoNew.getBillId() == 0L) {
                perChgBizInfoNew.setSuccess(false);
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"billId\u4e0d\u80fd\u4e3a\u7a7a;", (String)"PersonParamsBuilder_0", (String)"sdk-hr", (Object[])new Object[0]), sb);
                perChgBizInfoNew.setErrMsg(sb.toString());
            }
            if (HRStringUtils.isEmpty((String)perChgBizInfoNew.getBillSource())) {
                perChgBizInfoNew.setSuccess(false);
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"billSource\u4e0d\u80fd\u4e3a\u7a7a;", (String)"PersonParamsBuilder_2", (String)"sdk-hr", (Object[])new Object[0]), sb);
                perChgBizInfoNew.setErrMsg(sb.toString());
            }
            if (perChgBizInfoNew.getChgActionId() != null && perChgBizInfoNew.getChgActionId() != 0L) continue;
            perChgBizInfoNew.setSuccess(false);
            PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"PersonParamsBuilder_3", (String)"sdk-hr", (Object[])new Object[0]), sb);
            perChgBizInfoNew.setErrMsg(sb.toString());
        }
    }

    public static void buildErrMsg(PerChgBizInfoNew perChgBizInfoNew, String msg, StringBuilder sb) {
        sb.append(perChgBizInfoNew.getErrMsg()).append(msg);
        LOG.info("==PerChgBizInfoNew : billid:{} msg:{}==", (Object)perChgBizInfoNew.getBillId(), (Object)perChgBizInfoNew.getErrMsg());
    }

    public static void buildErrMsg(PerChgBizInfoNew perChgBizInfoNew, String msg) {
        perChgBizInfoNew.setErrMsg(perChgBizInfoNew.getErrMsg() + msg);
        LOG.info("==PerChgBizInfoNew : billid:{} msg:{}==", (Object)perChgBizInfoNew.getBillId(), (Object)perChgBizInfoNew.getErrMsg());
    }

    public static void buildFailMsg(PerChgBizInfoNew perChgBizInfoNew, String msg) {
        perChgBizInfoNew.setErrMsg(perChgBizInfoNew.getErrMsg() + msg);
        perChgBizInfoNew.setSuccess(false);
        LOG.info("==PerChgBizInfoNew : billid:{} failMsg:{}==", (Object)perChgBizInfoNew.getBillId(), (Object)perChgBizInfoNew.getErrMsg());
    }

    public static List<PersonBean> setChgPerListByDy(DynamicObject target) {
        ArrayList<PersonBean> perBeanList = new ArrayList<PersonBean>(4);
        PersonBean perBean = new PersonBean();
        PersonParamsUtils.setBeforePerInfo(perBean, target);
        PersonParamsUtils.setAfterPerInfo(perBean, target);
        perBeanList.add(perBean);
        return perBeanList;
    }

    private static void setAfterPerInfo(PersonBean perBean, DynamicObject target) {
        String chgType = target.getString("ba_p_chgtype");
        perBean.setaPersonId(target.getLong("ba_p_tid"));
        perBean.setaChgMethod(chgType);
    }

    private static void setBeforePerInfo(PersonBean perBean, DynamicObject target) {
        String chgType = target.getString("bb_p_chgtype");
        perBean.setbPersonId(target.getLong("bb_p_tid"));
        perBean.setbChgMethod(chgType);
    }

    public static List<PersonBean> setChgPerListByDyCollect(DynamicObjectCollection bPerCollection, DynamicObjectCollection aPerCollection) {
        ArrayList<PersonBean> perBeanList = new ArrayList<PersonBean>(4);
        PersonBean perBean = new PersonBean();
        if (!CollectionUtils.isEmpty((Collection)bPerCollection)) {
            DynamicObject bDy = (DynamicObject)bPerCollection.get(0);
            PersonParamsUtils.setBeforePer(perBean, bDy);
        }
        if (!CollectionUtils.isEmpty((Collection)aPerCollection)) {
            DynamicObject aDy = (DynamicObject)aPerCollection.get(0);
            PersonParamsUtils.setAfterPer(perBean, aDy);
        }
        perBeanList.add(perBean);
        return perBeanList;
    }

    private static void setAfterPer(PersonBean perBean, DynamicObject aDy) {
        perBean.setaPersonId(aDy.getLong("a_p_tid"));
        perBean.setaChgMethod(aDy.getString("a_p_chgtype"));
    }

    private static void setBeforePer(PersonBean perBean, DynamicObject bDy) {
        perBean.setbPersonId(bDy.getLong("b_p_tid"));
        perBean.setbChgMethod(bDy.getString("b_p_chgtype"));
    }

    public static List<EmpBean> setChgEmpListByDy(DynamicObject target) {
        ArrayList<EmpBean> empBeanList = new ArrayList<EmpBean>(4);
        EmpBean empBean = new EmpBean();
        PersonParamsUtils.setBeforeEmpInfo(empBean, target);
        PersonParamsUtils.setAfterEmpInfo(empBean, target);
        empBeanList.add(empBean);
        return empBeanList;
    }

    private static void setBeforeEmpInfo(EmpBean empBean, DynamicObject target) {
        String chgType = target.getString("bb_e_chgtype");
        empBean.setbEmpId(target.getLong("bb_e_tid"));
        empBean.setbChgMethod(chgType);
        empBean.setbEmpnumber(target.getString("bb_e_empnumber"));
        empBean.setbStartdate(target.getDate("bb_e_startdate"));
        empBean.setbEnddate(target.getDate("bb_e_enddate"));
        empBean.setbEnterpriseDy(target.getDynamicObject("bb_e_enterprise"));
        empBean.setbLaborreltypeDy(target.getDynamicObject("beforelaborreltype"));
        empBean.setbLaborrelstatusDy(target.getDynamicObject("beforelaborrelstatus"));
        empBean.setbBsed(target.getDate("b_effectivedate"));
        empBean.setbBsled(target.getDate("bb_e_bsled"));
        empBean.setbSysEnddate(target.getDate("bb_e_sysenddate"));
    }

    private static void setAfterEmpInfo(EmpBean empBean, DynamicObject target) {
        String chgType = target.getString("ba_e_chgtype");
        empBean.setaEmpId(target.getLong("ba_e_tid"));
        empBean.setaChgMethod(chgType);
        empBean.setaEmpnumber(target.getString("ba_e_empnumber"));
        empBean.setaStartdate(target.getDate("ba_e_startdate"));
        empBean.setaEnddate(target.getDate("ba_e_enddate"));
        empBean.setaEnterpriseDy(target.getDynamicObject("ba_e_enterprise"));
        empBean.setaLaborreltypeDy(target.getDynamicObject("laborreltype"));
        empBean.setaLaborrelstatusDy(target.getDynamicObject("laborrelstatus"));
        empBean.setaBsed(target.getDate("b_effectivedate"));
        empBean.setaBsled(target.getDate("ba_e_bsled"));
        empBean.setaSysEnddate(target.getDate("ba_e_sysenddate"));
    }

    public static void setTplPropertyFromBill(DynamicObject dy) {
        String name;
        if (dy.getDataEntityType().getProperties().containsKey((Object)"entry_a_person")) {
            return;
        }
        switch (name = dy.getDataEntityType().getName()) {
            case "hom_onbrdbilltpl": 
            case "hom_onbrdinfo": {
                PersonParamsUtils.setOnbrdProperty(dy);
                break;
            }
            case "hdm_regbasebill": {
                PersonParamsUtils.setRegProperty(dy);
                break;
            }
            case "hdm_transferbasebill": 
            case "hdm_mytransferbill": 
            case "hdm_transferapply": 
            case "hdm_transferinbill": {
                PersonParamsUtils.setTransferProperty(dy);
                break;
            }
            case "hdm_parttimeapplybill": 
            case "hdm_baseparttimebill": {
                PersonParamsUtils.setParttimeProperty(dy);
                break;
            }
            case "hdm_parttimeendbill": {
                PersonParamsUtils.setParttimeEndProperty(dy);
                break;
            }
            case "ham_dispatch": 
            case "ham_dispatchin": 
            case "ham_dispatchout": {
                PersonParamsUtils.setDispatchProperty(dy);
                break;
            }
            case "ham_dispback": {
                PersonParamsUtils.setDispBackProperty(dy);
                break;
            }
            case "htm_quitapplybasebill": 
            case "htm_quitapply": 
            case "htm_quitapplyfast": 
            case "htm_quitapplyemp": {
                PersonParamsUtils.setQuitProperty(dy);
                break;
            }
            default: {
                LOG.info("==setTplPropertyFromBill_NOT_STARD==");
            }
        }
    }

    private static void setQuitProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.QUIT_FIELD_MAPPING);
    }

    private static void setDispBackProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.DISPBACK_FIELD_MAPPING);
        dy.set("bb_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
        DynamicObject ermanfile = dy.getDynamicObject("ermanfile");
        dy.set("bb_d_tid", ermanfile.get("depemp.id"));
        if (Objects.nonNull(dy.get("org"))) {
            dy.set("bb_d_org", dy.get("org"));
        }
        dy.set("bb_d_enddate", (Object)PersonParamsUtils.getEndDate(dy));
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            DynamicObject poststate = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("posstatus", (Object)poststate);
        }
    }

    private static Date getEndDate(DynamicObject dy) {
        return "0".equals(dy.getString("genbytermrecord")) ? dy.getDate("enddate") : dy.getDate("backdate");
    }

    private static void setDispatchProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.DISPATCH_FIELD_MAPPING);
        DynamicObject erFile = dy.getDynamicObject("ermanfile");
        dy.set("bb_d_tid", erFile.get("depemp.id"));
        DynamicObject postState = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1050L));
        dy.set("beforeposstatus", (Object)postState);
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            DynamicObject postype = new HRBaseServiceHelper("hbss_postype").loadDynamicObject(new QFilter("id", "=", (Object)1040L));
            dy.set("postype", (Object)postype);
            DynamicObject poststate = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("posstatus", (Object)poststate);
        }
        dy.set("ba_d_apositiontype", dy.get("inradiogroupfield"));
        if (HRObjectUtils.isEmpty((Object)dy.get("ba_d_isprimary"))) {
            dy.set("ba_d_isprimary", (Object)"0");
        }
        dy.set("ba_d_orgnumbervid", dy.get("adminorglongnuminvid"));
        dy.set("ba_d_startdate", dy.get("startdate"));
        dy.set("ba_d_enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
    }

    private static void setParttimeEndProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.PARTTIMEEND_FIELD_MAPPING);
        dy.set("beforeposstatus", null);
    }

    private static void setParttimeProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.PARTTIME_FIELD_MAPPING);
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            DynamicObject posType = new HRBaseServiceHelper("hbss_postype").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("postype", (Object)posType);
            DynamicObject postState = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("posstatus", (Object)postState);
        }
        dy.set("ba_d_enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
    }

    private static void setTransferProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.TRANSFER_FIELD_MAPPING);
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            dy.set("postype", (Object)dy.getDynamicObject("beforepostype"));
        }
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("posstatus"))) {
            dy.set("posstatus", (Object)dy.getDynamicObject("beforeposstatus"));
        }
        dy.set("ba_d_enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dy.set("bb_d_enddate", (Object)HRDateTimeUtils.addDay((Date)dy.getDate("realitydate"), (long)-1L));
        if (HRStringUtils.isEmpty((String)dy.getString("ba_d_isprimary"))) {
            dy.set("ba_d_isprimary", (Object)"1");
        }
    }

    private static void setRegProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.REG_FIELD_MAPPING);
    }

    private static void setOnbrdProperty(DynamicObject dy) {
        PersonParamsUtils.setRegularField(dy, HpfsChgNew.ONBRD_FIELD_MAPPING);
        dy.set("ba_d_enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dy.set("ba_e_enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("postype"))) {
            DynamicObject posType = new HRBaseServiceHelper("hbss_postype").loadDynamicObject(new QFilter("id", "=", (Object)1040L));
            dy.set("beforepostype", (Object)posType);
            DynamicObject postState = new HRBaseServiceHelper("hbss_poststate").loadDynamicObject(new QFilter("id", "=", (Object)1020L));
            dy.set("beforeposstatus", (Object)postState);
        }
        if (HRObjectUtils.isEmpty((Object)dy.get("ba_d_isprimary"))) {
            dy.set("ba_d_isprimary", (Object)"1");
        }
    }

    private static void setRegularField(DynamicObject dy, Map<String, String> fieldMap) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String tplKey = entry.getKey();
            String billKey = entry.getValue();
            if (!properties.containsKey((Object)billKey) || !properties.containsKey((Object)tplKey)) continue;
            dy.set(tplKey, dy.get(billKey));
        }
    }

    public static List<EmpBean> setChgEmpListByDycollect(DynamicObjectCollection bCollection, DynamicObjectCollection aCollection) {
        ArrayList<EmpBean> empBeanList = new ArrayList<EmpBean>(4);
        EmpBean empBean = new EmpBean();
        if (!CollectionUtils.isEmpty((Collection)bCollection)) {
            DynamicObject bDy = (DynamicObject)bCollection.get(0);
            PersonParamsUtils.setBeforeEmp(bDy, empBean);
        }
        if (!CollectionUtils.isEmpty((Collection)aCollection)) {
            DynamicObject aDy = (DynamicObject)aCollection.get(0);
            PersonParamsUtils.setAfterEmp(aDy, empBean);
        }
        empBeanList.add(empBean);
        return empBeanList;
    }

    private static void setBeforeEmp(DynamicObject bDy, EmpBean empBean) {
        empBean.setbEmpId(bDy.getLong("b_e_tid"));
        empBean.setbChgMethod(bDy.getString("b_e_chgtype"));
        empBean.setbEmpnumber(bDy.getString("b_e_empnumber"));
        empBean.setbStartdate(bDy.getDate("b_e_startdate"));
        empBean.setbEnddate(bDy.getDate("b_e_enddate"));
        empBean.setbEnterpriseDy(bDy.getDynamicObject("b_e_enterprise"));
        empBean.setbLaborreltypeDy(bDy.getDynamicObject("b_e_laborreltype"));
        empBean.setbLaborrelstatusDy(bDy.getDynamicObject("b_e_laborrelstatus"));
        empBean.setbBsed(bDy.getDate("b_e_bsed"));
        empBean.setbBsled(bDy.getDate("b_e_bsled"));
        empBean.setbSysEnddate(bDy.getDate("b_e_sysenddate"));
    }

    private static void setAfterEmp(DynamicObject aDy, EmpBean empBean) {
        empBean.setaEmpId(aDy.getLong("a_e_tid"));
        empBean.setaChgMethod(aDy.getString("a_e_chgtype"));
        empBean.setaEmpnumber(aDy.getString("a_e_empnumber"));
        empBean.setaStartdate(aDy.getDate("a_e_startdate"));
        empBean.setaEnddate(aDy.getDate("a_e_enddate"));
        empBean.setaEnterpriseDy(aDy.getDynamicObject("a_e_enterprise"));
        empBean.setaLaborreltypeDy(aDy.getDynamicObject("a_e_laborreltype"));
        empBean.setaLaborrelstatusDy(aDy.getDynamicObject("a_e_laborrelstatus"));
        empBean.setaLaborrelstatusDy(aDy.getDynamicObject("a_e_laborrelstatus"));
        empBean.setaBsed(aDy.getDate("a_e_bsed"));
        empBean.setaBsled(aDy.getDate("a_e_bsled"));
        empBean.setaSysEnddate(aDy.getDate("a_e_sysenddate"));
    }

    public static List<DepempBean> setChgDepmListByDycollect(DynamicObjectCollection bCollection, DynamicObjectCollection aCollection) {
        ArrayList<DepempBean> depemBeanList;
        block10: {
            block9: {
                DepempBean depempBean;
                DynamicObject bDy;
                int i;
                depemBeanList = new ArrayList<DepempBean>(4);
                if (CollectionUtils.isEmpty((Collection)bCollection) || CollectionUtils.isEmpty((Collection)aCollection)) break block9;
                int max = Math.max(bCollection.size(), aCollection.size());
                int min = Math.min(bCollection.size(), aCollection.size());
                for (i = 0; i < min; ++i) {
                    bDy = (DynamicObject)bCollection.get(i);
                    DynamicObject aDy = (DynamicObject)aCollection.get(i);
                    DepempBean depempBean2 = new DepempBean();
                    PersonParamsUtils.setBeforeDep(bDy, depempBean2);
                    PersonParamsUtils.setAfterDep(aDy, depempBean2);
                    depemBeanList.add(depempBean2);
                }
                if (aCollection.size() > min) {
                    for (i = min; i < max; ++i) {
                        DynamicObject aDy = (DynamicObject)aCollection.get(i);
                        depempBean = new DepempBean();
                        PersonParamsUtils.setAfterDep(aDy, depempBean);
                        depemBeanList.add(depempBean);
                    }
                }
                if (bCollection.size() <= min) break block10;
                for (i = min; i < max; ++i) {
                    bDy = (DynamicObject)bCollection.get(i);
                    depempBean = new DepempBean();
                    PersonParamsUtils.setBeforeDep(bDy, depempBean);
                    depemBeanList.add(depempBean);
                }
                break block10;
            }
            if (!CollectionUtils.isEmpty((Collection)bCollection)) {
                for (DynamicObject bDy : bCollection) {
                    DepempBean depempBean = new DepempBean();
                    PersonParamsUtils.setBeforeDep(bDy, depempBean);
                    depemBeanList.add(depempBean);
                }
            } else if (!CollectionUtils.isEmpty((Collection)aCollection)) {
                for (DynamicObject aDy : aCollection) {
                    DepempBean depempBean = new DepempBean();
                    PersonParamsUtils.setAfterDep(aDy, depempBean);
                    depemBeanList.add(depempBean);
                }
            }
        }
        return depemBeanList;
    }

    public static List<DepempBean> setChgDepmListByDy(DynamicObject target) {
        ArrayList<DepempBean> depemBeanList = new ArrayList<DepempBean>(4);
        DepempBean depempBean = new DepempBean();
        PersonParamsUtils.setBeforeDepInfo(depempBean, target);
        PersonParamsUtils.setAfterDepInfo(depempBean, target);
        depemBeanList.add(depempBean);
        return depemBeanList;
    }

    private static void setBeforeDepInfo(DepempBean depempBean, DynamicObject bDy) {
        String bChgType = bDy.getString("bb_d_chgtype");
        depempBean.setbChgMethod(bChgType);
        depempBean.setbDepempId(bDy.getLong("bb_d_tid"));
        depempBean.setbAdminorg(bDy.getDynamicObject("bb_d_adminorg"));
        depempBean.setbPosition(bDy.getDynamicObject("bb_d_position"));
        depempBean.setbJob(bDy.getDynamicObject("bb_d_job"));
        depempBean.setbStdposition(bDy.getDynamicObject("bb_d_stdposition"));
        depempBean.setbPostype(bDy.getDynamicObject("beforepostype"));
        depempBean.setbPosstatus(bDy.getDynamicObject("beforeposstatus"));
        depempBean.setbStartdate(bDy.getDate("bb_d_startdate"));
        depempBean.setbEnddate(bDy.getDate("bb_d_enddate"));
        depempBean.setbBusinessStatus(bDy.getString("bb_d_businessstatus"));
        depempBean.setbOrg(bDy.getDynamicObject("bb_d_org"));
        depempBean.setbEmpgroup(bDy.getDynamicObject("bb_d_empgroup"));
        depempBean.setbAffiliateadminorg(bDy.getDynamicObject("bb_d_affiliateadminorg"));
        depempBean.setbBsed(bDy.getDate("b_effectivedate"));
        depempBean.setbBsled(bDy.getDate("bb_d_bsled"));
        depempBean.setbManagescope(bDy.getDynamicObject("bb_d_cmpemp"));
    }

    private static void setAfterDepInfo(DepempBean depempBean, DynamicObject aDy) {
        String aChgType = aDy.getString("ba_d_chgtype");
        depempBean.setaChgMethod(aChgType);
        depempBean.setaDeempId(aDy.getLong("ba_d_tid"));
        depempBean.setaAdminorg(aDy.getDynamicObject("ba_d_adminorg"));
        depempBean.setaPosition(aDy.getDynamicObject("ba_d_position"));
        depempBean.setaJob(aDy.getDynamicObject("ba_d_job"));
        depempBean.setaStdposition(aDy.getDynamicObject("ba_d_stdposition"));
        depempBean.setaPostype(aDy.getDynamicObject("postype"));
        depempBean.setaPosstatus(aDy.getDynamicObject("posstatus"));
        depempBean.setaStartdate(aDy.getDate("ba_d_startdate"));
        depempBean.setaEnddate(aDy.getDate("ba_d_enddate"));
        depempBean.setaBusinessStatus(aDy.getString("ba_d_businessstatus"));
        depempBean.setaOrg(aDy.getDynamicObject("ba_d_org"));
        depempBean.setaEmpgroup(aDy.getDynamicObject("ba_d_empgroup"));
        depempBean.setaAffiliateadminorg(aDy.getDynamicObject("ba_d_affiliateadminorg"));
        depempBean.setaErfileId(aDy.getLong("ba_d_mtid"));
        depempBean.setaManagescopeId(aDy.getLong("ba_d_cmpemp_id"));
        depempBean.setaManagescope(aDy.getDynamicObject("ba_d_cmpemp"));
        depempBean.setaBsed(aDy.getDate("b_effectivedate"));
        depempBean.setaBsled(aDy.getDate("ba_d_bsled"));
        DataEntityPropertyCollection properties = aDy.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"ba_d_apositiontype") && HRStringUtils.isNotEmpty((String)aDy.getString("ba_d_apositiontype"))) {
            depempBean.setaPositionType(aDy.getString("ba_d_apositiontype"));
        } else if (properties.containsKey((Object)"a_d_apositiontype")) {
            depempBean.setaPositionType(aDy.getString("a_d_apositiontype"));
        }
        if (properties.containsKey((Object)"ba_d_isprimary") && HRStringUtils.isNotEmpty((String)aDy.getString("ba_d_isprimary"))) {
            depempBean.setaIsPrimary(aDy.getString("ba_d_isprimary"));
        } else if (properties.containsKey((Object)"a_d_isprimary")) {
            depempBean.setaIsPrimary(aDy.getString("a_d_isprimary"));
        }
        LOG.info("==setAfterDepInfo_depempBean.getaPositionType() :{}==", (Object)depempBean.getaPositionType());
    }

    public static void initChgAction(List<PerChgBizInfoNew> allPerList, DynamicObject[] chgAction) {
        Map<Long, DynamicObject> idDy = Arrays.stream(chgAction).collect(Collectors.toMap(chg -> chg.getLong("id"), chg -> chg, (oldVal, newVal) -> newVal));
        for (PerChgBizInfoNew perChgBizInfoNew : allPerList) {
            Long actionId = perChgBizInfoNew.getChgActionId();
            perChgBizInfoNew.setChgActionDy(idDy.get(actionId));
        }
    }

    private static void setAfterDep(DynamicObject aDy, DepempBean depempBean) {
        depempBean.setaChgMethod(aDy.getString("a_d_chgtype"));
        depempBean.setaDeempId(aDy.getLong("a_d_tid"));
        depempBean.setaAdminorg(aDy.getDynamicObject("a_d_adminorg"));
        depempBean.setaPosition(aDy.getDynamicObject("a_d_position"));
        depempBean.setaJob(aDy.getDynamicObject("a_d_job"));
        LOG.info("==aDy.getDynamicObject(HpfsChgNew.D_A_JOB) :{}==", (Object)aDy.getDynamicObject("a_d_job"));
        LOG.info("==depempBean.getaJob() :{}==", (Object)depempBean.getaJob());
        depempBean.setaStdposition(aDy.getDynamicObject("a_d_stdposition"));
        depempBean.setaPostype(aDy.getDynamicObject("a_d_postype"));
        depempBean.setaPosstatus(aDy.getDynamicObject("a_d_posstatus"));
        depempBean.setaStartdate(aDy.getDate("a_d_startdate"));
        depempBean.setaEnddate(aDy.getDate("a_d_enddate"));
        depempBean.setaBusinessStatus(aDy.getString("a_d_businessstatus"));
        depempBean.setaOrg(aDy.getDynamicObject("a_d_org"));
        depempBean.setaEmpgroup(aDy.getDynamicObject("a_d_empgroup"));
        depempBean.setaAffiliateadminorg(aDy.getDynamicObject("a_d_affiliateadminorg"));
        depempBean.setaErfileId(aDy.getLong("a_d_mtid"));
        depempBean.setaManagescopeId(aDy.getLong("a_d_cmpemp_id"));
        depempBean.setaManagescope(aDy.getDynamicObject("a_d_cmpemp"));
        depempBean.setaBsed(aDy.getDate("a_d_bsed"));
        depempBean.setaBsled(aDy.getDate("a_d_bsled"));
        if (aDy.getDataEntityType().getProperties().containsKey((Object)"a_d_apositiontype")) {
            depempBean.setaPositionType(aDy.getString("a_d_apositiontype"));
        }
        if (aDy.getDataEntityType().getProperties().containsKey((Object)"a_d_isprimary")) {
            depempBean.setaIsPrimary(aDy.getString("a_d_isprimary"));
        }
    }

    private static void setBeforeDep(DynamicObject bDy, DepempBean depempBean) {
        depempBean.setbChgMethod(bDy.getString("b_d_chgtype"));
        depempBean.setbDepempId(bDy.getLong("b_d_tid"));
        depempBean.setbAdminorg(bDy.getDynamicObject("b_d_adminorg"));
        depempBean.setbPosition(bDy.getDynamicObject("b_d_position"));
        depempBean.setbJob(bDy.getDynamicObject("b_d_job"));
        depempBean.setbStdposition(bDy.getDynamicObject("b_d_stdposition"));
        depempBean.setbPostype(bDy.getDynamicObject("b_d_postype"));
        depempBean.setbPosstatus(bDy.getDynamicObject("b_d_posstatus"));
        depempBean.setbStartdate(bDy.getDate("b_d_startdate"));
        depempBean.setbEnddate(bDy.getDate("b_d_enddate"));
        depempBean.setbBusinessStatus(bDy.getString("b_d_businessstatus"));
        depempBean.setbOrg(bDy.getDynamicObject("b_d_org"));
        depempBean.setbEmpgroup(bDy.getDynamicObject("b_d_empgroup"));
        depempBean.setbAffiliateadminorg(bDy.getDynamicObject("b_d_affiliateadminorg"));
        depempBean.setbBsed(bDy.getDate("b_d_bsed"));
        depempBean.setbBsled(bDy.getDate("b_d_bsled"));
        depempBean.setbManagescope(bDy.getDynamicObject("b_d_cmpemp"));
    }

    public static void wrapSameFieldFromSourceForInit(DynamicObject target, DynamicObject source) {
        PersonParamsUtils.wrapSameFieldFromSource(target, source, new HashSet<String>(Arrays.asList("id", "multilanguagetext", "description", "initstatus", "creator", "creator_id", "modifier", "modifier_id", "createtime", "modifytime", "initdatasource", "boid", "iscurrentversion", "datastatus", "sourcevid", "ismodify", "hisversion", "changedescription")));
    }

    public static void wrapSameFieldFromSource(DynamicObject target, DynamicObject source, HashSet<String> ignoreFields) {
        DataEntityPropertyCollection targetFields = target.getDynamicObjectType().getProperties();
        BillEntityType sourceType = (BillEntityType)source.getDynamicObjectType();
        targetFields.stream().filter(field -> {
            String fieldName = field.getName();
            return CollectionUtils.isEmpty((Collection)ignoreFields) || !ignoreFields.contains(fieldName);
        }).forEach(field -> {
            String fieldName = field.getName();
            IDataEntityProperty property = sourceType.findProperty(fieldName);
            if (property != null) {
                target.set(fieldName, source.get(fieldName));
            }
        });
    }

    public static void wrapPropsFromSourceToDy(String[] props, DynamicObject source, DynamicObject target) {
        for (String field : props) {
            try {
                target.set(field, source.get(field));
            }
            catch (Exception ext) {
                LOG.error("InitValidateUtil_wrapPropsFromSourceToDy_eroor:", (Throwable)ext);
            }
        }
    }

    public static void setPositionVal(DynamicObject depDy, DepempBean depempBean, boolean hasJob, boolean isAfter) {
        if (isAfter) {
            depDy.set("position", (Object)depempBean.getaPosition());
            depDy.set("stdposition", (Object)depempBean.getaStdposition());
            if (hasJob) {
                depDy.set("job", (Object)depempBean.getaJob());
                LOG.info("==depempBean.getaJob():{}==", (Object)depempBean.getaJob());
            }
            LOG.info("==depDy:{}==", (Object)depDy);
        } else {
            depDy.set("position", (Object)depempBean.getbPosition());
            depDy.set("stdposition", (Object)depempBean.getbStdposition());
            if (hasJob) {
                depDy.set("job", (Object)depempBean.getbJob());
            }
        }
    }

    public static String getPostType(DepempBean depempBean, boolean isAfter) {
        if (isAfter) {
            if (depempBean.getaPosition() != null) {
                return "1";
            }
            if (depempBean.getaStdposition() != null) {
                return "0";
            }
            if (depempBean.getaJob() != null) {
                return "2";
            }
        } else {
            if (depempBean.getbPosition() != null) {
                return "1";
            }
            if (depempBean.getbStdposition() != null) {
                return "0";
            }
            if (depempBean.getbJob() != null) {
                return "2";
            }
        }
        return "1";
    }

    public static void readFieldMapped(List<PerChgBizInfoNew> successData) {
        LOG.info("==begin readFieldMapped=");
        Map<Long, List<PerChgBizInfoNew>> actionIdBizInfoMap = successData.stream().collect(Collectors.groupingBy(PerChgBizInfoNew::getChgActionId));
        List<ChgActionMappedBean> actionMappedBeanList = HPFSNewChgHelper.queryMapped(actionIdBizInfoMap.keySet());
        HashMap<String, Map<String, Set<Long>>> querySourceEntity = new HashMap<String, Map<String, Set<Long>>>(8);
        for (ChgActionMappedBean mappedBean : actionMappedBeanList) {
            Long actionId = mappedBean.getChgActionId();
            if (!mappedBean.isSuccess()) {
                String errMsg = mappedBean.getErrMsg();
                List<PerChgBizInfoNew> bizInfoNews = actionIdBizInfoMap.get(actionId);
                if (!CollectionUtils.isEmpty(bizInfoNews)) {
                    LOG.info("==mappedBean {}==", (Object)errMsg);
                    PersonParamsUtils.setPerChgBizInfoNewFail(bizInfoNews, errMsg);
                }
                return;
            }
            List<PerChgBizInfoNew> bizInfoNews = actionIdBizInfoMap.get(actionId);
            if (CollectionUtils.isEmpty(bizInfoNews)) continue;
            DynamicObject mappedDy = mappedBean.getMappedDy();
            DynamicObject actionDy = mappedBean.getChgActionDy();
            DynamicObject chgcategoryDy = actionDy.getDynamicObject("chgcategory");
            if (chgcategoryDy == null) {
                String errMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u5927\u7c7b\u4e0d\u5b58\u5728\uff1b", (String)"PersonParamsBuilder_8", (String)"sdk-hr", (Object[])new Object[0]);
                PersonParamsUtils.setPerChgBizInfoNewFail(bizInfoNews, errMsg);
                continue;
            }
            if (mappedDy == null) {
                LOG.info("==PerChgBizInfoNew : chgactionId:{}, mappedDy is null", (Object)bizInfoNews.get(0).getChgActionId());
                continue;
            }
            DynamicObjectCollection tableColl = mappedDy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)tableColl)) {
                LOG.info("==PerChgBizInfoNew : chgactionId:{}, fieldMap is null", (Object)bizInfoNews.get(0).getChgActionId());
                continue;
            }
            for (PerChgBizInfoNew bizInfoNew : bizInfoNews) {
                for (DynamicObject tableDy : tableColl) {
                    PersonParamsUtils.buildModifyMap(chgcategoryDy, querySourceEntity, bizInfoNew, tableDy);
                }
            }
        }
        HashMap<String, Map<Long, DynamicObject>> modifyIdDyMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        for (Map.Entry entry : querySourceEntity.entrySet()) {
            String entityNum = (String)entry.getKey();
            Map val = (Map)entry.getValue();
            if (CollectionUtils.isEmpty((Map)val)) continue;
            String qryCodition = (String)val.entrySet().iterator().next().getKey();
            QFilter filter = new QFilter(qryCodition, "in", val.get(qryCodition));
            modifyIdDyMap.computeIfAbsent(entityNum, map -> new HashMap()).putAll(PersonParamsUtils.queryModifyDataSetKey(filter, entityNum, qryCodition));
        }
        LOG.info("==successData.is {}", successData);
        successData = PersonParamsUtils.initBizInfoNew(successData);
        if (CollectionUtils.isEmpty(successData)) {
            LOG.info("==successData.is empty");
            return;
        }
        PersonParamsUtils.formMappedData(modifyIdDyMap, actionIdBizInfoMap, actionMappedBeanList);
    }

    private static void formMappedData(Map<String, Map<Long, DynamicObject>> modifyIdDyMap, Map<Long, List<PerChgBizInfoNew>> actionIdBizInfoMap, List<ChgActionMappedBean> actionMappedBeanList) {
        LOG.info("==formMappedData.begin==");
        for (ChgActionMappedBean mappedBean : actionMappedBeanList) {
            Long actionId = mappedBean.getChgActionId();
            List<PerChgBizInfoNew> perChgBizInfoNews = actionIdBizInfoMap.get(actionId);
            DynamicObject mappedDy = mappedBean.getMappedDy();
            if (mappedDy == null) {
                LOG.info("==formMappedData mappedDy is null==", perChgBizInfoNews);
                continue;
            }
            DynamicObject actionDy = mappedBean.getChgActionDy();
            DynamicObject chgcategoryDy = actionDy.getDynamicObject("chgcategory");
            DynamicObjectCollection candidateMapColl = mappedDy.getDynamicObjectCollection("entryentity_c");
            DynamicObjectCollection billMapColl = mappedDy.getDynamicObjectCollection("entryentity");
            for (PerChgBizInfoNew bizInfoNew : perChgBizInfoNews) {
                block26: for (DynamicObject billTableDy : billMapColl) {
                    DynamicObject sourceEntity = billTableDy.getDynamicObject("sourceentity");
                    DynamicObject targetEntity = billTableDy.getDynamicObject("targetentity");
                    String sourceEntry = billTableDy.getString("sourceentry");
                    if (sourceEntity == null || targetEntity == null) {
                        LOG.info("==formMappedData sourceEntity or targetEntity or  pairType is not write==", perChgBizInfoNews);
                        continue;
                    }
                    DynamicObjectCollection fieldEntry = billTableDy.getDynamicObjectCollection("subentryentity");
                    if (CollectionUtils.isEmpty((Collection)fieldEntry)) {
                        LOG.info("==formMappedData fieldEntry is null==", perChgBizInfoNews);
                        continue;
                    }
                    List fieldEntrys = fieldEntry.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("writepersoninfo")).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(fieldEntrys)) {
                        LOG.info("==formMappedData fieldEntrys is null==", perChgBizInfoNews);
                        continue;
                    }
                    fieldEntry = new DynamicObjectCollection();
                    fieldEntry.addAll(fieldEntrys);
                    String sourceNum = sourceEntity.getString("number");
                    String targetNum = targetEntity.getString("number");
                    DynamicObject sourceTrueData = bizInfoNew.getDy();
                    long eventId = chgcategoryDy.getLong("chgevent.id");
                    if ("n_extinfo_fields".equals(sourceEntry)) {
                        LOG.info("###formMappedData n_extinfo_fields is start==", perChgBizInfoNews);
                        PersonParamsUtils.dealMappingExtFields(bizInfoNew, targetEntity, fieldEntry, targetNum, sourceTrueData, true);
                        PersonParamsUtils.dealMappingExtFields(bizInfoNew, targetEntity, fieldEntry, targetNum, sourceTrueData, false);
                        LOG.info("###formMappedData n_extinfo_fields is end==", perChgBizInfoNews);
                        continue;
                    }
                    if (HRStringUtils.isEmpty((String)sourceEntry) || HRStringUtils.equals((String)sourceNum, (String)sourceEntry)) {
                        LOG.info("==formMappedData sourceEntry is null or sourceEntry is null==", (Object)bizInfoNew);
                        continue;
                    }
                    if (sourceTrueData.getDynamicObjectType().getProperties().get((Object)sourceEntry) == null) {
                        LOG.info("==sourceEntry not exist==");
                        continue;
                    }
                    DynamicObjectCollection sourceTrueDataEntry = sourceTrueData.getDynamicObjectCollection(sourceEntry);
                    if (CollectionUtils.isEmpty((Collection)sourceTrueDataEntry)) {
                        LOG.info("==sourceTrueDataEntry is null :{}", (Object)bizInfoNew);
                        continue;
                    }
                    DataEntityPropertyCollection sourceProCol = ((DynamicObject)sourceTrueDataEntry.get(0)).getDynamicObjectType().getProperties();
                    if (BENTRYNUM.contains(sourceEntry) || AENTRYNUM.contains(sourceEntry)) {
                        String hasId = "";
                        String hasChgType = "";
                        for (IDataEntityProperty pro : sourceProCol) {
                            String name = pro.getName();
                            if (name.contains("_chgtype")) {
                                hasChgType = name;
                                continue;
                            }
                            if (!name.contains("_tid")) continue;
                            hasId = name;
                        }
                        switch (targetNum) {
                            case "hrpi_empposorgrel": 
                            case "hrpi_empentrel": 
                            case "hspm_ermanfile": 
                            case "hrpi_pernontsprop": 
                            case "hrpi_pertsprop": 
                            case "hrpi_person": {
                                LOG.info("==dealTemplate3PersonData==");
                                PersonParamsUtils.dealTemplate3PersonData(bizInfoNew, fieldEntry, targetNum, sourceTrueDataEntry, hasId, hasChgType);
                                break;
                            }
                            default: {
                                LOG.info("==not 3 person not deal==", (Object)bizInfoNew);
                                break;
                            }
                        }
                        continue;
                    }
                    switch (targetNum) {
                        case "hrpi_empposorgrel": 
                        case "hrpi_empentrel": 
                        case "hspm_ermanfile": 
                        case "hrpi_pernontsprop": 
                        case "hrpi_pertsprop": 
                        case "hrpi_person": {
                            LOG.info("==deal3Person==");
                            PersonParamsUtils.deal3PersonData(modifyIdDyMap, bizInfoNew, fieldEntry, targetNum, sourceTrueDataEntry, sourceProCol);
                            continue block26;
                        }
                        case "hrpi_managingscope": {
                            LOG.info("==PAGE_MANAGING_SCOPE==");
                            PersonParamsUtils.dealCmpemp(modifyIdDyMap, bizInfoNew, fieldEntry, targetNum, sourceTrueDataEntry, sourceProCol);
                            continue block26;
                        }
                    }
                    LOG.info("==dealDefaultData==");
                    PersonParamsUtils.dealDefaultData(modifyIdDyMap, bizInfoNew, fieldEntry, targetNum, sourceTrueDataEntry, sourceProCol);
                }
                PersonParamsUtils.mapCandidateToPerson(perChgBizInfoNews, chgcategoryDy, candidateMapColl, bizInfoNew);
            }
        }
    }

    private static void dealMappingExtFields(PerChgBizInfoNew bizInfoNew, DynamicObject targetEntity, DynamicObjectCollection fieldEntry, String targetNum, DynamicObject sourceTrueData, boolean before) {
        List fieldEntryDys;
        String entry = null;
        if (before) {
            fieldEntryDys = fieldEntry.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getString("sourcefieldtag")) && data.getString("sourcefieldtag").contains("_b_")).collect(Collectors.toList());
            entry = B_MAIN_ENTRY.get(targetNum);
        } else {
            fieldEntryDys = fieldEntry.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getString("sourcefieldtag")) && data.getString("sourcefieldtag").contains("_a_")).collect(Collectors.toList());
            entry = A_MAIN_ENTRY.get(targetNum);
        }
        if (!CollectionUtils.isEmpty(fieldEntryDys)) {
            DynamicObjectCollection entryDys;
            if (HRStringUtils.isNotEmpty((String)entry) && sourceTrueData.getDataEntityType().getProperties().containsKey((Object)entry) && !CollectionUtils.isEmpty((Collection)(entryDys = sourceTrueData.getDynamicObjectCollection(entry))) && entryDys.size() > 1) {
                PersonParamsUtils.buildFailMsg(bizInfoNew, ResManager.loadKDString((String)"\u5b9e\u4f53\u6a21\u677f\u5206\u5f55\u6709\u591a\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5206\u5f55\u6570\u636e\u662f\u5426\u6b63\u786e;", (String)"PersonParamsBuilder_9", (String)"sdk-hr", (Object[])new Object[0]));
                return;
            }
            List<DynamicObject> bTargetEntityDataOfExtFields = PerChgNewBillUtils.getTargetEntityDataOfExtFields(bizInfoNew.getDy(), targetEntity, before);
            DynamicObjectCollection tmpDys = new DynamicObjectCollection();
            tmpDys.addAll(fieldEntryDys);
            PersonParamsUtils.addOrModifyExtFields(bizInfoNew, tmpDys, targetNum, bTargetEntityDataOfExtFields, before);
        }
    }

    private static void addOrModifyExtFields(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, List<DynamicObject> bTargetEntityDataOfExtFields, boolean before) {
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)targetNum);
        DynamicObject newHis = (DynamicObject)dyType.createInstance();
        DynamicObject sourceDy = bizInfoNew.getDy();
        Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
        List<ChgRecordEntryDto> chgRecordEntryDtoList = entityRecord.get(targetNum);
        if (CollectionUtils.isEmpty(bTargetEntityDataOfExtFields)) {
            if (!CollectionUtils.isEmpty(chgRecordEntryDtoList) && PersonParamsUtils.appendTemplateExtData(bizInfoNew, fieldEntry, before, sourceDy, entityRecord, (DynamicObjectType)dyType, newHis)) {
                return;
            }
            long id = ORM.create().genLongId((IDataEntityType)dyType);
            newHis.set("id", (Object)id);
            newHis.set("datastatus", (Object)"0");
            if (Objects.nonNull(newHis.getDataEntityType().getProperties().get((Object)"businessstatus"))) {
                newHis.set("businessstatus", (Object)"1");
            }
            HPFSNewChgHelper.setInit(newHis);
            bizInfoNew.setEntityRecord(targetNum, ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        } else {
            DynamicObject modifyDy = bTargetEntityDataOfExtFields.get(0);
            HRDynamicObjectUtils.copy((DynamicObject)modifyDy, (DynamicObject)newHis);
            long id = ORM.create().genLongId((IDataEntityType)dyType);
            newHis.set("id", (Object)id);
            LOG.info("==PersonParams id:{} targetNum:{}=", (Object)id, (Object)targetNum);
            String chgType = ChgModeEnum.MODIFY.getChgMode();
            HPFSNewChgHelper.checkBusistatus(chgType, newHis);
            if (!CollectionUtils.isEmpty(chgRecordEntryDtoList)) {
                if (PersonParamsUtils.appendTemplateExtData(bizInfoNew, fieldEntry, before, sourceDy, entityRecord, (DynamicObjectType)dyType, newHis)) {
                    return;
                }
            } else if ("hrpi_empentrel".equals(targetNum) || "hrpi_empposorgrel".equals(targetNum)) {
                Long queryId = PersonParamsUtils.getMatchFieldId(newHis, targetNum);
                PersonParamsUtils.handleMainAndRedundanceData(bizInfoNew, fieldEntry, sourceDy, targetNum, newHis, queryId, true);
                return;
            }
            ChgRecordHelper.updIdsRecord(targetNum, modifyDy, newHis, bizInfoNew, chgType);
        }
        HPFSNewChgHelper.setFieldMapping(sourceDy, fieldEntry, bizInfoNew, newHis);
    }

    private static Long getMatchFieldId(DynamicObject newHis, String targetNum) {
        if ("hrpi_empentrel".equals(targetNum)) {
            return newHis.getLong("employee.id");
        }
        if ("hrpi_empposorgrel".equals(targetNum)) {
            return newHis.getLong("depemp.id");
        }
        return 0L;
    }

    private static void buildNewSaveDy(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, DynamicObject sourceDy, String chgType, DynamicObject saveDy, DynamicObject dbDy, String entityName) {
        PersonParamsUtils.copyAndSetId(saveDy, dbDy, entityName);
        HPFSNewChgHelper.setMappingField(sourceDy, fieldEntry, bizInfoNew, saveDy);
        HPFSNewChgHelper.setSysField(saveDy);
        ChgRecordHelper.updIdsRecord(entityName, dbDy, saveDy, bizInfoNew, chgType);
    }

    private static void copyAndSetId(DynamicObject saveDy, DynamicObject dbDy, String entityName) {
        HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)saveDy);
        long id1 = ORM.create().genLongId(entityName);
        saveDy.set("id", (Object)id1);
    }

    private static boolean hasField(DynamicObjectCollection fieldEntry, DynamicObject saveDy) {
        DataEntityPropertyCollection properties = saveDy.getDataEntityType().getProperties();
        boolean hasField = false;
        for (DynamicObject dy : fieldEntry) {
            String targetField = dy.getString("targetfieldnew.number");
            if (!properties.containsKey((Object)targetField)) continue;
            hasField = true;
            break;
        }
        return hasField;
    }

    private static boolean appendTemplateExtData(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, boolean before, DynamicObject sourceDy, Map<String, List<ChgRecordEntryDto>> recordMap, DynamicObjectType dyType, DynamicObject newHis) {
        boolean matchSuccess = false;
        String targetNum = dyType.getName();
        HashMap<String, Long> matchMap = new HashMap<String, Long>(10);
        String modelField = PersonParamsUtils.getMatchId(sourceDy, dyType, before, matchMap);
        if (HRMapUtils.isEmpty(matchMap)) {
            LOG.info("==appendTemplateExtDataEmpty=={}", (Object)targetNum);
            return matchSuccess;
        }
        List<ChgRecordEntryDto> chgRecordEntryDtoList = recordMap.get(targetNum);
        if (CollectionUtils.isEmpty(chgRecordEntryDtoList)) {
            return matchSuccess;
        }
        for (ChgRecordEntryDto entryDto : chgRecordEntryDtoList) {
            long boId;
            DynamicObject existDy = entryDto.getDataDy();
            if (existDy == null || HRStringUtils.isEmpty((String)modelField)) continue;
            long id = HpfsDynamicObjectUtils.getBasicDataValue(existDy, modelField);
            if (MODEL_ENTITY.contains(targetNum) && (boId = existDy.getLong("boid")) != 0L) {
                id = boId;
            }
            Long mainId = (Long)matchMap.get(modelField);
            if (id == 0L) {
                LOG.info("==appendTemplateExtDataEmptyId=={}=={}", (Object)targetNum, (Object)mainId);
                continue;
            }
            if (mainId != id) continue;
            matchSuccess = true;
            PersonParamsUtils.handleMainAndRedundanceData(bizInfoNew, fieldEntry, sourceDy, targetNum, existDy, mainId, false);
        }
        if (!matchSuccess && ("hrpi_empentrel".equals(targetNum) || "hrpi_empposorgrel".equals(targetNum))) {
            Long queryId = PersonParamsUtils.getMatchFieldId(newHis, targetNum);
            if (queryId == 0L) {
                matchSuccess = false;
            } else {
                PersonParamsUtils.handleMainAndRedundanceData(bizInfoNew, fieldEntry, sourceDy, targetNum, newHis, queryId, true);
                matchSuccess = true;
            }
        }
        return matchSuccess;
    }

    private static boolean handleMainAndRedundanceData(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, DynamicObject sourceDy, String targetNum, DynamicObject existDy, Long mainId, boolean setContext) {
        List<Map<String, String>> needCopyEntity;
        HPFSNewChgHelper.setMappingField(sourceDy, fieldEntry, bizInfoNew, existDy);
        HPFSNewChgHelper.setSysField(existDy);
        if (setContext) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(targetNum);
            DynamicObject newHis = serviceHelper.generateEmptyDynamicObject();
            PersonParamsUtils.copyAndSetId(newHis, existDy, targetNum);
            ChgRecordHelper.updIdsRecord(targetNum, existDy, newHis, bizInfoNew, ChgModeEnum.MODIFY.getChgMode());
        }
        if (CollectionUtils.isEmpty(needCopyEntity = ENTITYNEEDCOPY.get(targetNum))) {
            return true;
        }
        Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
        block0: for (Map<String, String> needCopyMap : needCopyEntity) {
            for (Map.Entry<String, String> entry : needCopyMap.entrySet()) {
                DynamicObject dbDy;
                String idKey = entry.getKey();
                String entityNum = entry.getValue();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNum);
                DynamicObject saveDy = serviceHelper.generateEmptyDynamicObject();
                boolean hasField = PersonParamsUtils.hasField(fieldEntry, saveDy);
                if (!hasField) continue block0;
                List<ChgRecordEntryDto> redundanceList = entityRecord.get(entityNum);
                if (CollectionUtils.isEmpty(redundanceList)) {
                    DynamicObject dbDy2 = PersonParamsUtils.queryEntityData(idKey, entityNum, mainId);
                    if (dbDy2 == null) continue;
                    PersonParamsUtils.buildNewSaveDy(bizInfoNew, fieldEntry, sourceDy, ChgModeEnum.MODIFY.getChgMode(), saveDy, dbDy2, entityNum);
                    continue;
                }
                boolean matchSuccess = false;
                for (ChgRecordEntryDto redDy : redundanceList) {
                    DynamicObject needCopyDy = redDy.getDataDy();
                    String chgMode = redDy.getChgMode();
                    long boId = needCopyDy.getLong("boid");
                    long temId = HpfsDynamicObjectUtils.getBasicDataValue(needCopyDy, idKey);
                    if (("hrpi_depemp".equals(entityNum) || "hrpi_employee".equals(entityNum)) && boId != 0L) {
                        temId = HpfsDynamicObjectUtils.getBasicDataValue(needCopyDy, "boid");
                    }
                    if (mainId != temId) continue;
                    matchSuccess = true;
                    HPFSNewChgHelper.setMappingField(sourceDy, fieldEntry, bizInfoNew, needCopyDy);
                    if (!ChgModeEnum.UNCHANGED.getChgMode().equals(chgMode)) continue;
                    redDy.setChgMode(ChgModeEnum.MODIFY.getChgMode());
                    PersonParamsUtils.copyAndSetId(saveDy, needCopyDy, needCopyDy.getDataEntityType().getName());
                    redDy.setDataDy(saveDy);
                }
                if (matchSuccess || (dbDy = PersonParamsUtils.queryEntityData(idKey, entityNum, mainId)) == null) continue;
                PersonParamsUtils.buildNewSaveDy(bizInfoNew, fieldEntry, sourceDy, ChgModeEnum.MODIFY.getChgMode(), saveDy, dbDy, entityNum);
            }
        }
        return false;
    }

    private static String getMatchId(DynamicObject sourceDy, DynamicObjectType dyType, boolean before, Map<String, Long> matchMap) {
        String modelField = null;
        long mainId = 0L;
        String targetNum = dyType.getName();
        DataEntityPropertyCollection properties = dyType.getProperties();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(targetNum);
        modelField = classification != null ? (PersonModelClassificationEnum.PERSONMODEL == classification ? "id" : classification.getMainKey()) : (properties.containsKey((Object)"depemp") && !"hrpi_personrolerel".equals(targetNum) ? "depemp" : (properties.containsKey((Object)"employee") ? "employee" : (properties.containsKey((Object)"person") ? "person" : "id")));
        if ("depemp".equals(modelField) || "hrpi_depemp".equals(targetNum)) {
            mainId = before ? sourceDy.getLong("bb_d_tid") : sourceDy.getLong("ba_d_tid");
        } else if ("employee".equals(modelField) || "hrpi_employee".equals(targetNum)) {
            mainId = before ? sourceDy.getLong("bb_e_tid") : sourceDy.getLong("ba_e_tid");
        } else if ("person".equals(modelField) || "hrpi_person".equals(targetNum)) {
            mainId = before ? sourceDy.getLong("bb_p_tid") : sourceDy.getLong("ba_p_tid");
        }
        matchMap.put(modelField, mainId);
        return modelField;
    }

    private static void mapCandidateToPerson(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject chgcategoryDy, DynamicObjectCollection candidateMapColl, PerChgBizInfoNew bizInfoNew) {
        List<String> personAttachEntityNumber = PersonEntityConfRepository.getPersonAttachEntityNumber();
        for (DynamicObject candidateTableDy : candidateMapColl) {
            DynamicObject sourceEntity = candidateTableDy.getDynamicObject("sourceentity_c");
            DynamicObject targetEntity = candidateTableDy.getDynamicObject("targetentity_c");
            if (sourceEntity == null || targetEntity == null) {
                LOG.info("==formMappedData sourceEntity or targetEntity or  pairType is not write==", perChgBizInfoNews);
                continue;
            }
            DynamicObjectCollection fieldEntry = candidateTableDy.getDynamicObjectCollection("subentryentity_c");
            if (CollectionUtils.isEmpty((Collection)fieldEntry)) {
                LOG.info("==formMappedData fieldEntry is null==", perChgBizInfoNews);
                continue;
            }
            List fieldEntrys = fieldEntry.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew_c")) && data.getBoolean("writepersoninfo_c")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fieldEntrys)) {
                LOG.info("==formMappedData fieldEntrys is null==", perChgBizInfoNews);
                continue;
            }
            fieldEntry = new DynamicObjectCollection();
            fieldEntry.addAll(fieldEntrys);
            String sourceNum = sourceEntity.getString("number");
            String targetNum = targetEntity.getString("number");
            DynamicObject sourceTrueData = bizInfoNew.getDy();
            DataEntityPropertyCollection billProps = sourceTrueData.getDataEntityType().getProperties();
            long candidateId = 0L;
            if (billProps.containsKey((Object)"candidate")) {
                candidateId = sourceTrueData.getLong("candidate.id");
            } else if (billProps.containsKey((Object)"b_candidate")) {
                candidateId = sourceTrueData.getLong("b_candidate.id");
            }
            QFilter filter = new QFilter("candidate", "=", (Object)candidateId);
            DynamicObject[] candidateDys = RepositoryUtils.queryDynamicObjects(sourceNum, "", filter);
            PersonParamsUtils.dealDelParams(bizInfoNew, personAttachEntityNumber, targetNum);
            for (DynamicObject sourceDy : candidateDys) {
                DataEntityPropertyCollection properties = sourceDy.getDynamicObjectType().getProperties();
                if (properties.get((Object)"iscurrentversion") != null && (!sourceDy.getBoolean("iscurrentversion") || !"1".equals(sourceDy.getString("datastatus")))) continue;
                PersonParamsUtils.dealHcfMapField(bizInfoNew, fieldEntry, targetNum, sourceDy);
            }
        }
    }

    private static void dealDelParams(PerChgBizInfoNew bizInfoNew, List<String> personAttachEntityNumber, String targetNum) {
        DynamicObject chgActionDy = bizInfoNew.getChgActionDy();
        if (null == chgActionDy.get("createnewpersoninfo") || StringUtils.isEmpty((CharSequence)chgActionDy.getString("createnewpersoninfo")) || HRStringUtils.equals((String)chgActionDy.getString("createnewpersoninfo"), (String)"1") || HRStringUtils.equals((String)chgActionDy.getString("createnewpersoninfo"), (String)"true")) {
            LOG.info("PersonParamsUtils#skip dealDelParams createnewpersoninfo is {}", chgActionDy.get("createnewpersoninfo"));
            return;
        }
        List<PersonBean> personList = bizInfoNew.getPersonList();
        PersonBean personBean = personList.get(0);
        Long personId = personBean.getaPersonId() != 0L ? personBean.getaPersonId() : personBean.getbPersonId();
        LOG.info("PersonParamsUtils#dealDelParams personId is{}, targetNumber is {}", (Object)personId, (Object)targetNum);
        if (personId > 0L && personAttachEntityNumber.contains(targetNum)) {
            LOG.info("PersonParamsUtils#dealDelParams add data to DaelParam, targetNumber is {}", (Object)targetNum);
            QFilter perFilter = new QFilter("person.id", "=", (Object)personId);
            Object[] hrpiDys = RepositoryUtils.queryDynamicObjects(targetNum, "", perFilter);
            if (HRArrayUtils.isEmpty((Object[])hrpiDys)) {
                LOG.info("PersonParamsUtils#dealDelParams hrpiDys is empty, targetNumber is {}", (Object)targetNum);
                return;
            }
            bizInfoNew.setDelParams(targetNum, (DynamicObject[])hrpiDys);
        }
    }

    private static void dealHcfMapField(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObject sourceDy) {
        if (HpfsChgNew.PERSON3ENTITY.contains(targetNum)) {
            Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
            if (CollectionUtils.isEmpty((Collection)entityRecord.get(targetNum))) {
                if ("hrpi_pertsprop".equals(targetNum)) {
                    List<PersonBean> personList = bizInfoNew.getPersonList();
                    if (!CollectionUtils.isEmpty(personList)) {
                        PersonBean personBean = personList.get(0);
                        Long personId = personBean.getaPersonId();
                        QFilter filter = new QFilter("person.id", "=", (Object)personId);
                        DynamicObject perTs = RepositoryUtils.queryDynamicObject("hrpi_pertsprop", "", filter);
                        if (perTs == null) {
                            return;
                        }
                        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)targetNum);
                        DynamicObject newHis = (DynamicObject)dyType.createInstance();
                        HRDynamicObjectUtils.copy((DynamicObject)perTs, (DynamicObject)newHis);
                        long id = HPFSNewChgHelper.getId((DynamicObjectType)dyType);
                        newHis.set("id", (Object)id);
                        HPFSNewChgHelper.setFieldMappingHCF(sourceDy, fieldEntry, bizInfoNew, newHis);
                    }
                } else {
                    PersonParamsUtils.createFieldMapDyHCF(bizInfoNew, fieldEntry, targetNum, sourceDy);
                }
            } else {
                List<ChgRecordEntryDto> chgRecords = entityRecord.get(targetNum);
                DynamicObject targetDy = chgRecords.get(0).getDataDy();
                if (targetDy != null) {
                    HPFSNewChgHelper.setFieldMappingHCF(sourceDy, fieldEntry, bizInfoNew, targetDy);
                }
            }
        } else {
            PersonParamsUtils.createFieldMapDyHCF(bizInfoNew, fieldEntry, targetNum, sourceDy);
        }
    }

    private static void createFieldMapDy(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObject sourceDy) {
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)targetNum);
        DynamicObject newHis = (DynamicObject)dyType.createInstance();
        long id = HPFSNewChgHelper.getId((DynamicObjectType)dyType);
        newHis.set("id", (Object)id);
        HPFSNewChgHelper.setFieldMapping(sourceDy, fieldEntry, bizInfoNew, newHis);
        PersonParamsUtils.dealAttach(bizInfoNew, sourceDy, newHis);
        bizInfoNew.setEntityRecord(targetNum, ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
    }

    private static void createFieldMapDyHCF(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObject sourceDy) {
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)targetNum);
        DynamicObject newHis = (DynamicObject)dyType.createInstance();
        long id = HPFSNewChgHelper.getId((DynamicObjectType)dyType);
        newHis.set("id", (Object)id);
        HPFSNewChgHelper.setFieldMappingHCF(sourceDy, fieldEntry, bizInfoNew, newHis);
        PersonParamsUtils.dealAttach(bizInfoNew, sourceDy, newHis);
        bizInfoNew.setEntityRecord(targetNum, ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
    }

    private static void dealAttach(PerChgBizInfoNew bizInfoNew, DynamicObject sourceDy, DynamicObject newHis) {
        if (sourceDy != null) {
            String hcfEntity;
            ArrayList<DynamicObject> attachs = new ArrayList<DynamicObject>(16);
            long newId = sourceDy.getLong("id");
            String name = sourceDy.getDynamicObjectType().getName();
            if ("hcf_caneduexp".equals(name)) {
                HCFEDUIDHRPIEDUID.put(newId, newHis.getLong("id"));
            }
            if (HRStringUtils.isEmpty((String)(hcfEntity = AttachmentEnum.getHcfByBusiness(name)))) {
                LOG.info("==hcfEntity is empty==");
                return;
            }
            List<DynamicObject> bosAttachs = bizInfoNew.getEntitybosAttach().get(name);
            if (CollectionUtils.isEmpty(bosAttachs)) {
                LOG.info("==bosAttachs is empty==");
                return;
            }
            if ("hcf_educertificate".equals(name)) {
                long eduId = sourceDy.getLong("edu.id");
                Long hrpiEduId = HCFEDUIDHRPIEDUID.get(eduId);
                newHis.set("pereduexp", (Object)hrpiEduId);
                HPFSNewChgHelper.setSysField(newHis);
                HPFSNewChgHelper.setIdFromCache(bizInfoNew, newHis);
            }
            if (!CollectionUtils.isEmpty(bosAttachs)) {
                for (DynamicObject attach : bosAttachs) {
                    String fInterid = attach.getString("finterid");
                    if (!fInterid.equals(String.valueOf(newId))) continue;
                    String hrpiEntity = newHis.getDynamicObjectType().getName();
                    attachs.add(HPFSNewChgHelper.formatAttachment(attach, newHis.getLong("id"), hrpiEntity));
                }
                if (!CollectionUtils.isEmpty(attachs)) {
                    bizInfoNew.setBosAttachs(attachs);
                }
            }
        }
    }

    private static DynamicObject addEduCert(PerChgBizInfoNew bizInfoNew, long eduId, DynamicObject certDy) {
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)"hcf_educertificate");
        DynamicObject newHis = (DynamicObject)dyType.createInstance();
        long certId = HPFSNewChgHelper.getId((DynamicObjectType)dyType);
        newHis.set("id", (Object)certId);
        newHis.set("certtype", certDy.get("certtype"));
        newHis.set("businessstatus", (Object)"1");
        newHis.set("number", certDy.get("number"));
        newHis.set("isauthenticated", certDy.get("iscertification"));
        newHis.set("authcertnumber", certDy.get("certnumber"));
        newHis.set("pereduexp", (Object)eduId);
        HPFSNewChgHelper.setSysField(newHis);
        HPFSNewChgHelper.setIdFromCache(bizInfoNew, newHis);
        return newHis;
    }

    private static void dealCmpemp(Map<String, Map<Long, DynamicObject>> modifyIdDyMap, PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObjectCollection sourceTrueDataEntry, DataEntityPropertyCollection sourceProCol) {
        String hasId = "";
        String hasChgType = "";
        String hastId = "";
        for (IDataEntityProperty pro : sourceProCol) {
            String name = pro.getName();
            if (name.contains("_chgtype")) {
                hasChgType = name;
                continue;
            }
            if (!name.contains("_tid")) continue;
            hastId = name;
        }
        if (!HRStringUtils.isEmpty((String)hasChgType) && !HRStringUtils.isEmpty((String)hastId)) {
            for (DynamicObject sourceDy : sourceTrueDataEntry) {
                long entryId = sourceDy.getLong(hastId);
                String chgType = sourceDy.getString(hasChgType);
                if (ChgModeEnum.MODIFY.getChgMode().equals(chgType) || ChgModeEnum.INVALID.getChgMode().equals(chgType)) {
                    Map<Long, DynamicObject> manageDyMap = modifyIdDyMap.get(targetNum);
                    if (manageDyMap == null) {
                        LOG.error("==chgtype is modify but id not exist==");
                        continue;
                    }
                    DynamicObject manageDy = manageDyMap.get(entryId);
                    if (manageDy == null) {
                        LOG.error("==chgtype is modify but id not exist==");
                        continue;
                    }
                    DynamicObject hisManageDy = PersonParamsUtils.addOrModify(sourceDy, fieldEntry, chgType, manageDy, hastId, targetNum, bizInfoNew);
                    long cmpempId = manageDy.getLong("cmpemp.id");
                    DynamicObject cmpempDy = RepositoryUtils.queryById("hrpi_cmpemp", cmpempId);
                    if (cmpempDy != null) {
                        DynamicObject newHis = (DynamicObject)CMPEMPTYPE.createInstance();
                        HRDynamicObjectUtils.copy((DynamicObject)cmpempDy, (DynamicObject)newHis);
                        long id = HPFSNewChgHelper.getId(CMPEMPTYPE);
                        newHis.set("id", (Object)id);
                        PersonParamsUtils.wrapSameFieldFromSourceForInit(newHis, hisManageDy);
                        HPFSNewChgHelper.checkBusistatus(chgType, newHis);
                        ChgRecordHelper.updIdsRecord("hrpi_cmpemp", cmpempDy, newHis, bizInfoNew, chgType);
                    }
                }
                if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgType)) continue;
                DynamicObject cmpNewHis = (DynamicObject)CMPEMPTYPE.createInstance();
                long id = HPFSNewChgHelper.getId(CMPEMPTYPE);
                cmpNewHis.set("id", (Object)id);
                bizInfoNew.setCmpempDy(cmpNewHis);
                DynamicObject scopeNewHis = PersonParamsUtils.addOrModify(sourceDy, fieldEntry, chgType, null, hastId, targetNum, bizInfoNew);
                if (scopeNewHis != null) {
                    scopeNewHis.set("cmpemp", (Object)cmpNewHis);
                }
                if (cmpNewHis != null && scopeNewHis != null) {
                    PersonParamsUtils.wrapSameFieldFromSourceForInit(cmpNewHis, scopeNewHis);
                }
                ChgRecordHelper.addChgIdRecord("hrpi_cmpemp", bizInfoNew, id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), cmpNewHis);
                PersonParamsUtils.updateCmpEmp(ENTITYNAMES, cmpNewHis, bizInfoNew.getEntityRecord());
            }
        }
    }

    private static void updateCmpEmp(String[] entityNames, DynamicObject newCmpEmp, Map<String, List<ChgRecordEntryDto>> entityRecordMap) {
        Arrays.stream(entityNames).forEach(entityName -> {
            List chgRecordEntryDTOs = (List)entityRecordMap.get(entityName);
            if (CollectionUtils.isEmpty((Collection)chgRecordEntryDTOs)) {
                return;
            }
            for (ChgRecordEntryDto dto : chgRecordEntryDTOs) {
                if (!ChgModeEnum.ADD_NEW.getChgMode().equals(dto.getChgMode())) continue;
                dto.getDataDy().set("cmpemp", (Object)newCmpEmp);
            }
        });
        PersonParamsUtils.setErmanFileHbssCmpemp(newCmpEmp, entityRecordMap);
    }

    private static void setErmanFileHbssCmpemp(DynamicObject newCmpEmp, Map<String, List<ChgRecordEntryDto>> entityRecordMap) {
        List<ChgRecordEntryDto> chgRecordEntryDTOs = entityRecordMap.get("hspm_ermanfile");
        for (ChgRecordEntryDto dto : chgRecordEntryDTOs) {
            if (!ChgModeEnum.ADD_NEW.getChgMode().equals(dto.getChgMode())) continue;
            dto.getDataDy().set("hbsscmpemp", newCmpEmp.get("managingscope"));
        }
    }

    private static void dealTemplate3PersonData(PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObjectCollection sourceTrueDataEntry, String hasId, String hasChgType) {
        if (!HRStringUtils.isEmpty((String)hasChgType) && !HRStringUtils.isEmpty((String)hasId)) {
            for (DynamicObject sourceDy : sourceTrueDataEntry) {
                long temTid = sourceDy.getLong(hasId);
                Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
                List<ChgRecordEntryDto> entryDtos = entityRecord.get(targetNum);
                if (CollectionUtils.isEmpty(entryDtos)) {
                    return;
                }
                for (ChgRecordEntryDto entryDto : entryDtos) {
                    DynamicObject targetDy = entryDto.getDataDy();
                    long id = 0L;
                    id = targetNum.equals("hrpi_empposorgrel") || targetNum.equals("hspm_ermanfile") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "depemp") : (targetNum.equals("hrpi_empentrel") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "employee") : (targetNum.equals("hrpi_person") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "id") : HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "person")));
                    if (temTid == id) {
                        for (DynamicObject fieldDy : fieldEntry) {
                            String targetField = fieldDy.getString("targetfieldnew.number");
                            String sourceField = fieldDy.getString("sourcefieldtag");
                            Object sourceObject = sourceDy.get(sourceField);
                            HPFSNewChgHelper.setValue(targetDy, targetField, sourceObject);
                        }
                        PersonParamsUtils.copyData(bizInfoNew, targetDy, id, targetNum);
                        continue;
                    }
                    LOG.info("==id :{} temTid:{} ==", (Object)id, (Object)temTid);
                }
            }
        }
    }

    private static void copyData(PerChgBizInfoNew bizInfoNew, DynamicObject sourceDy, long id, String targetNum) {
        List<Map<String, String>> needCopyEntity = ENTITYNEEDCOPY.get(targetNum);
        if (CollectionUtils.isEmpty(needCopyEntity)) {
            return;
        }
        Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
        for (Map<String, String> needCopyMap : needCopyEntity) {
            for (Map.Entry<String, String> entry : needCopyMap.entrySet()) {
                String idKey = entry.getKey();
                String entityNum = entry.getValue();
                List<ChgRecordEntryDto> entryDtos = entityRecord.get(entityNum);
                for (ChgRecordEntryDto entryDto : entryDtos) {
                    DynamicObject needCopyDy = entryDto.getDataDy();
                    long temId = HpfsDynamicObjectUtils.getBasicDataValue(needCopyDy, idKey);
                    if (temId != id) continue;
                    if ("hrpi_emporgrelall".equals(entityNum)) {
                        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.empExpAllProps, sourceDy, needCopyDy);
                        continue;
                    }
                    if ("hrpi_depemp".equals(entityNum)) {
                        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.depToEmpposProps, sourceDy, needCopyDy);
                        HPFSNewChgHelper.setValue(needCopyDy, "isprimary", sourceDy.get("isprimary"));
                        continue;
                    }
                    PersonParamsUtils.wrapSameFieldFromSourceForInit(needCopyDy, sourceDy);
                }
            }
        }
    }

    private static void dealDefaultData(Map<String, Map<Long, DynamicObject>> modifyIdDyMap, PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObjectCollection sourceTrueDataEntry, DataEntityPropertyCollection sourceProCol) {
        Map<Object, Object> modifyMap;
        String defaultHasType = "";
        String defaultHastId = "";
        for (IDataEntityProperty pro : sourceProCol) {
            String name = pro.getName();
            if (name.contains("_chgtype")) {
                defaultHasType = name;
                continue;
            }
            if (!name.contains("tid")) continue;
            defaultHastId = name;
        }
        Map<Object, Object> map = modifyMap = modifyIdDyMap.get(targetNum) == null ? new HashMap() : modifyIdDyMap.get(targetNum);
        if (!HRStringUtils.isEmpty((String)defaultHasType) && !HRStringUtils.isEmpty((String)defaultHastId)) {
            for (DynamicObject sourceDy : sourceTrueDataEntry) {
                long tId = sourceDy.getLong(defaultHastId);
                String chgType = sourceDy.getString(defaultHasType);
                PersonParamsUtils.addOrModify(sourceDy, fieldEntry, chgType, (DynamicObject)modifyMap.get(tId), defaultHastId, targetNum, bizInfoNew);
            }
        }
    }

    private static void deal3PersonData(Map<String, Map<Long, DynamicObject>> modifyIdDyMap, PerChgBizInfoNew bizInfoNew, DynamicObjectCollection fieldEntry, String targetNum, DynamicObjectCollection sourceTrueDataEntry, DataEntityPropertyCollection sourceProCol) {
        Map<Object, Object> modifyMap;
        String hasId = "";
        String hasChgType = "";
        String hastId = "";
        for (IDataEntityProperty pro : sourceProCol) {
            String name = pro.getName();
            if (name.contains("_chgtype")) {
                hasChgType = name;
                continue;
            }
            if (targetNum.equals("hrpi_empposorgrel") || targetNum.equals("hspm_ermanfile")) {
                if (name.contains("_did")) {
                    hasId = name;
                }
            } else if (targetNum.equals("hrpi_empentrel")) {
                if (name.contains("_eid")) {
                    hasId = name;
                }
            } else if (name.contains("_pid")) {
                hasId = name;
            }
            if (!name.contains("tid")) continue;
            hastId = name;
        }
        Map<Object, Object> map = modifyMap = modifyIdDyMap.get(targetNum) == null ? new HashMap() : modifyIdDyMap.get(targetNum);
        if (!(HRStringUtils.isEmpty((String)hasChgType) || HRStringUtils.isEmpty((String)hasId) || HRStringUtils.isEmpty((String)hastId))) {
            for (DynamicObject sourceDy : sourceTrueDataEntry) {
                long entryId = sourceDy.getLong(hasId);
                long tid = sourceDy.getLong(hastId);
                String chgType = sourceDy.getString(hasChgType);
                Map<String, List<ChgRecordEntryDto>> entityRecord = bizInfoNew.getEntityRecord();
                List<ChgRecordEntryDto> entryDtos = entityRecord.get(targetNum);
                Optional<ChgRecordEntryDto> entryDtoAny = entryDtos.stream().filter(dto -> dto.getChgMode().equals(chgType)).findAny();
                if (entryDtoAny.isPresent()) {
                    DynamicObject targetDy = entryDtoAny.get().getDataDy();
                    long id = 0L;
                    id = targetNum.equals("hrpi_empposorgrel") || targetNum.equals("hspm_ermanfile") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "depemp") : (targetNum.equals("hrpi_empentrel") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "employee") : (targetNum.equals("hrpi_person") ? HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "id") : HpfsDynamicObjectUtils.getBasicDataValue(targetDy, "person")));
                    if (entryId == id) {
                        for (DynamicObject fieldDy : fieldEntry) {
                            String targetField = fieldDy.getString("targetfieldnew.number");
                            String sourceField = fieldDy.getString("sourcefieldtag");
                            Object sourceObject = sourceDy.get(sourceField);
                            HPFSNewChgHelper.setValue(targetDy, targetField, sourceObject);
                        }
                        PersonParamsUtils.copyData(bizInfoNew, targetDy, id, targetNum);
                        continue;
                    }
                    PersonParamsUtils.addOrModify(sourceDy, fieldEntry, chgType, (DynamicObject)modifyMap.get(tid), hastId, targetNum, bizInfoNew);
                    continue;
                }
                PersonParamsUtils.addOrModify(sourceDy, fieldEntry, chgType, (DynamicObject)modifyMap.get(tid), hastId, targetNum, bizInfoNew);
            }
        }
    }

    public static DynamicObject addOrModify(DynamicObject sourceDy, DynamicObjectCollection fieldEntry, String chgType, DynamicObject modifyDy, String hastId, String targetNum, PerChgBizInfoNew bizInfoNew) {
        if (ChgModeEnum.DELETE.getChgMode().equals(chgType) || ChgModeEnum.UNCHANGED.getChgMode().equals(chgType)) {
            return null;
        }
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)targetNum);
        DynamicObject newHis = (DynamicObject)dyType.createInstance();
        long id = 0L;
        if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgType)) {
            id = sourceDy.get(hastId) == null || sourceDy.getLong(hastId) == 0L ? ORM.create().genLongId((IDataEntityType)dyType) : ((Long)sourceDy.get(hastId)).longValue();
            newHis.set("id", (Object)id);
            newHis.set("datastatus", (Object)"0");
            if (Objects.nonNull(newHis.getDataEntityType().getProperties().get((Object)"businessstatus"))) {
                newHis.set("businessstatus", (Object)"1");
            }
            HPFSNewChgHelper.setInit(newHis);
            bizInfoNew.setEntityRecord(targetNum, ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        } else {
            if (modifyDy == null) {
                LOG.info("===modify id not exist==", (Object)bizInfoNew);
                return null;
            }
            id = ORM.create().genLongId((IDataEntityType)dyType);
            HRDynamicObjectUtils.copy((DynamicObject)modifyDy, (DynamicObject)newHis);
            newHis.set("id", (Object)id);
            LOG.info("==PersonParams id:{} targetNum:{}=", (Object)id, (Object)targetNum);
            HPFSNewChgHelper.checkBusistatus(chgType, newHis);
            ChgRecordHelper.updIdsRecord(targetNum, modifyDy, newHis, bizInfoNew, chgType);
        }
        HPFSNewChgHelper.setFieldMapping(sourceDy, fieldEntry, bizInfoNew, newHis);
        return newHis;
    }

    private static List<PerChgBizInfoNew> initBizInfoNew(List<PerChgBizInfoNew> listBizInfo) {
        return listBizInfo.stream().filter(PerChgBizInfoNew::isSuccess).collect(Collectors.toList());
    }

    private static void buildModifyMap(DynamicObject chgcategoryDy, Map<String, Map<String, Set<Long>>> querySourceEntity, PerChgBizInfoNew bizInfoNew, DynamicObject tableDy) {
        DataEntityPropertyCollection properties;
        IDataEntityProperty property;
        DynamicObject sourceEntity = tableDy.getDynamicObject("sourceentity");
        DynamicObject targetEntity = tableDy.getDynamicObject("targetentity");
        String sourceEntry = tableDy.getString("sourceentry");
        if (sourceEntity == null || targetEntity == null) {
            LOG.info("==sourceEntity or targetEntity or pairType is not write", (Object)bizInfoNew);
            return;
        }
        String sourceNum = sourceEntity.getString("number");
        String targetNum = targetEntity.getString("number");
        DynamicObject sourceTrueData = bizInfoNew.getDy();
        if (HRStringUtils.isEmpty((String)sourceEntry) || HRStringUtils.equals((String)sourceNum, (String)sourceEntry)) {
            LOG.info("==sourceEntry is null or sourceNum == sourceEntry", (Object)bizInfoNew);
            return;
        }
        long eventId = chgcategoryDy.getLong("chgevent.id");
        if (!(sourceNum.contains("hcf_") && HpfsChgNew.LICENSE_IN.contains(eventId) || !((property = (IDataEntityProperty)(properties = sourceTrueData.getDynamicObjectType().getProperties()).get((Object)sourceEntry)) instanceof EntryProp))) {
            DynamicObjectCollection sourceTrueDataEntry = sourceTrueData.getDynamicObjectCollection(sourceEntry);
            if (CollectionUtils.isEmpty((Collection)sourceTrueDataEntry)) {
                LOG.info("==sourceTrueDataEntry is null :{}", (Object)bizInfoNew);
                return;
            }
            DataEntityPropertyCollection sourceProCol = ((DynamicObject)sourceTrueDataEntry.get(0)).getDynamicObjectType().getProperties();
            String hastId = "";
            String hasChgType = "";
            for (Object pro : sourceProCol) {
                String name = pro.getName();
                if (name.contains("_chgtype")) {
                    hasChgType = name;
                    continue;
                }
                if (!name.contains("_tid")) continue;
                hastId = name;
            }
            if (HRStringUtils.isEmpty((String)hastId) || HRStringUtils.isEmpty((String)hasChgType)) {
                LOG.info("==hastId OR hasChgType is emptry==");
                return;
            }
            if (!BENTRYNUM.contains(sourceEntry)) {
                ArrayList<Long> trueDataIds = new ArrayList<Long>(sourceTrueDataEntry.size());
                for (DynamicObject entryDy : sourceTrueDataEntry) {
                    String bChgType = entryDy.getString(hasChgType);
                    long trueDataId = entryDy.getLong(hastId);
                    trueDataIds.add(trueDataId);
                    if (ChgModeEnum.MODIFY.getChgMode().equals(bChgType) || ChgModeEnum.INVALID.getChgMode().equals(bChgType)) {
                        PersonParamsUtils.formatQueryOrDel(querySourceEntity, targetNum, trueDataId, "id");
                    }
                    if (!ChgModeEnum.DELETE.getChgMode().equals(bChgType)) continue;
                    QFilter filter = new QFilter("id", "=", (Object)trueDataId);
                    DynamicObject[] delDys = RepositoryUtils.queryDynamicObjects(targetNum, "", filter);
                    bizInfoNew.setDelParams(targetNum, delDys);
                }
                List<DynamicObject> targetEntityDys = PerChgNewBillUtils.getTargetEntityData(bizInfoNew.getDy(), tableDy, null);
                if (!CollectionUtils.isEmpty(targetEntityDys)) {
                    targetEntityDys.forEach(targetEntityDy -> {
                        long trueDataId = targetEntityDy.getLong("id");
                        if (!trueDataIds.contains(trueDataId)) {
                            QFilter filter = new QFilter("id", "=", (Object)trueDataId);
                            DynamicObject[] delDys = RepositoryUtils.queryDynamicObjects(targetNum, "", filter);
                            bizInfoNew.setDelParams(targetNum, delDys);
                        }
                    });
                }
            }
        }
    }

    private static void formatQueryOrDel(Map<String, Map<String, Set<Long>>> sourceEntity, String targetNum, long trueDataId, String qryOrDelKey) {
        sourceEntity.computeIfAbsent(targetNum, map -> new HashMap(1)).computeIfAbsent(qryOrDelKey, set -> new HashSet()).add(trueDataId);
    }

    public static void setPerChgBizInfoNewFail(List<PerChgBizInfoNew> bizInfoNews, String errMsg) {
        for (PerChgBizInfoNew bizInfoNew : bizInfoNews) {
            bizInfoNew.setSuccess(false);
            PersonParamsUtils.buildErrMsg(bizInfoNew, errMsg);
        }
    }

    public static void wrapCommonField(DynamicObject dy) {
        long currUserId = RequestContext.get().getCurrUserId();
        dy.set("creator", (Object)currUserId);
        dy.set("modifier", (Object)currUserId);
        Date currentDate = new Date();
        dy.set("createtime", (Object)currentDate);
        dy.set("modifytime", (Object)currentDate);
        dy.set("initstatus", (Object)"2");
    }

    public static List<Map<String, Object>> buildDatasByCollection(DynamicObjectCollection ... collections) {
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.length);
        for (DynamicObjectCollection collection : collections) {
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collection);
            datas.add(item);
        }
        return datas;
    }

    public static Map<Long, DynamicObject> queryModifyDataSetKey(QFilter filter, String entity, String key) {
        DynamicObject[] modifyData = RepositoryUtils.queryDynamicObjects(entity, "", filter);
        if (modifyData != null) {
            return Arrays.stream(modifyData).collect(Collectors.toMap(dy -> dy.getLong(key), dy -> dy, (oldVal, newVal) -> newVal));
        }
        return new HashMap<Long, DynamicObject>(1);
    }

    public static Map<Long, DynamicObject> queryModifyDataSetKey(Set<Long> ids, String entity, String key) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1");
        QFilter filter = new QFilter(key, "in", ids).and(statusFilter);
        return PersonParamsUtils.queryModifyDataSetKey(filter, entity, key);
    }

    public static Map<Long, DynamicObject> queryModifyData(QFilter filter, String entity) {
        DynamicObject[] modifypersons = RepositoryUtils.queryDynamicObjects(entity, "", filter);
        if (modifypersons != null && modifypersons.length > 0) {
            return Arrays.stream(modifypersons).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (oldval, newval) -> newval));
        }
        return new HashMap<Long, DynamicObject>(1);
    }

    public static Map<Long, DynamicObject> queryModifyData(Set<Long> ids, String entity) {
        QFilter filter = new QFilter("id", "in", ids);
        return PersonParamsUtils.queryModifyData(filter, entity);
    }

    public static Map<String, Long> initFileTypeMap(Set<String> labAndPosTypeSet) {
        return HPFSNewChgHelper.getFileTypeByLabAndPosType(labAndPosTypeSet);
    }

    public static DynamicObject[] queryModifyData(Set<Long> ids, String entity, String key, String selectPops) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1").and("initstatus", "=", (Object)"2").and("businessstatus", "=", (Object)"1");
        QFilter filter = new QFilter(key, "in", ids).and(statusFilter);
        return RepositoryUtils.queryDynamicObjects(entity, selectPops, filter);
    }

    public static DynamicObject queryEntityData(String queryKey, String entity, long queryId) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1").and("initstatus", "=", (Object)"2");
        QFilter filter = new QFilter(queryKey, "in", (Object)queryId).and(statusFilter);
        return RepositoryUtils.queryDynamicObject(entity, "", filter);
    }

    public static Set<Long> getPosCateGory() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_postype");
        QFilter postFilter = new QFilter("postcategory", "!=", (Object)PerModelConstants.POSTCATEGORY_1020);
        Object[] dynamicObject1 = serviceHelper.query("id", new QFilter[]{postFilter});
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObject1)) {
            return Arrays.stream(dynamicObject1).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(1);
    }

    public static long getBasicDataValue(DynamicObject dy, String fieldName) {
        DataEntityPropertyCollection properties = dy.getDynamicObjectType().getProperties();
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)properties.get((Object)fieldName);
        if (dataEntityProperty instanceof BasedataProp) {
            return PersonParamsUtils.getBasicDataValue(dy, (BasedataProp)dataEntityProperty);
        }
        return (Long)dataEntityProperty.getValue((Object)dy);
    }

    public static long getBasicDataValue(DynamicObject dy, BasedataProp basedataProp) {
        Object value = basedataProp.getValue((Object)dy);
        if (value instanceof Long) {
            return (Long)value;
        }
        try {
            return (Long)basedataProp.getRefIdProp().getValue((Object)dy);
        }
        catch (Exception ex) {
            LOG.error("getBasicDataValueError {} ==== {}", (Object)basedataProp, basedataProp.getRefIdProp().getValue((Object)dy));
            throw ex;
        }
    }

    static {
        BENTRYNUM.add("entry_b_person");
        BENTRYNUM.add("entry_b_employee");
        BENTRYNUM.add("entry_b_depemp");
        AENTRYNUM.add("entry_a_person");
        AENTRYNUM.add("entry_a_employee");
        AENTRYNUM.add("entry_a_depemp");
        EMPORGERLALLENTITY.put("depemp", "hrpi_emporgrelall");
        DEPEMPENTITY.put("id", "hrpi_depemp");
        EMPENTITY.put("id", "hrpi_employee");
        EMPPOS_TMP_NEEDCOPY.add(EMPORGERLALLENTITY);
        EMPPOS_TMP_NEEDCOPY.add(DEPEMPENTITY);
        EMP_TMP_NEEDCOPY.add(EMPENTITY);
        ENTITYNEEDCOPY.put("hrpi_empposorgrel", EMPPOS_TMP_NEEDCOPY);
        ENTITYNEEDCOPY.put("hrpi_empentrel", EMP_TMP_NEEDCOPY);
        A_MAIN_ENTRY.put("hrpi_person", "entry_a_person");
        A_MAIN_ENTRY.put("hrpi_employee", "entry_a_employee");
        A_MAIN_ENTRY.put("hrpi_empentrel", "entry_a_employee");
        A_MAIN_ENTRY.put("hrpi_depemp", "entry_a_depemp");
        A_MAIN_ENTRY.put("hrpi_empposorgrel", "entry_a_depemp");
        B_MAIN_ENTRY.put("hrpi_person", "entry_b_person");
        B_MAIN_ENTRY.put("hrpi_employee", "entry_b_employee");
        B_MAIN_ENTRY.put("hrpi_empentrel", "entry_b_employee");
        B_MAIN_ENTRY.put("hrpi_depemp", "entry_b_depemp");
        B_MAIN_ENTRY.put("hrpi_empposorgrel", "entry_b_depemp");
    }
}

