/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRImageAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.dto.CardDrawDTO;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;

public class CardDrawElyMobHelper {
    private static final Log LOGGER = LogFactory.getLog(CardDrawElyMobHelper.class);
    private static final String ID_SUFIXX = ".id";

    public static void fieldSort(CardDrawDTO cardDrawDTO, List<Map<String, Object>> groups) {
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(8);
        int index = 0;
        for (Map<String, Object> group : groups) {
            List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
            if (CollectionUtils.isEmpty(fields)) continue;
            for (Map<String, Object> field : fields) {
                fieldIndexMap.put(CardDrawElyMobHelper.getFullFieldName(field), index++);
            }
        }
        ComparatorImpl comparator = new ComparatorImpl(fieldIndexMap);
        Collections.sort(cardDrawDTO.getTitleField().getFields(), comparator);
        Collections.sort(cardDrawDTO.getBracketField().getFields(), comparator);
        Collections.sort(cardDrawDTO.getTagField().getFields(), comparator);
        Collections.sort(cardDrawDTO.getContentField().getFields(), comparator);
    }

    private static String getField(Object field) {
        if (field instanceof LabelAp) {
            return ((LabelAp)field).getKey();
        }
        return field != null ? field.toString() : " ";
    }

    public static FlexPanelAp createContainer(String contentFlexKey) {
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(contentFlexKey).setName(contentFlexKey).setGrow(1).setShrink(0).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setMarginTop("1px")).setWidth("100%").setPaddingBottom("12px")).setBackColor("initial").build();
    }

    public static VectorAp createVectorAp(Map<String, String> data) {
        String key = "click" + data.get("id");
        return new HRVectorAp.Builder(key).setId(key).setName(key).setGrow(0).setShrink(0).setForeColor("#cccccc").setfontClass("kdfont kdfont-jinru").setClickable(false).build();
    }

    public static VectorAp createEditVectorAp(Map<String, String> data) {
        String key = "clickedit" + data.get("id");
        return new HRVectorAp.Builder(key).setId(key).setName(key).setGrow(0).setShrink(0).setForeColor("#666666").setfontClass("kdfont kdfont-bianjixiugai").setClickable(false).setFontSize(18).build();
    }

    public static FlexPanelAp createCardAp(Map<String, String> data, boolean margin) {
        String key = "card" + CardDrawElyMobHelper.getDataId(data);
        HRFlexPanelAp.Builder builder = new HRFlexPanelAp.Builder(key).setName(key).setGrow(0).setWrap(true).setWidth("100%").setDirection("row").setJustifyContent("space-between").setAlignItems("center");
        if (margin) {
            builder.setPaddingTop("12px");
        }
        return builder.build();
    }

    public static FlexPanelAp createContenFlextAp(Map<String, String> data) {
        String key = "cflext:" + CardDrawElyMobHelper.getMainTabNameId(data) + ":" + CardDrawElyMobHelper.getDataId(data);
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setName(key).setWidth("100%").setBackColor("#ffffff").setWrap(false).setDirection("row").setJustifyContent("space-between").setAlignItems("stretch").setPaddingBottom("12px")).setClickable(true).setRadius("4px").setBackColor("#F8F8F8").setPaddingTop("12px")).setPaddingLeft("16px")).setPaddingRight("16px")).build();
    }

    public static FlexPanelAp createDeleteOpFlextAp(Map<String, String> data) {
        String delKey = "del:" + CardDrawElyMobHelper.getMainTabNameId(data) + ":" + CardDrawElyMobHelper.getDataId(data);
        LabelAp delLabelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(delKey).setId(delKey).setShrink(0).setGrow(0).setFontSize(12).setForeColor("themeColor").setClickable(true).setName(ResManager.loadKDString((String)"\u5220\u9664", (String)"CardDrawHelper_0", (String)"hr-hspm-business", (Object[])new Object[0])).setPaddingTop("6px")).setPaddingBottom("6px")).setPaddingLeft("24px")).setPaddingRight("24px")).setBorderTop("0.5px_solid_themeColor")).setBorderBottom("0.5px_solid_themeColor")).setBorderLeft("0.5px_solid_themeColor")).setBorderRight("0.5px_solid_themeColor")).setMarginTop("10px")).setMarginBottom("10px")).setRadius("4px").setOperationKey("do_del").build();
        delLabelAp.setLineHeight("16px");
        String key = "delflext" + CardDrawElyMobHelper.getDataId(data);
        FlexPanelAp flexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setName(key).setWidth("100%").setShrink(1).setGrow(1).setBackColor("#ffffff").setDirection("row").setJustifyContent("flex-end").setAlignItems("center").setMarginTop("1px")).setPaddingRight("12px")).setOverflow("hidden").build();
        flexPanelAp.getItems().add(delLabelAp);
        return flexPanelAp;
    }

    public static FlexPanelAp createCardContentAp(Map<String, String> data) {
        String key = "cardcontent" + CardDrawElyMobHelper.getDataId(data);
        return new HRFlexPanelAp.Builder(key).setName(key).setWrap(false).setWidth("100%").setDirection("column").setAlignItems("stretch").build();
    }

    public static LabelAp createDefaultTitleLabel(String key) {
        LabelAp titleLabelAp = new LabelAp();
        titleLabelAp.setId(key);
        titleLabelAp.setKey(key);
        titleLabelAp.setShrink(1);
        titleLabelAp.setGrow(0);
        titleLabelAp.setFontSize(14);
        titleLabelAp.setForeColor("#212121");
        titleLabelAp.setFontWeight("500");
        titleLabelAp.setWidth(new LocaleString("100px"));
        return titleLabelAp;
    }

    private static void setLefMargin(LabelAp titleLabelAp) {
        if (titleLabelAp.getStyle() == null) {
            titleLabelAp.setStyle(new Style());
        }
        if (titleLabelAp.getStyle().getMargin() == null) {
            titleLabelAp.getStyle().setMargin(new Margin());
        }
        titleLabelAp.getStyle().getMargin().setLeft("4px");
    }

    public static LabelAp createDefaultTagLabel(String key) {
        LabelAp tagLabel = new LabelAp();
        tagLabel.setId(key);
        tagLabel.setKey(key);
        tagLabel.setShrink(0);
        tagLabel.setStyle(new Style());
        tagLabel.getStyle().setBorder(new Border());
        tagLabel.getStyle().getBorder().setTop("0.5px_solid_#CCCCCC");
        tagLabel.getStyle().getBorder().setLeft("0.5px_solid_#CCCCCC");
        tagLabel.getStyle().getBorder().setRight("0.5px_solid_#CCCCCC");
        tagLabel.getStyle().getBorder().setBottom("0.5px_solid_#CCCCCC");
        tagLabel.setForeColor("#666666");
        tagLabel.setRadius("10px");
        tagLabel.getStyle().setMargin(new Margin());
        tagLabel.getStyle().getMargin().setLeft("16px");
        tagLabel.getStyle().setPadding(new Padding());
        tagLabel.getStyle().getPadding().setLeft("8px");
        tagLabel.getStyle().getPadding().setRight("8px");
        tagLabel.setAlignSelf("center");
        tagLabel.setLineHeight("16px");
        tagLabel.setFontSize(12);
        return tagLabel;
    }

    public static FlexPanelAp createTitleRowAp(Map<String, Map<String, Object>> fieldMap, CardDrawDTO cardDrawDTO, Map<String, Tuple<String, String>> timeLineFieldMap, Map<String, String> data) {
        List<Object> titleFields = cardDrawDTO.getTitleField().getFields();
        List<Object> tagFields = cardDrawDTO.getTagField().getFields();
        String gName = data.get("@groupname");
        if (HRStringUtils.isNotEmpty((String)gName) && !tagFields.contains(gName)) {
            tagFields.add(0, "@groupname");
        }
        String dataId = CardDrawElyMobHelper.getDataId(data);
        String key = "title" + dataId;
        FlexPanelAp titleRowAp = new HRFlexPanelAp.Builder(key).setWrap(false).setHeight("24px").setJustifyContent("flex-start").setAlignItems("center").build();
        if (!CollectionUtils.isEmpty(titleFields) || !CollectionUtils.isEmpty(tagFields)) {
            String fieldName;
            Object field;
            int index;
            boolean firstColumn = true;
            for (index = 0; index < titleFields.size(); ++index) {
                String contentText;
                LabelAp titleLabelAp;
                field = titleFields.get(index);
                if (field == null || !fieldMap.containsKey(fieldName = (titleLabelAp = field instanceof LabelAp ? (LabelAp)JSON.parseObject((String)JSON.toJSONString((Object)field), LabelAp.class) : CardDrawElyMobHelper.createDefaultTitleLabel(field.toString())).getKey()) || !cardDrawDTO.usedFieldSet.add(fieldName) || HRStringUtils.isEmpty((String)(contentText = CardDrawElyMobHelper.getContent(fieldMap, fieldName, cardDrawDTO, timeLineFieldMap, data)))) continue;
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    contentText = "\u00b7 " + contentText;
                    CardDrawElyMobHelper.setLefMargin(titleLabelAp);
                }
                titleLabelAp.setName(new LocaleString(contentText));
                titleLabelAp.setId(titleLabelAp.getKey());
                titleLabelAp.setKey(dataId + "tf" + index);
                titleRowAp.getItems().add(titleLabelAp);
            }
            if (!CollectionUtils.isEmpty((Collection)titleRowAp.getItems())) {
                CardDrawElyMobHelper.drawBraketField(titleRowAp, cardDrawDTO, fieldMap, data);
            }
            for (index = 0; index < tagFields.size(); ++index) {
                LabelAp tagLabelAp;
                field = tagFields.get(index);
                if (field == null || !cardDrawDTO.usedFieldSet.add(fieldName = (tagLabelAp = field instanceof LabelAp ? (LabelAp)JSON.parseObject((String)JSON.toJSONString((Object)field), LabelAp.class) : CardDrawElyMobHelper.createDefaultTagLabel(field.toString())).getKey()) || !fieldMap.containsKey(fieldName) && !"@groupname".equals(fieldName) || !HRStringUtils.isNotEmpty((String)data.get(fieldName))) continue;
                String textContent = data.get(fieldName);
                tagLabelAp.setName(new LocaleString(textContent));
                tagLabelAp.setId(tagLabelAp.getKey());
                tagLabelAp.setKey(dataId + "tg" + index);
                titleRowAp.getItems().add(tagLabelAp);
            }
        }
        return titleRowAp;
    }

    private static void drawBraketField(FlexPanelAp titleRowAp, CardDrawDTO cardDrawDTO, Map<String, Map<String, Object>> fieldMap, Map<String, String> data) {
        List<Object> bracketFields = cardDrawDTO.getBracketField().getFields();
        for (int index = 0; index < bracketFields.size(); ++index) {
            LabelAp tagLabelAp;
            String fieldName;
            Object field = bracketFields.get(index);
            if (field == null || !cardDrawDTO.usedFieldSet.add(fieldName = (tagLabelAp = field instanceof LabelAp ? (LabelAp)JSON.parseObject((String)JSON.toJSONString((Object)field), LabelAp.class) : CardDrawElyMobHelper.createDefaultBraketLabel(field.toString())).getKey()) || !fieldMap.containsKey(fieldName) || !HRStringUtils.isNotEmpty((String)data.get(fieldName))) continue;
            String dataId = CardDrawElyMobHelper.getDataId(data);
            LabelAp leftBraket = CardDrawElyMobHelper.createDefaultBraketLabel(dataId + "bk" + index);
            leftBraket.setStyle(new Style());
            leftBraket.getStyle().setMargin(new Margin());
            leftBraket.getStyle().getMargin().setLeft("10px");
            leftBraket.getStyle().getMargin().setRight("2px");
            leftBraket.setName(new LocaleString("("));
            titleRowAp.getItems().add(leftBraket);
            String textContent = data.get(fieldName);
            tagLabelAp.setName(new LocaleString(textContent));
            tagLabelAp.setId(tagLabelAp.getKey());
            tagLabelAp.setKey(CardDrawElyMobHelper.getDataId(data) + "bk" + index);
            titleRowAp.getItems().add(tagLabelAp);
            LabelAp rightBraket = CardDrawElyMobHelper.createDefaultBraketLabel(dataId + "bkr" + index);
            rightBraket.setStyle(new Style());
            rightBraket.getStyle().setMargin(new Margin());
            rightBraket.getStyle().getMargin().setLeft("2px");
            rightBraket.setName(new LocaleString(")"));
            titleRowAp.getItems().add(rightBraket);
        }
    }

    public static LabelAp createDefaultBraketLabel(String key) {
        LabelAp braketLabel = new LabelAp();
        braketLabel.setId(key);
        braketLabel.setKey(key);
        braketLabel.setShrink(0);
        braketLabel.setGrow(0);
        braketLabel.setFontSize(14);
        braketLabel.setForeColor("#212121");
        return braketLabel;
    }

    private static String getContent(Map<String, Map<String, Object>> fieldMap, String fieldName, CardDrawDTO cardDrawDTO, Map<String, Tuple<String, String>> timeLineFieldMap, Map<String, String> data) {
        Tuple<String, String> timeLineTuple = timeLineFieldMap.get(fieldName);
        if (timeLineTuple != null) {
            if (fieldName.equals(timeLineTuple.item1)) {
                if (fieldMap.containsKey(timeLineTuple.item2) && HRStringUtils.isNotEmpty((String)data.get(timeLineTuple.item2))) {
                    cardDrawDTO.usedFieldSet.add((String)timeLineTuple.item2);
                    return data.get(timeLineTuple.item1) + " ~ " + data.get(timeLineTuple.item2);
                }
            } else if (fieldMap.containsKey(timeLineTuple.item1) && HRStringUtils.isNotEmpty((String)data.get(timeLineTuple.item1))) {
                cardDrawDTO.usedFieldSet.add((String)timeLineTuple.item1);
                return data.get(timeLineTuple.item1) + " ~ " + data.get(timeLineTuple.item2);
            }
            return null;
        }
        return data.get(fieldName);
    }

    public static FlexPanelAp createContentField(Map<String, Object> field, Object conField, CardDrawDTO cardDrawDTO, Map<String, Tuple<String, String>> timeLineFieldMap, Map<String, String> data, boolean hasContentTitle) {
        LabelAp labelAp = conField instanceof LabelAp ? (LabelAp)JSON.parseObject((String)JSON.toJSONString(field), LabelAp.class) : CardDrawElyMobHelper.createDefaultContentLabel(conField.toString());
        String fieldName = labelAp.getKey();
        labelAp.setId(fieldName);
        String contentText = data.get(fieldName);
        Tuple<String, String> timeLineTuple = timeLineFieldMap.get(fieldName);
        if (timeLineTuple != null) {
            if (fieldName.equals(timeLineTuple.item1)) {
                cardDrawDTO.usedFieldSet.add((String)timeLineTuple.item2);
                if (HRStringUtils.isEmpty((String)data.get(timeLineTuple.item2))) {
                    return null;
                }
                contentText = contentText + " ~ " + data.get(timeLineTuple.item2);
            } else {
                cardDrawDTO.usedFieldSet.add((String)timeLineTuple.item1);
                if (HRStringUtils.isEmpty((String)data.get(timeLineTuple.item1))) {
                    return null;
                }
                contentText = data.get(timeLineTuple.item1) + " ~ " + contentText;
            }
        }
        if (hasContentTitle && field.get("displayname") != null) {
            contentText = field.get("displayname") + "\uff1a  " + contentText;
        }
        labelAp.setName(new LocaleString(contentText));
        String dataId = CardDrawElyMobHelper.getDataId(data);
        String key = dataId + "cr" + fieldName;
        FlexPanelAp contentRowAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setName(key).setHeight("20px").setMarginTop("8px")).build();
        contentRowAp.getItems().add(labelAp);
        return contentRowAp;
    }

    public static LabelAp createDefaultContentLabel(String key) {
        LabelAp labelAp = new LabelAp();
        labelAp.setName(new LocaleString(key));
        labelAp.setKey(key);
        labelAp.setForeColor("#999999");
        labelAp.setFontSize(14);
        return labelAp;
    }

    public static String getDataId(Map<String, String> data) {
        if (HRStringUtils.isNotEmpty((String)data.get("id"))) {
            return data.get("id");
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (!entry.getKey().endsWith(ID_SUFIXX)) continue;
            data.put("id", entry.getValue());
            return entry.getValue();
        }
        return null;
    }

    public static String getMainTabNameId(Map<String, String> data) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (!entry.getKey().endsWith(ID_SUFIXX)) continue;
            return entry.getKey().replace(ID_SUFIXX, "");
        }
        return null;
    }

    public static String getFullFieldName(Map<String, Object> field) {
        return field.get("pnumber") + "." + field.get("number");
    }

    public static String handleEndDate(String field, Date endDate, List<Tuple<String, String>> timeLineList) {
        String[] str = field.split("\\.");
        String dbDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(str[0]);
        if (PersonModelClassificationEnum.PERATTACHED != classification) {
            String dbDateTimeStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd", (TimeZone)KDDateUtils.getSysTimeZone()) + " 00:00:00";
            String currDateTimeStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd", (TimeZone)KDDateUtils.getSysTimeZone()) + " 00:00:00";
            Date dbDate = null;
            Date currDate = null;
            try {
                dbDate = HRDateTimeUtils.parseDate((String)dbDateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                currDate = HRDateTimeUtils.parseDate((String)currDateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException exc) {
                LOGGER.error("handlerDateException", (Throwable)exc);
            }
            if (HRDateTimeUtils.dayAfter((Date)dbDate, (Date)currDate)) {
                Optional<Tuple> opt = timeLineList.stream().filter(val -> val.item2 != null && field.equals(val.item2)).findAny();
                if (opt.isPresent()) {
                    return CardDrawElyMobHelper.getUpToNowString();
                }
                Optional<Tuple> optional = timeLineList.stream().filter(val -> val.item1 != null && field.equals(val.item1)).findAny();
                if (!optional.isPresent()) {
                    return "-";
                }
            }
        }
        return dbDateStr;
    }

    public static String getUpToNowString() {
        return ResManager.loadKDString((String)"\u81f3\u4eca", (String)"CardDrawHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
    }

    public static FlexPanelAp createNotDataFlext(String contentFlexKey) {
        FlexPanelAp flexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(contentFlexKey).setName(contentFlexKey).setDirection("column").setJustifyContent("center").setAlignItems("center").setWrap(true).setAlignContent("center").setBackColor("#ffffff").setMarginTop("1px")).setPaddingBottom("156px")).build();
        ImageAp imageAp = ((HRImageAp.Builder)new HRImageAp.Builder(contentFlexKey + "_img").setImageKey("/images/pc/emotion/fxjd_no_data.png").setWidth("224px").setHeight("128px").setMarginBottom("16px")).build();
        LabelAp labelAp = new HRLabelAp.Builder(contentFlexKey + "_lab").setName(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"CardDrawHelper_2", (String)"hr-hspm-business", (Object[])new Object[0])).setForeColor("#666").setFontSize(14).build();
        flexPanelAp.getItems().add(imageAp);
        flexPanelAp.getItems().add(labelAp);
        return flexPanelAp;
    }

    public static FlexPanelAp createNotDataFlextForCard(String contentFlexKey) {
        FlexPanelAp flexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(contentFlexKey).setName(contentFlexKey).setDirection("column").setJustifyContent("center").setAlignItems("center").setWrap(true).setAlignContent("center").setBackColor("#ffffff").setMarginTop("1px")).setMarginBottom("12px")).build();
        ImageAp imageAp = ((HRImageAp.Builder)new HRImageAp.Builder(contentFlexKey + "_img").setImageKey("/images/mobile/emotion/hr_wsjcard_112_64.png").setWidth("112px").setMarginBottom("16px")).build();
        LabelAp labelAp = new HRLabelAp.Builder(contentFlexKey + "_lab").setName(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"CardDrawHelper_2", (String)"hr-hspm-business", (Object[])new Object[0])).setForeColor("#999999").setFontSize(14).build();
        flexPanelAp.getItems().add(imageAp);
        flexPanelAp.getItems().add(labelAp);
        return flexPanelAp;
    }

    private static class ComparatorImpl
    implements Comparator {
        Map<String, Integer> fieldIndexMap;

        public ComparatorImpl(Map<String, Integer> fieldIndexMap) {
            this.fieldIndexMap = fieldIndexMap;
        }

        public int compare(Object o1, Object o2) {
            String key1 = CardDrawElyMobHelper.getField(o1);
            String key2 = CardDrawElyMobHelper.getField(o2);
            return this.fieldIndexMap.getOrDefault(key1, 0) - this.fieldIndexMap.getOrDefault(key2, 0);
        }
    }
}

