/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

public class FieldPermHelper {
    public static final String CACHE_FIELD_RULES = "cache_fieldRules";

    public static Map<String, Object> adjustConfigParamByFieldRules(Map<String, Object> tabMap, IFormView view) {
        String pageNumber = (String)tabMap.get("pagenumber");
        FieldControlRule fieldControlRule = FieldPermHelper.getFieldRules(pageNumber);
        if (fieldControlRule != null) {
            List<Map<String, Object>> groups;
            Set<String> canNotReadFields = fieldControlRule.getCanNotReadFields();
            Set<String> canNotWriteFields = fieldControlRule.getCanNotWriteFields();
            String rules = null;
            if (!CollectionUtils.isEmpty((Collection)canNotReadFields) || !CollectionUtils.isEmpty((Collection)canNotWriteFields)) {
                rules = SerializationUtils.toJsonString((Object)fieldControlRule);
            }
            if (view != null) {
                view.getPageCache().put(CACHE_FIELD_RULES, rules);
            }
            if (HRStringUtils.isEmpty((String)rules)) {
                return tabMap;
            }
            String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabMap);
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(mappingFormId);
            if (isSingleRowTpl || FieldPermHelper.isEduPage(mappingFormId) || "hspm_ermanfile".equals(mappingFormId)) {
                Map<String, String> permFieldFullNames = FieldPermHelper.getPermFieldFullNames(pageNumber);
                if (!CollectionUtils.isEmpty((Collection)canNotReadFields)) {
                    canNotReadFields = FieldPermHelper.changePermFields(canNotReadFields, permFieldFullNames);
                }
                if (!CollectionUtils.isEmpty((Collection)canNotWriteFields)) {
                    canNotWriteFields = FieldPermHelper.changePermFields(canNotWriteFields, permFieldFullNames);
                }
            }
            if (CollectionUtils.isEmpty(groups = ParamAnalysisUtil.getGroups(tabMap))) {
                return tabMap;
            }
            boolean isEdu = FieldPermHelper.isEduPage(mappingFormId);
            for (Map<String, Object> group : groups) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
                if (CollectionUtils.isEmpty(fields)) continue;
                Iterator<Map<String, Object>> iterator = fields.iterator();
                while (iterator.hasNext()) {
                    Map<String, Object> field = iterator.next();
                    String number = (String)field.get("number");
                    if (isEdu && field.get("pnumber") != null) {
                        number = FieldPermHelper.concatPrefix(field.get("pnumber").toString(), number);
                    }
                    if (canNotReadFields != null && canNotReadFields.contains(number)) {
                        iterator.remove();
                        continue;
                    }
                    if (canNotWriteFields == null || !canNotWriteFields.contains(number)) continue;
                    field.put("isedit", Boolean.FALSE);
                }
            }
            FieldPermHelper.handleGroups(groups, isEdu);
        }
        return tabMap;
    }

    private static void handleGroups(List<Map<String, Object>> groups, boolean isEdu) {
        List<Map<String, Object>> fields;
        if (groups.size() > 1) {
            Iterator<Map<String, Object>> iterator = groups.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> group = iterator.next();
                if (groups.size() <= 1 || !CollectionUtils.isEmpty(ParamAnalysisUtil.getFields(group))) continue;
                iterator.remove();
            }
        }
        if (isEdu && groups.size() == 1 && !CollectionUtils.isEmpty(fields = ParamAnalysisUtil.getFields(groups.get(0))) && "hrpi_pereduexpcert".equals(fields.get(0).get("pnumber"))) {
            fields.clear();
        }
    }

    public static String adjustConfigParamByFieldRules(String configStr) {
        if (HRStringUtils.isNotEmpty((String)configStr)) {
            Map tabMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            Map<String, Object> config = FieldPermHelper.adjustConfigParamByFieldRules(tabMap, null);
            return SerializationUtils.toJsonString(config);
        }
        return configStr;
    }

    private static boolean isEduPage(String mappingFormId) {
        return "hrpi_pereduexp".equals(mappingFormId) || "hrpi_pereduexpcert".equals(mappingFormId);
    }

    private static Set<String> changePermFields(Set<String> oldSet, Map<String, String> otherFieldsPerm) {
        HashSet<String> newSet = new HashSet<String>(oldSet.size());
        for (String field : oldSet) {
            String fieldName = otherFieldsPerm.get(field);
            if (HRStringUtils.isNotEmpty((String)fieldName)) {
                newSet.add(fieldName);
                continue;
            }
            newSet.add(field);
        }
        return newSet;
    }

    private static Map<String, String> getPermFieldFullNames(String pageNumber) {
        String id = MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Form);
        AbstractMetadata abstractMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)abstractMetadata;
        List apList = formMetadata.getItems();
        HashMap<String, String> result = new HashMap<String, String>(apList.size());
        if (!CollectionUtils.isEmpty((Collection)apList)) {
            String defaultPrefix = null;
            Optional<ControlAp> defaultPrefixOp = apList.stream().filter(val -> "defaultprefix".equals(val.getKey())).findFirst();
            if (defaultPrefixOp.isPresent()) {
                defaultPrefix = FieldPermHelper.getLocaleString(defaultPrefixOp.get().getName());
            }
            for (ControlAp ap : apList) {
                if (!(ap instanceof FieldAp)) continue;
                Tips tips = ((FieldAp)ap).getCtlTips();
                if (tips != null && HRStringUtils.isNotEmpty((String)FieldPermHelper.getLocaleString(tips.getContent()))) {
                    result.put(ap.getKey(), FieldPermHelper.getLocaleString(tips.getContent()));
                    continue;
                }
                if (HRStringUtils.isNotEmpty((String)defaultPrefix)) {
                    result.put(ap.getKey(), FieldPermHelper.concatPrefix(defaultPrefix, ap.getKey()));
                    continue;
                }
                result.put(ap.getKey(), ap.getKey());
            }
        }
        return result;
    }

    private static String concatPrefix(String prefix, String fieldName) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append("-");
        sb.append(fieldName);
        return sb.toString();
    }

    private static String getLocaleString(LocaleString locale) {
        if (locale != null) {
            if (HRStringUtils.isNotEmpty((String)locale.getLocaleValue())) {
                return locale.getLocaleValue();
            }
            return (String)locale.getDefaultItem();
        }
        return null;
    }

    public static FieldControlRule getFieldRules(String formId) {
        return (FieldControlRule)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getFieldRulesSum", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "hspm", formId});
    }

    public static boolean hasViewFieldPerm(String formId, String field) {
        FieldControlRule fieldControlRule = FieldPermHelper.getFieldRules(formId);
        return fieldControlRule == null || CollectionUtils.isEmpty((Collection)fieldControlRule.getCanNotReadFields()) || !fieldControlRule.getCanNotReadFields().contains(field);
    }

    public static void showMessage(IFormView view) {
        String msg = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u5b57\u6bb5\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FieldPermHelper_0", (String)"sdk-hr", (Object[])new Object[0]);
        view.showMessage(msg);
    }

    public static boolean isFieldRuleChange(IFormView view) {
        FieldControlRule newRule = FieldPermHelper.getFieldRules(FieldPermHelper.getRegisterPermFromId(view));
        Set oldCanNotReadFields = null;
        Set oldCanNotWriteFields = null;
        String fieldControlRuleStr = view.getPageCache().get(CACHE_FIELD_RULES);
        if (HRStringUtils.isNotEmpty((String)fieldControlRuleStr)) {
            FieldControlRule oldRule = (FieldControlRule)SerializationUtils.fromJsonString((String)fieldControlRuleStr, FieldControlRule.class);
            oldCanNotReadFields = oldRule.getCanNotReadFields();
            oldCanNotWriteFields = oldRule.getCanNotWriteFields();
        }
        if (FieldPermHelper.isChange(oldCanNotWriteFields, newRule != null ? newRule.getCanNotWriteFields() : null)) {
            return true;
        }
        return FieldPermHelper.isChange(oldCanNotReadFields, newRule != null ? newRule.getCanNotReadFields() : null);
    }

    public static String getRegisterPermFromId(IFormView view) {
        Map tabMap;
        String mappingFormId;
        String tabInfo = (String)view.getFormShowParameter().getCustomParam("params");
        if (HRStringUtils.isNotEmpty((String)tabInfo) && !"hspm_ermanfile".equals(mappingFormId = ParamAnalysisUtil.getMappingFormId(tabMap = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class))) && !InfoGroupHelper.isSingleRowTpl(mappingFormId) && view.getParentView() != null) {
            return view.getParentView().getEntityId();
        }
        return view.getEntityId();
    }

    private static boolean isChange(Set<String> oldSet, Set<String> newSet) {
        if (oldSet == null) {
            oldSet = new HashSet<String>();
        }
        if (newSet == null) {
            newSet = new HashSet<String>();
        }
        if (oldSet.size() != newSet.size()) {
            return true;
        }
        oldSet.removeAll(newSet);
        return oldSet.size() > 0;
    }

    public static Set<String> getCanNotReadFields(IFormView view) {
        FieldControlRule newRule = FieldPermHelper.getFieldRules(FieldPermHelper.getRegisterPermFromId(view));
        Set<Object> canNotReadFields = null;
        if (newRule != null && !CollectionUtils.isEmpty((Collection)newRule.getCanNotReadFields())) {
            canNotReadFields = newRule.getCanNotReadFields();
            String tabInfo = (String)view.getFormShowParameter().getCustomParam("params");
            Map tabMap = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
            String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabMap);
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(mappingFormId);
            if (isSingleRowTpl || "hspm_ermanfile".equals(mappingFormId)) {
                String pageNumber = (String)tabMap.get("pagenumber");
                Map<String, String> permFieldFullNames = FieldPermHelper.getPermFieldFullNames(pageNumber);
                if (!CollectionUtils.isEmpty(canNotReadFields)) {
                    canNotReadFields = FieldPermHelper.changePermFields(canNotReadFields, permFieldFullNames);
                }
            }
        }
        return canNotReadFields == null ? new HashSet(0) : canNotReadFields;
    }
}

