/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.common.ext.file.MobileHomeVectorDTO;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.MobileHomeExtUtil;

public class HomeElyMobHelper {
    private static final Log logger = LogFactory.getLog(HomeElyMobHelper.class);

    public static FlexPanelAp createRelatePageInfoPanelAp(IFormView homeView, List<Map<String, Object>> mainEntryList) {
        FlexPanelAp relatePanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("relatepageflexpanellistap").setWrap(false).setDirection("column").setJustifyContent("center").setAlignItems("flex-start").setAlignContent("flex-start").setGrow(1).setWidth("100%").setShrink(0).setPaddingLeft("12px")).setPaddingRight("12px")).build();
        if (mainEntryList == null || mainEntryList.size() == 0) {
            return relatePanelAp;
        }
        MobileHomeVectorDTO mobileHomeVectorDTO = new MobileHomeVectorDTO();
        MobileHomeExtUtil.modifyMobileHomeVector(mobileHomeVectorDTO);
        homeView.getPageCache().put("MOBILEHOMEVECTOR_DATA", SerializationUtils.toJsonString((Object)mobileHomeVectorDTO));
        HashMap<String, Integer> multiTabAddCheckMap = new HashMap<String, Integer>(mainEntryList.size());
        for (Map<String, Object> manMap : mainEntryList) {
            FlexPanelAp showDataPanel;
            String formId = (String)manMap.get("pagenumber");
            if (formId == null || formId.isEmpty() || formId.trim().length() == 0) {
                logger.info(MessageFormat.format("infogroup_data_ex:{0}", SerializationUtils.toJsonString(manMap)));
                continue;
            }
            if (!HomeElyMobHelper.isOldHss(homeView.getFormShowParameter()) && !CommonUtil.hasPerm(formId, "47150e89000000ac", "hssc", homeView)) {
                logger.info(MessageFormat.format("infogroup_not_perm:{0}", formId));
                continue;
            }
            String pageKey = (String)manMap.get("targetkey");
            String groupName = (String)manMap.get("groupname");
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl((String)manMap.get("mappingFormid"));
            FlexPanelAp infogroupCardAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("infogroupcard_" + pageKey).setWrap(true).setOverflow("visible").setDirection("column").setJustifyContent("center").setAlignItems("stretch").setGrow(1).setShrink(0).setBackColor("#ffffff").setClickable(isSingleRowTpl).setPaddingLeft("12px")).setPaddingRight("12px")).setMarginTop("12px")).setRadius("8px").setWidth("100%").build();
            FlexPanelAp itemPanelAp = HomeElyMobHelper.getInfoGroupTitleRow(mobileHomeVectorDTO, pageKey, groupName, isSingleRowTpl);
            infogroupCardAp.getItems().add(itemPanelAp);
            FlexPanelAp contentPanelAp = new HRFlexPanelAp.Builder("content" + pageKey).setWrap(false).setOverflow("visible").setDirection("row").setJustifyContent("space-between").setAlignItems("center").setGrow(1).setShrink(0).setWidth("100%").build();
            if (isSingleRowTpl) {
                showDataPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("datapanel" + pageKey).setWrap(false).setDirection("row").setAlignItems("center").setJustifyContent("flex-start").setPaddingBottom("8px")).setGrow(1).setShrink(0).setWidth("100%").build();
                HomeElyMobHelper.showFilePage(homeView, pageKey, ShowType.InContainer, "datapanel" + pageKey);
                contentPanelAp.getItems().add(showDataPanel);
                infogroupCardAp.getItems().add(contentPanelAp);
            } else {
                showDataPanel = new HRFlexPanelAp.Builder("datapanel" + pageKey).setWrap(false).setDirection("row").setAlignItems("center").setJustifyContent("flex-start").setGrow(1).setShrink(0).setWidth("100%").build();
                HomeElyMobHelper.showFilePage(homeView, pageKey, ShowType.InContainer, "datapanel" + pageKey);
                contentPanelAp.getItems().add(showDataPanel);
                infogroupCardAp.getItems().add(contentPanelAp);
                homeView.setVisible(Boolean.FALSE, new String[]{pageKey.toLowerCase(Locale.ROOT) + "-addvec"});
                multiTabAddCheckMap.put(pageKey, 3);
            }
            relatePanelAp.getItems().add(infogroupCardAp);
        }
        if (multiTabAddCheckMap.size() > 0) {
            homeView.getPageCache().put("multiTabAddCheckMap", SerializationUtils.toJsonString(multiTabAddCheckMap));
        }
        return relatePanelAp;
    }

    public static Map<String, Object> getMultivewConfigInfoGroup(IFormView homeView, String pageKey) {
        String cnfStr = homeView.getPageCache().get("cnfjson");
        if (!HRStringUtils.isEmpty((String)cnfStr)) {
            Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
            List tabEntryList = (List)infoGroupConfig.get("mainentry");
            for (Map map : tabEntryList) {
                if (!pageKey.equalsIgnoreCase(String.valueOf(map.get("targetkey")))) continue;
                return map;
            }
        }
        return null;
    }

    public static FlexPanelAp getInfoGroupTitleRow(MobileHomeVectorDTO mobileHomeVectorDTO, String pageKey, String groupName, boolean isSingleRowTpl) {
        FlexPanelAp itemPanelAp = new HRFlexPanelAp.Builder(pageKey).setWrap(false).setOverflow("visible").setDirection("row").setJustifyContent("space-between").setAlignItems("center").setGrow(1).setShrink(0).setBackColor("#ffffff").setClickable(isSingleRowTpl).setHeight("48px").setWidth("100%").build();
        FlexPanelAp leftFlex = new HRFlexPanelAp.Builder(pageKey + "left").setGrow(0).setJustifyContent("center").setShrink(0).setDirection("row").build();
        if (mobileHomeVectorDTO.getEnable()) {
            HomeElyMobHelper.MenuVectorEx(leftFlex, pageKey, mobileHomeVectorDTO, isSingleRowTpl);
        }
        LabelAp itemLabel = new HRLabelAp.Builder(pageKey + "-lbl").setId(pageKey + "-lbl").setName(groupName).setFontSize(16).setClickable(isSingleRowTpl).setForeColor("#212121").setTextAlign("flex-start").setGrow(0).setShrink(0).build();
        itemLabel.setFontWeight("500");
        leftFlex.getItems().add(itemLabel);
        FlexPanelAp build = new HRFlexPanelAp.Builder(pageKey + "right").setGrow(0).setJustifyContent("center").setShrink(0).setDirection("row").build();
        if (!pageKey.equals("auditRecord") && !pageKey.equals("changeRecord")) {
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(pageKey + "notpass");
            labelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u4e0d\u901a\u8fc7", (String)"InfoGroupApprovalUtil_2", (String)"sdk-hr", (Object[])new Object[0])));
            labelAp.setShrink(0);
            labelAp.setGrow(0);
            labelAp.setAlignSelf("center");
            labelAp.setForeColor("#FB2323");
            labelAp.setAutoTextWrap(false);
            labelAp.setFontSize(12);
            labelAp.setBackColor("#FFF2F4");
            labelAp.setRadius("2px");
            labelAp.setLineHeight("18px");
            labelAp.setHeight(new LocaleString("20px"));
            labelAp.setWidth(new LocaleString("76px"));
            labelAp.setTextAlign("center");
            leftFlex.getItems().add(labelAp);
            Style style = new Style();
            Border border = new Border();
            style.setBorder(border);
            labelAp.setStyle(style);
            border.setBottom("0.5px_solid_#FF8088");
            border.setTop("0.5px_solid_#FF8088");
            border.setRight("0.5px_solid_#FF8088");
            border.setLeft("0.5px_solid_#FF8088");
            Margin margin = new Margin();
            style.setMargin(margin);
            margin.setLeft("8px");
        }
        build.getItems().add(HomeElyMobHelper.getInfoGroupCardHeadOp(pageKey, isSingleRowTpl));
        itemPanelAp.getItems().add(leftFlex);
        itemPanelAp.getItems().add(build);
        return itemPanelAp;
    }

    public static void showFilePage(IFormView homeView, String page, ShowType showType, String targetKey) {
        String personId;
        String permItemId;
        logger.info(MessageFormat.format("page:{0},showType:{1},targetKey:{2}", page, showType, targetKey));
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(showType);
        String cnfStr = homeView.getPageCache().get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
        List mainentryList = (List)infoGroupConfig.get("mainentry");
        Optional<Map> configOp = mainentryList.stream().filter(val -> page != null && page.equalsIgnoreCase((String)val.get("targetkey"))).findFirst();
        String formId = null;
        String opStatus = "cus_view";
        if (configOp.isPresent()) {
            Map params = configOp.get();
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl((String)params.get("mappingFormid"));
            if (HRStringUtils.isEmpty((String)targetKey)) {
                if (isSingleRowTpl) {
                    formId = (String)params.get("pagenumber");
                    opStatus = "cus_edit";
                } else {
                    List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(params);
                    formId = !CollectionUtils.isEmpty(groups) && groups.size() > 1 && !HomeElyMobHelper.isEduPage(params) ? HomeElyMobHelper.handleMultiGroup(homeView, groups) : (String)params.get("dialogpagenumber");
                    opStatus = "cus_addnew";
                }
            } else {
                formId = (String)params.get("pagenumber");
                showParameter.setCustomParam("isfrominitopen", (Object)"1");
            }
            showParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString((Object)params));
        }
        if (HRStringUtils.isEmpty(formId)) {
            homeView.showErrorNotification(MessageFormat.format("system error! infogroup key:{0}, formId:{1}", page, formId));
            return;
        }
        if (HRStringUtils.isEmpty((String)targetKey) && !HomeElyMobHelper.isOldHss(homeView.getFormShowParameter()) && !CommonUtil.hasPerm(formId, permItemId = opStatus == "cus_addnew" ? "47156aff000000ac" : "47150e89000000ac", "hssc", homeView)) {
            homeView.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        if (showType.equals((Object)ShowType.InContainer)) {
            showParameter.getOpenStyle().setTargetKey(targetKey);
        }
        if (HRStringUtils.isNotEmpty((String)(personId = homeView.getPageCache().get("personId")))) {
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile(Long.parseLong(personId));
            HomeElyMobHelper.setCustomParams((FormShowParameter)showParameter, erFileDy);
        }
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put("cus_status", opStatus);
        String ispreview = homeView.getPageCache().get("ispreview");
        if (HRStringUtils.isNotEmpty((String)ispreview)) {
            showParameter.getCustomParams().put("ispreview", "1");
        }
        showParameter.setCaption(configOp.get().get("groupname").toString());
        showParameter.setHasRight(true);
        homeView.showForm((FormShowParameter)showParameter);
    }

    public static boolean isEduPage(Map<String, Object> tabList) {
        String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabList);
        return "hrpi_pereduexp".equals(mappingFormId) || "hrpi_pereduexpcert".equals(mappingFormId);
    }

    private static String handleMultiGroup(IFormView homeView, List<Map<String, Object>> groups) {
        Optional<Map> opt;
        String groupName;
        DynamicObject selGroupDy = homeView.getModel().getDataEntity().getDynamicObject("selectinfogroup");
        if (selGroupDy != null && HRStringUtils.isNotEmpty((String)(groupName = selGroupDy.getString("name"))) && (opt = groups.stream().filter(group -> groupName.equalsIgnoreCase((String)group.get("gname"))).findFirst()).isPresent()) {
            Map group2 = opt.get();
            groups.clear();
            groups.add(group2);
            return ParamAnalysisUtil.getDialogPageNumber(ParamAnalysisUtil.getFields(group2));
        }
        return null;
    }

    public static boolean isOldHss(FormShowParameter formShowParameter) {
        return "hss_businessoffice".equals(formShowParameter.getParentFormId());
    }

    public static void setCustomParams(FormShowParameter showParameter, DynamicObject erFileDy) {
        showParameter.setCustomParam("person", (Object)erFileDy.getLong("person.id"));
        showParameter.setCustomParam("employee", (Object)erFileDy.getLong("employee.id"));
        showParameter.setCustomParam("depemp", (Object)erFileDy.getLong("depemp.id"));
        showParameter.setCustomParam("cmpemp", (Object)erFileDy.getLong("cmpemp.id"));
        showParameter.setCustomParam("empentrel", (Object)erFileDy.getLong("empentrel.id"));
        showParameter.setCustomParam("empposrel", (Object)erFileDy.getLong("empposrel.id"));
        showParameter.setCustomParam("name", (Object)erFileDy.getString("name"));
        showParameter.setCustomParam("erfileid", (Object)erFileDy.getLong("id"));
    }

    public static VectorAp getInfoGroupCardHeadOp(String pageKey, boolean isSingleRowTpl) {
        String key = pageKey + (isSingleRowTpl ? "-vec" : "-addvec");
        String fontClass = isSingleRowTpl ? "kdfont kdfont-bianjixiugai" : "kdfont kdfont-zengjia-yuan";
        return ((HRVectorAp.Builder)new HRVectorAp.Builder(key).setId(key).setfontClass(fontClass).setWidth(new LocaleString("20px")).setHeight(new LocaleString("20px")).setMarginLeft("8px")).setFontSize(20).setForeColor("#666666").setAlignSelf("center").build();
    }

    private static void MenuVectorEx(FlexPanelAp leftFlex, String pageKey, MobileHomeVectorDTO mobileHomeVectorDTO, boolean isSingleRowTpl) {
        Map<String, String> colorAndSize;
        Map<String, Map<String, String>> colorAndSizeMap;
        Style vectorStyle;
        Map<String, String> vectorMap = mobileHomeVectorDTO.getVectorMap();
        String vectorPath = null;
        if (!CollectionUtils.isEmpty(vectorMap)) {
            vectorPath = vectorMap.get(pageKey);
        }
        VectorAp preVectorAp = ((HRVectorAp.Builder)new HRVectorAp.Builder(pageKey + "-vector").setfontClass(HRStringUtils.isNotEmpty((String)vectorPath) ? vectorPath : mobileHomeVectorDTO.getDefaultVetor()).setWidth(new LocaleString("16px")).setHeight(new LocaleString("16px")).setMarginRight("12px")).setAlignSelf("center").setClickable(isSingleRowTpl).build();
        Map<String, Style> vectorStyleMap = mobileHomeVectorDTO.getVectorStyleMap();
        if (!CollectionUtils.isEmpty(vectorStyleMap) && (vectorStyle = vectorStyleMap.get(pageKey)) != null) {
            preVectorAp.setStyle(vectorStyle);
        }
        if (!CollectionUtils.isEmpty(colorAndSizeMap = mobileHomeVectorDTO.getColorAndSizeMap()) && (colorAndSize = colorAndSizeMap.get(pageKey)) != null && !colorAndSize.isEmpty()) {
            String zindex;
            String alignself;
            String customestyles;
            String shrink;
            String grow;
            String radius;
            String fontweight;
            String fontsize;
            String fontclass;
            String height;
            String width;
            String backcolor;
            String forecolor = colorAndSize.get("forecolor");
            if (HRStringUtils.isNotEmpty((String)forecolor)) {
                preVectorAp.setForeColor(forecolor);
            }
            if (HRStringUtils.isNotEmpty((String)(backcolor = colorAndSize.get("backcolor")))) {
                preVectorAp.setBackColor(backcolor);
            }
            if (HRStringUtils.isNotEmpty((String)(width = colorAndSize.get("width")))) {
                preVectorAp.setWidth(new LocaleString(width));
            }
            if (HRStringUtils.isNotEmpty((String)(height = colorAndSize.get("height")))) {
                preVectorAp.setHeight(new LocaleString(height));
            }
            if (HRStringUtils.isNotEmpty((String)(fontclass = colorAndSize.get("fontclass")))) {
                preVectorAp.setfontClass(fontclass);
            }
            if (HRStringUtils.isNotEmpty((String)(fontsize = colorAndSize.get("fontsize")))) {
                preVectorAp.setFontSize(Integer.parseInt(fontsize));
            }
            if (HRStringUtils.isNotEmpty((String)(fontweight = colorAndSize.get("fontweight")))) {
                preVectorAp.setFontWeight(fontweight);
            }
            if (HRStringUtils.isNotEmpty((String)(radius = colorAndSize.get("radius")))) {
                preVectorAp.setRadius(radius);
            }
            if (HRStringUtils.isNotEmpty((String)(grow = colorAndSize.get("grow")))) {
                preVectorAp.setGrow(Integer.parseInt(grow));
            }
            if (HRStringUtils.isNotEmpty((String)(shrink = colorAndSize.get("shrink")))) {
                preVectorAp.setShrink(Integer.parseInt(shrink));
            }
            if (HRStringUtils.isNotEmpty((String)(customestyles = colorAndSize.get("customestyles")))) {
                preVectorAp.setCustomeStyles(customestyles);
            }
            if (HRStringUtils.isNotEmpty((String)(alignself = colorAndSize.get("alignself")))) {
                preVectorAp.setAlignSelf(alignself);
            }
            if (HRStringUtils.isNotEmpty((String)(zindex = colorAndSize.get("zindex")))) {
                preVectorAp.setZIndex(Integer.parseInt(zindex));
            }
        }
        leftFlex.getItems().add(preVectorAp);
    }

    public static void handleCardAddOp(IFormView homeView) {
        String multiTabAddCheckMapStr = homeView.getPageCache().get("multiTabAddCheckMap");
        if (HRStringUtils.isEmpty((String)multiTabAddCheckMapStr)) {
            return;
        }
        Map multiTabAddCheckMap = (Map)SerializationUtils.fromJsonString((String)multiTabAddCheckMapStr, Map.class);
        Iterator iterator = multiTabAddCheckMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String targetKey = (String)entry.getKey();
            String cardOpCache = homeView.getPageCache().get("cardOpCache_" + targetKey);
            if (HRStringUtils.isNotEmpty((String)cardOpCache)) {
                Map cardOpMap = (Map)SerializationUtils.fromJsonString((String)cardOpCache, Map.class);
                if (Boolean.TRUE.equals(cardOpMap.get("hasAddOperate"))) {
                    homeView.setVisible(Boolean.TRUE, new String[]{targetKey.toLowerCase(Locale.ROOT) + "-addvec"});
                }
                iterator.remove();
                continue;
            }
            if ((Integer)entry.getValue() == 1) {
                iterator.remove();
                continue;
            }
            entry.setValue((Integer)entry.getValue() - 1);
        }
        if (multiTabAddCheckMap.size() > 0) {
            homeView.getPageCache().put("multiTabAddCheckMap", SerializationUtils.toJsonString((Object)multiTabAddCheckMap));
            homeView.addClientCallBack("handleCardAddOp", Integer.valueOf(1000));
        } else {
            homeView.getPageCache().remove("multiTabAddCheckMap");
        }
    }
}

