/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

public class HspmDesensitizeHelper {
    private static final Log LOGGER = LogFactory.getLog(HspmDesensitizeHelper.class);
    private static final String ISPRIVACY = "isprivacy";
    private static final String CAN_SHOWDETAIL = "canshowdetail";
    private static final String PRIVACY = "privacy";
    private static final String ITEM = "item";
    private static final String SHOWIDSLIST = "showidslist";

    public static void handleDesensitizeFieldForFrom(IFormView view, Map<String, Object> tabList) {
        if (view.getFormShowParameter().getStatus() != OperationStatus.ADDNEW && tabList != null) {
            String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabList);
            String targetKey = (String)tabList.get("targetkey");
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(mappingFormId);
            List<String> dataCache = null;
            Map<String, List<String>> desensitizeCache = HspmDesensitizeHelper.getDesensitizeCache(view);
            if (desensitizeCache != null) {
                dataCache = desensitizeCache.get(targetKey);
            }
            if (isSingleRowTpl) {
                HspmDesensitizeHelper.handleDesensitizeFieldForSingleTabFrom(view, tabList, dataCache);
            } else {
                List<Map<String, Object>> groups;
                List<Map<String, Object>> fields;
                String pkId = (String)view.getFormShowParameter().getCustomParam("pkid");
                if (pkId != null && (fields = ParamAnalysisUtil.getFields((groups = ParamAnalysisUtil.getGroups(tabList)).get(0))) != null && fields.size() > 0) {
                    String pageNumber = ParamAnalysisUtil.getPageNumber(fields);
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
                    DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
                    String dataDesKey = pageNumber + pkId;
                    if (dataCache == null || !dataCache.contains(dataDesKey)) {
                        for (Map<String, Object> field : fields) {
                            String fieldKey = (String)field.get("number");
                            boolean fieldLeveDes = dataCache != null && dataCache.contains(dataDesKey + fieldKey);
                            if (fieldLeveDes || !PrivacyCenterServiceHelper.isDesensitizeField((String)pageNumber, (String)fieldKey, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)emptyDynamicObject)) continue;
                            HspmDesensitizeHelper.setDesensitizedFieldForFrom(view, fieldKey, emptyDynamicObject, fieldKey);
                        }
                        if (InfoGroupHelper.isEduPage(mappingFormId) && groups.size() > 1) {
                            HspmDesensitizeHelper.handleEduDesensitizeField(view, dataCache, dataDesKey);
                        }
                    }
                }
            }
        }
    }

    private static void handleEduDesensitizeField(IFormView view, List<String> dataCache, String dataDesKey) {
        String idsListStr = view.getPageCache().get(SHOWIDSLIST);
        if (HRStringUtils.isNotEmpty((String)idsListStr)) {
            List showCertTypeids = (List)SerializationUtils.fromJsonString((String)idsListStr, List.class);
            DataEntityPropertyCollection properties = view.getModel().getDataEntityType().getProperties();
            HRBaseServiceHelper serviceHelper2 = new HRBaseServiceHelper("hrpi_pereduexpcert");
            DynamicObject emptyDynamicObject2 = serviceHelper2.generateEmptyDynamicObject();
            for (IDataEntityProperty property : properties) {
                boolean fieldLeveDes;
                String[] names;
                String name = property.getName();
                if (!name.contains("-") || !showCertTypeids.contains((names = name.split("-"))[names.length - 1]) || (fieldLeveDes = dataCache != null && dataCache.contains(dataDesKey + name)) || !PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_pereduexpcert", (String)names[0], (String)Lang.get().toString(), (String)"FORM", (DynamicObject)emptyDynamicObject2)) continue;
                HspmDesensitizeHelper.setDesensitizedFieldForFrom(view, name, emptyDynamicObject2, names[0]);
            }
        }
    }

    private static void handleDesensitizeFieldForSingleTabFrom(IFormView view, Map<String, Object> tabList, List<String> dataCache) {
        HashMap<String, ArrayList<Map<String, Object>>> groupByMappingFormid = new HashMap<String, ArrayList<Map<String, Object>>>(4);
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        if (!CollectionUtils.isEmpty(groups)) {
            for (Map map : groups) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(map);
                if (CollectionUtils.isEmpty(fields)) continue;
                for (Map<String, Object> field : fields) {
                    String pageNumber = (String)field.get("pnumber");
                    ArrayList<Map<String, Object>> fieldList = (ArrayList<Map<String, Object>>)groupByMappingFormid.get(pageNumber);
                    if (fieldList == null) {
                        fieldList = new ArrayList<Map<String, Object>>();
                        groupByMappingFormid.put(pageNumber, fieldList);
                    }
                    fieldList.add(field);
                }
            }
        }
        for (Map.Entry entry : groupByMappingFormid.entrySet()) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper((String)entry.getKey());
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            List fieldList = (List)entry.getValue();
            for (Map field : fieldList) {
                String origField = (String)field.get("origfield");
                String fieldKey = (String)field.get("number");
                if (dataCache != null && dataCache.contains(fieldKey) || !PrivacyCenterServiceHelper.isDesensitizeField((String)((String)entry.getKey()), (String)origField, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)emptyDynamicObject)) continue;
                HspmDesensitizeHelper.setDesensitizedFieldForFrom(view, fieldKey, emptyDynamicObject, origField);
            }
        }
    }

    public static void setDesensitizedFieldForFrom(IFormView view, String fldKey, DynamicObject mappingDy, String mappingField) {
        if (view != null && mappingDy != null && view.getModel().getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)fldKey)) {
            IDataEntityProperty fieldProperty;
            Object value = view.getModel().getValue(fldKey);
            if (value != null && !"".equals(value) && (fieldProperty = (IDataEntityProperty)mappingDy.getDynamicObjectType().getProperties().get((Object)mappingField)) != null) {
                String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)fieldProperty, (String)"FORM", (DynamicObject)mappingDy);
                if ("PLAINTEXT".equals(strategy)) {
                    return;
                }
                ClientViewProxy clientViewProxy = (ClientViewProxy)view.getService(IClientViewProxy.class);
                if ("CLICKVIEW".equals(strategy)) {
                    HspmDesensitizeHelper.setDesensitizedField(view, fldKey, Boolean.TRUE, Boolean.TRUE);
                }
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getString("name");
                }
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)fieldProperty, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)mappingDy, (Object)value);
                clientViewProxy.setFieldProperty(fldKey, "v", desensitizeValue);
            }
        } else {
            LOGGER.warn(MessageFormat.format("setDesensitizedFieldForFrom_warn not exist the field:{0}", fldKey));
        }
    }

    public static void setDesensitizedField(IFormView view, String fldKey, Boolean isPrivacy, Boolean canshowdetail) {
        ClientViewProxy clientViewProxy = (ClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        map.put(ISPRIVACY, isPrivacy);
        map.put(CAN_SHOWDETAIL, canshowdetail);
        HashMap<String, HashMap<String, Boolean>> privacyMap = new HashMap<String, HashMap<String, Boolean>>(2);
        privacyMap.put(PRIVACY, map);
        HashMap<String, HashMap<String, HashMap<String, Boolean>>> ctl = new HashMap<String, HashMap<String, HashMap<String, Boolean>>>(2);
        ctl.put(ITEM, privacyMap);
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(fldKey);
        paras.add(ctl);
        clientViewProxy.addAction("updateControlMetadata", paras);
        clientViewProxy.setControlMetaState(fldKey, ISPRIVACY, (Object)isPrivacy);
    }

    public static void saveDesensitizeOpForFrom(IFormView view, OnGetControlArgs args) {
        OperationContext operationContext = OperationContext.get();
        if (operationContext != null && "getPlainText".equals(operationContext.getOpMethod()) && args.getKey().equals(operationContext.getOpKey())) {
            Map<String, Object> tabList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
            String targetKey = (String)tabList.get("targetkey");
            Map<String, List<String>> desensitizeCache = HspmDesensitizeHelper.getDesensitizeCacheWithCreate(view);
            List<String> dataCache = HspmDesensitizeHelper.getDataCacheWithCreate(desensitizeCache, targetKey);
            String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabList);
            String dataContent = operationContext.getOpKey();
            view.getFormShowParameter().getCustomParam("pkid");
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(mappingFormId);
            if (!isSingleRowTpl && groups != null && groups.size() > 0) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(groups.get(0));
                dataContent = ParamAnalysisUtil.getPageNumber(fields) + view.getFormShowParameter().getCustomParam("pkid") + dataContent;
            }
            if (dataContent != null && !dataCache.contains(dataContent)) {
                Object clearVal;
                dataCache.add(dataContent);
                HspmDesensitizeHelper.saveDesensitizeCache(view, desensitizeCache);
                HspmDesensitizeHelper.setDesensitizedField(view, operationContext.getOpKey(), Boolean.FALSE, Boolean.TRUE);
                DynamicObject dynamicObject = view.getModel().getDataEntity();
                IDataEntityProperty fieldProperty = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)operationContext.getOpKey());
                try {
                    Control control = args.getControl();
                    BindingContext bindingContext = new BindingContext((Object)dynamicObject, 0);
                    clearVal = ((FieldEdit)control).getBindingValue(bindingContext);
                }
                catch (Exception ex) {
                    LOGGER.error("HspmDesensitizeHelper#saveDesensitizeOpForFrom getBindingValue error", (Throwable)ex);
                    clearVal = fieldProperty.getValue((Object)dynamicObject);
                }
                args.setControl(null);
                ClientViewProxy clientViewProxy = (ClientViewProxy)view.getService(IClientViewProxy.class);
                HashMap<String, Object> data = new HashMap<String, Object>(6);
                data.put("v", clearVal);
                clientViewProxy.invokeControlMethod(operationContext.getOpKey(), "setPlainText", new Object[]{data});
            }
        }
    }

    public static void saveDesensitizeCache(IFormView view, Map<String, List<String>> desensitizeCache) {
        PageCacheUtils.getHomePageCache(view).put("desensitize_cache", SerializationUtils.toJsonString(desensitizeCache));
    }

    public static Map<String, List<String>> getDesensitizeCache(IFormView view) {
        IPageCache homePage = PageCacheUtils.getHomePageCache(view);
        String desensitizeCache = homePage.get("desensitize_cache");
        if (desensitizeCache != null) {
            return (Map)SerializationUtils.fromJsonString((String)desensitizeCache, Map.class);
        }
        return null;
    }

    public static Map<String, List<String>> getDesensitizeCacheWithCreate(IFormView view) {
        Map<String, List<String>> desensitizeCache = HspmDesensitizeHelper.getDesensitizeCache(view);
        if (desensitizeCache == null) {
            return new HashMap<String, List<String>>(2);
        }
        return desensitizeCache;
    }

    public static List<String> getDataCacheWithCreate(Map<String, List<String>> desensitizeCache, String key) {
        List<String> dataCache = desensitizeCache.get(key);
        if (dataCache == null) {
            dataCache = new ArrayList<String>(2);
            desensitizeCache.put(key, dataCache);
        }
        return dataCache;
    }
}

