/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ImportBasedataHelper {
    private static final Log LOGGER = LogFactory.getLog(ImportBasedataHelper.class);
    private static final Long LABRELSTATUSPRD_ING = 1010L;
    private static final Long LABRELSTATUSPRD_END = 1020L;

    public static DynamicObjectCollection queryImportHisBaseData(List<Object> ids, String entityId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("id", "in", ids));
        qFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilterList.add(new QFilter("datastatus", "=", (Object)"1"));
        return helper.queryOriginalCollection("id", qFilterList.toArray(new QFilter[0]));
    }

    public static Map<Object, DynamicObject> queryLanguagecert(List<Object> ids, String languageName) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter languageFilter = new QFilter("languagetype.name", "=", (Object)languageName);
        return BusinessDataServiceHelper.loadFromCache((String)"hbss_languagecert", (String)"id", (QFilter[])new QFilter[]{idFilter, languageFilter});
    }

    public static List<Long> queryPersonBaseData(List<Object> personIdList) {
        if (personIdList.size() == 1) {
            return personIdList.stream().map(personId -> Long.parseLong(String.valueOf(personId))).collect(Collectors.toList());
        }
        LOGGER.info("ImportBasedataHelper#queryPersonBaseData personIdList:{}.", personIdList);
        DynamicObject[] empDyArr = ImportBasedataHelper.queryEmpByPersonIdList(personIdList);
        Map<Long, List<DynamicObject>> empDyListMap = Stream.of(empDyArr).collect(Collectors.groupingBy(empDy -> empDy.getLong("labrelstatusprd.id")));
        List<DynamicObject> empDyIngList = empDyListMap.get(LABRELSTATUSPRD_ING);
        if (!CollectionUtils.isEmpty(empDyIngList)) {
            return empDyIngList.stream().map(empDy -> empDy.getLong("person.id")).collect(Collectors.toList());
        }
        ArrayList<Long> resultPersonIdList = new ArrayList<Long>(empDyListMap.size());
        for (Map.Entry<Long, List<DynamicObject>> empDyListEntry : empDyListMap.entrySet()) {
            Long labrelstatusprdId = empDyListEntry.getKey();
            List<DynamicObject> empDyList = empDyListEntry.getValue();
            if (Objects.equals(labrelstatusprdId, LABRELSTATUSPRD_END)) {
                if (empDyList.size() == 1) {
                    resultPersonIdList.add(empDyList.get(0).getLong("person.id"));
                    continue;
                }
                Optional<DynamicObject> maxEnddateDyOptional = empDyList.stream().max(Comparator.comparing(o -> o.getDate("enddate")));
                if (maxEnddateDyOptional.isPresent()) {
                    DynamicObject maxEnddateDy = maxEnddateDyOptional.get();
                    resultPersonIdList.addAll(empDyList.stream().filter(empDy -> empDy.getDate("enddate").compareTo(maxEnddateDy.getDate("enddate")) == 0).map(empDy -> empDy.getLong("person.id")).collect(Collectors.toList()));
                    continue;
                }
                LOGGER.info("ImportBasedataHelper#queryPersonBaseData personIdList:{}, labrelstatusprdId {} has no max enddate.", personIdList, (Object)labrelstatusprdId);
                continue;
            }
            LOGGER.info("ImportBasedataHelper#queryPersonBaseData personIdList:{}, labrelstatusprdId not match. {}", personIdList, (Object)labrelstatusprdId);
        }
        return resultPersonIdList;
    }

    public static DynamicObject[] queryEmpByPersonIdList(List<Object> personIdList) {
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_empentrel");
        ArrayList qFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("person", "in", personIdList), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
        return empHelper.queryOriginalArray("person.id,labrelstatusprd.id,startdate,enddate", qFilterList.toArray(new QFilter[0]));
    }
}

