/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.repository.ext.service.InfoClassifyRepository;
import kd.sdk.hr.hspm.business.service.IInfoClassifyAttachmentService;
import kd.sdk.hr.hspm.business.service.IInfoClassifyService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class InfoClassifyServiceImpl
implements IInfoClassifyService {
    private static final Log LOGGER = LogFactory.getLog(InfoClassifyServiceImpl.class);
    private InfoClassifyRepository infoClassifyRepository;
    private InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO;

    public InfoClassifyServiceImpl(String number) {
        this.infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey(number);
        if (this.infoClassifyEntityKeyDTO != null) {
            this.infoClassifyRepository = new InfoClassifyRepository(number, this.infoClassifyEntityKeyDTO.getSourceKey());
        }
    }

    @Override
    public DynamicObject getInfoByPkId(Long pkId) {
        return this.infoClassifyRepository.getInfo(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertInfo(DynamicObject dataEntity) {
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyRepository.getInvokeSaveByInfo(dataEntity));
        Map<String, Object> resultMap = IInfoClassifyAttachmentService.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertInfo the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg(dataEntity, this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult updateInfo(Long pkId, DynamicObject dataEntity) {
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyRepository.getInvokeUpdateByInfo(pkId, dataEntity));
        Map<String, Object> resultMap = IInfoClassifyAttachmentService.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updateInfo the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg(dataEntity, this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult deleteInfo(List<Long> pkIdList) {
        DynamicObject[] dbDyArr = this.infoClassifyRepository.queryHrpiInfoForPerChg(pkIdList);
        Map<String, Object> resultMap = IInfoClassifyAttachmentService.attacheHandlerService.invokeDel(pkIdList, this.infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult.validate(resultMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deleteInfo the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg(dbDyArr, this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportInfo(String importtype, DynamicObject[] dataEntities) {
        DynamicObject[] importSaveDys = this.infoClassifyRepository.getImportSaveByInfo(dataEntities);
        Map<String, Object> resultMap = IInfoClassifyAttachmentService.attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportInfo the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg(dataEntities, this.infoClassifyEntityKeyDTO.getSourceKey(), this.infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.infoClassifyRepository.queryByPkIdList(pkIdList);
        return existsPkIdArr.length > 0 ? Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList()) : new ArrayList<Long>();
    }
}

