/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HpfsChgexternalrecordQueueDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long personId;
    private long employeeId = 0L;
    private long cmpEmpId = 0L;
    private long depEmpId = 0L;
    private long bsed;
    private String billNo;
    private String billSource;
    private String resultCallBackQueue;
    private List<Map<String, List<DataRowEntity>>> dataRow = new ArrayList<Map<String, List<DataRowEntity>>>();

    private HpfsChgexternalrecordQueueDto(long personId) {
        this.personId = personId;
    }

    private HpfsChgexternalrecordQueueDto(long personId, long employeeId, long cmpEmpId, long depEmpId) {
        this.personId = personId;
        this.employeeId = employeeId;
        this.cmpEmpId = cmpEmpId;
        this.depEmpId = depEmpId;
    }

    public static HpfsChgexternalrecordQueueDto build(long personId, DynamicObject ermanFileDy) {
        if (HRObjectUtils.isEmpty((Object)ermanFileDy)) {
            return new HpfsChgexternalrecordQueueDto(personId);
        }
        return new HpfsChgexternalrecordQueueDto(personId, ermanFileDy.getLong("employee.id"), ermanFileDy.getLong("cmpemp.id"), ermanFileDy.getLong("depemp.id"));
    }

    public HpfsChgexternalrecordQueueDto setBsed(long bsed) {
        this.bsed = bsed;
        return this;
    }

    public HpfsChgexternalrecordQueueDto setResultCallBackQueue(String resultCallBackQueue) {
        this.resultCallBackQueue = resultCallBackQueue;
        return this;
    }

    public HpfsChgexternalrecordQueueDto setBillNo(String billNo) {
        this.billNo = billNo;
        return this;
    }

    public HpfsChgexternalrecordQueueDto setBillSource(String billSource) {
        this.billSource = billSource;
        return this;
    }

    public HpfsChgexternalrecordQueueDto addDataRow(String entityNumber, Consumer<List<DataRowEntity>> consumer) {
        boolean isMatch = false;
        for (Map<String, List<DataRowEntity>> dataRowMap : this.dataRow) {
            List<DataRowEntity> dataRowEntityList = dataRowMap.get(entityNumber);
            if (dataRowEntityList == null || dataRowEntityList.isEmpty()) continue;
            isMatch = true;
            consumer.accept(dataRowEntityList);
            dataRowMap.put(entityNumber, dataRowEntityList);
            break;
        }
        if (!isMatch) {
            HashMap dataRowMap = new HashMap(16);
            ArrayList dataRowEntityList = new ArrayList();
            consumer.accept(dataRowEntityList);
            dataRowMap.put(entityNumber, dataRowEntityList);
            this.dataRow.add(dataRowMap);
        }
        return this;
    }

    public List<Map<String, List<DataRowEntity>>> getDataRow() {
        return this.dataRow;
    }

    public String request() {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("personId", this.personId);
        requestMap.put("employeeId", this.employeeId);
        requestMap.put("cmpEmpId", this.cmpEmpId);
        requestMap.put("depEmpId", this.depEmpId);
        requestMap.put("actionId", 1240L);
        requestMap.put("bsed", this.bsed);
        requestMap.put("billNo", this.billNo);
        requestMap.put("billSource", this.billSource);
        ArrayList dataRowList = new ArrayList(this.dataRow.size());
        for (Map<String, List<DataRowEntity>> dataRows : this.dataRow) {
            HashMap dataRowMap = new HashMap(dataRows.size());
            for (Map.Entry<String, List<DataRowEntity>> entry : dataRows.entrySet()) {
                String key = entry.getKey();
                List dataRowEntityMapList = entry.getValue().stream().map(dataRowEntity -> {
                    HashMap<String, Object> dataRowEntityMap = new HashMap<String, Object>(16);
                    dataRowEntityMap.put("idBefore", ((DataRowEntity)dataRowEntity).idBefore);
                    dataRowEntityMap.put("vidBefore", ((DataRowEntity)dataRowEntity).vidBefore);
                    dataRowEntityMap.put("idAfter", ((DataRowEntity)dataRowEntity).idAfter);
                    dataRowEntityMap.put("vidAfter", ((DataRowEntity)dataRowEntity).vidAfter);
                    dataRowEntityMap.put("flowType", ((DataRowEntity)dataRowEntity).flowType);
                    dataRowEntityMap.put("chgMode", ((DataRowEntity)dataRowEntity).chgMode);
                    return dataRowEntityMap;
                }).collect(Collectors.toList());
                dataRowMap.put(key, dataRowEntityMapList);
            }
            dataRowList.add(dataRowMap);
        }
        requestMap.put("dataRow", dataRowList);
        requestMap.put("resultCallBackQueue", this.resultCallBackQueue);
        return SerializationUtils.toJsonString(requestMap);
    }

    public static DataRowEntity buildDataRowEntityForHisNonLineInsert(Long idAfter) {
        DataRowEntity dataRowEntity = new DataRowEntity();
        dataRowEntity.setIdAfter(idAfter);
        dataRowEntity.setChgMode("0");
        return dataRowEntity;
    }

    public static DataRowEntity buildDataRowEntityForHisNonLineUpdate(Long idBefore, Long vidBefore, Long idAfter) {
        DataRowEntity dataRowEntity = new DataRowEntity();
        dataRowEntity.setIdBefore(idBefore);
        dataRowEntity.setVidBefore(vidBefore);
        dataRowEntity.setIdAfter(idAfter);
        dataRowEntity.setChgMode("1");
        return dataRowEntity;
    }

    public static DataRowEntity buildDataRowEntityForHisNonLineDelete(Long idBefore, Long vidBefore) {
        DataRowEntity dataRowEntity = new DataRowEntity();
        dataRowEntity.setIdBefore(idBefore);
        dataRowEntity.setVidBefore(vidBefore);
        dataRowEntity.setChgMode("3");
        return dataRowEntity;
    }

    public static DataRowEntity buildDataRowEntityForHisLineInsert(Long idAfter, Long vidAfter) {
        DataRowEntity dataRowEntity = new DataRowEntity();
        dataRowEntity.setIdAfter(idAfter);
        dataRowEntity.setVidAfter(vidAfter);
        dataRowEntity.setChgMode("0");
        return dataRowEntity;
    }

    public static DataRowEntity buildDataRowEntityForHisLineUpdate(Long idBefore, Long vidBefore, Long idAfter, Long vidAfter) {
        DataRowEntity dataRowEntity = new DataRowEntity();
        dataRowEntity.setIdBefore(idBefore);
        dataRowEntity.setVidBefore(vidBefore);
        dataRowEntity.setIdAfter(idAfter);
        dataRowEntity.setVidAfter(vidAfter);
        dataRowEntity.setChgMode("1");
        return dataRowEntity;
    }

    public static class DataRowEntity
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long idBefore = 0L;
        private long vidBefore = 0L;
        private long idAfter = 0L;
        private long vidAfter = 0L;
        private String flowType = "0";
        private String chgMode = "4";

        public DataRowEntity setIdBefore(long idBefore) {
            this.idBefore = idBefore;
            return this;
        }

        public DataRowEntity setVidBefore(long vidBefore) {
            this.vidBefore = vidBefore;
            return this;
        }

        public DataRowEntity setIdAfter(long idAfter) {
            this.idAfter = idAfter;
            return this;
        }

        public DataRowEntity setVidAfter(long vidAfter) {
            this.vidAfter = vidAfter;
            return this;
        }

        public DataRowEntity setFlowType(String flowType) {
            this.flowType = flowType;
            return this;
        }

        public DataRowEntity setChgMode(String chgMode) {
            this.chgMode = chgMode;
            return this;
        }
    }
}

