/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InfoClassifyEntityKeyDTO
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(InfoClassifyEntityKeyDTO.class);
    private static final long serialVersionUID = -4138136528990463229L;
    private String formKey;
    private String queryKey;
    private String listKey;
    private String tabKey;
    private String sourceKey;
    private String defaultImportType;
    private List<String> defaultLockUIs = new ArrayList<String>(10);
    private String importPlugin;

    public static void initCacheMap() {
    }

    private static DynamicObject queryByKey(String dbKey, String value) {
        HRBaseServiceHelper cnfHelper = new HRBaseServiceHelper("hspm_infoclassifycnf");
        return cnfHelper.loadDynamicObject(new QFilter[]{new QFilter(dbKey, "=", (Object)value)});
    }

    private static InfoClassifyEntityKeyDTO setDyToDTO(DynamicObject cacheDy) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = new InfoClassifyEntityKeyDTO();
        infoClassifyEntityKeyDTO.setFormKey(cacheDy.getString("formkey"));
        infoClassifyEntityKeyDTO.setQueryKey(cacheDy.getString("querykey"));
        infoClassifyEntityKeyDTO.setListKey(cacheDy.getString("listkey"));
        infoClassifyEntityKeyDTO.setTabKey(cacheDy.getString("tabkey"));
        infoClassifyEntityKeyDTO.setSourceKey(cacheDy.getString("sourcekey"));
        infoClassifyEntityKeyDTO.setDefaultImportType(cacheDy.getString("defaultimporttype"));
        String lockUi = cacheDy.getString("defaultlockuis");
        if (HRStringUtils.isNotEmpty((String)lockUi)) {
            infoClassifyEntityKeyDTO.setDefaultLockUIs(Arrays.asList(lockUi.split(",")));
        }
        infoClassifyEntityKeyDTO.setImportPlugin(cacheDy.getString("importplugin"));
        return infoClassifyEntityKeyDTO;
    }

    private static InfoClassifyEntityKeyDTO queryDTOByKey(String formKey, String queryKey) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hspm:InfoClassifyEntityKeyDTO");
        String cache = (String)ihrAppCache.get(formKey, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            return (InfoClassifyEntityKeyDTO)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        DynamicObject dynamicObject = InfoClassifyEntityKeyDTO.queryByKey(queryKey, formKey);
        if (dynamicObject != null) {
            InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.setDyToDTO(dynamicObject);
            ihrAppCache.put(formKey, (Object)SerializationUtils.serializeToBase64((Object)infoClassifyEntityKeyDTO));
            LOGGER.info("queryDTOByKey_From_db");
            return infoClassifyEntityKeyDTO;
        }
        return null;
    }

    public static InfoClassifyEntityKeyDTO getEntityKeyEnumByFormKey(String formKey) {
        return InfoClassifyEntityKeyDTO.queryDTOByKey(formKey, "formkey");
    }

    public static InfoClassifyEntityKeyDTO getEntityKeyEnumByListKey(String listKey) {
        return InfoClassifyEntityKeyDTO.queryDTOByKey(listKey, "listkey");
    }

    public static InfoClassifyEntityKeyDTO getEntityKeyEnumByQueryKey(String queryKey) {
        return InfoClassifyEntityKeyDTO.queryDTOByKey(queryKey, "querykey");
    }

    public String getFormKey() {
        return this.formKey;
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public String getListKey() {
        return this.listKey;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getDefaultImportType() {
        return this.defaultImportType;
    }

    public List<String> getDefaultLockUIs() {
        return this.defaultLockUIs;
    }

    public String getImportPlugin() {
        return this.importPlugin;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    public void setTabKey(String tabKey) {
        this.tabKey = tabKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public void setDefaultImportType(String defaultImportType) {
        this.defaultImportType = defaultImportType;
    }

    public void setDefaultLockUIs(List<String> defaultLockUIs) {
        this.defaultLockUIs = defaultLockUIs;
    }

    public void setImportPlugin(String importPlugin) {
        this.importPlugin = importPlugin;
    }
}

