/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.dto;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PersonModelDto {
    private static final Log LOGGER = LogFactory.getLog(PersonModelDto.class);
    private long personId = 0L;
    private long employeeId = 0L;
    private long cmpEmpId = 0L;
    private long depEmpId = 0L;

    private PersonModelDto() {
    }

    public PersonModelDto(long personId) {
        this.personId = personId;
    }

    private PersonModelDto(long personId, long employeeId, long cmpEmpId, long depEmpId) {
        this.personId = personId;
        this.employeeId = employeeId;
        this.cmpEmpId = cmpEmpId;
        this.depEmpId = depEmpId;
    }

    public static PersonModelDto build(long personId, DynamicObject ermanFileDy) {
        if (HRObjectUtils.isEmpty((Object)ermanFileDy)) {
            LOGGER.warn("the personid not query main ermanfile, personid is %s", (Object)personId);
            return new PersonModelDto(personId);
        }
        return new PersonModelDto(personId, ermanFileDy.getLong("employee.id"), ermanFileDy.getLong("cmpemp.id"), ermanFileDy.getLong("depemp.id"));
    }

    public long getPersonId() {
        return this.personId;
    }

    public long getEmployeeId() {
        return this.employeeId;
    }

    public long getCmpEmpId() {
        return this.cmpEmpId;
    }

    public long getDepEmpId() {
        return this.depEmpId;
    }
}

