/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.enums;

import java.util.Arrays;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.common.enums.InfoGroupFieldCategroyEnum;

@SdkPublic
public enum FieldTypeEnum {
    MULILANG_TEXT("kd.bos.entity.property.MuliLangTextProp", "1", InfoGroupFieldCategroyEnum.TEXT),
    TEXT("kd.bos.entity.property.TextProp", "2", InfoGroupFieldCategroyEnum.TEXT),
    COMBO("kd.bos.entity.property.ComboProp", "3", InfoGroupFieldCategroyEnum.TEXT),
    DATE("kd.bos.entity.property.DateProp", "4", InfoGroupFieldCategroyEnum.TEXT),
    CREATE_DATE("kd.bos.entity.property.CreateDateProp", "4", InfoGroupFieldCategroyEnum.TEXT),
    MODIFY_DATE("kd.bos.entity.property.ModifyDateProp", "4", InfoGroupFieldCategroyEnum.TEXT),
    DATE_TIME("kd.bos.entity.property.DateTimeProp", "4", InfoGroupFieldCategroyEnum.TEXT),
    BOOLEAN("kd.bos.entity.property.BooleanProp", "5", InfoGroupFieldCategroyEnum.TEXT),
    DECIMAL("kd.bos.entity.property.DecimalProp", "6", InfoGroupFieldCategroyEnum.TEXT),
    BIG_INT("kd.bos.entity.property.BigIntProp", "7", InfoGroupFieldCategroyEnum.TEXT),
    LONG("kd.bos.entity.property.LongProp", "7", InfoGroupFieldCategroyEnum.TEXT),
    ATTACHMENT_COUNT("kd.bos.entity.property.AttachmentCountProp", "7", InfoGroupFieldCategroyEnum.TEXT),
    INTEGER("kd.bos.entity.property.IntegerProp", "8", InfoGroupFieldCategroyEnum.TEXT),
    BASE_DATA("kd.bos.entity.property.BasedataProp", "9", InfoGroupFieldCategroyEnum.TEXT),
    CREATER("kd.bos.entity.property.CreaterProp", "10", InfoGroupFieldCategroyEnum.TEXT),
    MODIFIER("kd.bos.entity.property.ModifierProp", "11", InfoGroupFieldCategroyEnum.TEXT),
    PICTURE("kd.bos.entity.property.PictureProp", "12", InfoGroupFieldCategroyEnum.IMG),
    BILL_STATUS("kd.bos.entity.property.BillStatusProp", "13", InfoGroupFieldCategroyEnum.TEXT),
    USER("kd.bos.entity.property.UserProp", "14", InfoGroupFieldCategroyEnum.TEXT),
    CITY("kd.bos.entity.property.CityProp", "15", InfoGroupFieldCategroyEnum.TEXT),
    ADMIN_DIVISION("kd.bos.entity.property.AdminDivisionProp", "16", InfoGroupFieldCategroyEnum.TEXT),
    MAIN_ORG("kd.bos.entity.property.MainOrgProp", "17", InfoGroupFieldCategroyEnum.TEXT),
    ATTACHMENT("kd.bos.entity.property.AttachmentProp", "18", InfoGroupFieldCategroyEnum.ATTACH),
    TEXTAREA("kd.bos.entity.property.TextAreaProp", "19", InfoGroupFieldCategroyEnum.TEXT),
    Currency("kd.bos.entity.property.CurrencyProp", "20", InfoGroupFieldCategroyEnum.TEXT),
    ORGPROP("kd.bos.entity.property.OrgProp", "21", InfoGroupFieldCategroyEnum.TEXT),
    QueryProp("kd.bos.ext.hr.metadata.prop.QueryProp", "22", InfoGroupFieldCategroyEnum.TEXT),
    I18NNAMEPROP("kd.bos.ext.metadata.entity.property.I18nNameProp", "23", InfoGroupFieldCategroyEnum.TEXT),
    ADDRESSPROP("kd.bos.entity.property.AddressProp", "24", InfoGroupFieldCategroyEnum.TEXT),
    MULBASEDATAPROP("kd.bos.entity.property.MulBasedataProp", "25", InfoGroupFieldCategroyEnum.TEXT),
    MULQUERYPROP("kd.bos.ext.hr.metadata.prop.MulQueryProp", "26", InfoGroupFieldCategroyEnum.TEXT),
    AMOUNTPROP("kd.bos.entity.property.AmountProp", "27", InfoGroupFieldCategroyEnum.TEXT),
    HISMODELBASEDATAPROP("kd.bos.ext.hr.entity.property.HisModelBasedataProp", "28", InfoGroupFieldCategroyEnum.TEXT);

    private String code;
    private String type;
    private InfoGroupFieldCategroyEnum categroy;

    private FieldTypeEnum(String code, String type, InfoGroupFieldCategroyEnum categroy) {
        this.code = code;
        this.type = type;
        this.categroy = categroy;
    }

    public static FieldTypeEnum getFieldTypeBySimpleCode(String simpleCode) {
        for (FieldTypeEnum value : FieldTypeEnum.values()) {
            String[] str = value.getCode().split("\\.");
            if (str.length <= 0 || !str[str.length - 1].equalsIgnoreCase(simpleCode)) continue;
            return value;
        }
        return null;
    }

    public static FieldTypeEnum getFieldTypeByCode(String code) {
        for (FieldTypeEnum value : FieldTypeEnum.values()) {
            if (!value.code.equals(code)) continue;
            return value;
        }
        return null;
    }

    public static FieldTypeEnum geCodeByFieldType(String fieldType) {
        return Arrays.stream(FieldTypeEnum.values()).filter(row -> HRStringUtils.equals((String)row.getType(), (String)fieldType)).findFirst().orElse(null);
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeSimpleName() {
        try {
            return Class.forName(this.code).getSimpleName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getTypeClassObject(String code) {
        try {
            return Class.forName(code);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InfoGroupFieldCategroyEnum getCategroy() {
        return this.categroy;
    }

    public static boolean isBaseDataType(FieldTypeEnum type) {
        if (type != null) {
            switch (type) {
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: {
                    return true;
                }
            }
        }
        return false;
    }
}

