/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

@SdkPublic
public class ApprovalEntityUtils {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hspm_infoapprovalcache");
    private static final Log LOGGER = LogFactory.getLog(ApprovalEntityUtils.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hspm_infoapproval");

    public static void initCacheFromEntry(IFormView view, Map<String, Object> infoGroupConfig) {
        QFilter statusFilter;
        IPageCache pageCache = view.getPageCache();
        String ispreview = pageCache.get("ispreview");
        if (HRStringUtils.isNotEmpty((String)ispreview)) {
            return;
        }
        Set keSet = pageCache.getAll().keySet();
        Long personId = Long.valueOf(pageCache.get("personId"));
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        DynamicObject entry = serviceHelper.loadDynamicObject(new QFilter[]{personFilter, statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"D").or("billstatus", "=", (Object)"G")});
        if (entry == null) {
            ApprovalEntityUtils.initCacheFromDateBaseForNoBill(view, personId);
            return;
        }
        DynamicObjectCollection entryentity = entry.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        Map<String, String> groupMap = ((List)infoGroupConfig.get("mainentry")).stream().collect(Collectors.toMap(val -> (String)val.get("targetkey"), val -> (String)val.get("groupname")));
        try {
            for (DynamicObject object : entryentity) {
                String entrycache;
                List<HashMap<String, Object>> collection = new ArrayList<HashMap<String, Object>>();
                String targetkey = String.valueOf(object.get("firstgroupnum"));
                String reason = HRStringUtils.isNotEmpty((String)object.getString("reason")) ? object.getString("reason") : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"sdk-hr", (Object[])new Object[0]);
                String groupname = groupMap.get(targetkey);
                if (targetkey.equals("0000")) {
                    if ("G".equals(entry.getString("billstatus")) && object.getBoolean("status")) {
                        Label label;
                        view.setVisible(Boolean.valueOf(true), new String[]{"headtipspanel"});
                        if (!BusinessUtils.isPCFilePage(view.getEntityId()) && (label = (Label)view.getControl("notpassinfo")) != null) {
                            label.setText(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u5934\u50cf\u5df2\u88ab\u9a73\u56de\uff0c\u4e0d\u901a\u8fc7\u539f\u56e0\uff1a%s", (String)"MobileHomeTemplatePlugin_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]), reason));
                        }
                    }
                    groupname = targetkey;
                }
                if (HRStringUtils.isEmpty((String)groupname)) {
                    groupname = String.valueOf(object.get("firstgroup"));
                }
                if (keSet.contains(groupname + "-" + "entrycache") && HRStringUtils.isNotEmpty((String)(entrycache = pageCache.get(groupname + "-" + "entrycache")))) {
                    collection = (List)JSONUtils.cast((String)entrycache, List.class);
                    for (HashMap<String, Object> hashMap : collection) {
                        hashMap.put("isNewModify", null);
                    }
                    boolean anyMatch = collection.stream().anyMatch(arg -> object.get("fieldname").equals(arg.get("fieldname")) && object.get("dataid").equals(arg.get("dataid")) && targetkey.equals(arg.get("groupnumber")));
                    if (anyMatch) {
                        pageCache.put(groupname + "-" + "entrycache", JSONUtils.toString(collection));
                        continue;
                    }
                }
                ApprovalEntityUtils.addMapToCollect(object, groupname, targetkey, collection);
                pageCache.put(groupname + "-" + "entrycache", JSONUtils.toString(collection));
            }
            ApprovalEntityUtils.initCacheFromDateBaseForResubmit(view, personId, entry);
            pageCache.put("submitVerson", entry.getString("id"));
        }
        catch (IOException exception) {
            LOGGER.info("pageCache-init-error:{}", (Object)exception);
        }
    }

    private static void initCacheFromDateBaseForNoBill(IFormView view, Long personId) {
        IPageCache pageCache = view.getPageCache();
        QFilter filter = new QFilter("personid", "=", (Object)personId);
        DynamicObject queryOne = HELPER.loadDynamicObject(filter);
        if (queryOne == null) {
            return;
        }
        String cachelog_tag = queryOne.getString("cachelog_tag");
        if (HRStringUtils.isEmpty((String)cachelog_tag)) {
            return;
        }
        Map updateFieldMap = (Map)SerializationUtils.fromJsonString((String)cachelog_tag, Map.class);
        if (updateFieldMap == null || updateFieldMap.size() == 0) {
            return;
        }
        ApprovalEntityUtils.removeFieldNotAudit(pageCache, updateFieldMap);
        ApprovalEntityUtils.removeDirtyData(updateFieldMap);
        for (Map.Entry listEntry : updateFieldMap.entrySet()) {
            pageCache.put((String)listEntry.getKey(), SerializationUtils.toJsonString(listEntry.getValue()));
        }
        ApprovalHelper.updateSyncCacheToDataBase(view);
    }

    private static void removeDirtyData(Map<String, List<Map<String, Object>>> updateFieldMap) {
        if (updateFieldMap == null || updateFieldMap.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, List<Map<String, Object>>>> entryIterator = updateFieldMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, List<Map<String, Object>>> listEntry = entryIterator.next();
            List<Map<String, Object>> mapList = listEntry.getValue();
            if (mapList == null || mapList.size() == 0) {
                entryIterator.remove();
                continue;
            }
            Iterator<Map<String, Object>> iterator = mapList.iterator();
            while (iterator.hasNext()) {
                QFilter idFilter;
                QFilter statusFilter;
                boolean alreadyEffect;
                Map<String, Object> next = iterator.next();
                String entityName = String.valueOf(next.get("entityName"));
                long dataId = Long.parseLong(String.valueOf(next.get("dataid")));
                boolean isNew = Boolean.TRUE.equals(next.get("isnew"));
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
                boolean exists = helper.isExists((Object)dataId);
                if (!exists) {
                    iterator.remove();
                    continue;
                }
                if (!isNew || !(alreadyEffect = helper.isExists(new QFilter[]{statusFilter = new QFilter("datastatus", "=", (Object)"1"), idFilter = new QFilter("id", "=", (Object)dataId)}))) continue;
                iterator.remove();
            }
            if (mapList != null && mapList.size() != 0) continue;
            entryIterator.remove();
        }
    }

    private static void removeFieldNotAudit(IPageCache pageCache, Map<String, List<Map<String, Object>>> updateFieldMap) {
        String cnfStr = pageCache.get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
        Map<Object, List<Map<String, Object>>> allFieldGroupByInfoGroup = ApprovalEntityUtils.getAllFieldGroupByInfoGroup(infoGroupConfig);
        Iterator<Map.Entry<String, List<Map<String, Object>>>> entryIterator = updateFieldMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, List<Map<String, Object>>> listEntry = entryIterator.next();
            List<Map<String, Object>> mapList = listEntry.getValue();
            if (mapList == null || mapList.size() == 0) {
                entryIterator.remove();
                continue;
            }
            String groupNumber = String.valueOf(mapList.get(0).get("groupnumber"));
            List<Map<String, Object>> list = allFieldGroupByInfoGroup.get(groupNumber);
            if (list == null || list.size() == 0) {
                entryIterator.remove();
                continue;
            }
            Iterator<Map<String, Object>> iterator = mapList.iterator();
            if (HRStringUtils.isNotEmpty((String)cnfStr)) {
                while (iterator.hasNext()) {
                    Map<String, Object> next = iterator.next();
                    String fieldName = String.valueOf(next.get("fieldname"));
                    String entityName = String.valueOf(next.get("entityName"));
                    boolean anyMatch = true;
                    anyMatch = "0000".equals(groupNumber) ? list.stream().anyMatch(map -> map.get("source").equals(entityName) && map.get("number").equals(fieldName) && Boolean.TRUE.equals(map.get("isaudit"))) : list.stream().anyMatch(field -> field.get("pnumber").equals(entityName) && field.get("number").equals(fieldName) && Boolean.TRUE.equals(field.get("isaudit")));
                    if (anyMatch) continue;
                    iterator.remove();
                }
            }
            if (mapList != null && mapList.size() != 0) continue;
            entryIterator.remove();
        }
    }

    private static Map<Object, List<Map<String, Object>>> getAllFieldGroupByInfoGroup(Map<String, Object> infoGroupConfig) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        List headEntity = (List)infoGroupConfig.get("headentity");
        result.put("0000", headEntity);
        List mainEntity = (List)infoGroupConfig.get("mainentry");
        for (Map stringObjectMap : mainEntity) {
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(stringObjectMap);
            if (groups == null) continue;
            ArrayList<Map<String, Object>> allFields = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> group : groups) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
                if (fields == null) continue;
                allFields.addAll(fields);
            }
            result.put(stringObjectMap.get("targetkey"), allFields);
        }
        return result;
    }

    private static void initCacheFromDateBaseForResubmit(IFormView view, Long personId, DynamicObject entry) {
        if (!"G".equals(entry.getString("billstatus"))) {
            return;
        }
        QFilter filter = new QFilter("personid", "=", (Object)personId);
        DynamicObject queryOne = HELPER.loadDynamicObject(filter);
        if (queryOne == null) {
            ApprovalHelper.updateSyncCacheToDataBase(view);
        } else {
            if (queryOne.getDate("modifytime").before(entry.getDate("modifytime"))) {
                ApprovalHelper.updateSyncCacheToDataBase(view);
                return;
            }
            String cachelog_tag = queryOne.getString("cachelog_tag");
            Map updateFieldMap = (Map)SerializationUtils.fromJsonString((String)cachelog_tag, Map.class);
            if (updateFieldMap != null && updateFieldMap.size() > 0) {
                ApprovalEntityUtils.removeFieldNotAudit(view.getPageCache(), updateFieldMap);
                ApprovalEntityUtils.removeDirtyData(updateFieldMap);
                Map<String, List<Map<String, Object>>> auditFieldMap = ApprovalHelper.getAuditFieldMap(view);
                for (String string : auditFieldMap.keySet()) {
                    view.getPageCache().remove(string + "-entrycache");
                }
                for (Map.Entry entry2 : updateFieldMap.entrySet()) {
                    view.getPageCache().put((String)entry2.getKey(), SerializationUtils.toJsonString(entry2.getValue()));
                }
                ApprovalHelper.updateSyncCacheToDataBase(view);
            }
        }
    }

    private static boolean handleHeadsculptureAudit(DynamicObject bill, IPageCache pageCache) {
        if (!"G".equals(bill.getString("billstatus"))) {
            return false;
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            ArrayList<String> delList = new ArrayList<String>();
            delList.add("0000-entrycache");
            delList.add("submitVerson");
            pageCache.batchRemove(delList);
            if (entryentity.size() == 1 && "0000".equals(((DynamicObject)entryentity.get(0)).getString("firstgroupnum"))) {
                try {
                    WorkflowServiceHelper.withdraw((DynamicObject)bill);
                }
                catch (Exception exception) {
                    LOGGER.error("withdraw ex:", (Throwable)exception);
                }
                OperationResult result = new OperationServiceImpl().localInvokeOperation("delete", new DynamicObject[]{bill}, OperateOption.create());
                if (CollectionUtils.isEmpty((Collection)result.getSuccessPkIds())) {
                    StringBuilder tip = new StringBuilder();
                    List errors = result.getAllErrorOrValidateInfo();
                    if (!CollectionUtils.isEmpty((Collection)errors) && errors.get(0) != null) {
                        tip.append("\r\n").append(errors.get(0));
                    }
                    throw new KDBizException(tip.toString());
                }
                return true;
            }
        }
        return false;
    }

    private static void addMapToCollect(DynamicObject object, String groupname, String targetkey, List<HashMap<String, Object>> collection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityName", object.get("entityname"));
        map.put("dataid", object.get("dataid"));
        map.put("isnew", object.get("isnew"));
        map.put("isdel", object.get("isdel"));
        map.put("groupname", groupname);
        map.put("groupnumber", targetkey);
        map.put("fieldtype", object.get("fieldtype"));
        map.put("displayname", object.get("displayname"));
        map.put("fieldname", object.get("fieldname"));
        map.put("newvalue", object.get("newvalue"));
        map.put("oldvalue", object.get("oldvalue"));
        map.put("reason", Optional.ofNullable(object.getLocaleString("reason").getLocaleValue()).orElse(""));
        map.put("status", object.get("status"));
        collection.add(map);
    }

    public static void dealDataAfterDeleteEntry(List<Long> entryIdList, DynamicObject entry, Long pkid, boolean isFromBill) {
        if (entryIdList == null) {
            entryIdList = new ArrayList<Long>();
        }
        DynamicObjectCollection entryentity = entry.getDynamicObjectCollection("entryentity");
        HisModelController controller = HisModelController.getInstance();
        if (pkid != 0L) {
            List<Long> finalEntryIdList = entryIdList;
            List collect = entryentity.stream().filter(dynamicObject -> dynamicObject.getBoolean("isnew") && (pkid.equals(dynamicObject.getLong("dataid")) || finalEntryIdList.contains(dynamicObject.getLong("dataid")))).collect(Collectors.toList());
            if (collect != null && collect.size() > 0) {
                for (DynamicObject object : collect) {
                    String entityName = object.getString("entityname");
                    HashSet<Long> set = new HashSet<Long>();
                    set.add(object.getLong("dataid"));
                    if (HRArrayUtils.isEmpty((Object[])ApprovalEntityUtils.getDataStatus(entityName, set))) continue;
                    HisBaseBo hisBaseBo = new HisBaseBo();
                    hisBaseBo.setEntityNumber(entityName);
                    hisBaseBo.setBoIdList(Collections.singletonList(object.getLong("dataid")));
                    controller.deleteBo(hisBaseBo);
                }
            }
            return;
        }
        if (!isFromBill) {
            return;
        }
        Map<String, List<DynamicObject>> listMap = entryentity.stream().filter(dynamicObject -> dynamicObject.getBoolean("isnew")).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("entityname")));
        for (Map.Entry<String, List<DynamicObject>> listEntry : listMap.entrySet()) {
            Set<Long> dataid = listEntry.getValue().stream().map(dynamicObject -> dynamicObject.getLong("dataid")).collect(Collectors.toSet());
            DynamicObject[] objects = ApprovalEntityUtils.getDataStatus(listEntry.getKey(), dataid);
            if (objects == null || objects.length == 0) continue;
            List longList = Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            HisBaseBo hisBaseBo = new HisBaseBo();
            hisBaseBo.setEntityNumber(listEntry.getKey());
            hisBaseBo.setBoIdList(longList);
            controller.deleteBo(hisBaseBo);
        }
    }

    private static DynamicObject[] getDataStatus(String entityName, Set<Long> set) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter("id", "in", set);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"-3");
        return serviceHelper.query(new QFilter[]{idFilter, statusFilter});
    }
}

