/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.ehcache.syncstatus.MemoryCacheSyncStatusMange;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;

@SdkPublic
public class BusinessUtils {
    private static final Log LOGGER = LogFactory.getLog(BusinessUtils.class);
    private static final HRBaseServiceHelper PEREDUEXPCERT_HELPER = new HRBaseServiceHelper("hrpi_pereduexpcert");
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static final OperationServiceImpl OPERATION_SERVICE = new OperationServiceImpl();
    private static final HRBaseServiceHelper BOS_USER_SERVICEHELPER = new HRBaseServiceHelper("bos_user");
    private static final String CONTENT_TEXT = "contenttext";
    private static final long PROMPT_ID = 1662457857158861824L;
    private static final HRBaseServiceHelper PROMPT_HELPER = new HRBaseServiceHelper("hrcs_prompt");
    private static final long SUPER_PROMPT_ID = 1950948801552358400L;
    private static final String ATTACH_FILE_POSITION = "/download.do?path=/";
    private static final String ATTACH_FILE_PATH_REG = "path=/";
    private static final String MAIL_REG = "^\\w{1,500}([\\._\\\\-]{0,500}\\w){0,500}@(\\w+[\\w|\\-]{0,500}\\.){1,63}[\\w|\\-]+$";
    private static final Pattern PATTERN = Pattern.compile("^\\w{1,500}([\\._\\\\-]{0,500}\\w){0,500}@(\\w+[\\w|\\-]{0,500}\\.){1,63}[\\w|\\-]+$");

    public static Set<Long> getUpdateBoIdGenPkId(Map<String, DynamicObjectCollection> attachMap, boolean genPkId) {
        HashSet<Long> updateBoIdSet = new HashSet<Long>(16);
        if (attachMap == null || attachMap.size() == 0) {
            return updateBoIdSet;
        }
        for (Map.Entry<String, DynamicObjectCollection> entry : attachMap.entrySet()) {
            String tempName = entry.getKey();
            DynamicObjectCollection dynamics = attachMap.get(tempName);
            for (DynamicObject dynamicObject : dynamics) {
                long boId = dynamicObject.getLong("boid");
                long pkId = dynamicObject.getLong("id");
                if (boId != 0L) {
                    updateBoIdSet.add(boId);
                    continue;
                }
                if (!genPkId || pkId != 0L) continue;
                dynamicObject.set("id", (Object)BusinessUtils.getGenLongId(tempName));
            }
        }
        return updateBoIdSet;
    }

    private static long getGenLongId(String tempName) {
        return ORM.create().genLongId(tempName);
    }

    public static List<Map<String, Object>> getTempUrl(String entityNum, Map<String, Object> attachObj) {
        String saveUrl;
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        attachMap.put("type", attachObj.get("type"));
        attachMap.put("name", attachObj.get("name"));
        attachMap.put("description", attachObj.get("description"));
        String url = (String)attachObj.get("url");
        if (url.contains("download.do") && HRStringUtils.isEmpty((String)(url = UrlUtil.getParam((String)url, (String)"path")))) {
            throw new KDBizException("url error");
        }
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        try {
            saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(String.valueOf(attachObj.get("name")), (InputStream)new BufferedInputStream(inputStream), 7200);
        }
        catch (Exception ex) {
            LOGGER.error("use saveAsFullUrl Exception", (Throwable)ex);
            inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.valueOf(attachObj.get("name")), (InputStream)new BufferedInputStream(inputStream), 7200);
        }
        attachMap.put("url", saveUrl);
        String uid = (String)attachObj.get("uid");
        if (HRStringUtils.isEmpty((String)uid)) {
            uid = MemoryCacheSyncStatusMange.getUid() + "";
        }
        attachMap.put("uid", uid);
        attachMap.put("size", attachObj.get("size"));
        attachMap.put("fattachmentpanel", "attachmentpanelap_std");
        attachMap.put("entityNum", entityNum);
        attachMap.put("lastModified", System.currentTimeMillis());
        attachMap.put("status", "success");
        attachMap.put("client", null);
        attachDataList.add(attachMap);
        return attachDataList;
    }

    public static boolean checkBirthday(IFormView view, boolean setAge) {
        if (BusinessUtils.notExistBirthday(view.getModel())) {
            return false;
        }
        Date birthday = (Date)view.getModel().getValue("hrpi_pernontsprop-birthday");
        Date midnight = HspmDateUtils.getMidnight();
        if (birthday != null && !birthday.before(midnight)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"BusinessUtils_0", (String)"sdk-hr", (Object[])new Object[0]));
            return true;
        }
        if (setAge) {
            BusinessUtils.setAge(view, birthday);
        }
        return false;
    }

    private static boolean notExistBirthday(IDataModel model) {
        return !model.getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-birthday");
    }

    private static void setAge(IFormView view, Date birthday) {
        BigDecimal age;
        if (!view.getModel().getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-age")) {
            return;
        }
        BigDecimal bigDecimal = age = birthday == null ? BigDecimal.ZERO : BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)birthday, (Date)new Date()));
        if (view.getModel().getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-age")) {
            view.getModel().setValue("hrpi_pernontsprop-age", (Object)age);
        }
    }

    public static boolean isPCFilePage(String pageId) {
        return pageId.endsWith("pdv") || pageId.endsWith("pdg");
    }

    public static void addMapToCollect(IFormView view, Long pkId, String attachKey, Object newValue, Object oldValue, List<HashMap<String, Object>> collection, String entityName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String groupName = "0000";
        map.put("entityName", entityName);
        map.put("dataid", pkId);
        map.put("isnew", Boolean.FALSE);
        map.put("groupname", groupName);
        map.put("groupnumber", "0000");
        map.put("fieldtype", "PictureProp");
        map.put("displayname", "headsculpture");
        map.put("fieldname", attachKey);
        map.put("newvalue", newValue);
        map.put("oldvalue", oldValue);
        map.put("reason", null);
        map.put("status", null);
        PageCacheUtils.removeDataIfNeedUpdate(collection, pkId, attachKey, "0000");
        collection.add(map);
        if (collection.size() > 0) {
            PageCacheUtils.getHomePageCache(view).put(groupName + "-" + "entrycache", SerializationUtils.toJsonString(collection));
            PageCacheUtils.getHomePageCache(view).put("hasFieldChange-" + entityName + "-" + pkId, String.valueOf(true));
        } else {
            PageCacheUtils.getHomePageCache(view).remove(groupName + "-" + "entrycache");
        }
        ApprovalHelper.updateSyncCacheToDataBase(view);
    }

    public static void setDateLimit(IFormView view, String field, boolean includeCurrentDay, boolean isMax) {
        if (!BusinessUtils.isFieldExist(view, field)) {
            return;
        }
        DateEdit day = (DateEdit)view.getControl(field);
        if (isMax) {
            day.setMaxDate(HspmDateUtils.addDay((Date)new Date(), (long)(includeCurrentDay ? 0L : -1L)));
            return;
        }
        day.setMinDate(HspmDateUtils.addDay((Date)new Date(), (long)(includeCurrentDay ? 0L : 1L)));
    }

    public static boolean isFieldExist(IFormView view, String key) {
        return view.getModel().getDataEntityType().getAllFields().containsKey(key);
    }

    public static List<Long> getCertIds(IFormView view, Long pkid) {
        List<Long> certIdList = new ArrayList<Long>();
        if (view == null) {
            return certIdList;
        }
        if (view.getEntityId().equals("hspm_pereduexp_mdg") || view.getEntityId().equals("hspm_pereduexp_pdg")) {
            QFilter VersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "-3"});
            HRBaseServiceHelper certHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
            DynamicObject[] certDys = certHelper.loadDynamicObjectArray("hrpi_pereduexpcert", new QFilter[]{new QFilter("pereduexp", "=", (Object)pkid), VersionFilter, statusFilter});
            certIdList = Arrays.stream(certDys).map(certDy -> certDy.getLong("id")).collect(Collectors.toList());
        }
        return certIdList;
    }

    public static void changeAdjustTime(DynamicObject dbDy, String entityName, Map<String, DynamicObjectCollection> saveOrUpdateMap, IFormView view, boolean isAdComTimeAudit, boolean isAdWorkTimeAudit, boolean isJoinWorkTimeAudit) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        boolean companyTimeChanged = BusinessUtils.fieldIsChange(dbDy, entityName, dataEntity, "adjustcomtime");
        boolean workTimeChanged = BusinessUtils.fieldIsChange(dbDy, entityName, dataEntity, "adjustworktime");
        boolean beginTimeChanged = BusinessUtils.fieldIsChange(dbDy, entityName, dataEntity, "joinworktime");
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        String keyJoinTime = entityName + "-" + "joinworktime";
        boolean containJoinTime = properties.containsKey((Object)keyJoinTime);
        if (companyTimeChanged || workTimeChanged || containJoinTime) {
            BigDecimal serviceLen;
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_pernontsprop");
            Long person = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("person.id", "=", (Object)person));
            DynamicObject sourceDy = helper.loadDynamicObject(qFilter);
            if (sourceDy == null) {
                return;
            }
            DynamicObject destDy = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceDy, (DynamicObject)destDy);
            if (companyTimeChanged && !isAdComTimeAudit) {
                Date firstjoincomdate = dataEntity.getDate(entityName + "-" + "firstjoincomdate");
                Date joincomdate = dataEntity.getDate(entityName + "-" + "joincomdate");
                BigDecimal adjustTime = dataEntity.getBigDecimal(entityName + "-" + "adjustcomtime");
                serviceLen = adjustTime.add(BusinessUtils.calcYearsDiff(new Date(), firstjoincomdate));
                destDy.set("entservicelen", (Object)serviceLen);
                BigDecimal comserCount = HRPerserlenHelper.calcComsercount((Date)joincomdate, (BigDecimal)adjustTime, (Long)person);
                ((DynamicObject)saveOrUpdateMap.get("hrpi_perserlen").get(0)).set("comsercount", (Object)comserCount);
            }
            if ((beginTimeChanged || workTimeChanged) && !isAdWorkTimeAudit) {
                Date joinDate = dataEntity.getDate(entityName + "-" + "joinworktime");
                BigDecimal adjustTime = CommonUtil.getBigDecimalIfExist(view.getModel(), entityName + "-" + "adjustworktime", person, "adjustworktime");
                BigDecimal joinDateYearsDiff = BusinessUtils.calcYearsDiff(new Date(), joinDate);
                serviceLen = adjustTime.add(joinDateYearsDiff);
                destDy.set("servicelen", (Object)serviceLen);
                ((DynamicObject)saveOrUpdateMap.get("hrpi_perserlen").get(0)).set("workyear", (Object)serviceLen);
                BigDecimal adjustWorkAge = CommonUtil.getBigDecimalIfExist(view.getModel(), entityName + "-" + "adjustworkage", person, "adjustworkage");
                BigDecimal socialWorkAge = adjustWorkAge.add(joinDateYearsDiff);
                destDy.set("servicelen", (Object)socialWorkAge);
                ((DynamicObject)saveOrUpdateMap.get("hrpi_perserlen").get(0)).set("socialworkage", (Object)socialWorkAge);
            }
            if (containJoinTime) {
                try {
                    if (!isJoinWorkTimeAudit && !CommonUtil.customObjectEquals(dataEntity.get(keyJoinTime), dbDy.get("joinworktime"), "yyyy-MM-dd")) {
                        Date joinTime = dataEntity.getDate(keyJoinTime);
                        destDy.set("beginservicedate", (Object)joinTime);
                    }
                }
                catch (Exception esc) {
                    LOGGER.error("parse date error", (Throwable)esc);
                }
            }
            destDy.set("initstatus", (Object)"2");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            collection.add((Object)destDy);
            saveOrUpdateMap.put("hrpi_pernontsprop", collection);
        }
    }

    public static BigDecimal getHisComserCount(Long personId) {
        long statusId;
        if (personId == null || personId == 0L) {
            return BigDecimal.ZERO;
        }
        HRBaseServiceHelper empentrelHepler = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter filter = new QFilter("person.id", "=", (Object)personId).and(statusQFilter);
        DynamicObject empDy = empentrelHepler.queryOne("laborrelstatus", filter);
        if (empDy == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject laborrelstatusDy = empDy.getDynamicObject("laborrelstatus");
        if (laborrelstatusDy == null) {
            return BigDecimal.ZERO;
        }
        long l = statusId = laborrelstatusDy.getDynamicObject("labrelstatusprd") != null ? laborrelstatusDy.getLong("labrelstatusprd.id") : 0L;
        if (statusId == 1020L || statusId == 0L) {
            return BigDecimal.ZERO;
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter idQFilter = new QFilter("id", "=", (Object)personId);
        DynamicObject person = personHelper.queryOne("personindexid", new QFilter[]{idQFilter});
        long personIndexId = person.getLong("personindexid");
        if (personIndexId == 0L) {
            return BigDecimal.ZERO;
        }
        QFilter nonIdQFilter = new QFilter("id", "!=", (Object)personId);
        QFilter personIndexIdQFilter = new QFilter("personindexid", "=", (Object)personIndexId);
        DynamicObject personOne = personHelper.queryOne("id", new QFilter[]{statusQFilter, nonIdQFilter, personIndexIdQFilter}, " modifytime desc");
        if (personOne == null) {
            return BigDecimal.ZERO;
        }
        HRBaseServiceHelper perserlenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        QFilter personIdsQFilter = new QFilter("person.id", "=", (Object)personOne.getLong("id"));
        DynamicObject[] comsercounts = perserlenHelper.query("comsercount", new QFilter[]{personIdsQFilter, statusQFilter});
        BigDecimal result = Arrays.stream(comsercounts).map(p -> p.getBigDecimal("comsercount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return result;
    }

    public static BigDecimal getPerserlenByPersonId(Long personId, String keyName) {
        if (personId == null || personId == 0L) {
            return new BigDecimal(0);
        }
        HRBaseServiceHelper perserlenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter filter = new QFilter("person.id", "=", (Object)personId).and(statusQFilter);
        DynamicObject perserLen = perserlenHelper.queryOne(keyName, filter);
        return perserLen.getBigDecimal(keyName) == null ? BigDecimal.ZERO : perserLen.getBigDecimal(keyName);
    }

    public static Date getPerserlenDateByPersonId(Long personId, String keyName) {
        if (personId == null || personId == 0L) {
            return new Date();
        }
        HRBaseServiceHelper perserlenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter filter = new QFilter("person.id", "=", (Object)personId).and(statusQFilter);
        DynamicObject perserLen = perserlenHelper.queryOne(keyName, filter);
        return perserLen.getDate(keyName) == null ? new Date() : perserLen.getDate(keyName);
    }

    public static boolean checkPersonLabrelstatus(Long personId) {
        long statusId;
        if (personId == null || personId == 0L) {
            return true;
        }
        HRBaseServiceHelper empentrelHepler = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter filter = new QFilter("person.id", "=", (Object)personId).and(statusQFilter);
        DynamicObject empDy = empentrelHepler.queryOne("laborrelstatus", filter);
        if (empDy == null) {
            return true;
        }
        DynamicObject laborrelstatusDy = empDy.getDynamicObject("laborrelstatus");
        if (laborrelstatusDy == null) {
            return true;
        }
        long l = statusId = laborrelstatusDy.getDynamicObject("labrelstatusprd") != null ? laborrelstatusDy.getLong("labrelstatusprd.id") : 0L;
        return statusId == 1020L || statusId == 0L;
    }

    public static DynamicObject getPerserlen(Long personId) {
        if (personId == null || personId == 0L) {
            LOGGER.info("==personId is 0L==");
            return null;
        }
        HRBaseServiceHelper perserlenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter personIdsQFilter = new QFilter("person.id", "=", (Object)personId);
        return perserlenHelper.queryOne("adjustworkage", new QFilter[]{statusQFilter, personIdsQFilter});
    }

    public static boolean checkWorkage(String startDateField, IFormView view) {
        boolean startFieldExist = BusinessUtils.isFieldExist(view, startDateField);
        if (!startFieldExist) {
            return false;
        }
        Long person = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
        if (person == null || person == 0L) {
            return false;
        }
        DynamicObject erserlenDy = BusinessUtils.getPerserlen(person);
        if (erserlenDy == null) {
            return false;
        }
        BigDecimal adjustworkage = erserlenDy.getBigDecimal("adjustworkage");
        Date startDate = (Date)view.getModel().getValue(startDateField);
        BigDecimal diff = BusinessUtils.calcYearsDiff(new Date(), startDate);
        BigDecimal socialworkage = diff.add(adjustworkage);
        if (socialworkage.compareTo(BigDecimal.ZERO) < 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u793e\u4f1a\u5de5\u9f84\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"PerserlenDrawPlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean checkHeight(IFormView view) {
        boolean fieldExist = BusinessUtils.isFieldExist(view, "hrpi_pernontsprop-height");
        if (!fieldExist) {
            return false;
        }
        Integer height = view.getModel().getDataEntity().getInt("hrpi_pernontsprop-height");
        if (Objects.nonNull(height) && (height > 300 || height < 0)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8eab\u9ad8\u5b57\u6bb5\u503c\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,300]", (String)"PerserlenDrawPlugin_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]), new Object[0]);
            view.showErrorNotification(errMsg);
            return true;
        }
        return false;
    }

    public static void changeBeginServiceDate(DynamicObject dbDy, String entityName, Map<String, DynamicObjectCollection> saveOrUpdateMap, IFormView view, boolean audit) {
        Date dbJoinDate;
        Date joinDate;
        String propertyName;
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (properties.containsKey((Object)(propertyName = entityName + "-" + "beginservicedate")) && !HRObjectUtils.equals((Object)(joinDate = dataEntity.getDate(propertyName)), (Object)(dbJoinDate = dbDy.getDate("beginservicedate"))) && !audit) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_perserlen");
            Long employee = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("employee"));
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("employee.id", "=", (Object)employee));
            DynamicObject sourceDy = helper.loadDynamicObject(qFilter);
            if (sourceDy == null) {
                return;
            }
            DynamicObject destDy = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceDy, (DynamicObject)destDy);
            destDy.set("joinworktime", (Object)joinDate);
            BigDecimal adjustTime = sourceDy.getBigDecimal("adjustworktime");
            BigDecimal serviceLen = adjustTime.add(BusinessUtils.calcYearsDiff(new Date(), joinDate));
            BigDecimal adjustworkage = sourceDy.getBigDecimal("adjustworkage");
            BigDecimal socialworkage = BusinessUtils.calcYearsDiff(new Date(), joinDate);
            socialworkage = socialworkage.add(adjustworkage);
            destDy.set("workyear", (Object)serviceLen);
            destDy.set("socialworkage", (Object)socialworkage);
            destDy.set("initstatus", (Object)"2");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            collection.add((Object)destDy);
            saveOrUpdateMap.put("hrpi_perserlen", collection);
            for (DynamicObject nonTsProp : saveOrUpdateMap.get("hrpi_pernontsprop")) {
                nonTsProp.set("servicelen", (Object)socialworkage);
            }
        }
    }

    public static void changeBeginServiceDateAfterAudit(DynamicObject dbDy, DynamicObject newDy, Map<String, DynamicObjectCollection> saveOrUpdateMap, DynamicObject field) {
        Date dbJoinDate;
        String joinDateStr = field.getString("newvalue");
        Date joinDate = HRStringUtils.isEmpty((String)joinDateStr) ? null : new Date(Long.parseLong(joinDateStr));
        if (!HRObjectUtils.equals((Object)joinDate, (Object)(dbJoinDate = dbDy.getDate("beginservicedate")))) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_perserlen");
            HRBaseServiceHelper emphelper = new HRBaseServiceHelper("hrpi_employee");
            DynamicObject employee = emphelper.queryOne("id", new QFilter[]{new QFilter("person.id", "=", (Object)dbDy.getLong("person.id")), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
            if (employee == null) {
                return;
            }
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("employee.id", "=", (Object)employee.getLong("id")));
            DynamicObject sourceDy = helper.loadDynamicObject(qFilter);
            if (sourceDy == null) {
                return;
            }
            DynamicObject destDy = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceDy, (DynamicObject)destDy);
            destDy.set("joinworktime", (Object)joinDate);
            BigDecimal adjustTime = sourceDy.getBigDecimal("adjustworktime");
            BigDecimal serviceLen = adjustTime.add(BusinessUtils.calcYearsDiff(new Date(), joinDate));
            destDy.set("workyear", (Object)serviceLen);
            destDy.set("socialworkage", (Object)serviceLen);
            destDy.set("initstatus", (Object)"2");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            collection.add((Object)destDy);
            saveOrUpdateMap.put("hrpi_perserlen", collection);
            newDy.set("servicelen", (Object)serviceLen);
        }
    }

    private static boolean fieldIsChange(DynamicObject dbDy, String entityName, DynamicObject dataEntity, String changeField) {
        String propertyName;
        boolean change = false;
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (properties.containsKey((Object)(propertyName = entityName + "-" + changeField))) {
            String picField = dataEntity.getString(propertyName);
            String picDbField = dbDy.getString(changeField);
            if (HRStringUtils.isNotEmpty((String)picField) && !picField.equals(picDbField)) {
                change = true;
            }
        }
        return change;
    }

    public static Long getEduexpByEduCertId(Long eduCertId) {
        DynamicObject dynamicObject;
        if (eduCertId != null && (dynamicObject = PEREDUEXPCERT_HELPER.queryOne("pereduexp.id", (Object)eduCertId)) != null) {
            return dynamicObject.getLong("pereduexp.id");
        }
        return 0L;
    }

    public static List<Long> getEduCertIdByEduId(Long eduId) {
        if (eduId != null && eduId != 0L) {
            QFilter qFilter = new QFilter("pereduexp", "=", (Object)eduId);
            qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            qFilter.and("initstatus", "=", (Object)"2");
            DynamicObject[] dynamicObjects = PEREDUEXPCERT_HELPER.query("id", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                return Stream.of(dynamicObjects).map(val -> val.getLong("id")).collect(Collectors.toList());
            }
        }
        return null;
    }

    public static List<Long> getEduCertIdByEduId(List<Long> eduIdList) {
        if (eduIdList != null && eduIdList.size() > 0) {
            QFilter qFilter = new QFilter("pereduexp", "in", eduIdList);
            qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            qFilter.and("initstatus", "=", (Object)"2");
            DynamicObject[] dynamicObjects = PEREDUEXPCERT_HELPER.query("id", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                return Stream.of(dynamicObjects).map(val -> val.getLong("id")).collect(Collectors.toList());
            }
        }
        return null;
    }

    public static void closeHighestDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection, DynamicObject old) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ishighestdegree", "=", (Object)"0")).and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObject[] edus = helper.query("id", new QFilter[]{qFilter}, "createtime desc", 1);
        if (edus.length > 0) {
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, helper.loadSingle((Object)edus[0].getLong("id")));
            newDy.set("ishighestdegree", (Object)"1");
            updateCollection.add((Object)newDy);
        } else {
            for (DynamicObject dynamicObject : updateCollection) {
                if (dynamicObject.getLong("boid") != old.getLong("boid")) continue;
                dynamicObject.set("ishighestdegree", (Object)"1");
            }
        }
    }

    public static void addHighestDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection, DynamicObject old) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ishighestdegree", "=", (Object)"1")).and(new QFilter("initstatus", "=", (Object)"2"));
        long count = helper.count(helper.getEntityName(), new QFilter[]{qFilter});
        if (count == 0L) {
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, helper.loadSingle((Object)old.getLong("boid")));
            newDy.set("ishighestdegree", (Object)"1");
            updateCollection.add((Object)newDy);
        }
    }

    public static void addMajorDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection, DynamicObject old) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ismajor", "=", (Object)true)).and(new QFilter("initstatus", "=", (Object)"2"));
        long count = helper.count(helper.getEntityName(), new QFilter[]{qFilter});
        if (count == 0L) {
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, helper.loadSingle((Object)old.getLong("boid")));
            newDy.set("ismajor", (Object)true);
            updateCollection.add((Object)newDy);
        }
    }

    public static DynamicObject getNewDynamicObject(HRBaseServiceHelper helper, DynamicObject oldDy) {
        DynamicObject newDy = helper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)newDy);
        if (newDy.getDataEntityType().getProperties().containsKey((Object)"initstatus")) {
            newDy.set("initstatus", (Object)"2");
        }
        return newDy;
    }

    public static void openHighestDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        DynamicObject[] edus;
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ishighestdegree", "=", (Object)"1")).and(new QFilter("initstatus", "=", (Object)"2"));
        for (DynamicObject edu : edus = helper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, edu);
            newDy.set("ishighestdegree", (Object)"0");
            updateCollection.add((Object)newDy);
        }
    }

    public static void openMajor(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        DynamicObject[] mainPercres;
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ismajor", "=", (Object)true));
        for (DynamicObject mainPercre : mainPercres = helper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            boolean match = updateCollection.stream().anyMatch(dynamicObject -> dynamicObject.get("boid").equals(mainPercre.getLong("id")));
            if (match) continue;
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, mainPercre);
            newDy.set("ismajor", (Object)false);
            updateCollection.add((Object)newDy);
        }
    }

    public static void closeMajor(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ismajor", "=", (Object)false));
        DynamicObject[] percres = helper.query("id", new QFilter[]{qFilter}, "createtime desc", 1);
        if (percres.length > 0) {
            for (DynamicObject dynamicObject : updateCollection) {
                if (!dynamicObject.get("boid").equals(percres[0].getLong("id"))) continue;
                dynamicObject.set("ismajor", (Object)true);
                return;
            }
            DynamicObject newDy = BusinessUtils.getNewDynamicObject(helper, helper.loadSingle((Object)percres[0].getLong("id")));
            newDy.set("ismajor", (Object)true);
            updateCollection.add((Object)newDy);
        }
    }

    public static List<Map<String, Object>> buildAttachmentDataFromEdit(String entityNum, Map<String, Object> attachObj) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        attachMap.put("type", attachObj.get("type"));
        attachMap.put("description", LocaleString.fromMap((Map)((LinkedHashMap)attachObj.get("description"))).getLocaleValue());
        String name = LocaleString.fromMap((Map)((LinkedHashMap)attachObj.get("name"))).getLocaleValue();
        attachMap.put("name", name);
        String url = (String)attachObj.get("url");
        String saveUrl = BusinessUtils.getAttachUrl(url, name);
        attachMap.put("url", saveUrl);
        String uid = (String)attachObj.get("uid");
        if (HRStringUtils.isEmpty((String)uid)) {
            uid = MemoryCacheSyncStatusMange.getUid() + "";
        }
        attachMap.put("uid", uid);
        attachMap.put("size", attachObj.get("size"));
        attachMap.put("fattachmentpanel", "attachmentpanel");
        attachMap.put("entityNum", entityNum);
        attachMap.put("lastModified", System.currentTimeMillis());
        attachMap.put("status", "success");
        attachMap.put("client", null);
        attachDataList.add(attachMap);
        return attachDataList;
    }

    private static String getAttachUrl(String url, String name) {
        LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl url: {}", (Object)url);
        if (url.contains(ATTACH_FILE_POSITION)) {
            try {
                url = URLDecoder.decode(url, "utf-8");
                String path = url.split(ATTACH_FILE_PATH_REG)[1];
                LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl path: {}", (Object)path);
                String attach = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
                LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl attach: {}", (Object)attach);
                InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attach);
                String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(name, (InputStream)new BufferedInputStream(inputStream), 7200);
                LOGGER.info("PereduexpinfoEditPlugin#saveUrl saveUrl: {}", (Object)saveUrl);
                return saveUrl;
            }
            catch (Exception exp) {
                throw new KDException((Throwable)exp, new ErrorCode(BusinessUtils.class.getSimpleName(), exp.getMessage()), new Object[0]);
            }
        }
        return url;
    }

    public static void deleteEntryEntity(Long pkid, IFormView view) {
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry(view);
        if (currentEntry == null || currentEntry.length == 0) {
            return;
        }
        DynamicObjectCollection entryentity = currentEntry[0].getDynamicObjectCollection("entryentity");
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (next.get("dataid").equals(pkid)) {
                iterator.remove();
            }
            INFOAPPROVAL_HELPER.update(currentEntry);
            if (entryentity.size() != 0) continue;
            OPERATION_SERVICE.localInvokeOperation("unsubmit", currentEntry, OperateOption.create());
            INFOAPPROVAL_HELPER.deleteOne(currentEntry[0].getPkValue());
            PageCacheUtils.getHomePageCache(view).remove("submitVerson");
        }
    }

    public static void deleteApprovalCache(String entityName, Long id, IFormView view) {
        if (view.getParentView() == null) {
            LOGGER.warn("parentView is null");
            return;
        }
        Map tabList = (Map)SerializationUtils.fromJsonString((String)view.getPageCache().get("newParams"), Map.class);
        if (tabList == null || tabList.get("groupname") == null) {
            LOGGER.warn("tabList or groupName is null");
            return;
        }
        String groupName = (String)tabList.get("groupname");
        Map allCache = view.getParentView().getParentView().getPageCache().getAll();
        if (CollectionUtils.isEmpty((Map)allCache)) {
            LOGGER.warn("allCache is empty");
            return;
        }
        String cacheKey = groupName + "-entrycache";
        String cacheValue = (String)allCache.get(cacheKey);
        if (HRStringUtils.isEmpty((String)cacheValue)) {
            LOGGER.warn("dataCache is null");
            return;
        }
        List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
        if (!CollectionUtils.isEmpty((Collection)groupFields)) {
            Iterator it = groupFields.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                if (!id.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                it.remove();
            }
        }
        if (CollectionUtils.isEmpty((Collection)groupFields)) {
            view.getParentView().getParentView().getPageCache().batchRemove(Collections.singletonList(cacheKey));
        } else {
            view.getParentView().getParentView().getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)groupFields));
        }
    }

    public static void delData(String entityName, Long pk, IFormView view) {
        AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(entityName);
        DynamicObject[] dyArr = null;
        if (PersonModelClassificationEnum.PERATTACHED == classification || "hrpi_empjobrel".equals(entityName)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            dyArr = serviceHelper.queryOriginalArray("person.id,boid,sourcevid", new QFilter[]{new QFilter("id", "=", (Object)pk)});
        }
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
        HashMap<Long, Long> pkPersonIdMap = new HashMap<Long, Long>(16);
        pkPersonIdMap.put(pk, personId);
        List<Long> personIds = AttacheHandlerService.getInstance().validateSyncFieldsDelChange(entityName, pkPersonIdMap);
        Map<String, Object> resultMap = attacheHandlerService.invokeDel(Collections.singletonList(pk), entityName, Boolean.TRUE);
        if (AttacheHandlerService.isSuccess(resultMap)) {
            if (personIds != null && personIds.size() > 0) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(personIds);
            }
            if (dyArr != null && dyArr.length > 0) {
                String realFormId = AttacheHandlerService.getInstance().getRealFormId(view, "pagenumber", false);
                AttacheHandlerService.getInstance().sendHpfsChgDeleteRecord(dyArr, entityName, realFormId);
            }
            BusinessUtils.deleteApprovalCache(entityName, pk, view);
            BusinessUtils.deleteEntryEntity(pk, view);
            attacheHandlerService.removeAllAttachment(entityName, pk);
        }
    }

    public static String getDownUrl(DynamicObject attachObj) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(attachObj.getString("url"));
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)attachObj.getString("name"));
        FileItem fileItem = new FileItem(attachObj.getString("name"), pathParam, inputStream);
        String downUrl = service.upload(fileItem);
        return downUrl;
    }

    public static String createAvatar(String name) {
        DynamicObject bosUserDy = BOS_USER_SERVICEHELPER.generateEmptyDynamicObject();
        bosUserDy.set("name", (Object)name);
        String fullPinyin = UserOperationUtils.getFullSpellByName((String)name);
        bosUserDy.set("fullpinyin", (Object)fullPinyin);
        UserUtils.createAvatar((DynamicObject[])new DynamicObject[]{bosUserDy});
        return bosUserDy.getString("picturefield");
    }

    public static void dateChangedAfterSelected(IFormView view, String selectedField, String dateField, boolean isEditView) {
        boolean isnofixedterm;
        if (!view.getModel().getDataEntityType().getProperties().containsKey((Object)selectedField)) {
            return;
        }
        if (!view.getModel().getDataEntityType().getProperties().containsKey((Object)dateField)) {
            return;
        }
        if (view.getEntityId().startsWith("hspm_percre")) {
            String showlist = view.getPageCache().get("showlist");
            Set strings = new HashSet();
            if (!StringUtils.isEmpty((String)showlist)) {
                strings = (Set)SerializationUtils.fromJsonString((String)showlist, Set.class);
            }
            if (strings.stream().noneMatch(str -> str.contains(dateField))) {
                return;
            }
        }
        if (isnofixedterm = view.getModel().getDataEntity().getBoolean(selectedField)) {
            view.setVisible(Boolean.FALSE, new String[]{dateField});
            view.setVisible(Boolean.FALSE, new String[]{"containerflex_1" + dateField});
            BusinessUtils.addOrRemoveCacheIgnoreField(view, dateField, true);
            view.getModel().setValue(dateField, (Object)HRDateTimeUtils.getSysMaxDate());
        } else {
            view.setVisible(Boolean.TRUE, new String[]{dateField});
            view.setVisible(Boolean.TRUE, new String[]{"containerflex_1" + dateField});
            BusinessUtils.addOrRemoveCacheIgnoreField(view, dateField, false);
            if (isEditView) {
                return;
            }
            view.getModel().setValue(dateField, null);
        }
    }

    private static void addOrRemoveCacheIgnoreField(IFormView view, String dateField, boolean isAdd) {
        if (!view.getEntityId().endsWith("pdg") && !view.getEntityId().endsWith("_mdg")) {
            return;
        }
        String flag = view.getPageCache().get("isnofixedterm_audit");
        if (HRStringUtils.isEmpty((String)flag)) {
            return;
        }
        Set<String> commonSet = new HashSet<String>(16);
        String cacheStr = view.getPageCache().get("cacheingore");
        if (cacheStr != null && HRStringUtils.isNotEmpty((String)cacheStr)) {
            commonSet = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
        }
        if (isAdd) {
            commonSet.add(dateField);
        } else {
            commonSet.remove(dateField);
        }
        view.getPageCache().put("cacheingore", SerializationUtils.toJsonString(commonSet));
    }

    public static Set<String> getIgnoreField() {
        List<String> list = Arrays.asList("multilanguagetext", "creator", "createtime", "modifier", "modifytime", "modifiertime", "initstatus", "datastatus", "sourcevid", "iscurrentversion", "ismodify", "firstbsed", "changebsed", "brfd", "id", "boid", "person", "person_id");
        return list.stream().collect(Collectors.toSet());
    }

    public static boolean isEmail(String email) {
        Matcher m = PATTERN.matcher(email);
        return m.matches();
    }

    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        if (null == dateO || null == dateT || dateO.before(dateT)) {
            LOGGER.error("date calculate failed , we will return zero");
            return BigDecimal.ZERO;
        }
        return HRPerserlenHelper.calcYearsDiffNew((Date)dateO, (Date)dateT);
    }

    public static RoundingMode getBusiYearRoundingMode() {
        String roundingModeStr = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hspm_business_year_rounding_mode");
        try {
            return RoundingMode.valueOf(roundingModeStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("", (Throwable)e);
            return RoundingMode.HALF_UP;
        }
    }

    public static Boolean getUpdateButtonVisibleForErmanFile() {
        String updateButtonShow = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hspm_ermanfile_updatebutton_show");
        return "true".equals(updateButtonShow) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean getReviseButtonVisibleForErmanFile() {
        String reviseButtonShow = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hspm_ermanfile_revisebutton_show");
        return "true".equals(reviseButtonShow) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean getReviseButtonVisibleInOtherAppId() {
        String reviseButtonShow = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("revisebutton_inotherappid_show");
        return "true".equals(reviseButtonShow) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getHpfsMenuConfig() {
        String hpfsMenuConfig = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hpfs_switch_menu_config");
        return hpfsMenuConfig;
    }

    public static Boolean getReviseButtonVisible(IFormView view) {
        List<String> controlAppIdList;
        Boolean reviseButtonVisibleForErmanFileFlag = BusinessUtils.getReviseButtonVisibleForErmanFile();
        String curAppId = view.getFormShowParameter().getAppId();
        if (reviseButtonVisibleForErmanFileFlag.booleanValue() && (controlAppIdList = Arrays.asList("htm", "hdm", "ham")).contains(curAppId)) {
            return BusinessUtils.getReviseButtonVisibleInOtherAppId();
        }
        return reviseButtonVisibleForErmanFileFlag;
    }

    public static List<String> getReviseSupportEntityNumberList() {
        String configValue = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hspm_support_revise_entitynumber");
        String[] splitResultArr = configValue.split(",");
        ArrayList supportEntityNumberList = Lists.newArrayListWithExpectedSize((int)splitResultArr.length);
        for (String splitResult : splitResultArr) {
            supportEntityNumberList.add(splitResult);
        }
        return supportEntityNumberList;
    }

    public static Boolean isAllowInfoClassifyEdit() {
        String isAllowInfoclassEditStr = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hspm_business_is_allow_infoclass_edit");
        return "true".equals(isAllowInfoclassEditStr) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object typeChange(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)obj).getLocaleValue();
        }
        if (obj instanceof MulBasedataDynamicObjectCollection) {
            List collect = ((MulBasedataDynamicObjectCollection)obj).stream().map(dy -> dy.get("fbasedataid_id").toString()).collect(Collectors.toList());
            String join = String.join((CharSequence)";", collect);
            return join;
        }
        return obj;
    }

    public static Long queryEmpJobRelActionId() {
        String actionId = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("empjobrel_action_id");
        if (HRStringUtils.isEmpty((String)actionId)) {
            return HspmCommonConstants.JOB_ACTION_ID;
        }
        return Long.parseLong(actionId);
    }

    public static void reSetAttachmentUrl(FileService attachmentFileService, TempFileCache tempFileCache, Map<String, Object> attachment) {
        try {
            String url = (String)attachment.get("url");
            if (url.contains("tempfile/download.do?configKey")) {
                return;
            }
            if (url.contains("&kdedcba")) {
                url = url.substring(0, url.indexOf("&kdedcba"));
            }
            String path = UrlUtil.getParam((String)url, (String)"path");
            InputStream inputStream = attachmentFileService.getInputStream(path);
            String tempFileUrl = tempFileCache.saveAsFullUrl((String)attachment.get("name"), inputStream, 7200);
            attachment.put("url", tempFileUrl);
        }
        catch (Exception es) {
            LOGGER.error("reSetAttachmentUrlError", (Throwable)es);
        }
    }

    public static boolean endDateEditLock(DrawFormFieldDto drawFormField) {
        String lock = drawFormField.getLock();
        String field = drawFormField.getField();
        String origPageId = drawFormField.getOrigPageId();
        String className = drawFormField.getClassSimpleName();
        boolean mustInput = drawFormField.isMustInput();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(origPageId);
        if (PersonModelClassificationEnum.PERATTACHED != classification && mustInput) {
            return "DateProp".equals(className) && "edit".equals(lock) && (field.equals("enddate") || field.equals("sysenddate") || field.equals(origPageId + "-" + "enddate") || field.equals(origPageId + "-" + "sysenddate"));
        }
        return false;
    }

    public static String getBusinessValueByKey(String key) {
        String value = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey(key);
        LOGGER.info(key + "-------:" + value);
        return value;
    }

    public static String getSuperiorHint() {
        try {
            Map retMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getContentAndHtml", (Object[])new Object[]{1950948801552358400L});
            if (HRMapUtils.isEmpty((Map)retMap)) {
                return "";
            }
            String content = (String)retMap.get("content");
            if (HRStringUtils.isNotEmpty((String)content)) {
                return content;
            }
        }
        catch (Exception ex) {
            LOGGER.error("getSuperiorHintError", (Throwable)ex);
            return "";
        }
        return "";
    }
}

