/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.card.CardExtCommon;

@SdkPublic
public class CommonUtil {
    private static final Log logger = LogFactory.getLog(CommonUtil.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static final int INT_EIGHTEEN = 18;
    private static final int INT_FIFTEEN = 15;
    private static final int INT_NINETEEN = 19;
    private static final int SEX_MALE = 1;
    private static final int SEX_FEMALE = 2;
    private static final int SEX_OTHERS = 9;

    public static String listToString(List<String> list, char separator) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < list.size(); ++index) {
            sb.append(list.get(index));
            if (index >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean objIsEmpty(Object obj) {
        return obj instanceof String ? HRStringUtils.isEmpty((String)((String)obj)) : (obj instanceof Long ? (Long)obj == null || (Long)obj == 0L : (obj instanceof OrmLocaleValue ? HRStringUtils.isEmpty((String)((OrmLocaleValue)obj).getLocaleValue()) : obj == null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean customObjectEquals(Object obj1, Object obj2, String dateFormat) throws Exception {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            Set collectSecond;
            if (obj1 instanceof Integer) {
                obj1 = ((Integer)obj1).longValue();
            }
            if (obj2 instanceof Integer) {
                obj2 = ((Integer)obj2).longValue();
            }
            if (obj1 instanceof Long && obj2 instanceof Long) {
                return obj1.equals(obj2);
            }
            if (obj1 instanceof String && obj2 instanceof String) {
                return ((String)obj1).trim().equals(((String)obj2).trim());
            }
            if (obj1 instanceof Date && obj2 instanceof Date) {
                if (!HRStringUtils.isNotEmpty((String)dateFormat)) return false;
                String objDate1 = HRDateTimeUtils.format((Date)((Date)obj1), (String)dateFormat);
                String objDate2 = HRDateTimeUtils.format((Date)((Date)obj2), (String)dateFormat);
                return objDate1.equals(objDate2);
            }
            if (obj1 instanceof Date && obj2 instanceof String) {
                if (!HRStringUtils.isNotEmpty((String)dateFormat)) return false;
                String objDate1 = HRDateTimeUtils.format((Date)((Date)obj1), (String)dateFormat);
                String objDate2 = HRDateTimeUtils.format((Date)HRDateTimeUtils.parseDate((String)((String)obj2), (String)dateFormat), (String)dateFormat);
                return objDate1.equals(objDate2);
            }
            if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
                if (((BigDecimal)obj1).compareTo((BigDecimal)obj2) != 0) return false;
                return true;
            }
            if (obj1 instanceof Long && obj2 instanceof DynamicObject) {
                return obj1.equals(((DynamicObject)obj2).getLong("id"));
            }
            if (obj1 instanceof DynamicObject && obj2 instanceof Long) {
                return obj2.equals(((DynamicObject)obj1).getLong("id"));
            }
            if (obj1 instanceof DynamicObject && obj2 instanceof DynamicObject) {
                if (((DynamicObject)obj1).getLong("id") != ((DynamicObject)obj2).getLong("id")) return false;
                return true;
            }
            if (obj1 instanceof Long && obj2 instanceof Map) {
                Object oldPageId = ((Map)obj2).get("id");
                if (oldPageId == null) return false;
                return Long.valueOf(String.valueOf(oldPageId)).equals(obj1);
            }
            if (obj1 instanceof Map && obj2 instanceof Long) {
                Object oldPageId = ((Map)obj1).get("id");
                if (oldPageId == null) return false;
                return Long.valueOf(String.valueOf(oldPageId)).equals(obj2);
            }
            if (obj1 instanceof DynamicObject && obj2 instanceof Map) {
                long pageId = ((DynamicObject)obj1).getLong("id");
                Object oldPageId = ((Map)obj2).get("id");
                if (oldPageId == null) return false;
                return Long.valueOf(String.valueOf(oldPageId)).equals(pageId);
            }
            if (obj1 instanceof Map && obj2 instanceof DynamicObject) {
                long pageId = ((DynamicObject)obj2).getLong("id");
                Object oldPageId = ((Map)obj1).get("id");
                if (oldPageId == null) return false;
                return Long.valueOf(String.valueOf(oldPageId)).equals(pageId);
            }
            if (obj1 instanceof OrmLocaleValue && obj2 instanceof OrmLocaleValue) {
                Set entries = ((OrmLocaleValue)obj1).entrySet();
                Set entriesOld = ((OrmLocaleValue)obj2).entrySet();
                if (!entriesOld.containsAll(entries)) return false;
                if (!entries.containsAll(entriesOld)) return false;
                return true;
            }
            if (obj1 instanceof OrmLocaleValue && obj2 instanceof Map) {
                Object anObject;
                String localeValue;
                Set cnKeySet = ((OrmLocaleValue)obj1).keySet();
                if (cnKeySet.size() == 0 && ((Map)obj2).size() == 0) {
                    return true;
                }
                Iterator entriesOld = cnKeySet.iterator();
                do {
                    if (!entriesOld.hasNext()) return false;
                    String key = (String)entriesOld.next();
                    localeValue = ((OrmLocaleValue)obj1).getLocaleValue();
                    anObject = ((Map)obj2).get(key);
                    if (!HRStringUtils.isEmpty((String)localeValue) || !Objects.isNull(anObject)) continue;
                    return true;
                } while (!HRStringUtils.isNotEmpty((String)localeValue) || !localeValue.equals(anObject));
                return true;
            }
            if (obj1 instanceof String && obj2 instanceof Map) {
                if (((String)obj1).trim().length() != 0) return false;
                if (!((Map)obj2).isEmpty()) return false;
                return true;
            }
            if (obj1 instanceof OrmLocaleValue && obj2 instanceof String) {
                Set cnKeySet = ((OrmLocaleValue)obj1).keySet();
                if (cnKeySet.size() == 0 && HRStringUtils.isEmpty((String)((String)obj2))) {
                    return true;
                }
                if (!((OrmLocaleValue)obj1).getLocaleValue().equals(obj2)) return false;
                return true;
            }
            if (!(obj1 instanceof MulBasedataDynamicObjectCollection)) return obj1.equals(obj2);
            if (!(obj2 instanceof MulBasedataDynamicObjectCollection)) return obj1.equals(obj2);
            if (((MulBasedataDynamicObjectCollection)obj1).size() != ((MulBasedataDynamicObjectCollection)obj2).size()) return false;
            Set collect = ((MulBasedataDynamicObjectCollection)obj1).stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!collect.containsAll(collectSecond = ((MulBasedataDynamicObjectCollection)obj2).stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet()))) return false;
            if (!collectSecond.containsAll(collect)) return false;
            return true;
        }
        if (obj1 == null && obj2 instanceof String) {
            if (!HRStringUtils.isEmpty((String)((String)obj2))) return false;
            return true;
        }
        if (obj1 != null) return false;
        if (!(obj2 instanceof OrmLocaleValue)) return false;
        Set entries = ((OrmLocaleValue)obj2).entrySet();
        return entries.stream().allMatch(arg -> HRStringUtils.isEmpty((String)((String)arg.getValue())));
    }

    public static boolean listEquals(List<Long> list1, List<Long> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Collections.sort(list1);
        Collections.sort(list2);
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPerm(String entityName, String permItemId) {
        return CommonUtil.hasPerm(entityName, permItemId, "hspm");
    }

    public static boolean hasPerm(String entityName, String permItemId, String appId) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"11", (String)appId, (String)entityName, (String)permItemId);
    }

    public static boolean hasPerm(String entityName, String permItemId, String appId, IFormView view) {
        long userId = RequestContext.get().getCurrUserId();
        if (view != null && view.getFormShowParameter() != null && view.getFormShowParameter().getAppId() != null) {
            appId = view.getFormShowParameter().getAppId();
            String checkRightAppId = view.getFormShowParameter().getCheckRightAppId();
            if (HRStringUtils.isEmpty((String)checkRightAppId)) {
                checkRightAppId = appId;
            }
            if (!HRStringUtils.equals((String)appId, (String)checkRightAppId)) {
                appId = checkRightAppId;
            }
        }
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"11", (String)appId, (String)entityName, (String)permItemId);
    }

    public static boolean permShowClickError(IFormView view, String permItemId, BeforeClickEvent evt, String currentPage) {
        String entityName = CommonUtil.setEntityName(view, currentPage);
        if (HRStringUtils.isEmpty((String)entityName)) {
            return false;
        }
        boolean result = CommonUtil.hasPerm(entityName, permItemId, "hspm", view);
        if (!result) {
            evt.setCancel(true);
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        return true;
    }

    private static String setEntityName(IFormView view, String currentPage) {
        IFormView parentView;
        String entityName = null;
        entityName = "1".equals(currentPage) || "2".equals(currentPage) ? view.getEntityId() : ((parentView = view.getParentView()) != null ? parentView.getEntityId() : view.getEntityId());
        return entityName;
    }

    public static boolean isNumeric(String str) {
        String regEx = "^[0-9]*[1-9][0-9]*$";
        return CommonUtil.checkNumber(str, regEx);
    }

    public static boolean isDecimal(String str) {
        String regEx = "^[0-9]+([.]{1}[0-9]+){0,1}$";
        return CommonUtil.checkNumber(str, regEx);
    }

    private static boolean checkNumber(String str, String regEx) {
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(str);
        return mat.find();
    }

    public static DynamicObject[] getCurrentEntry(IFormView view) {
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
        if (personId == null || personId == 0L) {
            logger.warn("personId is null");
            return null;
        }
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"D").or("billstatus", "=", (Object)"G");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
    }

    public static DynamicObject[] getCurrentEntry(Long personId) {
        if (personId == null || personId == 0L) {
            logger.warn("personId is null");
            return null;
        }
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"D").or("billstatus", "=", (Object)"G");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
    }

    public static boolean isBaseDataType(Class baseDataClass, String classSimpleName) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldTypeBySimpleCode(classSimpleName);
        return fieldTypeEnum != null && baseDataClass.isAssignableFrom(FieldTypeEnum.getTypeClassObject(fieldTypeEnum.getCode()));
    }

    public static Set<String> fullLineField() {
        HashSet fullName = Sets.newHashSet((Object[])new String[]{"addressinfo", "emrgaddress", "description"});
        new CardExtCommon().setFullLineName(fullName);
        return fullName;
    }

    public static boolean existAuditingEntry(IFormView view) {
        String presonIdStr;
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
        if ((personId == null || personId == 0L) && HRStringUtils.isNotEmpty((String)(presonIdStr = view.getPageCache().get("personId")))) {
            personId = Long.valueOf(presonIdStr);
        }
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"D");
        return SERVICE_HELPER.isExists(new QFilter[]{personFilter, statusFilter});
    }

    public static boolean getMaxDate(Date endDate) {
        if (endDate == null) {
            return false;
        }
        try {
            endDate = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)endDate));
            return HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L)) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L));
        }
        catch (Exception esc) {
            logger.error("getMaxDateError", (Throwable)esc);
            return false;
        }
    }

    public static Date getBirthDayFromIdCard(String idCard) {
        Date birth = null;
        try {
            if (idCard.length() == 18) {
                String year = idCard.substring(6).substring(0, 4);
                String month = idCard.substring(10).substring(0, 2);
                String day = idCard.substring(12).substring(0, 2);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                birth = format.parse(year + "-" + month + "-" + day);
            } else if (idCard.length() == 15) {
                String year = 19 + idCard.substring(6, 8);
                String month = idCard.substring(8, 10);
                String day = idCard.substring(10, 12);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                birth = format.parse(year + "-" + month + "-" + day);
            }
        }
        catch (ParseException exp) {
            logger.error("getBirthDayFromIdCardError:", (Throwable)exp);
        }
        return birth;
    }

    public static int getSexFromIdCard(String idCard) {
        int sex = 9;
        if (HRStringUtils.isEmpty((String)idCard)) {
            return 0;
        }
        if (idCard.length() == 18) {
            sex = Integer.parseInt(idCard.substring(16).substring(0, 1)) % 2 == 0 ? 2 : 1;
        } else if (idCard.length() == 15) {
            String usex = idCard.substring(14, 15);
            sex = Integer.parseInt(usex) % 2 == 0 ? 2 : 1;
        }
        return sex;
    }

    public static int getAgeForIdCard(String idcard) {
        try {
            int age = 0;
            if (HRStringUtils.isEmpty((String)idcard)) {
                return age;
            }
            String birth = "";
            if (idcard.length() == 18) {
                birth = idcard.substring(6, 14);
            } else if (idcard.length() == 15) {
                birth = 19 + idcard.substring(6, 12);
            }
            int year = Integer.parseInt(birth.substring(0, 4));
            int month = Integer.parseInt(birth.substring(4, 6));
            int day = Integer.parseInt(birth.substring(6));
            Calendar cal = Calendar.getInstance();
            age = cal.get(1) - year;
            if (cal.get(2) < month - 1 || cal.get(2) == month - 1 && cal.get(5) < day) {
                --age;
            }
            return age;
        }
        catch (Exception e) {
            logger.error("getAgeForIdCard:", (Throwable)e);
            return -1;
        }
    }

    public static boolean isCurrentDataExistBill(Map<String, Object> tabList, IFormView view) {
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry(view);
        if (currentEntry != null && currentEntry.length > 0) {
            DynamicObject dynamicObject = currentEntry[0];
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (entryentity == null) {
                return false;
            }
            String customParam = (String)view.getFormShowParameter().getCustomParam("pkid");
            Long pkid = Long.parseLong(customParam == null ? "0" : customParam);
            if (pkid != 0L) {
                long count = entryentity.stream().filter(next -> next.get("firstgroupnum").equals(tabList.get("targetkey")) && next.get("dataid").equals(pkid)).count();
                if (count > 0L) {
                    return true;
                }
                if (!view.getEntityId().equals("hspm_pereduexp_mdg")) {
                    return false;
                }
                HRBaseServiceHelper certHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
                QFilter VersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "-3"});
                DynamicObject[] certDys = certHelper.loadDynamicObjectArray("hrpi_pereduexpcert", new QFilter[]{new QFilter("pereduexp", "=", (Object)pkid), VersionFilter, statusFilter});
                logger.info("certDys=={}=={}", (Object)certDys, (Object)certDys.length);
                for (DynamicObject certDy : certDys) {
                    long num = entryentity.stream().filter(next -> next.get("firstgroupnum").equals(tabList.get("targetkey")) && next.get("dataid").equals(certDy.getPkValue())).count();
                    if (num <= 0L) continue;
                    return true;
                }
            } else {
                if (view.getEntityId().endsWith("_mdg") || view.getEntityId().endsWith("pdg")) {
                    return false;
                }
                long count = entryentity.stream().filter(next -> next.get("firstgroupnum").equals(tabList.get("targetkey"))).count();
                if (count > 0L) {
                    return true;
                }
            }
        }
        return false;
    }

    public static BigDecimal getBigDecimalIfExist(IDataModel model, String key) {
        return CommonUtil.isFieldExist(model, key) ? model.getDataEntity().getBigDecimal(key) : new BigDecimal("0.0");
    }

    public static BigDecimal getBigDecimalIfExist(IDataModel model, String key, Long personId, String selProp) {
        if (CommonUtil.isFieldExist(model, key)) {
            return model.getDataEntity().getBigDecimal(key);
        }
        return BusinessUtils.getPerserlenByPersonId(personId, selProp);
    }

    public static boolean isFieldExist(IDataModel model, String key) {
        return model.getDataEntityType().getAllFields().containsKey(key);
    }
}

