/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.DynamicTransformUtil;

@SdkPublic
public class DynamicPropValidateUtil {
    public static boolean checkChanged(DynamicObject dataEntity, DynamicObject dbDy) {
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(dataEntity.getDataEntityType().getExtendName());
        dynamicPropString = String.join((CharSequence)",", dynamicPropString, "description");
        return DynamicPropValidateUtil.checkChanged(dataEntity, dbDy, dynamicPropString);
    }

    public static boolean checkChanged(DynamicObject dataEntity, DynamicObject dbDy, String dynamicPropString) {
        String[] props;
        DataEntityPropertyCollection dbDyProperties = dbDy.getDynamicObjectType().getProperties();
        for (String prop : props = HRStringUtils.split((String)dynamicPropString, (String)",")) {
            try {
                if (!dbDyProperties.containsKey((Object)prop) || CommonUtil.customObjectEquals(dataEntity.get(prop), dbDy.get(prop), "yyyy-MM-dd")) continue;
                return true;
            }
            catch (Exception e) {
                throw new KDBizException(String.format(Locale.ROOT, "compare error. %s", prop));
            }
        }
        return false;
    }

    public static Map<String, List<String>> checkChangedPropMap(DynamicObject dataEntity, DynamicObject dbDy) {
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(dataEntity.getDataEntityType().getName());
        dynamicPropString = String.join((CharSequence)",", dynamicPropString, "description");
        return DynamicPropValidateUtil.checkChangedPropMap(dataEntity, dbDy, dynamicPropString);
    }

    public static Map<String, List<String>> checkChangedPropMap(DynamicObject dataEntity, DynamicObject dbDy, String dynamicPropString) {
        DataEntityPropertyCollection dbDyProperties = dbDy.getDynamicObjectType().getProperties();
        String[] props = HRStringUtils.split((String)dynamicPropString, (String)",");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<String> hasChangedProps = new ArrayList<String>(10);
        ArrayList<String> noChangedProps = new ArrayList<String>(10);
        for (String prop : props) {
            try {
                if (!dbDyProperties.containsKey((Object)prop)) continue;
                if (!CommonUtil.customObjectEquals(dataEntity.get(prop), dbDy.get(prop), "yyyy-MM-dd")) {
                    hasChangedProps.add(prop);
                } else {
                    noChangedProps.add(prop);
                }
                result.put("hasChangedProps", hasChangedProps);
                result.put("noChangedProps", noChangedProps);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(Locale.ROOT, "compare error. %s", prop));
            }
        }
        return result;
    }

    public static void trim(DynamicObject dataEntity) {
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            Object value = dataEntity.get(property);
            if (value == null) continue;
            if (value instanceof String) {
                dataEntity.set(property, (Object)value.toString().trim());
                continue;
            }
            if (!(value instanceof OrmLocaleValue)) continue;
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
            for (Map.Entry entry : ormLocaleValue.entrySet()) {
                if (entry.getValue() == null) continue;
                String trimVal = ((String)entry.getValue()).trim();
                ormLocaleValue.put((String)entry.getKey(), trimVal);
            }
            dataEntity.set(property, (Object)ormLocaleValue);
        }
    }
}

