/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;

@SdkPublic
public class PropertyHelper {
    private static final ThreadLocal<Map<String, EntityMetadata>> ENTITYMETADATA_TL = new ThreadLocal();

    public static boolean existProperty(DynamicObject obj, String key) {
        boolean existProperty = false;
        if (obj == null || obj.getDataEntityType() == null || obj.getDataEntityType().getProperties() == null) {
            return existProperty;
        }
        existProperty = obj.getDataEntityType().getProperties().containsKey((Object)key);
        return existProperty;
    }

    public static Object getProperty(DynamicObject obj, String key) {
        return obj == null || HRStringUtils.isEmpty((String)key) ? null : obj.get(key);
    }

    public static boolean existProperty(String pageNumber, String key) {
        Map allFields;
        return HRStringUtils.isNotEmpty((String)pageNumber) && HRStringUtils.isNotEmpty((String)key) && (allFields = MetadataServiceHelper.getDataEntityType((String)pageNumber).getAllFields()) != null && allFields.containsKey(key);
    }

    public static String setLanguage(DynamicObject cnfDy, String langDbField, String langField) {
        String localeValue = cnfDy.getDynamicObject(langDbField).getLocaleString(langField).getLocaleValue();
        if (HRStringUtils.isEmpty((String)localeValue)) {
            return cnfDy.getDynamicObject(langDbField).getString(langField);
        }
        return localeValue;
    }

    public static String setLanguageField(DynamicObject cnfDy, String langDbField) {
        String localeValue = cnfDy.getLocaleString(langDbField).getLocaleValue();
        if (HRStringUtils.isEmpty((String)localeValue)) {
            return cnfDy.getString(langDbField);
        }
        return localeValue;
    }

    public static String getMultiLanguageValue(DynamicObject dy, String fieldName) {
        if (dy != null) {
            ILocaleString localeString = dy.getLocaleString(fieldName);
            if (localeString != null && HRStringUtils.isNotEmpty((String)localeString.getLocaleValue())) {
                return localeString.getLocaleValue();
            }
            return dy.getString(fieldName);
        }
        return null;
    }

    public static Field getField(DrawFormFieldDto drawFormField) {
        EntityMetadata entityMetadata;
        if (drawFormField == null || HRStringUtils.isEmpty((String)drawFormField.getOrigPageId())) {
            return null;
        }
        Map<String, EntityMetadata> entityMetadataMap = ENTITYMETADATA_TL.get();
        if (entityMetadataMap == null) {
            entityMetadataMap = new HashMap<String, EntityMetadata>(4);
            ENTITYMETADATA_TL.set(entityMetadataMap);
        }
        if ((entityMetadata = entityMetadataMap.get(drawFormField.getOrigPageId())) == null) {
            String id = MetadataDao.getIdByNumber((String)drawFormField.getOrigPageId(), (MetaCategory)MetaCategory.Form);
            if (id == null) {
                return null;
            }
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        }
        if (entityMetadata == null) {
            return null;
        }
        entityMetadataMap.put(drawFormField.getOrigPageId(), entityMetadata);
        String field = drawFormField.getField();
        boolean single = InfoGroupHelper.isSingleRowTpl(drawFormField.getOrigPageId());
        String fieldKey = single ? field.replace(drawFormField.getOrigPageId() + "-", "") : field;
        return entityMetadata.getFieldByKey(fieldKey);
    }
}

