/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.infoclassify;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.hspm.business.helper.ImportBasedataHelper;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class InfoClassifyEditPlugin
extends HRDataBaseEdit
implements UploadListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(InfoClassifyEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit personEdit = (BasedataEdit)this.getControl("person");
        if (personEdit != null) {
            personEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Boolean isAllowInfoClassifyEdit = BusinessUtils.isAllowInfoClassifyEdit();
        if (isAllowInfoClassifyEdit.booleanValue()) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getCustomParams().put("isAllowInfoClassifyEdit", Boolean.TRUE);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormView view = (FormView)this.getView();
        if (view.getStatus() == OperationStatus.EDIT) {
            view.setVisible(Boolean.FALSE, new String[]{InfoClassifyFormOperateEnum.FORM_BTN_SAVE.getKey()});
        } else if (view.getStatus() == OperationStatus.ADDNEW) {
            view.setVisible(Boolean.FALSE, new String[]{InfoClassifyFormOperateEnum.FORM_BTN_UPDATE.getKey()});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{InfoClassifyFormOperateEnum.FORM_BTN_SAVE.getKey()});
            view.setVisible(Boolean.FALSE, new String[]{InfoClassifyFormOperateEnum.FORM_BTN_UPDATE.getKey()});
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(formOperate.getOperateKey());
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        boolean dataChanged = this.getModel().getDataChanged();
        if (operateKeyEnum == InfoClassifyFormOperateEnum.FORM_BTN_UPDATE) {
            this.beforeDoOperationForFormBtnSave(args, dataChanged);
        } else if (!dataChanged) {
            args.setCancel(true);
            this.getView().close();
        }
    }

    protected void beforeDoOperationForFormBtnSave(BeforeDoOperationEventArgs args, boolean dataChanged) {
        if (!dataChanged) {
            args.setCancel(true);
            this.saveOrUpdateAfterDoOperation();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(formOperate.getOperateKey());
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        String entityId = this.getView().getEntityId();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey(entityId);
        if (infoClassifyEntityKeyDTO == null) {
            LOGGER.error("hspm_infoclassifycnf is empty,please register");
            return;
        }
        switch (operateKeyEnum) {
            case FORM_BTN_SAVE: {
                this.afterDoOperationForFormBtnSave(args, infoClassifyEntityKeyDTO);
                break;
            }
            case FORM_BTN_UPDATE: {
                this.afterDoOperationForFormBtnUpdate(args, infoClassifyEntityKeyDTO);
                break;
            }
        }
    }

    protected void afterDoOperationForFormBtnSave(AfterDoOperationEventArgs args, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        this.saveOrUpdateAfterDoOperation();
    }

    protected void afterDoOperationForFormBtnUpdate(AfterDoOperationEventArgs args, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        this.saveOrUpdateAfterDoOperation();
    }

    protected void saveOrUpdateAfterDoOperation() {
        this.getModel().setDataChanged(false);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.getView().returnDataToParent((Object)pkValue);
        this.getView().close();
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs args) {
        List<String> hisBaseDataEntityList = this.getHisBaseDataEntityList();
        List<String> personDataEntityList = this.getPersonDataEntityList();
        args.getSearchResult().forEach((item, ids) -> {
            String entityId = item.getEntityNumber();
            if (hisBaseDataEntityList.contains(entityId)) {
                this.queryAndSetImportBaseData((List<Object>)ids, entityId);
            }
            if (personDataEntityList.contains(entityId)) {
                this.queryAndSetPersonImportBaseData((List<Object>)ids);
            }
        });
    }

    protected List<String> getHisBaseDataEntityList() {
        ArrayList<String> hisBaseDataEntityList = new ArrayList<String>();
        hisBaseDataEntityList.add("hrpi_person");
        hisBaseDataEntityList.add("hrpi_personf7query");
        return hisBaseDataEntityList;
    }

    protected List<String> getPersonDataEntityList() {
        ArrayList<String> hisBaseDataEntityList = new ArrayList<String>();
        hisBaseDataEntityList.add("hrpi_person");
        hisBaseDataEntityList.add("hrpi_personf7query");
        return hisBaseDataEntityList;
    }

    protected void queryAndSetImportBaseData(List<Object> ids, String entityId) {
        DynamicObjectCollection idCol = ImportBasedataHelper.queryImportHisBaseData(ids, entityId);
        ids.clear();
        ids.addAll(idCol.stream().map(dy -> dy.get("id")).collect(Collectors.toList()));
    }

    protected void queryAndSetPersonImportBaseData(List<Object> ids) {
        List<Long> personIdList = ImportBasedataHelper.queryPersonBaseData(ids);
        ids.clear();
        ids.addAll(personIdList);
    }

    protected void setMustInput(String field, boolean mustInput) {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(field);
        fieldEdit.setMustInput(mustInput);
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)this.getModel().getDataEntity().getDynamicObjectType().getProperties().get((Object)field);
        if (iDataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)iDataEntityProperty;
            basedataProp.setMustInput(mustInput);
        } else if (iDataEntityProperty instanceof FieldProp) {
            FieldProp fieldProp = (FieldProp)iDataEntityProperty;
            fieldProp.setMustInput(mustInput);
        }
        this.getView().updateView(field);
    }
}

