/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.infoclassify;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ListVisible;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.CommonQFilterHelper;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;
import kd.sdk.hr.hspm.common.enums.InfoClassifyListOperateEnum;
import kd.sdk.hr.hspm.common.utils.InfoClassifyOpenWindowUtil;
import kd.sdk.hr.hspm.common.utils.PermUtil;
import kd.sdk.hr.hspm.formplugin.infoclassify.InfoClassifyQueryListPlugin;

public class InfoClassifyListPlugin
extends InfoClassifyQueryListPlugin {
    private static final String LISTBTNDELETECONFIRMCALLBACKID = "ListBtnDeleteConfirmCallBack";
    private static final String BUTTON_EXPORTLIST = "exportlist";
    private static final String BUTTON_IMPORDATA = "importdata";
    private static final List<String> INIT_INVISIBLE_BUTTONLIST = Arrays.asList("new", "delete", "close", "exportlist", "importdata");
    private static final Long WORKING_STATE_ID = 1010L;
    private static final Log LOGGER = LogFactory.getLog(InfoClassifyListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn prdColumn = args.getFilterColumn("hrpi_empentrel.labrelstatusprd.name");
        if (Objects.nonNull(prdColumn)) {
            prdColumn.setDefaultValue(String.valueOf(WORKING_STATE_ID));
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List<QFilter> customFilterList = this.getCustomFilter();
        setFilterEvent.getQFilters().addAll(customFilterList);
        String orderBy = this.getCustomOrderBy();
        setFilterEvent.setOrderBy(orderBy);
        super.setFilter(setFilterEvent);
    }

    protected List<QFilter> getCustomFilter() {
        ArrayList<QFilter> customFilterList = new ArrayList<QFilter>();
        String initbatch = (String)this.getView().getFormShowParameter().getCustomParam("initbatch");
        customFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        customFilterList.add(new QFilter("datastatus", "=", (Object)"1"));
        customFilterList.add(new QFilter("hrpi_empposorgrel.isprimary", "=", (Object)"1"));
        customFilterList.add(new QFilter("hspm_ermanfile.businessstatus", "=", (Object)"1"));
        customFilterList.add(new QFilter("hrpi_empentrel.islatestrecord", "=", (Object)"1"));
        customFilterList.add(new QFilter("hrpi_empposorgrel.empposing", "=", (Object)"1"));
        customFilterList.add(new QFilter("hspm_ermanfile.ermanfileing", "=", (Object)"1"));
        QFilter lastFilter = new QFilter("hrpi_empposorgrel.islatestrecord", "=", (Object)"1");
        QFilter busFilter = new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"2");
        lastFilter.and(busFilter).or(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
        customFilterList.add(lastFilter);
        if (HRObjectUtils.isEmpty((Object)initbatch)) {
            customFilterList.add(CommonQFilterHelper.getAllErfiletypeMainErfiletypeassign("hspm_ermanfile.filetype"));
            customFilterList.add(new QFilter("initstatus", "=", (Object)"2"));
        } else {
            customFilterList.add(CommonQFilterHelper.getErfiletypeInitErfiletypeassign("hspm_ermanfile.filetype"));
            customFilterList.add(new QFilter("initbatch", "=", (Object)Long.valueOf(initbatch)));
        }
        return customFilterList;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String initbatch = (String)this.getView().getFormShowParameter().getCustomParam("initbatch");
        if (!HRObjectUtils.isEmpty((Object)initbatch)) {
            INIT_INVISIBLE_BUTTONLIST.forEach(button -> this.getView().setVisible(Boolean.valueOf(false), new String[]{button}));
        }
    }

    protected List<String> getExportInitQFilterStr() {
        return this.getQFilterStr();
    }

    protected String getCustomOrderBy() {
        return "person";
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = this.initDefaultFixedColumnList();
        this.customerFixedColumnList(fixedColumnList);
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
        List<String> visibleColumnList = this.initVisibleColumnList();
        this.customerVisibleColumnList(visibleColumnList);
        visibleColumnList.forEach(column -> args.getListColumn(column).setVisible(ListVisible.LOOKUP.getVisible()));
    }

    protected List<String> initDefaultFixedColumnList() {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("hrpi_person.headsculpture");
        fixedColumnList.add("hrpi_person.name");
        fixedColumnList.add("hrpi_person.number");
        return fixedColumnList;
    }

    protected void customerFixedColumnList(List<String> fixedColumnList) {
    }

    protected List<String> initVisibleColumnList() {
        ArrayList<String> visibleColumnList = new ArrayList<String>();
        visibleColumnList.add("hspm_ermanfile.affiliateadminorg.name");
        visibleColumnList.add("hspm_ermanfile.empgroup.name");
        visibleColumnList.add("hrpi_empposorgrel.apositiontype");
        visibleColumnList.add("hrpi_empposorgrel.position.name");
        visibleColumnList.add("hrpi_empposorgrel.stdposition.name");
        visibleColumnList.add("hrpi_empposorgrel.job.name");
        visibleColumnList.add("hrpi_empposorgrel.isprimary");
        visibleColumnList.add("hrpi_empentrel.laborreltype.name");
        visibleColumnList.add("hrpi_empentrel.laborrelstatus.name");
        return visibleColumnList;
    }

    protected void customerVisibleColumnList(List<String> visibleColumnList) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        IListView listView = (IListView)this.getView();
        String itemKey = evt.getItemKey();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByListKey(listView.getBillFormId());
        InfoClassifyListOperateEnum operateKeyEnum = InfoClassifyListOperateEnum.getInfoClassifyListOperateEnumByOperateKey(itemKey);
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        switch (operateKeyEnum) {
            case LIST_BTN_CLOSE: {
                IFormView parentView = listView.getParentView().getParentView();
                parentView.close();
                listView.sendFormAction(parentView);
                break;
            }
            case LIST_BTN_DELETE: {
                if (!PermUtil.hasPerm(infoClassifyEntityKeyDTO.getQueryKey(), "4715e1f1000000ac")) break;
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractListView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LISTBTNDELETECONFIRMCALLBACKID, (IFormPlugin)this);
                    if (!selectedRows.isEmpty()) {
                        String message = MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff08\u9009\u4e2d\u6761\u6570\uff1a{0}\uff09\uff0c{1}\u3002", (String)"InfoClassifyListPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), selectedRows.size(), System.lineSeparator());
                        String confirmMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"InfoClassifyListPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                        this.getView().showConfirm(message + confirmMsg, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
                    }
                }
                evt.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IListView listView = (IListView)this.getView();
        String operateKey = formOperate.getOperateKey();
        InfoClassifyEntityKeyDTO entityKeyEnum = InfoClassifyEntityKeyDTO.getEntityKeyEnumByListKey(listView.getBillFormId());
        InfoClassifyListOperateEnum operateKeyEnum = InfoClassifyListOperateEnum.getInfoClassifyListOperateEnumByOperateKey(operateKey);
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        switch (operateKeyEnum) {
            case LIST_BTN_NEW: {
                args.setCancel(true);
                this.beforeDoOperateForListBtnNew(args, entityKeyEnum);
                break;
            }
            case LIST_BTN_HISINFO: {
                if (listView.getSelectedRows().size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u5904\u7406\u4e00\u6761\u6570\u636e\u3002", (String)"InfoClassifyListPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long pkId = (Long)listView.getFocusRowPkId();
                this.beforeDoOperateForListBtnHisinfo(args, pkId, entityKeyEnum);
                break;
            }
            case LIST_BTN_EXPORTLIST: 
            case LIST_BTN_EXPORTLIST_EXPT: {
                FormOperate operate = (FormOperate)args.getSource();
                Map parameter = operate.getParameter();
                parameter.put("byList", Boolean.FALSE);
                operate.setParameter(parameter);
                break;
            }
            case LIST_BTN_IMPORT: {
                args.setCancel(true);
                this.beforeDoOperateForListBtnImport(args, entityKeyEnum);
                break;
            }
        }
    }

    protected void beforeDoOperateForListBtnNew(BeforeDoOperationEventArgs args, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyListPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    protected void beforeDoOperateForListBtnHisinfo(BeforeDoOperationEventArgs args, Long pkId, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyListPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    protected void beforeDoOperateForListBtnImport(BeforeDoOperationEventArgs args, InfoClassifyEntityKeyDTO importOperateEnum) {
        FormShowParameter formShowParameter = InfoClassifyOpenWindowUtil.openWindowForHisNonLineImportStartPage((ListView)this.getView(), importOperateEnum.getImportPlugin());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, InfoClassifyFormOperateEnum.FORM_BTN_IMPORTDATA.getOperateKey()));
        this.getView().showForm(formShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        InfoClassifyEntityKeyDTO entityKeyEnum = InfoClassifyEntityKeyDTO.getEntityKeyEnumByListKey(listView.getBillFormId());
        if (entityKeyEnum == null) {
            LOGGER.error("click hspm_infoclassifycnf is empty,please register");
            return;
        }
        Long pkId = (Long)listView.getFocusRowPkId();
        this.billListHyperLinkClick(args, pkId, entityKeyEnum);
    }

    protected void billListHyperLinkClick(HyperLinkClickArgs args, Long pkId, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyListPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IListView listView = (IListView)this.getView();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        InfoClassifyEntityKeyDTO entityKeyEnum = InfoClassifyEntityKeyDTO.getEntityKeyEnumByListKey(listView.getBillFormId());
        if (HRStringUtils.equals((String)callBackId, (String)LISTBTNDELETECONFIRMCALLBACKID)) {
            int result = messageBoxClosedEvent.getResult().getValue();
            if (result == MessageBoxResult.Yes.getValue()) {
                this.afterConfirmCallBackForListBtnDelete(entityKeyEnum);
            }
            return;
        }
        super.confirmCallBack(messageBoxClosedEvent);
    }

    protected void afterConfirmCallBackForListBtnDelete(InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        this.doOperateForListBtnDelete(infoClassifyEntityKeyDTO);
    }

    protected void doOperateForListBtnDelete(InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        IListView listView = (IListView)this.getView();
        OperationResult operationResult = listView.invokeOperation(InfoClassifyListOperateEnum.LIST_BTN_DELETE.getKey());
        this.getView().invokeOperation(InfoClassifyListOperateEnum.LIST_BTN_REFRESH.getOperateKey());
        if (operationResult.isSuccess()) {
            this.deleteAfterDoOperate();
        }
    }

    protected void deleteAfterDoOperate() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"InfoClassifyListPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.isEmpty((String)actionId)) {
            return;
        }
        InfoClassifyFormOperateEnum formOperateEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(actionId);
        if (formOperateEnum == null) {
            return;
        }
        switch (formOperateEnum) {
            case FORM_BTN_SAVE: 
            case FORM_BTN_UPDATE: {
                Long returnData = (Long)event.getReturnData();
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                this.saveOrUpdateClosedCallBack(event);
                break;
            }
            case FORM_BTN_IMPORTDATA: {
                this.getView().invokeOperation(InfoClassifyListOperateEnum.LIST_BTN_REFRESH.getOperateKey());
                break;
            }
        }
    }

    private void saveOrUpdateClosedCallBack(ClosedCallBackEvent event) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InfoClassifyListPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation(InfoClassifyListOperateEnum.LIST_BTN_REFRESH.getOperateKey());
    }
}

