/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.employee.base;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.helper.CardDrawElyMobHelper;
import kd.sdk.hr.hspm.business.helper.HspmDesensitizeHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.CardDrawDTO;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.formplugin.web.file.employee.base.ElyCardTplEdit;

public abstract class AbstractElyCardEdit
extends HRDynamicFormBasePlugin
implements ElyCardTplEdit {
    private static final Log LOGGER = LogFactory.getLog(AbstractElyCardEdit.class);
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static Pattern pattern = Pattern.compile("[a-zA-Z]");
    public static final ThreadLocal<Object> INPROCESS_BILL_TL = new ThreadLocal();

    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        this.load(this.getView());
        this.handleAuditHint();
        this.keepDataId();
        ApprovalHelper.showNoPassInfoForDelOP(this.getView());
    }

    protected void handleAuditHint() {
        Map tabList = this.getMultiViewConfig(this.getView());
        if (tabList != null) {
            DynamicObject bill;
            String groupName = (String)tabList.get("groupname");
            String cacheValue = this.getGroupAuditCacheValue(groupName);
            if (HRStringUtils.isNotEmpty((String)cacheValue) && (bill = this.getInProcessWorkFlowBill()) != null) {
                if ("G".equals(bill.getString("billstatus"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"auditinghint"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"notpsshint"});
                }
            } else if (ParamAnalysisUtil.existAuditField(tabList)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"notpsshint"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"statushint"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"auditinghint"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"audithintflex"});
            }
        }
    }

    private void keepDataId() {
        List groupDataList = this.getGroupDataList();
        if (!CollectionUtils.isEmpty((Collection)groupDataList)) {
            HashSet<String> dataIds = new HashSet<String>();
            for (List list : groupDataList) {
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                for (Map data : list) {
                    dataIds.add(CardDrawElyMobHelper.getDataId(data));
                }
            }
            this.getView().getPageCache().put("data_ids", SerializationUtils.toJsonString(dataIds));
        }
    }

    protected void queryAdditionalField(Map<String, Object> group) {
    }

    @Override
    public void setData(List<List<Map<String, String>>> groupDataList) {
        Map tabList = this.getMultiViewConfig(this.getView());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (CollectionUtils.isEmpty((Map)formShowParameter.getCustomParams())) {
            return;
        }
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        if (CollectionUtils.isEmpty(groups)) {
            return;
        }
        boolean isPreView = this.isPreView(this.getView());
        for (Map<String, Object> group : groups) {
            this.queryAdditionalField(group);
            List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
            ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
            if (!CollectionUtils.isEmpty(fields)) {
                Map<String, List<Map>> groupFields = fields.stream().collect(Collectors.groupingBy(val -> (String)val.get("pnumber")));
                for (Map.Entry<String, List<Map<String, Object>>> entry : groupFields.entrySet()) {
                    List selectProps = entry.getValue().stream().map(val -> (String)val.get("number")).collect(Collectors.toList());
                    selectProps.add("datastatus");
                    QFilter qFilter = this.getQFilter(entry, formShowParameter.getCustomParams());
                    if (entry.getKey().equals("hrpi_pereduexpcert") || qFilter == null && !isPreView) continue;
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entry.getKey());
                    String orderBys = this.getOrderBys(entry.getKey());
                    Object limitParam = formShowParameter.getCustomParams().get("LimitParam");
                    DynamicObject[] dataArray = limitParam == null ? serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter}, orderBys) : serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter}, orderBys, Integer.parseInt(limitParam.toString()));
                    this.handleDataResult(isPreView, tabList, dataList, entry, dataArray);
                    break;
                }
            }
            groupDataList.add(dataList);
        }
    }

    private void handleDataResult(boolean isPreView, Map<String, Object> tabList, List<Map<String, String>> dataList, Map.Entry<String, List<Map<String, Object>>> entry, DynamicObject[] dataArray) {
        if (dataArray != null && dataArray.length > 0) {
            String groupName = (String)tabList.get("groupname");
            String targetKey = (String)tabList.get("targetkey");
            Map<String, Map> fieldMap = entry.getValue().stream().collect(Collectors.toMap(val -> val.get("number").toString(), val -> val));
            Set<String> desensitizeFields = null;
            List<String> dataCache = null;
            Map<String, List<String>> desensitizeCache = HspmDesensitizeHelper.getDesensitizeCache(this.getView());
            if (desensitizeCache != null) {
                dataCache = desensitizeCache.get(targetKey);
            }
            for (DynamicObject dynamicObject : dataArray) {
                boolean isDesensitized;
                String schoolRecord;
                if (this.isAbandonData(groupName, dynamicObject)) continue;
                this.updateCacheDataIfExist(groupName, dynamicObject);
                if ("hrpi_pereduexp".equals(entry.getKey()) && fieldMap.containsKey("schoolrecord") && fieldMap.containsKey("graduateschool") && 1386848073895945216L == dynamicObject.getLong("graduateschool.id") && dynamicObject.getLocaleString("schoolrecord") != null && HRStringUtils.isNotEmpty((String)(schoolRecord = dynamicObject.getLocaleString("schoolrecord").getLocaleValue()))) {
                    dynamicObject.set("graduateschool", (Object)schoolRecord);
                }
                Map dataMap = this.changeToMap(entry.getKey(), fieldMap, dynamicObject, isPreView);
                String key = dynamicObject.getDataEntityType().getName() + dynamicObject.getPkValue();
                boolean bl = isDesensitized = dataCache != null && dataCache.contains(key);
                if (!isDesensitized) {
                    if (desensitizeFields == null) {
                        desensitizeFields = this.getDesensitizeFields(dynamicObject, entry.getValue());
                    }
                    if (desensitizeFields.size() > 0 && dataMap.size() > 0) {
                        String tabName = dynamicObject.getDataEntityType().getName();
                        for (String fieldKey : desensitizeFields) {
                            String fieldName = tabName + "." + fieldKey;
                            String value = (String)dataMap.get(fieldName);
                            if (value == null || value.isEmpty()) continue;
                            Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)((IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)fieldKey)), (String)Lang.get().toString(), (String)"FORM", (DynamicObject)dynamicObject, (Object)value);
                            dataMap.put(fieldName, desensitizeValue != null ? desensitizeValue.toString() : "");
                            dataMap.put("desensitizeop-", "true");
                        }
                    }
                }
                dataList.add(dataMap);
            }
        }
    }

    protected Set<String> getDesensitizeFields(DynamicObject dataDy, List<Map<String, Object>> configFields) {
        HashSet<String> desensitizeFields = new HashSet<String>(4);
        String formId = dataDy.getDataEntityType().getName();
        CardDrawDTO cardDraw = this.getCardDrawDTO();
        for (Map<String, Object> field : configFields) {
            String fldKey = (String)field.get("number");
            if (cardDraw != null && !cardDraw.getAllCardFieldSet().contains(formId + "." + fldKey) || !PrivacyCenterServiceHelper.isDesensitizeField((String)formId, (String)fldKey, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)dataDy)) continue;
            desensitizeFields.add(fldKey);
        }
        return desensitizeFields;
    }

    private boolean isAbandonData(String groupName, DynamicObject dynamicObject) {
        List groupFields;
        if (!"-3".equals(dynamicObject.getString("datastatus"))) {
            return false;
        }
        boolean isAbandonData = true;
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            Long id = dynamicObject.getLong("id");
            String entityName = dynamicObject.getDynamicObjectType().getName();
            for (Map map : groupFields) {
                Object dataIdCache = map.get("dataid");
                Object entityNameCache = map.get("entityName");
                if ("hrpi_pereduexpcert".equals(entityNameCache)) {
                    dataIdCache = BusinessUtils.getEduexpByEduCertId((Long)dataIdCache);
                    entityNameCache = "hrpi_pereduexp";
                }
                if (!Boolean.TRUE.equals(map.get("isnew")) || !id.equals(dataIdCache) || !entityName.equals(entityNameCache)) continue;
                isAbandonData = false;
                break;
            }
        }
        return isAbandonData;
    }

    public String getGroupAuditCacheValue(String groupName) {
        if (HRStringUtils.isEmpty((String)groupName) || this.getView().getParentView() == null) {
            return null;
        }
        Map allCache = this.getView().getParentView().getPageCache().getAll();
        if (CollectionUtils.isEmpty((Map)allCache)) {
            return null;
        }
        return (String)allCache.get(groupName + "-entrycache");
    }

    private void updateCacheDataIfExist(String groupName, DynamicObject dynamicObject) {
        List groupFields;
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            Long id = dynamicObject.getLong("id");
            String entityName = dynamicObject.getDynamicObjectType().getName();
            for (Map map : groupFields) {
                if (Boolean.TRUE.equals(map.get("isdel")) || !id.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                String fieldName = (String)map.get("fieldname");
                Object fieldType = map.get("fieldtype");
                Object newValue = map.get("newvalue");
                if (!HRStringUtils.isNotEmpty((String)fieldName) || fieldType == null || newValue == null) continue;
                ValueConvertHelper.setValue(dynamicObject, fieldName, fieldType.toString(), newValue.toString());
            }
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("addop-")) {
            Button button = new Button();
            button.setKey(args.getKey());
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            button.setOperationKey("do_add");
            args.setControl((Control)button);
        } else if (key.startsWith("viewop-") || key.startsWith("editop-") || key.startsWith("abandonop-") || key.startsWith("delop-")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            if (key.startsWith("delop-")) {
                label.setOperationKey("do_del");
            } else if (key.startsWith("editop-")) {
                label.setOperationKey("do_edit");
            } else if (key.startsWith("abandonop-")) {
                label.setOperationKey("do_abandon");
            }
            args.setControl((Control)label);
        } else if (key.startsWith("desensitizeop-")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            args.setControl((Control)vector);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        LOGGER.info(MessageFormat.format("click_key : {0}", key));
        if (key.startsWith("addop-")) {
            if (CommonUtil.existAuditingEntry(this.getView())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff1a\u5df2\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5ba1\u6279\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"AbstractMobCardEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            this.showDetail(key.replace("addop-", ""), null, OperationStatus.ADDNEW);
        } else if (key.startsWith("viewop-") || key.startsWith("editop-")) {
            OperationStatus status;
            String[] strs = key.split("-");
            if (key.endsWith("hint")) {
                this.showNotPassInfoComfirm(key, strs);
                return;
            }
            if (key.startsWith("editop-")) {
                if (CommonUtil.existAuditingEntry(this.getView())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5ba1\u6279\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AbstractMobileFormDrawEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                    return;
                }
                status = OperationStatus.EDIT;
            } else {
                status = OperationStatus.VIEW;
            }
            if (strs.length >= 3) {
                this.showDetail(this.getGroupName(strs), this.getDataId(strs), status);
            } else if (strs.length == 4) {
                this.showDetail(this.getGroupName0(strs), this.getDataId(strs), status);
            }
        } else if (key.startsWith("delop-")) {
            this.handleDel(key);
        } else if (key.startsWith("abandonop-")) {
            if (!this.checkBeforeAbandon(key)) {
                return;
            }
            this.getView().showConfirm(this.getAbandonTips(key), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
        } else if (key.startsWith("desensitizeop-")) {
            String[] strs = key.split("-");
            String targetKey = (String)this.getMultiViewConfig(this.getView()).get("targetkey");
            Map<String, List<String>> desensitizeCache = HspmDesensitizeHelper.getDesensitizeCacheWithCreate(this.getView());
            List<String> dataCache = HspmDesensitizeHelper.getDataCacheWithCreate(desensitizeCache, targetKey);
            dataCache.add(strs[1] + strs[2]);
            HspmDesensitizeHelper.saveDesensitizeCache(this.getView(), desensitizeCache);
            this.getView().updateView();
            this.getView().sendFormAction(this.getView());
        } else {
            LOGGER.warn(MessageFormat.format("no match:{0}", key));
        }
    }

    private String getGroupName(String[] strs) {
        StringBuilder groupNameSb;
        block4: {
            int len = strs.length;
            groupNameSb = new StringBuilder(strs[1]);
            if (len <= 3) break block4;
            String lastStr = strs[len - 1];
            if (pattern.matcher(lastStr).find()) {
                for (int index = 2; index < strs.length - 2; ++index) {
                    groupNameSb.append('-').append(strs[index]);
                }
            } else {
                for (int index = 2; index < strs.length - 1; ++index) {
                    groupNameSb.append('-').append(strs[index]);
                }
            }
        }
        return groupNameSb.toString();
    }

    private String getDataId(String[] strs) {
        int len = strs.length;
        String lastStr = strs[len - 1];
        if (pattern.matcher(lastStr).find()) {
            return strs[len - 2];
        }
        return strs[len - 1];
    }

    private String getGroupName0(String[] strs) {
        StringBuilder groupNameSb = new StringBuilder(strs[1]);
        return groupNameSb.toString();
    }

    private void showNotPassInfoComfirm(String key, String[] strs) {
        List collection;
        Optional<Map> first;
        Map tableList = this.getMultiViewConfig(this.getView());
        String cacheValue = this.getGroupAuditCacheValue(String.valueOf(tableList.get("groupname")));
        String reason = "";
        if (HRStringUtils.isNotEmpty((String)cacheValue) && (first = (collection = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)).stream().filter(map -> map.get("entityName").equals(strs[1]) && map.get("dataid").toString().equals(strs[2]) && Boolean.TRUE.equals(map.get("status")) && Boolean.TRUE.equals(map.get("isdel"))).findFirst()).isPresent()) {
            reason = HRStringUtils.isNotEmpty((String)String.valueOf(first.get().get("reason"))) ? String.valueOf(first.get().get("reason")) : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u539f\u56e0\u4e3a\uff1a{0}\uff0c\u786e\u8ba4\u540e\u5c06\u4e0d\u518d\u91cd\u590d\u5c55\u793a\u672c\u63d0\u793a\u3002", (String)"AbstractElyCardEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), reason), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
        }
    }

    private String getAbandonTips(String abandonKey) {
        String[] strs = abandonKey.split("-");
        String entityName = strs[1];
        Long dataId = Long.valueOf(strs[2]);
        Map tabList = this.getMultiViewConfig(this.getView());
        String groupName = (String)tabList.get("groupname");
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isEmpty((String)cacheValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
        boolean isNew = false;
        StringBuilder updateFields = new StringBuilder();
        for (Map map : groupFields) {
            boolean matchEduCert = false;
            if ("hrpi_pereduexpcert".equals(map.get("entityName"))) {
                Long dataIdDB = BusinessUtils.getEduexpByEduCertId((Long)map.get("dataid"));
                matchEduCert = dataId.equals(dataIdDB);
            }
            if (!matchEduCert && (!dataId.equals(map.get("dataid")) || !entityName.equals(map.get("entityName")))) continue;
            if (Boolean.TRUE.equals(map.get("isnew"))) {
                isNew = true;
                break;
            }
            if (updateFields.length() > 0) {
                updateFields.append("\u3001");
            }
            updateFields.append(String.format("\"%s\"", map.get("displayname")));
        }
        if (isNew) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u201c\u653e\u5f03\u201d\u540e\uff0c\u8be5\u884c\u6570\u636e\u5c06\u88ab\u5220\u9664\uff0c\u786e\u5b9a\u8981\u653e\u5f03\u65b0\u589e\u5f53\u524d\u6570\u636e\u5417\uff1f", (String)"AbstractElyCardEdit_3", (String)"sdk-hr", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u9009\u62e9\u201c\u653e\u5f03\u201d\u540e\uff0c%s\u5c06\u6062\u590d\u4e3a\u63d0\u4ea4\u5ba1\u6838\u524d\u7684\u751f\u6548\u6570\u636e\uff0c\u786e\u5b9a\u8981\u653e\u5f03\uff1f", (String)"AbstractElyCardEdit_4", (String)"sdk-hr", (Object[])new Object[0]), updateFields.toString());
    }

    protected void showDetail(String groupName, String pkId, OperationStatus status) {
        LOGGER.info(MessageFormat.format("showDetail_param:[{0}],[{1}],[{2}]", groupName, pkId, status));
        Map tabList = this.getMultiViewConfig(this.getView());
        Map<String, Object> group = this.getCurrentGroup(tabList, groupName);
        String dialogPageNumber = ParamAnalysisUtil.getDialogPageNumber(ParamAnalysisUtil.getFields(group));
        LOGGER.info(MessageFormat.format("showDetail_dialogPageNumber:[{0}]", dialogPageNumber));
        if (HRStringUtils.isNotEmpty((String)dialogPageNumber)) {
            if (!this.checkDialogPagePerm(dialogPageNumber, status)) {
                LOGGER.info(MessageFormat.format("no right dialogPageNumber:[{0}]", dialogPageNumber));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId(dialogPageNumber);
            showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
            if (!CollectionUtils.isEmpty(groups) && groups.size() > 1 && !this.isEduPage(tabList)) {
                tabList.put("groups", Collections.singletonList(group));
                showParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString((Object)tabList));
            }
            showParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString((Object)tabList));
            showParameter.setCustomParam("pkid", (Object)pkId);
            showParameter.setHasRight(true);
            showParameter.setStatus(status);
            this.getView().showForm(showParameter);
        } else {
            LOGGER.warn("dialogPageNumber value is invaild");
        }
    }

    private boolean checkDialogPagePerm(String dialogPageNumber, OperationStatus status) {
        String permItemId = null;
        if (OperationStatus.VIEW == status) {
            permItemId = "47150e89000000ac";
        } else if (OperationStatus.ADDNEW == status) {
            permItemId = "47156aff000000ac";
        } else if (OperationStatus.EDIT == status) {
            permItemId = "4715a0df000000ac";
        }
        if (permItemId != null && !CommonUtil.hasPerm(dialogPageNumber, permItemId, "hssc", this.getView())) {
            this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        return true;
    }

    protected void handleDel(String key) {
        DynamicObject bill = this.getInProcessWorkFlowBill();
        if (!HRObjectUtils.isEmpty((Object)bill) && !"G".equals(bill.getString("billstatus"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u4eba\u5458\u6863\u6848\u4fe1\u606f\u53d8\u66f4\u7533\u8bf7\uff0c\u8bf7\u64a4\u9500\u5355\u636e\u6216\u7b49\u5f85\u5ba1\u6279\u7ed3\u675f\u540e\uff0c\u518d\u64cd\u4f5c\u5220\u9664\u3002", (String)"AbstractMobCardEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        if (!this.checkDelPerm()) {
            return;
        }
        String[] delKey = this.getDelKey(key);
        String curEntity = delKey[1];
        String pkStr = delKey[2];
        String tips = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AbstractMobCardEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        if (!ApprovalHelper.noNeedDelAudit(this.getView(), pkStr, curEntity)) {
            tips = ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5305\u542b\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\uff0c\u9700\u9876\u90e8\u64cd\u4f5c\u201c\u63d0\u4ea4\u5ba1\u6838\u201d\uff0c\u7ecf\u5ba1\u6838\u901a\u8fc7\u624d\u53ef\u5220\u9664\u3002", (String)"AbstractElyCardEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
    }

    private boolean existAuditCache(DynamicObject bill, String entityName, Long dataId) {
        Map tabList = this.getMultiViewConfig(this.getView());
        String groupNum = (String)tabList.get("targetkey");
        if (HRStringUtils.isNotEmpty((String)groupNum)) {
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entity) {
                if (!groupNum.equals(dynamicObject.getString("firstgroupnum"))) continue;
                Long dataIdDB = dynamicObject.getLong("dataid");
                String entityNameDB = dynamicObject.getString("entityname");
                if ("hrpi_pereduexpcert".equals(entityNameDB)) {
                    dataIdDB = BusinessUtils.getEduexpByEduCertId(dataIdDB);
                    entityNameDB = "hrpi_pereduexp";
                }
                if (!dataId.equals(dataIdDB) || !entityName.equals(entityNameDB)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDelPerm() {
        String curEntity = this.getView().getEntityId();
        boolean hasPerm = CommonUtil.hasPerm(curEntity, "4715e1f1000000ac", "hssc", this.getView());
        if (!hasPerm) {
            this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        return true;
    }

    public String[] getDelKey(String key) {
        String[] delKey = key.split("-");
        if (delKey.length != 3) {
            LOGGER.error(MessageFormat.format("====delKey_exception==={0}", key));
            throw new KDBizException("delete key is invalid");
        }
        return delKey;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String[] strs;
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.isEmpty((String)key)) {
            return;
        }
        LOGGER.info(MessageFormat.format("confirmCallBack key:{0}", key));
        if (key.startsWith("delop-")) {
            List dataIds;
            String[] delKey = this.getDelKey(key);
            String curEntity = delKey[1];
            String pkStr = delKey[2];
            String dataIdsStr = this.getView().getPageCache().get("data_ids");
            if (HRStringUtils.isNotEmpty((String)dataIdsStr) && !CollectionUtils.isEmpty((Collection)(dataIds = SerializationUtils.fromJsonStringToList((String)dataIdsStr, String.class))) && !dataIds.contains(pkStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u6cd5\u5220\u9664", (String)"AbstractMobCardEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkDelPerm()) {
                return;
            }
            Tuple<Boolean, Boolean> tuple = this.delData(curEntity, Long.parseLong(pkStr));
            if (((Boolean)tuple.item1).booleanValue() && ((Boolean)tuple.item2).booleanValue()) {
                this.getView().updateView();
                this.getView().sendFormAction(this.getView());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AbstractMobCardEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            } else if (!((Boolean)tuple.item1).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"AbstractMobCardEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
        } else if (key.startsWith("abandonop-")) {
            String[] strs2 = key.split("-");
            if (this.abandon(strs2[1], Long.valueOf(strs2[2]))) {
                this.getView().updateView();
                this.getView().sendFormAction(this.getView());
            }
        } else if (key.startsWith("viewop-") && key.endsWith("hint") && this.abandon(this.getGroupName(strs = key.split("-")), Long.valueOf(strs[strs.length - 1]))) {
            this.getView().updateView();
            this.getView().sendFormAction(this.getView());
        }
    }

    protected boolean abandon(String entityName, Long dataId) {
        DynamicObject bill;
        Map tabList = this.getMultiViewConfig(this.getView());
        String groupName = (String)tabList.get("groupname");
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isEmpty((String)cacheValue) || (bill = this.getInProcessWorkFlowBill()) == null || !"G".equals(bill.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean exist = false;
        List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
        if (!CollectionUtils.isEmpty((Collection)groupFields)) {
            Iterator iterator = groupFields.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                boolean matchEduCert = false;
                if ("hrpi_pereduexpcert".equals(map.get("entityName"))) {
                    Long dataIdDB = BusinessUtils.getEduexpByEduCertId((Long)map.get("dataid"));
                    matchEduCert = dataId.equals(dataIdDB);
                }
                if (!matchEduCert && (!dataId.equals(map.get("dataid")) || !entityName.equals(map.get("entityName")))) continue;
                iterator.remove();
                if (exist) continue;
                exist = true;
            }
        }
        if (!exist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getView().getParentView() != null) {
            if (CollectionUtils.isEmpty((Collection)groupFields) && ApprovalHelper.getAuditFieldMap(this.getView().getParentView()).size() <= 1) {
                boolean fail = false;
                try {
                    OperationResult operationResult = new OperationServiceImpl().localInvokeOperation("discard", new DynamicObject[]{bill}, OperateOption.create());
                    if (operationResult == null || !operationResult.isSuccess()) {
                        LOGGER.error("discard operationResult:", (Object)operationResult);
                        fail = true;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("discard ex:", (Throwable)exception);
                    fail = true;
                }
                if (fail) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u653e\u5f03\u5355\u636e\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                bill.set("billstatus", (Object)"F");
                INFOAPPROVAL_HELPER.updateOne(bill);
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().getPageCache().remove("submitVerson");
                }
            }
            if (CollectionUtils.isEmpty((Collection)groupFields)) {
                this.getView().getParentView().getPageCache().batchRemove(Collections.singletonList(groupName + "-entrycache"));
            } else {
                this.getView().getParentView().getPageCache().put(groupName + "-entrycache", SerializationUtils.toJsonString((Object)groupFields));
            }
            ApprovalHelper.updateSyncCacheToDataBase(this.getView());
        }
        return true;
    }

    private Tuple<Boolean, Boolean> delData(String entityName, Long pk) {
        HRBaseServiceHelper serviceHelper;
        AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(entityName);
        DynamicObject dyArr = null;
        if ((PersonModelClassificationEnum.PERATTACHED == classification || "hrpi_empjobrel".equals(entityName)) && (dyArr = (serviceHelper = new HRBaseServiceHelper(entityName)).loadSingle((Object)pk)) == null) {
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        }
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
        HashMap<Long, Long> pkPersonIdMap = new HashMap<Long, Long>(16);
        pkPersonIdMap.put(pk, personId);
        List<Long> personIds = AttacheHandlerService.getInstance().validateSyncFieldsDelChange(entityName, pkPersonIdMap);
        Map tabList = this.getMultiViewConfig(this.getView());
        if (ApprovalHelper.dealAuditBeforeDel(this.getView(), entityName, pk, dyArr, tabList)) {
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.FALSE);
        }
        Map<String, Object> resultMap = attacheHandlerService.invokeDel(Collections.singletonList(pk), entityName, Boolean.TRUE);
        if (AttacheHandlerService.isSuccess(resultMap)) {
            List<Long> eudCertIds;
            if ("hrpi_pereduexp".equals(entityName) && !CollectionUtils.isEmpty(eudCertIds = BusinessUtils.getEduCertIdByEduId(pk))) {
                attacheHandlerService.invokeDel(eudCertIds, "hrpi_pereduexpcert", Boolean.TRUE);
                for (Long eudCertId : eudCertIds) {
                    this.handleApprovalDataAfterDelete("hrpi_pereduexpcert", eudCertId);
                }
            }
            if (personIds != null && personIds.size() > 0) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(personIds);
            }
            if (dyArr != null) {
                String realFormId = AttacheHandlerService.getInstance().getRealFormId(this.getView(), "pagenumber", false);
                AttacheHandlerService.getInstance().sendHpfsChgDeleteRecord(new DynamicObject[]{dyArr}, entityName, realFormId);
            }
            this.handleApprovalDataAfterDelete(entityName, pk);
            attacheHandlerService.removeAllAttachment(entityName, pk);
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        }
        return Tuple.create((Object)Boolean.FALSE, (Object)Boolean.FALSE);
    }

    private void handleApprovalDataAfterDelete(String entityName, Long id) {
        DynamicObject bill = this.getInProcessWorkFlowBill();
        if (bill != null && "G".equals(bill.getString("billstatus")) && this.existAuditCache(bill, entityName, id)) {
            this.abandon(entityName, id);
        } else {
            this.deleteApprovalCache(entityName, id);
        }
    }

    private void deleteApprovalCache(String entityName, Long id) {
        if (this.getView().getParentView() == null) {
            return;
        }
        Map tabList = this.getMultiViewConfig(this.getView());
        if (tabList != null && tabList.get("groupname") != null) {
            String groupName = (String)tabList.get("groupname");
            Map allCache = this.getView().getParentView().getPageCache().getAll();
            if (!CollectionUtils.isEmpty((Map)allCache)) {
                String cacheKey = groupName + "-entrycache";
                String cacheValue = (String)allCache.get(cacheKey);
                if (HRStringUtils.isEmpty((String)cacheValue)) {
                    return;
                }
                List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                if (!CollectionUtils.isEmpty((Collection)groupFields)) {
                    boolean update = false;
                    Iterator it = groupFields.iterator();
                    while (it.hasNext()) {
                        Map map = (Map)it.next();
                        if (!id.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                        it.remove();
                        if (update) continue;
                        update = true;
                    }
                    if (update) {
                        if (CollectionUtils.isEmpty((Collection)groupFields)) {
                            this.getView().getParentView().getPageCache().batchRemove(Collections.singletonList(cacheKey));
                        } else {
                            this.getView().getParentView().getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)groupFields));
                        }
                    }
                    ApprovalHelper.updateSyncCacheToDataBase(this.getView());
                }
            }
        }
    }

    protected Map<String, Object> getCurrentGroup(Map<String, Object> tabList, String groupName) {
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        if (!CollectionUtils.isEmpty(groups)) {
            for (Map<String, Object> group : groups) {
                Object gname = group.get("gname");
                LOGGER.info(MessageFormat.format("find currentGroup:gname:[{0}]", gname));
                if (gname == null || !groupName.equalsIgnoreCase(gname.toString())) continue;
                return group;
            }
        }
        return null;
    }

    protected Map<String, Map<String, Object>> changeToFieldMap(Map<String, Object> group) {
        List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
        if (!CollectionUtils.isEmpty(fields)) {
            return fields.stream().collect(Collectors.toMap(val -> CardDrawElyMobHelper.getFullFieldName(val), val -> val));
        }
        return new HashMap<String, Map<String, Object>>(0);
    }

    protected void changeLabelStyle(LabelAp labelAp) {
    }

    protected void changeLabelStyle(FlexPanelAp flexPanelAp) {
        for (ControlAp controlAp : flexPanelAp.getItems()) {
            if (!(controlAp instanceof LabelAp)) continue;
            this.changeLabelStyle((LabelAp)controlAp);
        }
    }

    protected static String getViewOpKey(String groupName, String dataId, String ... elements) {
        StringBuilder builder = new StringBuilder("viewop-");
        builder.append(groupName);
        builder.append("-").append(dataId);
        if (elements != null && elements.length > 0) {
            for (String element : elements) {
                builder.append("-").append(element);
            }
        }
        return builder.toString();
    }

    protected static String getEditOpKey(String groupName, String dataId) {
        StringBuilder builder = new StringBuilder("editop-");
        builder.append(groupName);
        builder.append("-").append(dataId);
        return builder.toString();
    }

    protected static String getAbandonOpKey(String entityName, String dataId) {
        StringBuilder builder = new StringBuilder("abandonop-");
        builder.append(entityName);
        builder.append("-").append(dataId);
        return builder.toString();
    }

    protected DynamicObject getInProcessWorkFlowBill() {
        Object bill = INPROCESS_BILL_TL.get();
        if (bill instanceof String) {
            return null;
        }
        if (bill instanceof DynamicObject) {
            return (DynamicObject)bill;
        }
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParams().get("person");
        DynamicObject dynamicObject = ApprovalHelper.getInProcessWorkFlowBill(personId);
        INPROCESS_BILL_TL.set(dynamicObject != null ? dynamicObject : "");
        return dynamicObject;
    }

    protected boolean hasAbandonButton(String entityName, Long dataId) {
        List groupFields;
        Map tabList = this.getMultiViewConfig(this.getView());
        String groupName = (String)tabList.get("groupname");
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            boolean isWaitreSubmit;
            DynamicObject bill = this.getInProcessWorkFlowBill();
            boolean bl = isWaitreSubmit = bill != null && "G".equals(bill.getString("billstatus"));
            if (!isWaitreSubmit) {
                return false;
            }
            boolean update = false;
            boolean existWaitreSubmit = false;
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            String firstGroupNum = (String)tabList.get("targetkey");
            Map<String, DynamicObject> entityMap = entity.stream().filter(val -> firstGroupNum.equals(val.getString("firstgroupnum"))).collect(Collectors.toMap(val -> ApprovalHelper.getFullKey(val), val -> val));
            if (!CollectionUtils.isEmpty(entityMap)) {
                for (Map map : groupFields) {
                    StringBuilder fullKey;
                    DynamicObject dynamicObject;
                    Object dataIdCache = map.get("dataid");
                    Object entityNameCache = map.get("entityName");
                    if ("hrpi_pereduexpcert".equals(entityNameCache)) {
                        dataIdCache = BusinessUtils.getEduexpByEduCertId((Long)dataIdCache);
                        entityNameCache = "hrpi_pereduexp";
                    }
                    if (!dataId.equals(dataIdCache) || !entityName.equals(entityNameCache) || (dynamicObject = entityMap.get((fullKey = new StringBuilder(firstGroupNum).append(map.get("entityName")).append(map.get("fieldname")).append(map.get("dataid"))).toString())) == null || map.get("isNewModify") != null) continue;
                    Boolean status = dynamicObject.getBoolean("status");
                    if (!status.equals(map.get("status"))) {
                        String reason = dynamicObject.getString("reason");
                        map.put("status", status);
                        map.put("reason", reason);
                        if (!update) {
                            update = true;
                        }
                    }
                    if (!status.booleanValue() || existWaitreSubmit) continue;
                    existWaitreSubmit = true;
                }
            }
            if (update) {
                this.getView().getParentView().getPageCache().put(groupName + "-entrycache", SerializationUtils.toJsonString((Object)groupFields));
            }
            return existWaitreSubmit;
        }
        return false;
    }

    protected boolean checkBeforeAbandon(String abandonKey) {
        String[] strs;
        if (HRStringUtils.isNotEmpty((String)abandonKey) && (strs = abandonKey.split("-")).length >= 3) {
            boolean hasAbandonButton = this.hasAbandonButton(strs[1], Long.valueOf(strs[2]));
            if (!hasAbandonButton) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
            return hasAbandonButton;
        }
        return false;
    }

    protected String getValueFromData(Map<String, String> data, String key) {
        String value = data.get(key);
        if (HRStringUtils.isEmpty((String)value)) {
            return "-";
        }
        return value;
    }

    protected CardDrawDTO adjuestCardDrawFields(CardDrawDTO cardDraw, Map<String, String> data) {
        return cardDraw;
    }

    protected FlexPanelAp createNoDataPanel(boolean isOnlyOneGroup) {
        HRFlexPanelAp.Builder builder = new HRFlexPanelAp.Builder("notdataflex").setGrow(1).setShrink(1).setWrap(false).setWidth("100%").setHeight("100%").setDirection("column").setJustifyContent("center").setAlignItems("center");
        if (isOnlyOneGroup) {
            builder.setPaddingTop("10%");
        }
        FlexPanelAp notData = builder.build();
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("imageap");
        imageAp.setImageKey("images/pc/emotion/fxjd_no_data.png");
        LabelAp textLbl = new LabelAp();
        textLbl.setKey("textlblap");
        textLbl.setName(new LocaleString(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"AbstractElyCardEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        textLbl.setFontSize(14);
        textLbl.setForeColor("#666");
        textLbl.setTextAlign("center");
        notData.getItems().add(imageAp);
        notData.getItems().add(textLbl);
        return notData;
    }

    protected boolean isEduPage(Map<String, Object> tabList) {
        String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabList);
        return "hrpi_pereduexp".equals(mappingFormId) || "hrpi_pereduexpcert".equals(mappingFormId);
    }
}

