/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.annotation.SdkPlugin;
import kd.sdk.hr.hspm.business.helper.FieldPermHelper;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

@SdkPlugin(name="\u4eba\u5458\u6863\u6848\u5206\u5f55\u6837\u5f0f\u7236\u7c7b")
public class AbstractEntryEntityDrawEdit
extends HRDataBaseEdit {
    public static final String GROUP_CONTANIER_SUFFIX = "_flex";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.handleByConfig();
    }

    private void handleByConfig() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String tabInfo = (String)formShowParameter.getCustomParam("params");
        if (HRStringUtils.isEmpty((String)tabInfo)) {
            return;
        }
        Map<String, Object> tabList = (Map<String, Object>)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList = FieldPermHelper.adjustConfigParamByFieldRules(tabList, null));
        if (CollectionUtils.isEmpty(groups)) {
            return;
        }
        Set<String> allEntryEntity = this.getAllEntryEntity();
        for (Map<String, Object> group : groups) {
            this.handleEntity(group, allEntryEntity);
        }
        if (!CollectionUtils.isEmpty(allEntryEntity)) {
            for (String entityName : allEntryEntity) {
                this.getView().setVisible(Boolean.FALSE, new String[]{entityName + GROUP_CONTANIER_SUFFIX});
            }
        }
    }

    private void handleEntity(Map<String, Object> group, Set<String> allEntryEntity) {
        List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
        if (!CollectionUtils.isEmpty(fields)) {
            String pName = (String)fields.get(0).get("pnumber");
            String entityName = this.getEntryEntityAlias(pName);
            if (this.getControl(entityName) == null) {
                return;
            }
            allEntryEntity.remove(entityName);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entityName);
            DataEntityPropertyCollection entityProperty = dynamicObjects.getDynamicObjectType().getProperties();
            boolean hide = true;
            ArrayList<String> showField = new ArrayList<String>(fields.size());
            ArrayList<String> lockFields = new ArrayList<String>(fields.size());
            EntryGrid entryGrid = (EntryGrid)this.getControl(entityName);
            for (Map<String, Object> field : fields) {
                String fieldName = this.getFieldAlias(entityName, (String)field.get("number"));
                showField.add(fieldName);
                if (!Boolean.TRUE.equals(field.get("isedit"))) {
                    lockFields.add(fieldName);
                }
                if (Boolean.TRUE.equals(field.get("isrequired"))) {
                    entryGrid.setMustInput(fieldName, true);
                }
                if (!hide || !entityProperty.containsKey((Object)fieldName)) continue;
                hide = false;
            }
            if (hide) {
                this.getView().setVisible(Boolean.FALSE, new String[]{entityName + GROUP_CONTANIER_SUFFIX});
            } else {
                List<String> hideFields;
                if (lockFields.size() > 0) {
                    for (int index = 0; index < entryGrid.getEntryData().getDataEntitys().length; ++index) {
                        this.getView().setEnable(Boolean.FALSE, index, lockFields.toArray(new String[lockFields.size()]));
                    }
                }
                if ((hideFields = entityProperty.stream().map(val -> val.getName()).filter(val -> !showField.contains(val)).collect(Collectors.toList())).size() > 0) {
                    this.getView().setVisible(Boolean.FALSE, hideFields.toArray(new String[hideFields.size()]));
                }
            }
        }
    }

    protected String getEntryEntityAlias(String entityName) {
        return entityName;
    }

    protected String getFieldAlias(String entityName, String fieldName) {
        return fieldName;
    }

    protected Set<String> getAllEntryEntity() {
        return new HashSet<String>(0);
    }
}

