/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.ext.hr.metadata.field.HisModelBasedataField;
import kd.bos.ext.hr.metadata.field.QueryField;
import kd.bos.ext.metadata.entity.businessfield.I18nNameField;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkService;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.CustomDrawUtils;

@SdkService(name="\u521b\u5efa\u5b57\u6bb5ControlAp\u670d\u52a1")
public class ApControlService {
    private static final Set<String> ZERO_NOT_SHOW = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"period", "classhour", "trainlength", "score", "cost", "projectlenth"}));

    public Field createField(DrawFormFieldDto drawFormField) {
        CustomDrawUtils customDrawUtils = CustomDrawUtils.getInstance();
        Field customDrawField = customDrawUtils.customDrawField(drawFormField);
        if (customDrawField != null) {
            return customDrawField;
        }
        switch (drawFormField.getClassSimpleName()) {
            case "BasedataProp": 
            case "CurrencyProp": {
                return this.customBaseDataControlAp(drawFormField);
            }
            case "CityProp": {
                return this.customCityFieldAp(drawFormField);
            }
            case "QueryProp": {
                return this.queryField(drawFormField);
            }
            case "MulBasedataProp": {
                return this.customMulitBaseDataControlAp(drawFormField);
            }
            case "TextProp": 
            case "TextAreaProp": {
                return this.customTextControlAp(drawFormField);
            }
            case "AddressProp": {
                return this.customAddressControlAp(drawFormField);
            }
            case "I18nNameProp": {
                return this.customNameControlAp(drawFormField);
            }
            case "LongProp": 
            case "BigIntProp": {
                return this.customBigIntControlAp(drawFormField);
            }
            case "DecimalProp": {
                return this.customDecimalControlAp(drawFormField);
            }
            case "AmountProp": {
                return this.customAmountControlAp(drawFormField);
            }
            case "DateProp": {
                return this.customDateControlAp(drawFormField);
            }
            case "BooleanProp": {
                return this.customCheckBoxControlAp(drawFormField);
            }
            case "ComboProp": {
                return this.customComboControlAp(drawFormField);
            }
            case "IntegerProp": {
                return this.customIntegerControlAp(drawFormField);
            }
            case "MuliLangTextProp": {
                return this.customMulilangTextControlAp(drawFormField);
            }
            case "AdminDivisionProp": {
                return this.customAdminDivisionControlAp(drawFormField);
            }
            case "PictureProp": {
                return this.customPicControlAp(drawFormField);
            }
            case "AttachmentProp": {
                return this.customAttachmentControlAp(drawFormField);
            }
            case "OrgProp": 
            case "MainOrgProp": {
                return this.customOrgControlAp(drawFormField);
            }
            case "HisModelBasedataProp": {
                return this.customHisModelBaseDataControlAp(drawFormField);
            }
        }
        return null;
    }

    private Field customHisModelBaseDataControlAp(DrawFormFieldDto drawFormField) {
        HisModelBasedataField basedataField = new HisModelBasedataField();
        basedataField.setBaseEntityId(drawFormField.getBaseEntityId());
        basedataField.setName(new LocaleString(drawFormField.getName()));
        basedataField.setKey(drawFormField.getField());
        basedataField.setId(drawFormField.getField());
        basedataField.setDisplayStyle(drawFormField.getDisplayStyle());
        basedataField.setDisplayProp("name");
        basedataField.setEditSearchProp("number");
        basedataField.setMustInput(drawFormField.isMustInput());
        basedataField.setViewDetail(false);
        if (drawFormField.hasEmptyText()) {
            basedataField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"ApControlService_1", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return basedataField;
    }

    private Field customAmountControlAp(DrawFormFieldDto drawFormField) {
        AmountField amountField = new AmountField();
        amountField.setMustInput(drawFormField.isMustInput());
        String field = drawFormField.getField();
        String origPageId = drawFormField.getOrigPageId();
        String relId = drawFormField.getBaseEntityId();
        if (field.contains("-")) {
            relId = origPageId + "-" + relId;
        }
        amountField.setId(field);
        amountField.setCurrencyFieldId(relId);
        amountField.setKey(field);
        amountField.setPrecision(drawFormField.getPrecision());
        amountField.setScale(drawFormField.getScale());
        String id = MetadataDao.getIdByNumber((String)origPageId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        amountField.setEntityMetadata(entityMetadata);
        if (!ZERO_NOT_SHOW.contains(field)) {
            amountField.setZeroShow(true);
        }
        if (drawFormField.hasEmptyText()) {
            amountField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return amountField;
    }

    public Field createMobileField(DrawFormFieldDto drawFormField) {
        switch (drawFormField.getClassSimpleName()) {
            case "BasedataProp": 
            case "CurrencyProp": {
                return this.customBaseDataControlAp(drawFormField);
            }
            case "CityProp": {
                return this.customCityFieldAp(drawFormField);
            }
            case "QueryProp": {
                return this.queryField(drawFormField);
            }
            case "MulBasedataProp": {
                return this.customMulitBaseDataControlAp(drawFormField);
            }
            case "TextProp": {
                return this.customTextControlAp(drawFormField);
            }
            case "AddressProp": {
                return this.customAddressControlAp(drawFormField);
            }
            case "I18nNameProp": {
                return this.customNameControlAp(drawFormField);
            }
            case "LongProp": 
            case "BigIntProp": {
                return this.customBigIntControlAp(drawFormField);
            }
            case "DecimalProp": {
                return this.customDecimalControlAp(drawFormField);
            }
            case "AmountProp": {
                return this.customAmountControlAp(drawFormField);
            }
            case "DateProp": {
                return this.customDateControlAp(drawFormField);
            }
            case "BooleanProp": {
                return this.customCheckBoxControlAp(drawFormField);
            }
            case "ComboProp": {
                return this.customComboControlAp(drawFormField);
            }
            case "IntegerProp": {
                return this.customIntegerControlAp(drawFormField);
            }
            case "TextAreaProp": 
            case "MuliLangTextProp": {
                if (drawFormField.getField().contains("description")) {
                    return this.customMultiTextControlAp(drawFormField);
                }
                return this.customTextControlAp(drawFormField);
            }
            case "AdminDivisionProp": {
                return this.customAdminDivisionControlAp(drawFormField);
            }
            case "PictureProp": {
                return this.customPicControlAp(drawFormField);
            }
            case "AttachmentProp": {
                return this.customAttachmentControlAp(drawFormField);
            }
            case "OrgProp": 
            case "MainOrgProp": {
                return this.customOrgControlAp(drawFormField);
            }
            case "HisModelBasedataProp": {
                return this.customHisModelBaseDataControlAp(drawFormField);
            }
        }
        return null;
    }

    private Field customCityFieldAp(DrawFormFieldDto drawFormField) {
        String apKey = drawFormField.getField();
        CityField cityField = new CityField();
        cityField.setId(apKey);
        cityField.setKey(apKey);
        cityField.setDisplayProp("name");
        cityField.setEditSearchProp("name");
        cityField.setMustInput(drawFormField.isMustInput());
        cityField.setViewDetail(false);
        return cityField;
    }

    private Field customAddressControlAp(DrawFormFieldDto drawFormField) {
        AddressField addressField = new AddressField();
        addressField.setKey(drawFormField.getField());
        addressField.setMustInput(drawFormField.isMustInput());
        addressField.setName(new LocaleString(drawFormField.getName()));
        if (drawFormField.hasEmptyText()) {
            addressField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return addressField;
    }

    private Field customNameControlAp(DrawFormFieldDto drawFormField) {
        I18nNameField nameField = new I18nNameField();
        nameField.setKey(drawFormField.getField());
        nameField.setMustInput(drawFormField.isMustInput());
        nameField.setName(new LocaleString(drawFormField.getName()));
        nameField.setEntityMetadata(new EntityMetadata());
        nameField.setSimpleModeId(true);
        if (drawFormField.hasEmptyText()) {
            nameField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return nameField;
    }

    private Field queryField(DrawFormFieldDto drawFormField) {
        QueryField basedataField = new QueryField();
        basedataField.setName(new LocaleString(drawFormField.getName()));
        basedataField.setBaseEntityNumber(drawFormField.getBaseEntityId());
        String entityId = MetadataDao.getIdByNumber((String)drawFormField.getBaseEntityId(), (MetaCategory)MetaCategory.Form);
        basedataField.setBaseEntityId(entityId);
        basedataField.setKey(drawFormField.getField());
        basedataField.setId(drawFormField.getField());
        basedataField.setDisplayStyle(drawFormField.getDisplayStyle());
        basedataField.setDisplayProp("name");
        basedataField.setEditSearchProp("name");
        basedataField.setMustInput(drawFormField.isMustInput());
        basedataField.setViewDetail(false);
        if (drawFormField.hasEmptyText()) {
            basedataField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return basedataField;
    }

    private Field customBaseDataControlAp(DrawFormFieldDto drawFormField) {
        BasedataField basedataField = new BasedataField();
        basedataField.setName(new LocaleString(drawFormField.getName()));
        basedataField.setBaseEntityId(drawFormField.getBaseEntityId());
        basedataField.setId(drawFormField.getField());
        basedataField.setKey(drawFormField.getField());
        basedataField.setDisplayStyle(drawFormField.getDisplayStyle());
        basedataField.setDisplayProp("name");
        basedataField.setEditSearchProp("number");
        basedataField.setMustInput(drawFormField.isMustInput());
        basedataField.setViewDetail(false);
        if (drawFormField.hasEmptyText()) {
            basedataField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"ApControlService_1", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return basedataField;
    }

    private Field customMulitBaseDataControlAp(DrawFormFieldDto drawFormField) {
        MulBasedataField basedataField = new MulBasedataField();
        basedataField.setBaseEntityId(drawFormField.getBaseEntityId());
        basedataField.setId(drawFormField.getField());
        basedataField.setKey(drawFormField.getField());
        basedataField.setAllowAutoList(true);
        basedataField.setFieldName(drawFormField.getField());
        basedataField.setCacheLookUpList(true);
        basedataField.setLableHyperlink(false);
        basedataField.setMustInput(drawFormField.isMustInput());
        basedataField.setAllowAutoList(true);
        basedataField.setEntityMetadata(new EntityMetadata());
        basedataField.setOrgFuncs(drawFormField.getField());
        if (drawFormField.hasEmptyText()) {
            basedataField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"ApControlService_1", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return basedataField;
    }

    private Field customTextControlAp(DrawFormFieldDto drawFormField) {
        Field fieldObject = null;
        if ("TextProp".equals(drawFormField.getClassSimpleName())) {
            fieldObject = PropertyHelper.getField(drawFormField);
        }
        String field = drawFormField.getField();
        if (fieldObject instanceof TelephoneField) {
            TelephoneField telephoneField = new TelephoneField();
            telephoneField.setKey(drawFormField.getField());
            telephoneField.setMustInput(drawFormField.isMustInput());
            telephoneField.setValidateRule(true);
            telephoneField.setName(new LocaleString(drawFormField.getName()));
            if (drawFormField.hasEmptyText()) {
                telephoneField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
            }
            return telephoneField;
        }
        if (fieldObject instanceof EmailField || "hrpi_percontact-peremail".equals(field) || "hrpi_percontact-busemail".equals(field)) {
            EmailField emailField = new EmailField();
            emailField.setMustInput(drawFormField.isMustInput());
            emailField.setName(new LocaleString(drawFormField.getName()));
            emailField.setKey(drawFormField.getField());
            if (drawFormField.hasEmptyText()) {
                emailField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
            }
            return emailField;
        }
        TextField textField = new TextField();
        textField.setKey(drawFormField.getField());
        textField.setMustInput(drawFormField.isMustInput());
        textField.setName(new LocaleString(drawFormField.getName()));
        if (HRStringUtils.isNotEmpty((String)drawFormField.getMaxSize())) {
            textField.setMaxLength(Integer.parseInt(drawFormField.getMaxSize()));
        }
        if (HRStringUtils.isNotEmpty((String)drawFormField.getMinSize())) {
            textField.setMinLength(Integer.parseInt(drawFormField.getMinSize()));
        }
        if (drawFormField.hasEmptyText()) {
            textField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return textField;
    }

    private Field customMultiTextControlAp(DrawFormFieldDto drawFormField) {
        String field = drawFormField.getField();
        TextAreaField textAreaField = new TextAreaField();
        textAreaField.setKey(drawFormField.getField());
        textAreaField.setMustInput(drawFormField.isMustInput());
        textAreaField.setName(new LocaleString(drawFormField.getName()));
        if (drawFormField.hasEmptyText()) {
            textAreaField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return textAreaField;
    }

    private Field customBigIntControlAp(DrawFormFieldDto drawFormField) {
        BigIntField bigIntField = new BigIntField();
        String field = drawFormField.getField();
        bigIntField.setKey(field);
        if (!ZERO_NOT_SHOW.contains(field)) {
            bigIntField.setZeroShow(true);
        }
        bigIntField.setMustInput(drawFormField.isMustInput());
        if (drawFormField.hasEmptyText()) {
            bigIntField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return bigIntField;
    }

    private Field customDecimalControlAp(DrawFormFieldDto drawFormField) {
        DecimalField decimalField = new DecimalField();
        String field = drawFormField.getField();
        decimalField.setKey(field);
        decimalField.setMustInput(drawFormField.isMustInput());
        decimalField.setPrecision(drawFormField.getPrecision());
        decimalField.setScale(drawFormField.getScale());
        if (!ZERO_NOT_SHOW.contains(field)) {
            decimalField.setZeroShow(true);
        }
        if (drawFormField.getField().contains("entservicelen")) {
            decimalField.setDataScope("[0,]");
        }
        if (drawFormField.getField().contains("servicelen")) {
            decimalField.setDataScope("[0,]");
        }
        if (drawFormField.getField().contains("adjustcomtime") || drawFormField.getField().contains("adjustworktime")) {
            decimalField.setDataScope("[-50,50]");
            decimalField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165[-50\uff0c50]\u7684\u6570\u503c\u3002", (String)"ApControlService_3", (String)"sdk-hr", (Object[])new Object[0])));
        }
        if (drawFormField.hasEmptyText()) {
            decimalField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return decimalField;
    }

    private Field customDateControlAp(DrawFormFieldDto drawFormField) {
        DateField dateField = new DateField();
        dateField.setKey(drawFormField.getField());
        dateField.setMustInput(drawFormField.isMustInput());
        dateField.setId(drawFormField.getField());
        if (drawFormField.getField().contains("beginservicedate")) {
            dateField.setMaxDate(HRDateTimeUtils.format((Date)HspmDateUtils.addDay((Date)new Date(), (long)-1L)));
        }
        if (drawFormField.hasEmptyText()) {
            dateField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return dateField;
    }

    private Field customCheckBoxControlAp(DrawFormFieldDto drawFormField) {
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setKey(drawFormField.getField());
        checkBoxField.setShowStyle(0);
        checkBoxField.setMustInput(drawFormField.isMustInput());
        return checkBoxField;
    }

    private Field customComboControlAp(DrawFormFieldDto drawFormField) {
        ComboField comboField = new ComboField();
        comboField.setKey(drawFormField.getField());
        comboField.setItems(drawFormField.getComboItemList());
        comboField.setMustInput(drawFormField.isMustInput());
        if (drawFormField.hasEmptyText()) {
            comboField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"ApControlService_1", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return comboField;
    }

    private Field customIntegerControlAp(DrawFormFieldDto drawFormField) {
        IntegerField integerField = new IntegerField();
        String field = drawFormField.getField();
        integerField.setKey(field);
        integerField.setMustInput(drawFormField.isMustInput());
        if (!ZERO_NOT_SHOW.contains(field)) {
            integerField.setZeroShow(true);
        }
        integerField.setName(new LocaleString(drawFormField.getName()));
        if (drawFormField.hasEmptyText()) {
            integerField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return integerField;
    }

    private Field customMulilangTextControlAp(DrawFormFieldDto drawFormField) {
        MuliLangTextField muliLangTextField = new MuliLangTextField();
        muliLangTextField.setKey(drawFormField.getField());
        muliLangTextField.setDefValue("");
        muliLangTextField.setMutiLine(false);
        muliLangTextField.setMustInput(drawFormField.isMustInput());
        String maxSize = drawFormField.getMaxSize();
        if (HRStringUtils.isNotEmpty((String)maxSize)) {
            muliLangTextField.setMaxLength(Integer.parseInt(maxSize));
        }
        if (drawFormField.hasEmptyText()) {
            muliLangTextField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        if (CommonUtil.fullLineField().contains(drawFormField.getField())) {
            muliLangTextField.setMutiLine(true);
        }
        return muliLangTextField;
    }

    private Field customAdminDivisionControlAp(DrawFormFieldDto drawFormField) {
        AdminDivisionField adminDivisionField = new AdminDivisionField();
        adminDivisionField.setKey(drawFormField.getField());
        adminDivisionField.setMustInput(drawFormField.isMustInput());
        if (drawFormField.hasEmptyText()) {
            adminDivisionField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ApControlService_0", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return adminDivisionField;
    }

    private Field customPicControlAp(DrawFormFieldDto drawFormField) {
        PictureField pictureField = new PictureField();
        pictureField.setKey(drawFormField.getField());
        pictureField.setMustInput(drawFormField.isMustInput());
        pictureField.setName(new LocaleString(drawFormField.getName()));
        return pictureField;
    }

    private Field customAttachmentControlAp(DrawFormFieldDto drawFormField) {
        AttachmentField attachmentField = new AttachmentField();
        attachmentField.setKey(drawFormField.getField());
        attachmentField.setMustInput(drawFormField.isMustInput());
        attachmentField.setName(new LocaleString(drawFormField.getName()));
        attachmentField.setEntityMetadata(new EntityMetadata());
        return attachmentField;
    }

    private Field customOrgControlAp(DrawFormFieldDto drawFormField) {
        OrgField orgField = new OrgField();
        orgField.setKey(drawFormField.getField());
        String id = MetadataDao.getIdByNumber((String)"hspm_ermanfile", (MetaCategory)MetaCategory.Entity);
        orgField.setBaseEntityId("bos_org");
        orgField.setId(drawFormField.getField());
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        orgField.setEntityMetadata(entityMetadata);
        orgField.setMustInput(drawFormField.isMustInput());
        OrgViewSchemeProp orgViewSchemeProp = new OrgViewSchemeProp();
        orgField.setOrgViewScheme(orgViewSchemeProp);
        orgField.setOrgFuncs("25");
        orgField.setName(new LocaleString(drawFormField.getName()));
        if (drawFormField.hasEmptyText()) {
            orgField.setEmptyText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"ApControlService_1", (String)"sdk-hr", (Object[])new Object[0])));
        }
        return orgField;
    }
}

