/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.sdk.hr.hspm.business.helper.ImportBasedataHelper;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;

public class InfoclassifyImportPlugin
extends HisBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(InfoclassifyImportPlugin.class);
    private static final String UPDATE_ONLY_FIELD = "person.number";

    protected String getImportSaveOpNum() {
        return InfoClassifyFormOperateEnum.FORM_BTN_SAVEIMPORT.getOperateKey();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (this.ctx.isResolveComplete(this.ctx.getAllUrls().toArray(new String[0])[0])) {
            HisBatchImportCache.getInstance().removeEventId(this.getBillFormId());
        }
        return result;
    }

    public void customFilter(String selectProp, DynamicObjectCollection dataCol) {
        LOGGER.info("InfoclassifyImportPlugin#selectProp ,selectProp:{}", (Object)selectProp);
        this.queryObjFromDBWithPersonNumber(selectProp, dataCol);
    }

    protected void queryObjFromDBWithPersonNumber(String selectProp, DynamicObjectCollection dataCol) {
        if (!HRStringUtils.equals((String)selectProp, (String)UPDATE_ONLY_FIELD)) {
            return;
        }
        if (dataCol.size() == 1) {
            return;
        }
        Map<String, List<DynamicObject>> personNumberListDyMap = dataCol.stream().collect(Collectors.groupingBy(dataDy -> dataDy.getString(UPDATE_ONLY_FIELD)));
        HashSet<Long> existsIdSet = new HashSet<Long>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : personNumberListDyMap.entrySet()) {
            List<DynamicObject> personNumberListDy = entry.getValue();
            List ids = personNumberListDy.stream().map(dataDy -> dataDy.get("id")).collect(Collectors.toList());
            HRBaseServiceHelper helper = new HRBaseServiceHelper(this.ctx.getBillFormId());
            DynamicObjectCollection dyPersonCollection = helper.queryOriginalCollection("id,person.id", new QFilter[]{new QFilter("id", "in", ids), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
            if (dyPersonCollection.size() == 1) {
                existsIdSet.add(((DynamicObject)dyPersonCollection.get(0)).getLong("id"));
                continue;
            }
            List<Object> personIdList = dyPersonCollection.stream().map(dy -> dy.get("person.id")).collect(Collectors.toList());
            HashSet personIdSet = Sets.newHashSet(ImportBasedataHelper.queryPersonBaseData(personIdList));
            existsIdSet.addAll(dyPersonCollection.stream().filter(dyPerson -> personIdSet.contains(dyPerson.getLong("person.id"))).map(dyPerson -> dyPerson.getLong("id")).collect(Collectors.toSet()));
        }
        dataCol.removeIf(dataDy -> !existsIdSet.contains(dataDy.getLong("id")));
    }

    protected List<ComboItem> getOverrideFieldsConfig(Map<String, LocaleString> itemMap) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (!itemMap.containsKey(p.getName())) continue;
            LocaleString itemName = itemMap.get(p.getName());
            if (HRObjectUtils.isEmpty((Object)itemName)) {
                items.add(new ComboItem(p.getDisplayName(), p.getName()));
                continue;
            }
            items.add(new ComboItem(itemName, p.getName()));
        }
        return items;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get("importtype");
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            Object boid = billdata.getData().get((Object)"boid");
            if (boid == null && !HRStringUtils.equals((String)importType, (String)"override")) continue;
            if (boid != null && HRStringUtils.equals((String)importType, (String)"new")) {
                billdata.getData().put("boid", (Object)0L);
            }
            if (!(boid instanceof String) || StringUtils.isNumeric((String)((String)boid))) continue;
            logger.log(Integer.valueOf(billdata.getStartIndex()), ResManager.loadKDString((String)"\u4e1a\u52a1ID\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"InfoclassifyImportPlugin_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            logger.fail();
            it.remove();
        }
        super.beforeSave(billdatas, logger);
    }

    public static class HisBatchImportCache {
        private static final HisBatchImportCache INSTANCE = new HisBatchImportCache();

        public static HisBatchImportCache getInstance() {
            return INSTANCE;
        }

        public String getFromCacheImportLogId(String entityNumber) {
            IHRAppCache ihrAppCache = HRAppCache.get((String)"hbp");
            String importCacheKeySuffix = HisModelImportUtil.getImportCacheKeySuffix();
            String importLogIdCacheKey = String.format("HisImportLogId_%s_%s", entityNumber, importCacheKeySuffix);
            return (String)ihrAppCache.get(importLogIdCacheKey, String.class);
        }

        public Long getEventId(String entityNumber) {
            String importEventIdCacheKey;
            IHRAppCache ihrAppCache;
            String fromCacheImportLogId = this.getFromCacheImportLogId(entityNumber);
            Long eventId = 0L;
            if (HRStringUtils.isNotEmpty((String)fromCacheImportLogId) && ((eventId = (Long)(ihrAppCache = HRAppCache.get((String)"hspm")).get(importEventIdCacheKey = this.getImportEventIdCacheKey(entityNumber), Long.class)) == null || eventId == 0L)) {
                eventId = ORM.create().genLongId(entityNumber);
                ihrAppCache.put(importEventIdCacheKey, (Object)eventId);
            }
            return eventId;
        }

        public void removeEventId(String entityNumber) {
            String importEventIdCacheKey = this.getImportEventIdCacheKey(entityNumber);
            IHRAppCache ihrAppCache = HRAppCache.get((String)"hspm");
            ihrAppCache.remove(importEventIdCacheKey);
        }

        private String getImportEventIdCacheKey(String entityNumber) {
            String importCacheKeySuffix = HisModelImportUtil.getImportCacheKeySuffix();
            return String.format("HisImportEventId_%s_%s", entityNumber, importCacheKeySuffix);
        }
    }
}

