/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.HrpiServiceOperateParam;

public class InfoclassifySaveOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(InfoclassifySaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        String operationKey = args.getOperationKey();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(operationKey);
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        for (DynamicObject entity : dataEntities = args.getDataEntities()) {
            boolean isnofixedterm;
            if (!entity.getDynamicObjectType().getProperties().containsKey((Object)"isnofixedterm") || !entity.getDynamicObjectType().getProperties().containsKey((Object)"expirationdate") || !(isnofixedterm = entity.getBoolean("isnofixedterm"))) continue;
            entity.set("expirationdate", (Object)HRDateTimeUtils.getSysMaxDate());
        }
        switch (operateKeyEnum) {
            case FORM_BTN_SAVE: 
            case FORM_BTN_DO_SAVE: {
                this.saveNew(args, dataEntities);
                break;
            }
            case FORM_BTN_UPDATE: {
                this.saveOverride(args, dataEntities);
                break;
            }
            case FORM_BTN_DELETE: {
                this.delete(args, dataEntities);
                break;
            }
            case FORM_BTN_SAVEIMPORT: {
                this.saveImport(args, dataEntities);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operationKey = args.getOperationKey();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(operationKey);
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        switch (operateKeyEnum) {
            case FORM_BTN_SAVE: 
            case FORM_BTN_DO_SAVE: {
                this.afterSaveNew(args, dataEntities);
                break;
            }
            case FORM_BTN_UPDATE: {
                this.afterSaveOverride(args, dataEntities);
                break;
            }
            case FORM_BTN_DELETE: {
                List<Long> failDeleteIdList = this.checkDelete(args, dataEntities);
                if (!failDeleteIdList.isEmpty()) {
                    OperationResult operationResult = this.getOperationResult();
                    operationResult.setSuccess(false);
                    List successPkIds = operationResult.getSuccessPkIds();
                    Iterator iterator = successPkIds.iterator();
                    while (iterator.hasNext()) {
                        Long successPkId = (Long)iterator.next();
                        if (!failDeleteIdList.contains(successPkId)) continue;
                        iterator.remove();
                    }
                }
                this.afterDelete(args, dataEntities);
                break;
            }
            case FORM_BTN_SAVEIMPORT: {
                this.afterSaveImport(args, dataEntities);
                break;
            }
        }
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoclassifySaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    protected void saveImport(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        String importType;
        switch (importType = this.getOption().getVariableValue("importtype")) {
            case "new": {
                this.saveImportNew(args, dataEntities);
                break;
            }
            case "override": {
                this.saveImportOverride(args, dataEntities);
                break;
            }
            case "overridenew": {
                this.saveImportOverridenew(args, dataEntities);
                break;
            }
        }
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoclassifySaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoclassifySaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoclassifySaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    protected void afterSaveNew(AfterOperationArgs args, DynamicObject[] dataEntities) {
    }

    protected void afterSaveOverride(AfterOperationArgs args, DynamicObject[] dataEntities) {
    }

    protected void afterDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
    }

    protected void afterSaveImport(AfterOperationArgs args, DynamicObject[] dataEntities) {
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoclassifySaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey(entityName);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject[] importSaveDys = this.getImportOverrideDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
            Map<String, Object> resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("override", importSaveDys);
            HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
            if (operateResult.isSuccess()) {
                LOGGER.info(String.format(Locale.ROOT, "saveImport%s the id is %s.", entityName, operateResult.getDataMapForIds()));
                HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg(new DynamicObject[]{dataEntities[i]}, infoClassifyEntityKeyDTO.getSourceKey(), infoClassifyEntityKeyDTO.getFormKey());
            }
            this.validateOperateResult(args, operateResult, false);
        }
    }

    public DynamicObject[] getImportOverrideDatas(DynamicObject[] dataEntities, HRBaseServiceHelper serviceHelper) {
        DynamicObject[] importSaveDys = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject object = serviceHelper.queryOne(dataEntities[i].getPkValue());
            HRDynamicObjectUtils.copy((DynamicObject)dataEntities[i], (DynamicObject)object, BusinessUtils.getIgnoreField());
            importSaveDys[i] = object;
        }
        return importSaveDys;
    }

    public DynamicObject[] getImportNewDatas(DynamicObject[] dataEntities, HRBaseServiceHelper serviceHelper) {
        DynamicObject[] importSaveDys = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject object;
            importSaveDys[i] = object = HrpiServiceOperateParam.getSaveDy(serviceHelper, dataEntities[i]);
        }
        return importSaveDys;
    }

    protected void saveImportOverridenew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey(entityName);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        for (int i = 0; i < dataEntities.length; ++i) {
            Map<String, Object> resultMap;
            DynamicObject[] importSaveDys;
            if (dataEntities[i].getLong("boid") != 0L) {
                importSaveDys = this.getImportOverrideDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
                resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("override", importSaveDys);
            } else {
                importSaveDys = this.getImportNewDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
                resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("new", importSaveDys);
            }
            HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
            if (operateResult.isSuccess()) {
                LOGGER.info(String.format(Locale.ROOT, "saveImport%s the id is %s.", entityName, operateResult.getDataMapForIds()));
                HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg(new DynamicObject[]{dataEntities[i]}, infoClassifyEntityKeyDTO.getSourceKey(), infoClassifyEntityKeyDTO.getFormKey());
            }
            this.validateOperateResult(args, operateResult, false);
        }
    }

    protected boolean isNoDataChanged(BeginOperationTransactionArgs args, boolean compareResult) {
        if (!compareResult) {
            args.setCancelOperation(true);
            this.getOperationResult().setMessage("the entity has not changed.");
            return true;
        }
        return false;
    }

    protected void validateOperateResult(BeginOperationTransactionArgs args, HrpiServiceOperateResult operateResult) {
        this.validateOperateResult(args, operateResult, true);
    }

    protected void validateOperateResult(BeginOperationTransactionArgs args, HrpiServiceOperateResult operateResult, boolean cancelOperationFlag) {
        if (!operateResult.isSuccess()) {
            if (cancelOperationFlag) {
                args.setCancelOperation(true);
            }
            throw new KDBizException(operateResult.getMessage());
        }
    }
}

