/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin.ext;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.hr.hspm.business.service.IInfoClassifyService;
import kd.sdk.hr.hspm.business.service.impl.InfoClassifyServiceImpl;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class InfoClassifyExtSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(InfoClassifyExtSaveOp.class);
    private IInfoClassifyService infoClassifyService;

    @Override
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void setContext(MainEntityType billEntityType, Map<String, Object> operateMeta, OperateOption option) {
        super.setContext(billEntityType, operateMeta, option);
        this.infoClassifyService = new InfoClassifyServiceImpl(billEntityType.getName());
    }

    @Override
    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        DynamicObject[] var3 = dataEntities;
        int var4 = dataEntities.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            DynamicObject dataEntity = var3[var5];
            DynamicPropValidateUtil.trim(dataEntity);
            HrpiServiceOperateResult operateResult = this.infoClassifyService.insertInfo(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    @Override
    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        DynamicObject[] var3 = dataEntities;
        int var4 = dataEntities.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            DynamicObject dataEntity = var3[var5];
            DynamicPropValidateUtil.trim(dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.infoClassifyService.getInfoByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged(dataEntity, dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.infoClassifyService.updateInfo(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    @Override
    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List<Long> pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        HrpiServiceOperateResult operateResult = this.infoClassifyService.deleteInfo(pkIdList);
        this.validateOperateResult(args, operateResult);
    }

    @Override
    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List<Long> pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.infoClassifyService.queryExistsIdByPkIdList(pkIdList);
    }

    @Override
    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        DynamicObject[] var3 = dataEntities;
        int var4 = dataEntities.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            DynamicObject dataEntity = var3[var5];
            HrpiServiceOperateResult operateResult = this.infoClassifyService.saveImportInfo("new", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
        }
    }
}

