/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.ssc.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.ssc.business.service.ISSCSLAService;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;

public class SSCSLAServiceImpl
implements ISSCSLAService {
    private static final Log LOGGER = LogFactory.getLog(SSCSLAServiceImpl.class);

    @Override
    public Map<Long, SLATimeInfoDTO> getSLAInfoByIds(List<Long> taskIds) {
        if (HRCollUtil.isEmpty(taskIds)) {
            LOGGER.warn("###SSCSLAServiceImpl.getSLAInfoByIds, taskIds is empty!", taskIds);
            return Collections.emptyMap();
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("id", taskIds);
        LOGGER.info("###SSCSLAServiceImpl.getSLAInfoByIds, ids:{}", (Object)JSON.toJSONString(taskIds));
        OpenApiResult invokeResult = OpenApiSdkUtil.invoke((String)"/v2/ssc/getTaskTimeById", params);
        LOGGER.info("###SSCSLAServiceImpl.getSLAInfoByIds, invokeResult:{}", (Object)JSON.toJSONString((Object)invokeResult));
        if (Boolean.FALSE.equals(invokeResult.isStatus()) || HRMapUtils.isEmpty((Map)((Map)invokeResult.getData()))) {
            return Collections.emptyMap();
        }
        Map dataMap = (Map)invokeResult.getData();
        List dataList = (List)dataMap.get("result");
        if (HRCollUtil.isEmpty((Collection)dataList)) {
            return Collections.emptyMap();
        }
        Map<Long, Map<String, Object>> slaTimeInfoMap = this.convertToDataMap(dataList);
        HashMap<Long, SLATimeInfoDTO> result = new HashMap<Long, SLATimeInfoDTO>(taskIds.size());
        for (long taskId : taskIds) {
            Map<String, Object> slaTimeInfo = slaTimeInfoMap.get(taskId);
            if (HRObjectUtils.isEmpty(slaTimeInfo)) {
                result.put(taskId, null);
                continue;
            }
            SLATimeInfoDTO slaTimeFieldDto = new SLATimeInfoDTO();
            Date createTime = (Date)slaTimeInfo.get("CREATETIME");
            Date realfinishTime = (Date)slaTimeInfo.get("COMPLETETIME");
            BigDecimal remainingHours = (BigDecimal)slaTimeInfo.get("RESTTIME");
            BigDecimal consumingHours = (BigDecimal)slaTimeInfo.get("FIRSTCOSTWAITTIME");
            slaTimeFieldDto.setCreateTime(createTime);
            slaTimeFieldDto.setRemainingDays(this.formatDayAndHours(remainingHours));
            long remainingSeconds = remainingHours.multiply(new BigDecimal(3600)).longValue();
            slaTimeFieldDto.setLatestdFinishTime(this.calcLatestdFinishTime(createTime, remainingSeconds));
            slaTimeFieldDto.setConsumingDays(this.formatDayAndHours(consumingHours));
            slaTimeFieldDto.setRealFinishTime(realfinishTime);
            result.put(taskId, slaTimeFieldDto);
        }
        LOGGER.info("###SSCSLAServiceImpl.getSLAInfoByIds, result:{}", (Object)JSON.toJSONString(result));
        return result;
    }

    @Override
    public String calcConsumingTime(Date beginDate, Date completeTime) {
        String dayStr = ResManager.loadKDString((String)"\u5929", (String)"SSCSLAServiceImpl_0", (String)"sdk-hr", (Object[])new Object[0]);
        String hourStr = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"SSCSLAServiceImpl_1", (String)"sdk-hr", (Object[])new Object[0]);
        if (HRObjectUtils.isEmpty((Object)beginDate) || HRObjectUtils.isEmpty((Object)completeTime)) {
            return "";
        }
        long consumingTime = (completeTime.getTime() - beginDate.getTime()) / 1000L;
        long days = consumingTime / 86400L;
        long hours = consumingTime % 86400L / 3600L;
        if (days == 0L && hours == 0L) {
            return "";
        }
        if (days == 0L) {
            return hours + hourStr;
        }
        return days + dayStr + hours + hourStr;
    }

    private Map<Long, Map<String, Object>> convertToDataMap(List<Map<String, Object>> dataList) {
        HashMap slaTimeInfoJsonMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        for (Map<String, Object> item : dataList) {
            slaTimeInfoJsonMap.put((Long)item.get("ID"), item);
        }
        return slaTimeInfoJsonMap;
    }

    private String formatDayAndHours(BigDecimal totalHours) {
        String dayStr = ResManager.loadKDString((String)"\u5929", (String)"SSCSLAServiceImpl_0", (String)"sdk-hr", (Object[])new Object[0]);
        String hourStr = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"SSCSLAServiceImpl_1", (String)"sdk-hr", (Object[])new Object[0]);
        if (HRObjectUtils.isEmpty((Object)totalHours)) {
            return "";
        }
        BigDecimal days = totalHours.divide(BigDecimal.valueOf(24L), 0, RoundingMode.DOWN);
        BigDecimal hours = totalHours.remainder(BigDecimal.valueOf(24L)).setScale(0, RoundingMode.DOWN);
        if (days.compareTo(BigDecimal.ZERO) == 0 && hours.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        if (days.compareTo(BigDecimal.ZERO) == 0) {
            return hours + hourStr;
        }
        return days + dayStr + hours + hourStr;
    }

    private Date calcLatestdFinishTime(Date beginDate, long remainingSeconds) {
        if (HRObjectUtils.isEmpty((Object)remainingSeconds)) {
            return beginDate;
        }
        Instant instant = beginDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localBeginDateTime = instant.atZone(zoneId).toLocalDateTime();
        LocalDateTime result = remainingSeconds >= 0L ? localBeginDateTime.plusSeconds(remainingSeconds) : localBeginDateTime.minusSeconds(Math.abs(remainingSeconds));
        ZonedDateTime zonedDateTime = result.atZone(zoneId);
        return Date.from(zonedDateTime.toInstant());
    }
}

