/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soebs.business.service.cadrefile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStdCadreFileReportAppRemSplicingService {
    public String getAppRemSplicingRes(List<Row> rows) {
        List<GroupBean> groupBeanList = this.assembleGroupBeanList(rows);
        StringBuilder res = AbstractStdCadreFileReportAppRemSplicingService.getSplicingRes(groupBeanList);
        return res.toString();
    }

    private List<GroupBean> assembleGroupBeanList(List<Row> rows) {
        int totalRow = rows.size() - 1;
        ArrayList groupBeanList = Lists.newArrayListWithCapacity((int)totalRow);
        for (int rowIndex = 0; rowIndex <= totalRow; ++rowIndex) {
            String postKey;
            Row row = rows.get(rowIndex);
            String positionType = row.getString(this.getPositionType());
            if ("0".equals(positionType)) {
                postKey = this.getStdPositionName();
            } else if ("1".equals(positionType)) {
                postKey = this.getPositionName();
            } else {
                if (!"2".equals(positionType)) continue;
                postKey = this.getJobName();
            }
            Long companyId = row.getLong(this.getCompanyId());
            Long adminOrgId = row.getLong(this.getAdminOrgId());
            if (companyId == null || adminOrgId == null || companyId == 0L || adminOrgId == 0L) continue;
            GroupBean groupBean = new GroupBean();
            groupBean.setCompanyName(row.getString(this.getCompanyName()));
            groupBean.setCompanyId(companyId);
            groupBean.setAdminOrgName(row.getString(this.getAdminOrgName()));
            groupBean.setAdminOrgId(adminOrgId);
            groupBean.setPostName(row.getString(postKey));
            groupBeanList.add(groupBean);
        }
        return groupBeanList;
    }

    private static StringBuilder getSplicingRes(List<GroupBean> groupBeanList) {
        Map companyGroup = groupBeanList.stream().collect(Collectors.groupingBy(GroupBean::getCompanyId, TreeMap::new, Collectors.toList()));
        StringBuilder res = new StringBuilder();
        int companyIndex = companyGroup.size();
        for (Map.Entry companyGroupEntry : companyGroup.entrySet()) {
            String companyName = ((GroupBean)((List)companyGroupEntry.getValue()).get(0)).getCompanyName();
            res.append(companyName);
            Map adminOrgGroup = ((List)companyGroupEntry.getValue()).stream().collect(Collectors.groupingBy(GroupBean::getAdminOrgId, TreeMap::new, Collectors.toList()));
            int adminOrgIndex = adminOrgGroup.size();
            for (Map.Entry adminOrgGroupEntry : adminOrgGroup.entrySet()) {
                String adminOrgName = ((GroupBean)((List)adminOrgGroupEntry.getValue()).get(0)).getAdminOrgName();
                res.append(adminOrgName);
                String posSplicing = ((List)adminOrgGroupEntry.getValue()).stream().map(GroupBean::getPostName).filter(StringUtils::isNotBlank).collect(Collectors.joining("\u3001"));
                res.append(posSplicing);
                if (adminOrgIndex != 1) {
                    res.append("\u3001");
                }
                --adminOrgIndex;
            }
            if (companyIndex != 1) {
                res.append("\uff0c\r\n");
            }
            --companyIndex;
        }
        return res;
    }

    protected abstract String getPositionType();

    protected abstract String getCompanyName();

    protected abstract String getCompanyId();

    protected abstract String getAdminOrgName();

    protected abstract String getAdminOrgId();

    protected abstract String getPositionName();

    protected abstract String getStdPositionName();

    protected abstract String getJobName();

    static class GroupBean {
        String companyName;
        Long companyId;
        String adminOrgName;
        Long adminOrgId;
        String postName;

        GroupBean() {
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public Long getCompanyId() {
            return this.companyId;
        }

        public void setCompanyId(Long companyId) {
            this.companyId = companyId;
        }

        public Long getAdminOrgId() {
            return this.adminOrgId;
        }

        public void setAdminOrgId(Long adminOrgId) {
            this.adminOrgId = adminOrgId;
        }

        public String getAdminOrgName() {
            return this.adminOrgName;
        }

        public void setAdminOrgName(String adminOrgName) {
            this.adminOrgName = adminOrgName;
        }

        public String getPostName() {
            return this.postName;
        }

        public void setPostName(String postName) {
            this.postName = postName;
        }
    }
}

