/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soecadm.business.service.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.sihc.soecadm.business.service.workflow.WorkFlowManageApplicationService;
import kd.sdk.sihc.soecadm.common.ActivityGroupInsCommConstants;
import org.apache.commons.collections4.CollectionUtils;

@SdkPublic
public class ActivityGroupInsCommonService
implements ActivityGroupInsCommConstants {
    private static final Log LOG = LogFactory.getLog(ActivityGroupInsCommonService.class);

    public List<Map<String, Object>> mateActivityGroup(Long sechemeId, DynamicObject data) {
        LOG.info("ActivityGroupInsCommonService.mateActivityGroup , sechemeId : {} , data : {}", (Object)sechemeId, (Object)data);
        List<Map<String, Object>> activityGroupIns = Lists.newArrayListWithCapacity((int)16);
        try {
            activityGroupIns = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"mateActivityGroup", (Object[])new Object[]{sechemeId, data});
            LOG.info("ActivityGroupInsCommonService.mateActivityGroup , activityGroupIns : {}", (Object)activityGroupIns.size());
        }
        catch (KDException exception) {
            LOG.info("ActivityGroupInsCommonService.mateActivityGroup error");
            return activityGroupIns;
        }
        return activityGroupIns;
    }

    public Long generateActivityGroupIns(Long bizBillId, List<Map<String, Object>> activityGroupIns) {
        LOG.info("ActivityGroupInsCommonService.generateActivityGroupIns , bizBillId : {} , activityGroupIns : {}", (Object)bizBillId, activityGroupIns);
        Long activityGroupInsId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"generateActivityGroupIns", (Object[])new Object[]{bizBillId, activityGroupIns});
        LOG.info("ActivityGroupInsCommonService.generateActivityGroupIns , activityGroupInsId : {}", (Object)activityGroupInsId);
        return activityGroupInsId;
    }

    public Long generateActivityGroupIns(Long bizBillId, Long sechemeId, DynamicObject data, Long souActivityId) {
        LOG.info("ActivityGroupInsCommonService.generateActivityGroupIns , bizBillId : {} , sechemeId : {}, souActivityId : {}", new Object[]{bizBillId, sechemeId, souActivityId});
        String appRemType = data.getString("appremtype");
        if (HRStringUtils.equals((String)appRemType, (String)"1") && souActivityId != null && souActivityId > 0L) {
            WorkFlowManageApplicationService workFlowManageApplicationService;
            List<Long> excludeActivityIds;
            List<Map<String, Object>> activityGroupInsList = this.mateActivityGroup(sechemeId, data);
            List activityIds = activityGroupInsList.stream().map(obj -> Long.valueOf(String.valueOf(obj.get("activity")))).collect(Collectors.toList());
            if (!activityIds.contains(souActivityId)) {
                Map<String, Object> souActivity = this.getDefaultActivityinsMap(souActivityId);
                activityGroupInsList.add(souActivity);
            }
            if ((excludeActivityIds = (workFlowManageApplicationService = new WorkFlowManageApplicationService()).getFrontActivitysWithGivenActivity(data, souActivityId)) != null && !excludeActivityIds.isEmpty()) {
                this.excludeActivityGroupInsList(activityGroupInsList, excludeActivityIds);
            }
            return this.generateActivityGroupIns(bizBillId, activityGroupInsList);
        }
        LOG.info("ActivityGroupInsCommonService.generateActivityGroupIns , bizBillId : {} , sechemeId : {} , data : {}", new Object[]{bizBillId, sechemeId, data});
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            Long activityGroupInsId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"generateActivityGroupIns", (Object[])new Object[]{bizBillId, sechemeId, data});
            LOG.info("ActivityGroupInsCommonService.generateActivityGroupIns , activityGroupInsId : {}", (Object)activityGroupInsId);
            Long l = activityGroupInsId;
            return l;
        }
        catch (Exception exception) {
            txHandle.markRollback();
            LOG.error("ActivityGroupInsCommonService.generateActivityGroupIns error");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return 0L;
    }

    public void excludeActivityGroupInsList(List<Map<String, Object>> activityGroupInsList, List<Long> excludeActivityIds) {
        Iterator<Map<String, Object>> iterator = activityGroupInsList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> activityGroupIns = iterator.next();
            if (!excludeActivityIds.contains(activityGroupIns.get("activity"))) continue;
            iterator.remove();
        }
    }

    private Map<String, Object> getDefaultActivityinsMap(Long activityId) {
        HashMap activityGroupInsMap = Maps.newHashMapWithExpectedSize((int)2);
        activityGroupInsMap.put("activity", activityId);
        activityGroupInsMap.put("activitytype", "1");
        activityGroupInsMap.put("status", "1");
        return activityGroupInsMap;
    }

    public Long updateActivityGroupIns(Long bizBillId, List<Map<String, Object>> activityGroupIns) {
        LOG.info("ActivityGroupInsCommonService.updateActivityGroupIns , bizBillId : {} , activityGroupIns : {}", (Object)bizBillId, activityGroupIns);
        Long activityGroupInsId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"updateActivityGroupIns", (Object[])new Object[]{bizBillId, activityGroupIns});
        LOG.info("ActivityGroupInsCommonService.updateActivityGroupIns , activityGroupInsId : {}", (Object)activityGroupInsId);
        return activityGroupInsId;
    }

    public int deleteActivityGroupInsById(Long bizBillId) {
        LOG.info("ActivityGroupInsCommonService.deleteActivityGroupInsById , bizBillId : {}", (Object)bizBillId);
        int count = (Integer)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"deleteActivityGroupInsById", (Object[])new Object[]{bizBillId});
        LOG.info("ActivityGroupInsCommonService.deleteActivityGroupInsById , count : {}", (Object)count);
        return count;
    }

    public int deleteActivityGroupInsByIds(List<Long> bizBillIds) {
        LOG.info("ActivityGroupInsCommonService.deleteActivityGroupInsByIds , bizBillIds : {}", bizBillIds);
        int count = (Integer)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"deleteActivityGroupInsByIds", (Object[])new Object[]{bizBillIds});
        LOG.info("ActivityGroupInsCommonService.deleteActivityGroupInsByIds , count : {}", (Object)count);
        return count;
    }

    public DynamicObject queryActivityGroupInsById(Long bizBillId) {
        LOG.info("ActivityGroupInsCommonService.queryActivityGroupInsById \uff0cbizBillId : {}", (Object)bizBillId);
        DynamicObject activityGroupInsObj = (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"queryActivityGroupInsById", (Object[])new Object[]{bizBillId});
        return activityGroupInsObj;
    }

    public Map<Long, List<Map<String, Object>>> queryActivityGroupInsByIds(List<Long> bizBillIds) {
        LOG.info("ActivityGroupInsCommonService.queryActivityGroupInsByIds \uff0cbizBillIds : {}", bizBillIds);
        DynamicObject[] activityGroupInsObjs = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"queryActivityGroupInsByIds", (Object[])new Object[]{bizBillIds});
        if (activityGroupInsObjs == null || activityGroupInsObjs.length < 1) {
            return Collections.EMPTY_MAP;
        }
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)activityGroupInsObjs.length);
        for (DynamicObject activityGroupInsObj : activityGroupInsObjs) {
            Long bizBillId = activityGroupInsObj.getLong("bizbillid");
            DynamicObjectCollection entryEntity = activityGroupInsObj.getDynamicObjectCollection("entryentity");
            ArrayList<HashMap> activityGroupInsList = new ArrayList<HashMap>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                HashMap activityMap = Maps.newHashMapWithExpectedSize((int)2);
                Long activityId = entry.getLong("activity.id");
                String activityType = entry.getString("activitytype");
                String status = entry.getString("status");
                activityMap.put("activity", activityId);
                activityMap.put("activitytype", activityType);
                activityMap.put("status", status);
                activityGroupInsList.add(activityMap);
            }
            billMap.put(bizBillId, activityGroupInsList);
        }
        return billMap;
    }

    public Boolean getActivityContainsNodeByActivityObj(DynamicObject activityObj, Long activityInsId) {
        Map<Long, Boolean> activityObjContainsIns = this.queryActivityContainsNodeByActivityObjs(Lists.newArrayList((Object[])new DynamicObject[]{activityObj}), activityInsId);
        Boolean res = activityObjContainsIns.get(activityObj.getLong("id"));
        if (res == null) {
            return Boolean.FALSE;
        }
        return res;
    }

    public Map<Long, Boolean> queryActivityContainsNodeByActivityObjs(List<DynamicObject> activityObjs, Long activityInsId) {
        Map<Long, List<Long>> insByActivityObjs = this.queryActivityGroupInsByActivityObjs(activityObjs);
        return insByActivityObjs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, map -> ((List)map.getValue()).contains(activityInsId)));
    }

    public Map<Long, List<Long>> queryActivityGroupInsByActivityObjs(List<DynamicObject> activityObjs) {
        return this.queryActivityGroupInsByActivityObjs(activityObjs, null);
    }

    public Map<Long, List<Long>> queryActivityGroupInsByActivityObjs(List<DynamicObject> activityObjs, Function<List<Map<String, Object>>, List<Long>> filterFun) {
        List<Long> appRemRegAppRemIdList = activityObjs.stream().map(obj -> obj.getDynamicObjectCollection("perpositionentity")).flatMap(col -> col.stream().map(entry -> entry.getLong("appremid"))).collect(Collectors.toList());
        Map<Long, List<Map<String, Object>>> activityGroupInsByIds = this.queryActivityGroupInsByIds(appRemRegAppRemIdList);
        Map<Long, List> activityAppRemIdMap = activityObjs.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getDynamicObjectCollection("perpositionentity").stream().map(entry -> entry.getLong("appremid")).collect(Collectors.toList()), (k1, k2) -> k1));
        HashMap result = Maps.newHashMapWithExpectedSize((int)activityAppRemIdMap.size());
        activityAppRemIdMap.forEach((activityId, appRemIds) -> {
            LinkedList curActivityInsList = new LinkedList();
            result.put(activityId, curActivityInsList);
            for (Long appRemId : appRemIds) {
                List activityIns = (List)activityGroupInsByIds.get(appRemId);
                if (CollectionUtils.isEmpty((Collection)activityIns)) continue;
                List activityInsIds = filterFun != null ? (List)filterFun.apply(activityIns) : activityIns.stream().filter(map -> "1".equals(map.get("status"))).map(map -> (Long)map.get("activity")).collect(Collectors.toList());
                curActivityInsList.addAll(activityInsIds);
            }
        });
        return result;
    }
}

