/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soecadm.business.service.orgProcess;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.dto.OrgProcessDTO;

public class OrgProcessDomainService {
    private static final Log LOG = LogFactory.getLog(OrgProcessDomainService.class);
    private static final HRBaseServiceHelper SOECADM_ORGPROCESSING_HELPER = HRBaseServiceHelper.create((String)"soecadm_orgprocessing");

    public void saveOrgProcessData(OrgProcessDTO orgProcessDTO) {
        if (!this.checkMustInput(orgProcessDTO)) {
            LOG.error("saveOrgProcessData checkMustInput is false orgProcessDTO:{}", (Object)(orgProcessDTO != null ? orgProcessDTO.toString() : ""));
            return;
        }
        SOECADM_ORGPROCESSING_HELPER.deleteByFilter(this.getQueryFilter(orgProcessDTO));
        DynamicObject dynamicObject = this.createDynamicObject(orgProcessDTO);
        SOECADM_ORGPROCESSING_HELPER.saveOne(dynamicObject);
    }

    public void saveOrgProcessDatas(List<OrgProcessDTO> orgProcessDTOs) {
        if (CollectionUtils.isEmpty(orgProcessDTOs)) {
            LOG.error("saveOrgProcessData orgProcessDTOs is empty");
            return;
        }
        List<OrgProcessDTO> processDTOS = orgProcessDTOs.stream().filter(this::checkMustInput).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(processDTOS)) {
            LOG.error("saveOrgProcessData orgProcessDTOs need save datas is empty");
        }
        SOECADM_ORGPROCESSING_HELPER.deleteByFilter(this.getQueryFilterWithBatchProcess(processDTOS));
        SOECADM_ORGPROCESSING_HELPER.save(this.createDynamicObjects(processDTOS).toArray(new DynamicObject[0]));
    }

    public DynamicObject[] getOrgProcessData(String billKey, Long billId, Long employeeId) {
        if (HRStringUtils.isEmpty((String)billKey) || billId == null || billId == 0L || employeeId == null || employeeId == 0L) {
            LOG.error("getOrgProcessData billKey or billId or employeeId is empty");
            return null;
        }
        return SOECADM_ORGPROCESSING_HELPER.loadDynamicObjectArray(this.getQueryFilter(billKey, billId, employeeId));
    }

    public Map<Long, List<DynamicObject>> getOrgProcessDatas(String billKey, List<Long> billIds) {
        if (HRStringUtils.isEmpty((String)billKey) || CollectionUtils.isEmpty(billIds)) {
            LOG.error("getOrgProcessData billKey or billIds is empty");
            return null;
        }
        QFilter billKeyFilter = new QFilter("billkey", "=", (Object)billKey);
        QFilter billidFilter = new QFilter("billid", "in", billIds);
        DynamicObject[] dynamicObjects = SOECADM_ORGPROCESSING_HELPER.loadDynamicObjectArray(new QFilter[]{billKeyFilter, billidFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(obj -> obj.getLong("billid")));
    }

    public Map<Long, List<DynamicObject>> getOrgProcessDatas(String billKey, Long billId, List<Long> employeeIds) {
        if (HRStringUtils.isEmpty((String)billKey) || billId == null || billId == 0L || CollectionUtils.isEmpty(employeeIds)) {
            LOG.error("getOrgProcessData billKey or billId or employeeIds is empty");
            return null;
        }
        QFilter billKeyFilter = new QFilter("billkey", "=", (Object)billKey);
        QFilter billidFilter = new QFilter("billid", "=", (Object)billId);
        QFilter employeeidFilter = new QFilter("employeeid", "in", employeeIds);
        DynamicObject[] dynamicObjects = SOECADM_ORGPROCESSING_HELPER.loadDynamicObjectArray(new QFilter[]{billKeyFilter, billidFilter, employeeidFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(obj -> obj.getLong("employeeid")));
    }

    private boolean checkMustInput(OrgProcessDTO orgProcessDTO) {
        return orgProcessDTO != null && !HRStringUtils.isEmpty((String)orgProcessDTO.getBillKey()) && orgProcessDTO.getBillId() != null && orgProcessDTO.getBillId() != 0L && orgProcessDTO.getEmployeeId() != null && orgProcessDTO.getEmployeeId() != 0L && !HRStringUtils.isEmpty((String)orgProcessDTO.getProcessingDetail());
    }

    private QFilter[] getQueryFilter(String billKey, Long billId, Long employeeId) {
        QFilter billKeyFilter = new QFilter("billkey", "=", (Object)billKey);
        QFilter billidFilter = new QFilter("billid", "=", (Object)billId);
        QFilter employeeidFilter = new QFilter("employeeid", "=", (Object)employeeId);
        return new QFilter[]{billKeyFilter, billidFilter, employeeidFilter};
    }

    private QFilter[] getQueryFilter(OrgProcessDTO orgProcessDTO) {
        QFilter billKeyFilter = new QFilter("billkey", "=", (Object)orgProcessDTO.getBillKey());
        QFilter billidFilter = new QFilter("billid", "=", (Object)orgProcessDTO.getBillId());
        QFilter employeeidFilter = new QFilter("employeeid", "=", (Object)orgProcessDTO.getEmployeeId());
        return new QFilter[]{billKeyFilter, billidFilter, employeeidFilter};
    }

    private QFilter[] getQueryFilterWithBatchProcess(List<OrgProcessDTO> orgProcessDTOs) {
        QFilter billKeyFilter = new QFilter("billkey", "=", (Object)orgProcessDTOs.get(0).getBillKey());
        QFilter billidFilter = new QFilter("billid", "=", (Object)orgProcessDTOs.get(0).getBillId());
        List employeeIds = orgProcessDTOs.stream().map(OrgProcessDTO::getEmployeeId).collect(Collectors.toList());
        QFilter employeeidFilter = new QFilter("employeeid", "in", employeeIds);
        return new QFilter[]{billKeyFilter, billidFilter, employeeidFilter};
    }

    private List<DynamicObject> createDynamicObjects(List<OrgProcessDTO> orgProcessDTOs) {
        return orgProcessDTOs.stream().map(this::createDynamicObject).collect(Collectors.toList());
    }

    private DynamicObject createDynamicObject(OrgProcessDTO orgProcessDTO) {
        DynamicObject dynamicObject = SOECADM_ORGPROCESSING_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("billkey", (Object)orgProcessDTO.getBillKey());
        dynamicObject.set("billid", (Object)orgProcessDTO.getBillId());
        dynamicObject.set("employeeid", (Object)orgProcessDTO.getEmployeeId());
        dynamicObject.set("processingdetail", (Object)orgProcessDTO.getProcessingDetail());
        dynamicObject.set("processingdate", (Object)orgProcessDTO.getProcessingDate());
        dynamicObject.set("enddate", (Object)orgProcessDTO.getEnddate());
        dynamicObject.set("processingtype", (Object)orgProcessDTO.getProcessingType());
        dynamicObject.set("processingresult", (Object)orgProcessDTO.getProcessingResult());
        dynamicObject.set("handleopi", (Object)orgProcessDTO.getHandleOpi());
        dynamicObject.set("impactperiod", (Object)orgProcessDTO.getImpactPeriod());
        return dynamicObject;
    }
}

