/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soecadm.business.service.workflow;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBillSetting;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCustomParam;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.business.service.activity.ActivityGroupInsCommonService;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sdk.sihc.soecadm.enums.WFGroupDecisionTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class WorkFlowManageApplicationService {
    private static final Log LOG = LogFactory.getLog(WorkFlowManageApplicationService.class);
    private static final String STATUSINFO = "statusInfo";
    private static final String STARTSIGNALEVENT = "StartSignalEvent";
    private static final String ENDNONEEVENT = "EndNoneEvent";
    private static final String INCLUSIVEGATEWAY = "InclusiveGateway";
    private static final String USERTASK = "UserTask";
    private static final String HRACTIVITY = "HRActivity";
    private static final String SUBMIT = "submit";
    private static final String STATUS = "status";
    private static final String RESULT = "result";

    public WFFlowNode mergeFlowNodeWithSameType(List<WFFlowNode> wfFlowNodes, int mergeType) {
        if (CollectionUtils.isEmpty(wfFlowNodes)) {
            return null;
        }
        this.mergeFlowNodeWithSameTypeRecursion(null, wfFlowNodes);
        return wfFlowNodes.get(0);
    }

    public WFFlowNode mergeFlowNodeWithDifferentType(List<WFFlowNode> wfFlowNodes) {
        if (wfFlowNodes == null || wfFlowNodes.size() < 2 || wfFlowNodes.get(0) == null) {
            return null;
        }
        int listCount = 0;
        for (WFFlowNode wfFlowNode : wfFlowNodes) {
            if (listCount > 0) {
                wfFlowNodes.get(0).getNextNodes().addAll(wfFlowNode.getNextNodes());
            }
            ++listCount;
        }
        return wfFlowNodes.get(0);
    }

    public List<Long> getFrontActivityInProgress(DynamicObject[] bills) {
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return null;
        }
        WFFlowNode flowNode = null;
        for (DynamicObject bill : bills) {
            flowNode = this.getWFFlowNode(bill);
            if (flowNode != null) continue;
            return null;
        }
        List<Long> activityIds = this.getWaitingActivityInfos(bills, flowNode);
        List<Long> terminateActivityInfos = this.getTerminateActivityInfos(bills, flowNode);
        if (CollectionUtils.isEmpty(activityIds) && !CollectionUtils.isEmpty(terminateActivityInfos)) {
            return null;
        }
        if (CollectionUtils.isEmpty(activityIds)) {
            LOG.info("WorkFlowManageApplicationService  activityIds is null");
            List wfFlowNodes = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWfQueryService", (String)"queryWFFlowNodes", (Object[])new Object[]{Lists.newArrayList((Object[])new DynamicObject[]{bills[0]})});
            if (!CollectionUtils.isEmpty((Collection)wfFlowNodes)) {
                WFFlowNode wfFlowNode = (WFFlowNode)wfFlowNodes.get(0);
                WFFlowNode firstNode = (WFFlowNode)wfFlowNode.getNextNodes().get(0);
                if (USERTASK.equals(firstNode.getType())) {
                    for (WFFlowNode childNode : firstNode.getNextNodes()) {
                        activityIds.add(this.getActivityId(childNode));
                    }
                } else {
                    for (WFFlowNode childNode : wfFlowNode.getNextNodes()) {
                        activityIds.add(this.getActivityId(childNode));
                    }
                }
            }
        } else {
            LOG.info("WorkFlowManageApplicationService  activityIds:{}", activityIds);
            HashMap<Long, WFFlowNode> activityMap = new HashMap<Long, WFFlowNode>(16);
            for (Long activityId : activityIds) {
                this.getNodeList(flowNode, activityId, activityMap);
            }
            ArrayList<Long> followActivityList = new ArrayList<Long>(10);
            this.getFollowNode(activityMap, activityIds, followActivityList);
        }
        LOG.info("WorkFlowManageApplicationService result activityIds:{}", activityIds);
        return activityIds;
    }

    public Map<Long, Set<Long>> getAllActivityIdsByBill(DynamicObject[] bills) {
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return null;
        }
        WFFlowNode flowNode = null;
        for (DynamicObject bill : bills) {
            flowNode = this.getWFFlowNode(bill);
            if (flowNode != null) continue;
            return null;
        }
        return this.getAllActivityInfos(bills, flowNode);
    }

    public List<Long> getFrontActivityInProgressOrTerminate(DynamicObject[] bills) {
        ArrayList<Long> followActivityList;
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return null;
        }
        WFFlowNode flowNode = null;
        for (DynamicObject bill : bills) {
            flowNode = this.getWFFlowNode(bill);
            if (flowNode != null) continue;
            return null;
        }
        List<Long> activityIds = this.getWaitingActivityInfos(bills, flowNode);
        List<Long> terminateActivityInfos = this.getTerminateActivityInfos(bills, flowNode);
        if (CollectionUtils.isEmpty(activityIds) && !CollectionUtils.isEmpty(terminateActivityInfos)) {
            LOG.info("WorkFlowManageApplicationService  getFrontActivityTerminate activityIds:{}", terminateActivityInfos);
            HashMap<Long, WFFlowNode> activityMap = new HashMap<Long, WFFlowNode>(16);
            for (Long activityId : terminateActivityInfos) {
                this.getNodeList(flowNode, activityId, activityMap);
            }
            followActivityList = new ArrayList<Long>(10);
            this.getFollowNode(activityMap, terminateActivityInfos, followActivityList);
            return terminateActivityInfos;
        }
        if (CollectionUtils.isEmpty(activityIds)) {
            LOG.info("WorkFlowManageApplicationService  activityIds is null");
            List wfFlowNodes = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWfQueryService", (String)"queryWFFlowNodes", (Object[])new Object[]{Lists.newArrayList((Object[])new DynamicObject[]{bills[0]})});
            if (!CollectionUtils.isEmpty((Collection)wfFlowNodes)) {
                WFFlowNode wfFlowNode = (WFFlowNode)wfFlowNodes.get(0);
                WFFlowNode firstNode = (WFFlowNode)wfFlowNode.getNextNodes().get(0);
                if (USERTASK.equals(firstNode.getType())) {
                    for (WFFlowNode childNode : firstNode.getNextNodes()) {
                        activityIds.add(this.getActivityId(childNode));
                    }
                } else {
                    for (WFFlowNode childNode : wfFlowNode.getNextNodes()) {
                        activityIds.add(this.getActivityId(childNode));
                    }
                }
            }
        } else {
            LOG.info("WorkFlowManageApplicationService  activityIds:{}", activityIds);
            HashMap<Long, WFFlowNode> activityMap = new HashMap<Long, WFFlowNode>(16);
            for (Long activityId : activityIds) {
                this.getNodeList(flowNode, activityId, activityMap);
            }
            followActivityList = new ArrayList(10);
            this.getFollowNode(activityMap, activityIds, followActivityList);
        }
        LOG.info("WorkFlowManageApplicationService result activityIds:{}", activityIds);
        return activityIds;
    }

    private List<Long> getWaitingActivityInfos(DynamicObject[] bills, WFFlowNode flowNode) {
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        ArrayList<Long> waitingActivitys = new ArrayList<Long>(10);
        this.getALlFlowNodeWithMap(flowNode, activityMap);
        for (DynamicObject bill : bills) {
            List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)String.valueOf(bill.getPkValue()));
            LOG.info("WorkFlowManageApplicationService  allApprovalRecord:{}", (Object)SerializationUtils.toJsonString((Object)allApprovalRecord));
            for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
                Long activityIdLong;
                WFFlowNode flowNodeTemp;
                IApprovalRecordItem approvalRecordItem;
                String activityId;
                List children;
                if (!WFGroupDecisionTypeEnum.WAIT.getType().equals(approvalRecord.getGroupDecisionType()) || CollectionUtils.isEmpty((Collection)(children = approvalRecord.getChildren())) || StringUtils.isEmpty((CharSequence)(activityId = (approvalRecordItem = (IApprovalRecordItem)children.get(0)).getActivityId())) || (flowNodeTemp = (WFFlowNode)activityMap.get(activityId)) == null || waitingActivitys.contains(activityIdLong = this.getActivityId(flowNodeTemp))) continue;
                waitingActivitys.add(activityIdLong);
            }
        }
        return waitingActivitys;
    }

    private List<Long> getTerminateActivityInfos(DynamicObject[] bills, WFFlowNode flowNode) {
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        ArrayList<Long> terminateActivitys = new ArrayList<Long>(10);
        this.getALlFlowNodeWithMap(flowNode, activityMap);
        for (DynamicObject bill : bills) {
            List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)String.valueOf(bill.getPkValue()));
            LOG.info("WorkFlowManageApplicationService  allApprovalRecord:{}", (Object)SerializationUtils.toJsonString((Object)allApprovalRecord));
            for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
                Long activityIdLong;
                WFFlowNode flowNodeTemp;
                IApprovalRecordItem approvalRecordItem;
                String activityId;
                List children;
                if (!WFGroupDecisionTypeEnum.TERMINATE.getType().equals(approvalRecord.getGroupDecisionType()) || CollectionUtils.isEmpty((Collection)(children = approvalRecord.getChildren())) || StringUtils.isEmpty((CharSequence)(activityId = (approvalRecordItem = (IApprovalRecordItem)children.get(0)).getActivityId())) || (flowNodeTemp = (WFFlowNode)activityMap.get(activityId)) == null || terminateActivitys.contains(activityIdLong = this.getActivityId(flowNodeTemp))) continue;
                terminateActivitys.add(activityIdLong);
            }
        }
        return terminateActivitys;
    }

    private Map<Long, Set<Long>> getAllActivityInfos(DynamicObject[] bills, WFFlowNode flowNode) {
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        HashMap terminateActivities = Maps.newHashMapWithExpectedSize((int)10);
        this.getALlFlowNodeWithMap(flowNode, activityMap);
        for (DynamicObject bill : bills) {
            List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)String.valueOf(bill.getPkValue()));
            LOG.info("WorkFlowManageApplicationService  allApprovalRecord:{}", (Object)SerializationUtils.toJsonString((Object)allApprovalRecord));
            HashSet approvalSet = Sets.newHashSetWithExpectedSize((int)allApprovalRecord.size());
            terminateActivities.put(bill.getLong("id"), approvalSet);
            for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
                Long activityIdLong;
                WFFlowNode flowNodeTemp;
                IApprovalRecordItem approvalRecordItem;
                String activityId;
                List children = approvalRecord.getChildren();
                if (CollectionUtils.isEmpty((Collection)children) || StringUtils.isEmpty((CharSequence)(activityId = (approvalRecordItem = (IApprovalRecordItem)children.get(0)).getActivityId())) || (flowNodeTemp = (WFFlowNode)activityMap.get(activityId)) == null || (activityIdLong = this.getActivityId(flowNodeTemp)) == 0L) continue;
                approvalSet.add(activityIdLong);
            }
        }
        return terminateActivities;
    }

    public Map<String, List<Map<String, String>>> getWaitingActivityInfosWithBills(DynamicObject[] bills) {
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return null;
        }
        WFFlowNode flowNode = this.getWFFlowNode(bills[0]);
        if (flowNode == null) {
            return null;
        }
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        this.getALlFlowNodeWithMap(flowNode, activityMap);
        HashMap<String, List<Map<String, String>>> waitingActivitysWithBills = new HashMap<String, List<Map<String, String>>>(16);
        for (DynamicObject bill : bills) {
            String billId = String.valueOf(bill.getPkValue());
            List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)billId);
            ArrayList waitingActivitys = new ArrayList(10);
            for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
                List children;
                if (!WFGroupDecisionTypeEnum.WAIT.getType().equals(approvalRecord.getGroupDecisionType()) || CollectionUtils.isEmpty((Collection)(children = approvalRecord.getChildren()))) continue;
                IApprovalRecordItem approvalRecordItem = (IApprovalRecordItem)children.get(0);
                String activityId = approvalRecordItem.getActivityId();
                WFFlowNode wfFlowNode = (WFFlowNode)activityMap.get(activityId);
                HashMap<String, String> waitingActivity = new HashMap<String, String>(16);
                waitingActivity.put("activityId", String.valueOf(this.getActivityId(wfFlowNode)));
                if (wfFlowNode instanceof WFUserTask) {
                    WFBillSetting billSetting = ((WFUserTask)wfFlowNode).getBillSetting();
                    waitingActivity.put("acitityBillId", billSetting.getId());
                    waitingActivity.put("activityBillNum", billSetting.getFormKey());
                }
                waitingActivitys.add(waitingActivity);
            }
            waitingActivitysWithBills.put(billId, waitingActivitys);
        }
        return waitingActivitysWithBills;
    }

    public List<Map<String, String>> getAllWaitingActivityInfos(DynamicObject[] bills) {
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return null;
        }
        WFFlowNode flowNode = this.getWFFlowNode(bills[0]);
        if (flowNode == null) {
            return null;
        }
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        this.getALlFlowNodeWithMap(flowNode, activityMap);
        ArrayList<Map<String, String>> waitingActivitys = new ArrayList<Map<String, String>>(10);
        for (DynamicObject bill : bills) {
            String billId = String.valueOf(bill.getPkValue());
            List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)billId);
            for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
                List children;
                if (!WFGroupDecisionTypeEnum.WAIT.getType().equals(approvalRecord.getGroupDecisionType()) || CollectionUtils.isEmpty((Collection)(children = approvalRecord.getChildren()))) continue;
                IApprovalRecordItem approvalRecordItem = (IApprovalRecordItem)children.get(0);
                String activityId = approvalRecordItem.getActivityId();
                WFFlowNode wfFlowNode = (WFFlowNode)activityMap.get(activityId);
                HashMap<String, String> waitingActivity = new HashMap<String, String>(16);
                waitingActivity.put("activityId", String.valueOf(this.getActivityId(wfFlowNode)));
                if (wfFlowNode instanceof WFUserTask) {
                    WFBillSetting billSetting = ((WFUserTask)wfFlowNode).getBillSetting();
                    waitingActivity.put("acitityBillId", billSetting.getId());
                    waitingActivity.put("activityBillNum", billSetting.getFormKey());
                }
                waitingActivitys.add(waitingActivity);
            }
        }
        return waitingActivitys;
    }

    public void getALlFlowNodeWithMap(WFFlowNode flowNode, Map<String, WFFlowNode> activityMap) {
        if (flowNode == null) {
            return;
        }
        String nodeId = this.getNodeId(flowNode);
        activityMap.put(nodeId, flowNode);
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getALlFlowNodeWithMap(wfFlowNode, activityMap);
        }
    }

    private void getALlFlowNodeIds(WFFlowNode flowNode, Map<String, Long> activityMap) {
        if (flowNode == null || ENDNONEEVENT.equals(flowNode.getType())) {
            return;
        }
        activityMap.put(flowNode.getId(), this.getActivityId(flowNode));
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getALlFlowNodeIds(wfFlowNode, activityMap);
        }
    }

    public Map<String, String> getTailActivityState(DynamicObject bill) {
        WFFlowNode flowNode = this.getWFFlowNode(bill);
        if (flowNode == null) {
            return null;
        }
        HashMap<String, WFFlowNode> activityMap = new HashMap<String, WFFlowNode>(16);
        List<Long> paramByActivityGroupIns = this.getParamByActivityGroupIns(bill);
        this.getEndNodeWithMap(flowNode, activityMap, paramByActivityGroupIns);
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)String.valueOf(bill.getPkValue()));
        HashMap<String, String> activityState = new HashMap<String, String>(16);
        activityMap.forEach((key, value) -> {
            boolean isExist = false;
            for (IApprovalRecordGroup iApprovalRecordGroup : allApprovalRecord) {
                List children = iApprovalRecordGroup.getChildren();
                if (CollectionUtils.isEmpty((Collection)children) || children.size() <= 1 || !StringUtils.equals((CharSequence)((IApprovalRecordItem)children.get(0)).getActivityId(), (CharSequence)key)) continue;
                isExist = true;
                activityState.put(String.valueOf(this.getActivityId((WFFlowNode)value)), WFGroupDecisionTypeEnum.getStatusByType(iApprovalRecordGroup.getGroupDecisionType()));
            }
            if (!isExist) {
                activityState.put(String.valueOf(this.getActivityId((WFFlowNode)value)), WFGroupDecisionTypeEnum.WILL_RUNNING.getStatus());
            }
        });
        return activityState;
    }

    public List<Long> getFrontActivitysWithGivenActivity(DynamicObject bill, Long activityId) {
        WFFlowNode flowNode = this.getWFFlowNode(bill);
        if (flowNode == null || activityId == null || activityId == 0L) {
            return null;
        }
        ArrayList<Long> activityList = new ArrayList<Long>(10);
        this.checkAndGetFrontActivitys(flowNode, activityId, activityList);
        return activityList;
    }

    public void removeSubmitAndGateWayNode(WFFlowNode flowNode) {
        if (ENDNONEEVENT.equals(flowNode.getType())) {
            return;
        }
        CopyOnWriteArrayList childNodes = new CopyOnWriteArrayList(flowNode.getNextNodes());
        for (WFFlowNode childNode : childNodes) {
            if (!USERTASK.equals(childNode.getType()) && !INCLUSIVEGATEWAY.equals(childNode.getType()) || INCLUSIVEGATEWAY.equals(childNode.getType()) && childNode.getNextNodes().size() > 1) continue;
            flowNode.getNextNodes().remove(childNode);
            flowNode.getNextNodes().addAll(childNode.getNextNodes());
        }
        for (WFFlowNode childNode : flowNode.getNextNodes()) {
            this.removeSubmitAndGateWayNode(childNode);
        }
    }

    public void resetFlowNodeStatusForConsistentProgress(WFFlowNode flowNode, List<Long> frontActivityIds) {
        if (flowNode == null || CollectionUtils.isEmpty(frontActivityIds)) {
            return;
        }
        if (HRACTIVITY.equals(flowNode.getType())) {
            List<Map<String, String>> nodeStatusInfo = this.getNodeStatusInfo(flowNode);
            for (Map<String, String> statusInfo : nodeStatusInfo) {
                boolean canModify = !CollectionUtils.isEmpty(frontActivityIds) && !frontActivityIds.contains(this.getActivityId(flowNode)) && (HRStringUtils.equals((String)statusInfo.get(STATUS), (String)WFGroupDecisionTypeEnum.WAIT.getStatus()) || HRStringUtils.equals((String)statusInfo.get(STATUS), (String)WFGroupDecisionTypeEnum.TERMINATE.getStatus()));
                if (!canModify) continue;
                statusInfo.put(STATUS, WFGroupDecisionTypeEnum.WILL_RUNNING.getStatus());
            }
        }
        for (WFFlowNode childNode : flowNode.getNextNodes()) {
            this.resetFlowNodeStatusForConsistentProgress(childNode, frontActivityIds);
        }
    }

    public void resetFlowNodeTerminateReason(WFFlowNode flowNode, DynamicObject appRemRegInfo) {
        if (flowNode == null) {
            return;
        }
        if (HRACTIVITY.equals(flowNode.getType())) {
            List<Map<String, String>> nodeStatusInfo = this.getNodeStatusInfo(flowNode);
            for (Map<String, String> statusInfo : nodeStatusInfo) {
                if (!HRStringUtils.equals((String)statusInfo.get(STATUS), (String)WFGroupDecisionTypeEnum.TERMINATE.getStatus()) || HRObjectUtils.isEmpty((Object)appRemRegInfo.get("terminationexplain"))) continue;
                statusInfo.put(RESULT, appRemRegInfo.getLocaleString("terminationexplain").getLocaleValue());
            }
        }
        for (WFFlowNode childNode : flowNode.getNextNodes()) {
            this.resetFlowNodeTerminateReason(childNode, appRemRegInfo);
        }
    }

    private boolean checkAndGetFrontActivitys(WFFlowNode flowNode, Long activityId, List<Long> activityList) {
        if (activityId.equals(this.getActivityId(flowNode))) {
            return true;
        }
        if (ENDNONEEVENT.equals(flowNode.getType())) {
            return false;
        }
        boolean isFront = false;
        for (WFFlowNode childNode : flowNode.getNextNodes()) {
            isFront = isFront || this.checkAndGetFrontActivitys(childNode, activityId, activityList);
        }
        if (isFront && this.getActivityId(flowNode) != 0L) {
            activityList.add(this.getActivityId(flowNode));
        }
        return isFront;
    }

    private WFFlowNode getWFFlowNode(DynamicObject dynamicObject) {
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        List processElements = WorkflowServiceHelper.getProcessElements((DynamicObject)dynamicObject, (String)SUBMIT);
        if (CollectionUtils.isEmpty((Collection)processElements) || processElements.get(0) == null) {
            return null;
        }
        return (WFFlowNode)processElements.get(0);
    }

    private void getEndNodeWithMap(WFFlowNode flowNode, Map<String, WFFlowNode> activityMap, List<Long> paramByActivityGroupIns) {
        boolean isEndNode;
        List nextNodes = flowNode.getNextNodes();
        String nodeId = this.getNodeId(flowNode);
        Long activityId = this.getActivityId(flowNode);
        boolean bl = isEndNode = !CollectionUtils.isEmpty((Collection)nextNodes) && nextNodes.size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)nextNodes.get(0)).getType()) && paramByActivityGroupIns.contains(activityId);
        if (isEndNode) {
            activityMap.put(nodeId, flowNode);
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getEndNodeWithMap(wfFlowNode, activityMap, paramByActivityGroupIns);
        }
    }

    private void getNodeList(WFFlowNode flowNode, Long activityId, Map<Long, WFFlowNode> nodeMap) {
        if (this.getActivityId(flowNode).equals(activityId)) {
            nodeMap.put(activityId, flowNode);
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getNodeList(wfFlowNode, activityId, nodeMap);
        }
    }

    private void getFollowNode(Map<Long, WFFlowNode> activityIds, List<Long> allActivityList, List<Long> followActivityList) {
        activityIds.forEach((nodeName, flowNode) -> {
            for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
                this.getSameNameList(wfFlowNode, allActivityList, followActivityList);
            }
        });
    }

    private void getSameNameList(WFFlowNode flowNode, List<Long> allActivityList, List<Long> followActivityList) {
        Long nodeActivityId = this.getActivityId(flowNode);
        if (allActivityList.contains(nodeActivityId)) {
            followActivityList.add(nodeActivityId);
            allActivityList.remove(nodeActivityId);
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getSameNameList(wfFlowNode, allActivityList, followActivityList);
        }
    }

    private Long getActivityId(WFFlowNode flowNode) {
        String type = flowNode.getType();
        if (HRStringUtils.equals((String)type, (String)HRACTIVITY)) {
            List customParams = flowNode.getCustomParams();
            WFCustomParam wfCustomParam = (WFCustomParam)customParams.get(0);
            if (wfCustomParam == null || StringUtils.isEmpty((CharSequence)wfCustomParam.getId())) {
                return 0L;
            }
            return Long.parseLong(wfCustomParam.getId());
        }
        return 0L;
    }

    private void mergeFlowNodeWithSameTypeRecursion(WFFlowNode parentFlowNode, List<WFFlowNode> wfFlowNodes) {
        if (CollectionUtils.isEmpty(wfFlowNodes) || wfFlowNodes.size() == 1) {
            return;
        }
        if (this.isAllSameActivitysAndMergeSameNode(wfFlowNodes)) {
            LOG.info("mergeFlowNodeWithSameTypeRecursion  isAllSameActivitysAndMergeSameNode");
            return;
        }
        String id = wfFlowNodes.get(0).getId();
        boolean isEqual = true;
        boolean isBranch = false;
        for (WFFlowNode wFFlowNode : wfFlowNodes) {
            if (!StringUtils.equals((CharSequence)id, (CharSequence)wFFlowNode.getId())) {
                isEqual = false;
                break;
            }
            if (wFFlowNode.getNextNodes().size() == 1) continue;
            isBranch = true;
        }
        if (isEqual) {
            List<Map<String, String>> nodeStatusInfo = this.getNodeStatusInfo(wfFlowNodes.get(0));
            for (WFFlowNode wfFlowNode3 : wfFlowNodes) {
                if (wfFlowNode3.equals(wfFlowNodes.get(0))) continue;
                List<Map<String, String>> statusInfo = this.getNodeStatusInfo(wfFlowNode3);
                nodeStatusInfo.addAll(statusInfo);
            }
            this.setNodeStatusInfo(wfFlowNodes.get(0), nodeStatusInfo);
            if (isBranch) {
                for (WFFlowNode wfFlowNode2 : wfFlowNodes) {
                    if (wfFlowNode2.equals(wfFlowNodes.get(0))) continue;
                    wfFlowNodes.get(0).getNextNodes().addAll(wfFlowNode2.getNextNodes());
                }
            } else {
                List<WFFlowNode> list = wfFlowNodes.stream().map(wfFlowNode -> (WFFlowNode)wfFlowNode.getNextNodes().get(0)).collect(Collectors.toList());
                this.mergeFlowNodeWithSameTypeRecursion(wfFlowNodes.get(0), list);
            }
        } else {
            for (WFFlowNode wFFlowNode : wfFlowNodes) {
                if (wFFlowNode.equals(wfFlowNodes.get(0)) || parentFlowNode == null) continue;
                parentFlowNode.getNextNodes().add(wFFlowNode);
            }
            if (parentFlowNode != null && !CollectionUtils.isEmpty((Collection)parentFlowNode.getNextNodes()) && parentFlowNode.getNextNodes().size() > 1) {
                parentFlowNode.getNextNodes().removeIf(wfFlowNode -> ENDNONEEVENT.equals(wfFlowNode.getType()));
            }
        }
    }

    private void setNodeStatusInfo(WFFlowNode wfFlowNode, List<Map<String, String>> statusInfo) {
        if (wfFlowNode.getExtProps().get(STATUSINFO) != null) {
            wfFlowNode.getExtProps().remove(STATUSINFO);
        }
        wfFlowNode.getExtProps().put(STATUSINFO, statusInfo);
    }

    private List<Map<String, String>> getNodeStatusInfo(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(STATUSINFO) != null) {
            List nodeInfo = (List)wfFlowNode.getExtProps().get(STATUSINFO);
            return nodeInfo;
        }
        return Lists.newArrayListWithExpectedSize((int)10);
    }

    private List<Long> getParamByActivityGroupIns(DynamicObject bill) {
        long billId = (Long)bill.getPkValue();
        ActivityGroupInsCommonService activityGroupInsCommonService = ServiceFactory.getService(ActivityGroupInsCommonService.class);
        DynamicObject runTimeActivity = activityGroupInsCommonService.queryActivityGroupInsById(billId);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        if (HRObjectUtils.isEmpty((Object)runTimeActivity)) {
            return result;
        }
        DynamicObjectCollection entryEntity = runTimeActivity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            String status = entry.getString(STATUS);
            if (!"1".equals(status)) continue;
            DynamicObject activity = entry.getDynamicObject("activity");
            result.add(activity.getLong("id"));
        }
        return result;
    }

    private String getNodeId(WFFlowNode wfFlowNode) {
        if (wfFlowNode == null) {
            return "";
        }
        return wfFlowNode.getId();
    }

    public boolean checkIsValueFlowNodeList(List<WFFlowNode> flowNodeList) {
        if (CollectionUtils.isEmpty(flowNodeList)) {
            return false;
        }
        for (WFFlowNode wfFlowNode : flowNodeList) {
            if (this.checkIsValueFlowNode(wfFlowNode)) continue;
            return false;
        }
        return true;
    }

    public boolean checkIsValueFlowNode(WFFlowNode flowNode) {
        if (flowNode == null) {
            return false;
        }
        if (HRACTIVITY.equals(flowNode.getType())) {
            return true;
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            if (!this.checkIsValueFlowNode(wfFlowNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSameActivitysAndMergeSameNode(List<WFFlowNode> wfFlowNodes) {
        if (CollectionUtils.isEmpty(wfFlowNodes)) {
            return false;
        }
        if (wfFlowNodes.size() == 1) {
            return true;
        }
        ArrayList<Map<String, List<Map<String, String>>>> listMap = new ArrayList<Map<String, List<Map<String, String>>>>(wfFlowNodes.size());
        for (WFFlowNode wfFlowNode : wfFlowNodes) {
            HashMap<String, List<Map<String, String>>> flowMap = new HashMap<String, List<Map<String, String>>>(16);
            this.getFlowNodeStatusInfo(wfFlowNode, flowMap);
            ArrayList flowNodeClassList = new ArrayList(1);
            HashMap<String, String> classMap = new HashMap<String, String>(1);
            classMap.put("classHashCode", String.valueOf(wfFlowNode.hashCode()));
            flowNodeClassList.add(classMap);
            flowMap.put("classHashCode", flowNodeClassList);
            listMap.add(flowMap);
        }
        Map<Set, List<Map>> setListMap = listMap.stream().collect(Collectors.groupingBy(Map::keySet));
        boolean isAllSame = false;
        ArrayList<WFFlowNode> needDeleteFlowNode = new ArrayList<WFFlowNode>(10);
        if (setListMap.size() == 1) {
            isAllSame = true;
            this.setFlowNodeStatusInfo(wfFlowNodes.get(0), listMap);
        } else if (setListMap.size() <= wfFlowNodes.size()) {
            for (Map.Entry<Set, List<Map>> entry : setListMap.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                WFFlowNode tempFlowNode = null;
                for (Map tempNodeMap : entry.getValue()) {
                    for (WFFlowNode wfFlowNode : wfFlowNodes) {
                        if (!String.valueOf(wfFlowNode.hashCode()).equals(((Map)((List)tempNodeMap.get("classHashCode")).get(0)).get("classHashCode"))) continue;
                        if (tempFlowNode == null) {
                            tempFlowNode = wfFlowNode;
                            continue;
                        }
                        needDeleteFlowNode.add(wfFlowNode);
                    }
                }
                this.setFlowNodeStatusInfo(tempFlowNode, entry.getValue());
            }
        }
        wfFlowNodes.removeAll(needDeleteFlowNode);
        return isAllSame;
    }

    private void getFlowNodeStatusInfo(WFFlowNode flowNode, Map<String, List<Map<String, String>>> nodeMap) {
        if (flowNode == null) {
            return;
        }
        if (HRACTIVITY.equals(flowNode.getType())) {
            nodeMap.put(flowNode.getId(), this.getNodeStatusInfo(flowNode));
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.getFlowNodeStatusInfo(wfFlowNode, nodeMap);
        }
    }

    private void setFlowNodeStatusInfo(WFFlowNode flowNode, List<Map<String, List<Map<String, String>>>> listMap) {
        if (flowNode == null) {
            return;
        }
        if (HRACTIVITY.equals(flowNode.getType())) {
            ArrayList<Map<String, String>> nodeStatusInfo = new ArrayList<Map<String, String>>(16);
            for (Map<String, List<Map<String, String>>> nodeMap : listMap) {
                nodeStatusInfo.addAll((Collection<Map<String, String>>)nodeMap.get(flowNode.getId()));
            }
            this.setNodeStatusInfo(flowNode, nodeStatusInfo);
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.setFlowNodeStatusInfo(wfFlowNode, listMap);
        }
    }

    public String getActivityRelationByBillsAndIds(DynamicObject[] bills, Long activityIdSource, Long activityIdTarget) {
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return "0";
        }
        ArrayList appObjects = Lists.newArrayList((Object[])bills);
        List wfFlowNodes = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWfQueryService", (String)"queryWFFlowNodes", (Object[])new Object[]{appObjects});
        if (CollectionUtils.isEmpty((Collection)wfFlowNodes)) {
            return "0";
        }
        for (WFFlowNode flowNode : wfFlowNodes) {
            HashMap<String, Long> activityMap = new HashMap<String, Long>(16);
            this.getALlFlowNodeIds(flowNode, activityMap);
            AtomicReference sourceFlowNode = new AtomicReference();
            AtomicReference targetFlowNode = new AtomicReference();
            HashMap<String, WFFlowNode> activityFlowNodeMap = new HashMap<String, WFFlowNode>(16);
            this.getALlFlowNodeWithMap(flowNode, activityFlowNodeMap);
            activityMap.forEach((key, value) -> {
                if (value.equals(activityIdSource)) {
                    sourceFlowNode.set(activityFlowNodeMap.get(key));
                }
                if (value.equals(activityIdTarget)) {
                    targetFlowNode.set(activityFlowNodeMap.get(key));
                }
            });
            if (sourceFlowNode.get() == null || targetFlowNode.get() == null) continue;
            if (this.containNodeWithActivityId((WFFlowNode)sourceFlowNode.get(), activityIdTarget)) {
                return "2";
            }
            if (this.containNodeWithActivityId((WFFlowNode)targetFlowNode.get(), activityIdSource)) {
                return "1";
            }
            return "3";
        }
        return "0";
    }

    private boolean containNodeWithActivityId(WFFlowNode flowNode, Long activityId) {
        if (flowNode == null || CollectionUtils.isEmpty((Collection)flowNode.getNextNodes()) || ENDNONEEVENT.equals(flowNode.getType())) {
            return false;
        }
        if (this.getActivityId(flowNode).equals(activityId)) {
            return true;
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            if (!this.containNodeWithActivityId(wfFlowNode, activityId)) continue;
            return true;
        }
        return false;
    }
}

