/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soecadm.business.servicehelper;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)TypesContainer.getOrRegisterSingletonInstance((String)clazz.getName());
    }

    public static <T> T getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"sihc-sdk-business", (Object[])new Object[0]), serviceName));
        }
        return (T)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    public static <T> List<T> getService() {
        Collection<String> values = SERVICE_MAP.values();
        return values.stream().map(className -> TypesContainer.getOrRegisterSingletonInstance((String)className)).collect(Collectors.toList());
    }
}

