/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soecadm.extpoint;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.sihc.soecadm.business.service.auth.AuthOrgService;
import kd.sdk.sihc.soecadm.common.ActivityBillCommConstants;
import kd.sdk.sihc.soecadm.enums.PostPatterEnum;
import kd.sdk.sihc.soecadm.extpoint.IGeneratePersonNameService;

@SdkPublic
public abstract class AbstractActivityBillCommonService {
    private static final Log logger = LogFactory.getLog(AbstractActivityBillCommonService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject assembleActivityBill(Long appremId, Long activityId, Long instanceId, int sla) {
        DynamicObject appremDyn = this.getAppremreg(appremId);
        Long appremregId = 0L;
        if (appremDyn != null) {
            appremregId = appremDyn.getLong("appremregid");
        }
        if (appremDyn == null || appremregId.equals(0L)) {
            logger.error("AbstractActivityBillCommonService.assembleActivityBill getAppremreg is null, appremId is {}", (Object)appremId);
            return null;
        }
        String entityNumber = this.getEntityNumber();
        String lockKey = entityNumber + activityId + appremregId;
        DLock dLock = DLock.create((String)lockKey);
        if (dLock.tryLock(ActivityBillCommConstants.MS_TIMEOUT.longValue())) {
            logger.info("AbstractActivityBillCommonService.assembleActivityBill lockKey is {}", (Object)lockKey);
            logger.info("AbstractActivityBillCommonService.assembleActivityBill dLock.getLock");
            TXHandle txHandle = TX.required();
            try {
                DynamicObject dynamicObject;
                DynamicObject activityBillDyn;
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                if (this.isMerge()) {
                    Boolean result;
                    QFilter appremregFilter = new QFilter("appremregid", "=", (Object)appremregId);
                    activityBillDyn = serviceHelper.loadDynamicObject(appremregFilter);
                    if (activityBillDyn == null) {
                        activityBillDyn = serviceHelper.generateEmptyDynamicObject();
                        this.initBaseCommonFields(activityBillDyn, appremDyn, activityId);
                    }
                    if (!(result = this.initPersonPositionEntry(activityBillDyn, appremDyn, instanceId)).booleanValue()) {
                        DynamicObject dynamicObject2 = null;
                        return dynamicObject2;
                    }
                    this.handlePositionName(activityBillDyn);
                    this.generateAuthEntry(activityBillDyn);
                } else {
                    QFilter appremIdFilter = new QFilter("appremid", "=", (Object)appremId);
                    DynamicObject existAppremDyn = serviceHelper.queryOne(new QFilter[]{appremIdFilter});
                    if (!HRObjectUtils.isEmpty((Object)existAppremDyn)) {
                        logger.info("AbstractActivityBillCommonService.existAppremDyn is exist{}", (Object)existAppremDyn.toString());
                        DynamicObject dynamicObject3 = null;
                        return dynamicObject3;
                    }
                    activityBillDyn = serviceHelper.generateEmptyDynamicObject();
                    this.initBaseCommonFields(activityBillDyn, appremDyn, activityId);
                    this.initPositionFields(activityBillDyn, appremDyn, instanceId);
                    this.handleActivityPosPositionName(appremDyn, activityBillDyn);
                }
                this.handleSLA(activityBillDyn, sla);
                this.generateBill(activityBillDyn);
                this.setBillNumber(activityBillDyn);
                this.setOperateStatus(activityBillDyn);
                Object result = serviceHelper.saveOne(activityBillDyn);
                if (result instanceof DynamicObject) {
                    dynamicObject = (DynamicObject)result;
                    return dynamicObject;
                }
                dynamicObject = null;
                return dynamicObject;
            }
            catch (Exception exception) {
                logger.error("AbstractActivityBillCommonService.assembleActivityBill error:", (Throwable)exception);
                txHandle.markRollback();
            }
            finally {
                logger.info("AbstractActivityBillCommonService.assembleActivityBill dLock.unlock");
                dLock.unlock();
                dLock.close();
                txHandle.close();
            }
        }
        return null;
    }

    private void handleActivityPosPositionName(DynamicObject appremDyn, DynamicObject activityBillDyn) {
        StringBuilder positionNameSB = new StringBuilder();
        this.generatePositionName(positionNameSB, activityBillDyn);
        String type = appremDyn.getString("appremtype");
        if (HRStringUtils.equals((String)type, (String)"1")) {
            activityBillDyn.set("apositionname", (Object)positionNameSB.toString());
        } else {
            activityBillDyn.set("rpositionname", (Object)positionNameSB.toString());
        }
        PluginProxy pluginProxy = PluginProxy.create(null, IGeneratePersonNameService.class, (String)"kd.sdk.sihc.soecadm.extpoint.IGeneratePersonNameService#handleActivityPosPositionName");
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                plugin.handleActivityPosPositionName(appremDyn, activityBillDyn);
            }
            return null;
        });
    }

    public void updatePersonPosition(Long appremregId, DynamicObjectCollection entryColl) {
        QFilter idFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityNumber());
        DynamicObject activityBill = serviceHelper.loadDynamicObject(idFilter = new QFilter("appremregid", "=", (Object)appremregId));
        if (activityBill == null) {
            return;
        }
        if (this.isMerge()) {
            DynamicObjectCollection positionEntryColl = activityBill.getDynamicObjectCollection("perpositionentity");
            Map<Long, DynamicObject> collect = entryColl.stream().collect(Collectors.toMap(entry -> entry.getLong("instanceid"), entry -> entry));
            Set<Long> ids = collect.keySet();
            for (DynamicObject entry2 : positionEntryColl) {
                Long id = entry2.getLong("instanceid");
                if (!ids.contains(id)) continue;
                DynamicObject from = collect.get(id);
                entry2.set("stposition", from.get("stposition"));
                entry2.set("position", from.get("position"));
                entry2.set("job", from.get("job"));
                entry2.set("ismainpost", from.get("ismainpost"));
                entry2.set("company", from.get("company"));
                entry2.set("adminorg", from.get("adminorg"));
                entry2.set("joblevel", from.get("joblevel"));
                entry2.set("jobgrade", from.get("jobgrade"));
            }
            this.generateAuthEntry(activityBill);
            this.handlePositionName(activityBill);
        }
        serviceHelper.saveOne(activityBill);
    }

    public void updateActivityStatus(DynamicObject[] dynamicObjects) {
        String entityNumber = this.getEntityNumber();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            logger.info("AbstractActivityBillCommonService.updateActivityStatus no data - entityNumber : {}", (Object)entityNumber);
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("activitystatus", (Object)"2");
            if (dynamicObject.containsProperty("modifier")) {
                dynamicObject.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            }
            if (!dynamicObject.containsProperty("modifytime")) continue;
            dynamicObject.set("modifytime", (Object)new Date());
        }
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityNumber);
        serviceHelper.save(dynamicObjects);
        logger.info("AbstractActivityBillCommonService.updateActivityStatus end - entityNumber : {}", (Object)entityNumber);
    }

    public void batchTerminateTask(List<Long> appremregIds) {
        DynamicObject[] dynamicObjects = this.queryProceActivityByAppRemRegIds(appremregIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        List<Long> taskIds = this.getTaskIdsByDos(dynamicObjects);
        if (taskIds != null && !taskIds.isEmpty()) {
            logger.info("AbstractActivityBillCommonService.batchTerminateTask - taskIds: {}", taskIds);
            OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchTerminateTask", (Object[])new Object[]{taskIds, ""});
            logger.info("AbstractActivityBillCommonService.batchTerminateTask - result: {}", (Object)result.isSuccess());
            this.stop(appremregIds);
        }
    }

    private List<Long> getTaskIdsByDos(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> taskIds = new ArrayList(dynamicObjects.length);
        boolean isMerge = this.isMerge();
        if (isMerge) {
            for (DynamicObject activityObj : dynamicObjects) {
                DynamicObjectCollection perPositionEntity = activityObj.getDynamicObjectCollection("perpositionentity");
                List instanceIds = perPositionEntity.stream().map(obj -> obj.getLong("instanceid")).collect(Collectors.toList());
                if (instanceIds == null || instanceIds.isEmpty()) continue;
                taskIds.addAll(instanceIds);
            }
        } else {
            taskIds = Arrays.stream(dynamicObjects).map(obj -> obj.getLong("instanceid")).collect(Collectors.toList());
        }
        return taskIds;
    }

    public DynamicObject[] queryProceActivityByAppRemRegIds(List<Long> appremregIds) {
        String entityNumber = this.getEntityNumber();
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityNumber);
        QFilter idQF = new QFilter("appremregid", "in", appremregIds);
        ArrayList<String> statusList = new ArrayList<String>(2);
        statusList.add("1");
        statusList.add("2");
        QFilter statusQF = new QFilter("activitystatus", "not in", statusList);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{idQF, statusQF});
        logger.info("AbstractActivityBillCommonService.queryProceActivityByAppRemRegIds - entityNumber : {} , data.length : {}", (Object)entityNumber, (Object)dynamicObjects.length);
        return dynamicObjects;
    }

    public void stop(List<Long> appremregIds) {
        DynamicObject[] dynamicObjects = this.queryProceActivityByAppRemRegIds(appremregIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        this.updateActivityStatus(dynamicObjects);
    }

    protected abstract void generateBill(DynamicObject var1);

    protected abstract boolean isMerge();

    protected abstract String getEntityNumber();

    private void initBaseCommonFields(DynamicObject activityBillDyn, DynamicObject appremDyn, Long activityId) {
        HRDynamicObjectUtils.copy((DynamicObject)appremDyn, (DynamicObject)activityBillDyn, this.getIngoreKeys());
        activityBillDyn.set("billstatus", (Object)"A");
        activityBillDyn.set("auditstatus", (Object)"A");
        Date date = new Date();
        activityBillDyn.set("createtime", (Object)date);
        Long appremregId = appremDyn.getLong("appremregid");
        activityBillDyn.set("appremregid", (Object)appremregId);
        activityBillDyn.set("activitystatus", (Object)"0");
        activityBillDyn.set("activityid", (Object)activityId);
        DynamicObject appremer = activityBillDyn.getDynamicObject("appremper");
        DynamicObject person = appremer.getDynamicObject("person");
        if (!HRObjectUtils.isEmpty((Object)person)) {
            activityBillDyn.set("person", (Object)person);
            activityBillDyn.set("fullnumber", person.get("number"));
        }
        activityBillDyn.set("fullname", appremer.get("name"));
    }

    private Boolean initPersonPositionEntry(DynamicObject activityBillDyn, DynamicObject appremDyn, Long instanceId) {
        DynamicObjectCollection positionEntry = activityBillDyn.getDynamicObjectCollection("perpositionentity");
        for (DynamicObject entry : positionEntry) {
            Long entryInstanceId = entry.getLong("instanceid");
            if (!instanceId.equals(entryInstanceId)) continue;
            return Boolean.FALSE;
        }
        DynamicObject personPersonDyn = positionEntry.addNew();
        HRDynamicObjectUtils.copy((DynamicObject)appremDyn, (DynamicObject)personPersonDyn);
        personPersonDyn.set("adminorg", appremDyn.get("department"));
        personPersonDyn.set("appremid", (Object)appremDyn.getLong("id"));
        personPersonDyn.set("entryappremregid", (Object)appremDyn.getLong("appremregid"));
        personPersonDyn.set("instanceid", (Object)instanceId);
        return Boolean.TRUE;
    }

    private void initPositionFields(DynamicObject activityBillDyn, DynamicObject appremDyn, Long instanceId) {
        HRDynamicObjectUtils.copy((DynamicObject)appremDyn, (DynamicObject)activityBillDyn, this.getIngoreKeys());
        activityBillDyn.set("adminorg", appremDyn.get("department"));
        activityBillDyn.set("instanceid", (Object)instanceId);
        activityBillDyn.set("appremid", (Object)appremDyn.getLong("id"));
        activityBillDyn.set("appremregid", (Object)appremDyn.getLong("appremregid"));
    }

    private void handleSLA(DynamicObject activityBillDyn, int sla) {
        Date deadline = HRDateTimeUtils.addHour((Date)activityBillDyn.getDate("createtime"), (long)sla);
        activityBillDyn.set("endtime", (Object)deadline);
    }

    public void generateAuthEntry(DynamicObject activityBillDyn) {
        AuthOrgService authOrgService = new AuthOrgService();
        authOrgService.handleActivityAuthEntry(activityBillDyn);
    }

    private void setOperateStatus(DynamicObject activityBillDyn) {
        activityBillDyn.set("operatestatus", (Object)"0");
    }

    public void handlePositionName(DynamicObject activityBillDyn) {
        DynamicObjectCollection positionColl = activityBillDyn.getDynamicObjectCollection("perpositionentity");
        logger.info("AbstractActivityBillCommonService.handlePositionName positionColl size is {}", (Object)positionColl.size());
        StringBuilder aPositionNameSB = new StringBuilder();
        StringBuilder rPositionNameSB = new StringBuilder();
        HashMap aPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap rPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        String cadreCategoryName = null;
        for (DynamicObject position : positionColl) {
            DynamicObject appointtype = position.getDynamicObject("appointtype");
            if (HRObjectUtils.isEmpty((Object)appointtype)) {
                logger.error("AbstractActivityBillCommonService.handlePositionName appointtype is empty");
                continue;
            }
            Long typeId = appointtype.getLong("group.id");
            if (ActivityBillCommConstants.TYPE_ID_APPOINT.equals(typeId)) {
                DynamicObject cadreCategory;
                String appremMethod = activityBillDyn.getString("appremmethod");
                if (HRStringUtils.equals((String)appremMethod, (String)"0") && (cadreCategory = position.getDynamicObject("cadrecategory")) != null) {
                    cadreCategoryName = cadreCategory.getString("name");
                }
                this.generatePositionMap(aPositionMap, position);
                continue;
            }
            if (!ActivityBillCommConstants.TYPE_ID_REMOVE.equals(typeId)) continue;
            this.generatePositionMap(rPositionMap, position);
        }
        this.generatePositionNameSB(aPositionMap, aPositionNameSB);
        this.generatePositionNameSB(rPositionMap, rPositionNameSB);
        if (HRStringUtils.isEmpty((String)aPositionNameSB.toString()) && !HRStringUtils.isEmpty(cadreCategoryName)) {
            DynamicObject positionEntry = (DynamicObject)positionColl.get(0);
            this.appendValue(positionEntry.getString("company.name"), aPositionNameSB);
            this.appendValue(positionEntry.getString("adminorg.name"), aPositionNameSB);
            this.appendValue(positionEntry.getString("job.name"), aPositionNameSB);
            this.appendValue(positionEntry.getString("position.name"), aPositionNameSB);
            aPositionNameSB.append(cadreCategoryName);
        }
        activityBillDyn.set("apositionname", (Object)HRStringUtils.substringBeforeLast((String)aPositionNameSB.toString(), (String)"\uff0c"));
        activityBillDyn.set("rpositionname", (Object)HRStringUtils.substringBeforeLast((String)rPositionNameSB.toString(), (String)"\uff0c"));
        PluginProxy pluginProxy = PluginProxy.create(null, IGeneratePersonNameService.class, (String)"kd.sdk.sihc.soecadm.extpoint.IGeneratePersonNameService#handleActivityPositionName");
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                plugin.handleActivityPositionName(activityBillDyn);
            }
            return null;
        });
    }

    private void appendValue(String value, StringBuilder sb) {
        if (!HRStringUtils.isEmpty((String)value)) {
            sb.append(value);
        }
    }

    private void generatePositionNameSB(Map<String, Map<String, String>> positionMap, StringBuilder positionNameSB) {
        positionMap.forEach((company, adminOrgMap) -> {
            positionNameSB.append((String)company);
            StringBuilder positionSB = new StringBuilder();
            if (adminOrgMap != null) {
                adminOrgMap.forEach((adminorg, position) -> {
                    positionSB.append((String)adminorg);
                    if (HRStringUtils.isNotEmpty((String)position)) {
                        positionSB.append(HRStringUtils.substringBeforeLast((String)position, (String)"\u3001"));
                    }
                    positionSB.append("\u3001");
                });
            }
            positionNameSB.append(HRStringUtils.substringBeforeLast((String)positionSB.toString(), (String)"\u3001")).append("\uff0c");
        });
    }

    private void generatePositionMap(Map<String, Map<String, String>> positionMap, DynamicObject positionEntry) {
        String company = positionEntry.getString("company.name");
        String adminorg = positionEntry.getString("adminorg.name");
        if (HRStringUtils.isEmpty((String)company) || HRStringUtils.isEmpty((String)adminorg)) {
            StringBuilder positionNameSB = new StringBuilder();
            this.appendValue(positionEntry.getString("adminorg.name"), positionNameSB);
            this.appendValue(positionEntry.getString("job.name"), positionNameSB);
            this.appendValue(positionEntry.getString("position.name"), positionNameSB);
            DynamicObject cadreCategory = positionEntry.getDynamicObject("cadrecategory");
            if (positionNameSB.length() > 0 && cadreCategory != null) {
                positionNameSB.append("(").append(cadreCategory.getString("name")).append(")");
            } else if (!HRStringUtils.isEmpty((String)company) && cadreCategory != null) {
                positionNameSB.append("(").append(cadreCategory.getString("name")).append(")");
            } else if (cadreCategory != null) {
                positionNameSB.append(cadreCategory.getString("name"));
            }
            if (HRStringUtils.isNotEmpty((String)company)) {
                Set<String> companySet = positionMap.keySet();
                Map<Object, Object> adminOrgMap = Maps.newHashMapWithExpectedSize((int)16);
                if (companySet.contains(company)) {
                    adminOrgMap = positionMap.get(company);
                }
                adminOrgMap.put(positionNameSB.toString(), null);
                positionMap.put(company, adminOrgMap);
            } else {
                positionMap.put(positionNameSB.toString(), null);
            }
            return;
        }
        Set<String> companySet = positionMap.keySet();
        Map<Object, Object> adminOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        if (companySet.contains(company)) {
            adminOrgMap = positionMap.get(company);
        }
        Set adminOrgSet = adminOrgMap.keySet();
        StringBuilder positionNameSB = new StringBuilder();
        if (adminOrgSet.contains(adminorg)) {
            positionNameSB = new StringBuilder((String)adminOrgMap.get(adminorg));
        }
        DynamicObject job = positionEntry.getDynamicObject("job");
        DynamicObject position = positionEntry.getDynamicObject("position");
        DynamicObject stdPosition = positionEntry.getDynamicObject("stposition");
        String postPattern = positionEntry.getString("postpattern");
        if (HRStringUtils.isEmpty((String)postPattern)) {
            logger.info("AbstractActivityBillCommonService.generatePositionName postPattern is empty");
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.JOB.getNumber()) && !HRObjectUtils.isEmpty((Object)job)) {
            positionNameSB.append(job.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.STDPOSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)stdPosition)) {
            positionNameSB.append(stdPosition.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.POSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)position)) {
            positionNameSB.append(position.getString("name"));
        } else {
            logger.info("AbstractActivityBillCommonService.generatePositionName job,position,stdposition all is empty");
        }
        DynamicObject cadreCategory = positionEntry.getDynamicObject("cadrecategory");
        if (cadreCategory != null) {
            positionNameSB.append("(").append(cadreCategory.getString("name")).append(")");
        }
        positionNameSB.append("\u3001");
        adminOrgMap.put(adminorg, positionNameSB.toString());
        positionMap.put(company, adminOrgMap);
    }

    public void generatePositionName(StringBuilder positionNameSB, DynamicObject positionEntry) {
        String company = positionEntry.getString("company.name");
        String adminorg = positionEntry.containsProperty("adminorg") ? positionEntry.getString("adminorg.name") : positionEntry.getString("department.name");
        DynamicObject job = positionEntry.getDynamicObject("job");
        DynamicObject position = positionEntry.getDynamicObject("position");
        DynamicObject stdPosition = positionEntry.getDynamicObject("stposition");
        DynamicObject cadreCategory = positionEntry.getDynamicObject("cadrecategory");
        String postPattern = positionEntry.getString("postpattern");
        if (HRStringUtils.isEmpty((String)postPattern)) {
            logger.info("AbstractActivityBillCommonService.generatePositionName postPattern is empty");
            if (cadreCategory != null) {
                positionNameSB.append(cadreCategory.getString("name"));
            }
            return;
        }
        if (!HRStringUtils.isEmpty((String)company)) {
            positionNameSB.append(company);
        }
        if (!HRStringUtils.isEmpty((String)adminorg)) {
            positionNameSB.append(adminorg);
        }
        if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.JOB.getNumber()) && !HRObjectUtils.isEmpty((Object)job)) {
            positionNameSB.append(job.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.STDPOSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)stdPosition)) {
            positionNameSB.append(stdPosition.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.POSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)position)) {
            positionNameSB.append(position.getString("name"));
        } else {
            logger.error("AbstractActivityBillCommonService.generatePositionName job,position,stdposition all is empty");
        }
        if (cadreCategory != null) {
            positionNameSB.append("(").append(cadreCategory.getString("name")).append(")");
        }
    }

    private Set<String> getIngoreKeys() {
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)16);
        keySet.add("billno");
        keySet.add("billstatus");
        keySet.add("auditstatus");
        keySet.add("createtime");
        keySet.add("creator");
        keySet.add("modifytime");
        keySet.add("modifier");
        keySet.add("auditor");
        keySet.add("auditdate");
        return keySet;
    }

    private void setBillNumber(DynamicObject activityBillDyn) {
        String entityNumber = this.getEntityNumber();
        String number = CodeRuleServiceHelper.getNumber((String)entityNumber, (DynamicObject)activityBillDyn, null);
        if (HRStringUtils.isEmpty((String)number)) {
            logger.info("AbstractActivityBillCommonService.setBillNumber number is empty");
            number = "act" + activityBillDyn.getDate("createtime").getTime();
        }
        activityBillDyn.set("billno", (Object)number);
    }

    private DynamicObject getAppremreg(Long appremId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("soecadm_apprem");
        return serviceHelper.loadSingle((Object)appremId);
    }

    public void generatePositionNameFromDispMainInfo(StringBuilder positionNameSB, DynamicObject dispMainInfo) {
        String company = dispMainInfo.getString("company.name");
        String adminorg = dispMainInfo.getString("adminorg.name");
        DynamicObject job = dispMainInfo.getDynamicObject("job");
        DynamicObject position = dispMainInfo.getDynamicObject("position");
        DynamicObject stdPosition = dispMainInfo.getDynamicObject("stposition");
        DynamicObject cadreCategory = dispMainInfo.getDynamicObject("cadrecategory");
        String postPattern = dispMainInfo.getString("postpattern");
        if (HRStringUtils.isEmpty((String)postPattern)) {
            logger.info("AbstractActivityBillCommonService.generatePositionName postPattern is empty");
            if (cadreCategory != null) {
                positionNameSB.append(cadreCategory.getString("name"));
            }
            return;
        }
        positionNameSB.append(company).append(adminorg);
        if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.JOB.getNumber()) && !HRObjectUtils.isEmpty((Object)job)) {
            positionNameSB.append(job.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.STDPOSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)stdPosition)) {
            positionNameSB.append(stdPosition.getString("name"));
        } else if (HRStringUtils.equals((String)postPattern, (String)PostPatterEnum.POSITION.getNumber()) && !HRObjectUtils.isEmpty((Object)position)) {
            positionNameSB.append(position.getString("name"));
        } else {
            logger.error("AbstractActivityBillCommonService.generatePositionName job,position,stdposition all is empty");
        }
        if (cadreCategory != null) {
            positionNameSB.append(cadreCategory.getString("name"));
        }
    }

    public void handlePositionName4Appremcoll(DynamicObject positionColl) {
        StringBuilder aPositionNameSB = new StringBuilder();
        StringBuilder rPositionNameSB = new StringBuilder();
        HashMap aPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap rPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        String cadreCategoryName = null;
        DynamicObject appointtype = positionColl.getDynamicObject("appointtype");
        if (HRObjectUtils.isEmpty((Object)appointtype)) {
            logger.error("AbstractActivityBillCommonService.handlePositionName appointtype is empty");
            return;
        }
        Long typeId = appointtype.getLong("group.id");
        if (ActivityBillCommConstants.TYPE_ID_APPOINT.equals(typeId)) {
            DynamicObject cadreCategory;
            String appremMethod = positionColl.getString("appremmethod");
            if (HRStringUtils.equals((String)appremMethod, (String)"0") && (cadreCategory = positionColl.getDynamicObject("cadrecategory")) != null) {
                cadreCategoryName = cadreCategory.getString("name");
            }
            this.generatePositionMap(aPositionMap, positionColl);
        } else if (ActivityBillCommConstants.TYPE_ID_REMOVE.equals(typeId)) {
            this.generatePositionMap(rPositionMap, positionColl);
        }
        this.generatePositionNameSB(aPositionMap, aPositionNameSB);
        this.generatePositionNameSB(rPositionMap, rPositionNameSB);
        if (HRStringUtils.isEmpty((String)aPositionNameSB.toString()) && !HRStringUtils.isEmpty((String)cadreCategoryName)) {
            this.appendValue(positionColl.getString("company.name"), aPositionNameSB);
            this.appendValue(positionColl.getString("adminorg.name"), aPositionNameSB);
            this.appendValue(positionColl.getString("job.name"), aPositionNameSB);
            this.appendValue(positionColl.getString("position.name"), aPositionNameSB);
            aPositionNameSB.append(cadreCategoryName);
        }
        positionColl.set("apositionname", (Object)HRStringUtils.substringBeforeLast((String)aPositionNameSB.toString(), (String)"\uff0c"));
        positionColl.set("rpositionname", (Object)HRStringUtils.substringBeforeLast((String)rPositionNameSB.toString(), (String)"\uff0c"));
        PluginProxy pluginProxy = PluginProxy.create(null, IGeneratePersonNameService.class, (String)"kd.sdk.sihc.soecadm.extpoint.IGeneratePersonNameService#handleActivityPositionName");
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                plugin.handleActivityPositionName(positionColl);
            }
            return null;
        });
    }
}

