/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.business.spread.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.BorderTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.CellStyle;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.properties.SpreadProperties;
import org.apache.commons.lang3.tuple.Pair;

public class BorderHlStyleCommand
extends SpreadCommand<Pair<RptAreaConf, List<List<Cell>>>> {
    @Override
    public Object getParameters() {
        HashMap results = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList params = Lists.newArrayListWithExpectedSize((int)10);
        results.put(SpreadProperties.SetCellStyleMethod.DATA.k(), params);
        Pair pair = (Pair)this.initParam;
        RptAreaConf areaConf = (RptAreaConf)pair.getLeft();
        List areas = (List)pair.getRight();
        for (int row = 0; row < areas.size(); ++row) {
            List cols = (List)areas.get(row);
            params.addAll(this.getCellStyleParam(cols, row, areas.size() - 1, areaConf));
        }
        results.put(SpreadProperties.SetSelectionsMethod.SI.k(), areaConf.getSi());
        return results;
    }

    private List<Map<String, Object>> getCellStyleParam(List<Cell> cols, int row, int endRow, RptAreaConf areaConf) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)cols.size());
        boolean isReLoad = areaConf.getAreaSettingEnum() == AreaSettingEnum.CLEAR;
        for (int col = 0; col < cols.size(); ++col) {
            Cell cell = cols.get(col);
            CellStyle cellStyle = cell.getCellStyle();
            if (Objects.isNull(cellStyle)) {
                cellStyle = new CellStyle();
                String emptyType = BorderTypeEnum.EMPTY.getType();
                cellStyle.setBorderStyles(new String[]{emptyType, emptyType, emptyType, emptyType});
                cellStyle.setBorderColors(new String[]{"#00000000", "#00000000", "#00000000", "#00000000"});
            }
            String[] borderStyles = new String[4];
            String[] borderColors = new String[4];
            boolean isAdd = false;
            if (isReLoad) {
                borderStyles = cellStyle.getBorderStyles();
                borderColors = cellStyle.getBorderColors();
            }
            if (row == 0) {
                if (!isReLoad) {
                    borderStyles = new String[]{areaConf.getHighlightBdStyle(), cellStyle.getRBorderStyle(), cellStyle.getBBorderStyle(), cellStyle.getLBorderStyle()};
                    borderColors = new String[]{areaConf.getBdHlColor(), cellStyle.getRBorderColor(), cellStyle.getBBorderColor(), cellStyle.getLBorderColor()};
                }
                isAdd = true;
            }
            if (col == 0) {
                if (!isReLoad) {
                    if (isAdd) {
                        borderStyles[3] = areaConf.getHighlightBdStyle();
                        borderColors[3] = areaConf.getBdHlColor();
                    } else {
                        borderStyles = new String[]{cellStyle.getTBorderStyle(), cellStyle.getRBorderStyle(), cellStyle.getBBorderStyle(), areaConf.getHighlightBdStyle()};
                        borderColors = new String[]{cellStyle.getTBorderColor(), cellStyle.getRBorderColor(), cellStyle.getBBorderColor(), areaConf.getBdHlColor()};
                    }
                }
                isAdd = true;
            }
            if (col == cols.size() - 1) {
                if (!isReLoad) {
                    if (isAdd) {
                        borderStyles[1] = areaConf.getHighlightBdStyle();
                        borderColors[1] = areaConf.getBdHlColor();
                    } else {
                        borderStyles = new String[]{cellStyle.getTBorderStyle(), areaConf.getHighlightBdStyle(), cellStyle.getBBorderStyle(), cellStyle.getLBorderColor()};
                        borderColors = new String[]{cellStyle.getTBorderColor(), areaConf.getBdHlColor(), cellStyle.getBBorderColor(), cellStyle.getLBorderColor()};
                    }
                }
                isAdd = true;
            }
            if (row == endRow) {
                if (!isReLoad) {
                    if (isAdd) {
                        borderStyles[2] = areaConf.getHighlightBdStyle();
                        borderColors[2] = areaConf.getBdHlColor();
                    } else {
                        borderStyles = new String[]{cellStyle.getTBorderStyle(), cellStyle.getRBorderStyle(), areaConf.getHighlightBdStyle(), cellStyle.getLBorderStyle()};
                        borderColors = new String[]{cellStyle.getTBorderColor(), cellStyle.getRBorderColor(), areaConf.getBdHlColor(), cellStyle.getLBorderColor()};
                    }
                }
                isAdd = true;
            }
            if (!isAdd) continue;
            Map<String, Object> features = this.addBorderStyleColor(cell, borderStyles, borderColors);
            result.add(features);
        }
        return result;
    }

    private Map<String, Object> addBorderStyleColor(Cell cell, String[] borderStyles, String[] borderColors) {
        Map<String, Object> features = this.getRangeFeatures(cell);
        HashMap styleParam = Maps.newHashMapWithExpectedSize((int)1);
        HashMap style = Maps.newHashMapWithExpectedSize((int)1);
        styleParam.put(SpreadProperties.SetCellStyleMethod.BORDERSTYLE.k(), borderStyles);
        styleParam.put(SpreadProperties.SetCellStyleMethod.BORDERCOLOR.k(), borderColors);
        style.put(SpreadProperties.SetCellStyleMethod.BORDER.k(), styleParam);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), style);
        return features;
    }

    private Map<String, Object> getRangeFeatures(Cell cell) {
        HashMap features = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList rangeList = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, Object> rangeMap = SpreadCommandHelper.getRangeMap(cell);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        return features;
    }

    @Override
    public String getMethodName() {
        return SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k();
    }

    public BorderHlStyleCommand(Pair<RptAreaConf, List<List<Cell>>> cells) {
        this.initParam = cells;
    }
}

