/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.business.spread.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCusToolBarHelper;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.CusToolBarEnum;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.SpreadSetToolParam;
import kd.sdk.sihc.soehrr.common.spread.properties.SpreadProperties;
import kd.sdk.sihc.soehrr.common.spread.toolbar.ToolBar;
import kd.sdk.sihc.soehrr.common.spread.toolbar.ToolBarGroup;
import kd.sdk.sihc.soehrr.common.spread.toolbar.ToolCusBar;
import kd.sdk.sihc.soehrr.common.spread.toolbar.ToolCusBarItem;

public class SetToolbarGroupsCommand
extends SpreadCommand<SpreadSetToolParam> {
    @Override
    public Object getParameters() {
        ArrayList barGroups = Lists.newArrayListWithExpectedSize((int)10);
        ToolBarGroup toolBarGroup = new ToolBarGroup();
        toolBarGroup.setKey("default");
        toolBarGroup.setName(ResManager.loadKDString((String)"\u5206\u7ec40", (String)"SetToolbarGroupsCommand_0", (String)"sihc-soehrr-common", (Object[])new Object[0]));
        if (HRStringUtils.equals((String)((SpreadSetToolParam)this.initParam).getCollectType(), (String)CollectTypeEnum.SUM.getType())) {
            toolBarGroup.setToolbarItems(this.getFillBarTotal());
        } else {
            toolBarGroup.setToolbarItems(this.getFillBarList());
        }
        barGroups.add(toolBarGroup);
        return barGroups;
    }

    private List<Object> getFillBarTotal() {
        ArrayList<Object> toolbarItems = new ArrayList<Object>(30);
        ToolCusBar btnFillArea = new ToolCusBar();
        btnFillArea.setKey(CusToolBarEnum.FILL_AREA.getKey());
        btnFillArea.setIcon(CusToolBarEnum.FILL_AREA.getIcon());
        btnFillArea.setTitle(CusToolBarEnum.FILL_AREA.getTitle());
        btnFillArea.setCallback("invokeAction");
        btnFillArea.setInvokeAction(CallBackEnum.FILL_AREA.getM());
        btnFillArea.setDropDownType(1);
        String rptType = ((SpreadSetToolParam)this.initParam).getRptType();
        if (HRStringUtils.equals((String)rptType, (String)RptTypeEnum.STATISTICS.getType())) {
            btnFillArea.setItems(Arrays.asList(SpreadCusToolBarHelper.fillArea(), SpreadCusToolBarHelper.lastPeriodNumArea(), SpreadCusToolBarHelper.lastYearNumArea(), SpreadCusToolBarHelper.lockArea()));
        }
        toolbarItems.addAll(Arrays.asList(btnFillArea, SpreadCusToolBarHelper.clearArea(), new ToolBar("Separator")));
        this.loadCheckAndQuery(toolbarItems);
        return toolbarItems;
    }

    private List<Object> getFillBarList() {
        ArrayList<Object> toolbarItems = new ArrayList<Object>(30);
        ToolCusBar groupFill = new ToolCusBar();
        groupFill.setKey(CusToolBarEnum.DYNAMIC_LIST_AREA.getKey());
        groupFill.setIcon(CusToolBarEnum.DYNAMIC_LIST_AREA.getIcon());
        groupFill.setTitle(CusToolBarEnum.DYNAMIC_LIST_AREA.getTitle());
        groupFill.setCallback("invokeAction");
        groupFill.setInvokeAction(CallBackEnum.DYNAMIC_LIST_AREA.getM());
        groupFill.setDropDownType(1);
        String rptType = ((SpreadSetToolParam)this.initParam).getRptType();
        if (HRStringUtils.equals((String)rptType, (String)RptTypeEnum.STATISTICS.getType())) {
            groupFill.setItems(Arrays.asList(SpreadCusToolBarHelper.dynamicListArea(), SpreadCusToolBarHelper.lastPeriodNumArea(), SpreadCusToolBarHelper.lastYearNumArea(), SpreadCusToolBarHelper.listSummaryArea()));
        }
        toolbarItems.addAll(Arrays.asList(groupFill, SpreadCusToolBarHelper.clearArea(), new ToolBar("Separator")));
        this.loadCheckAndQuery(toolbarItems);
        return toolbarItems;
    }

    private void loadCheckAndQuery(List<Object> toolbarItems) {
        String rptType = ((SpreadSetToolParam)this.initParam).getRptType();
        if (HRStringUtils.equals((String)rptType, (String)RptTypeEnum.STATISTICS.getType())) {
            ToolCusBar checkToolCusBar = new ToolCusBar();
            checkToolCusBar.setKey(CusToolBarEnum.DATA_CHECK.getKey());
            checkToolCusBar.setTitle(CusToolBarEnum.DATA_CHECK.getTitle());
            checkToolCusBar.setIcon(CusToolBarEnum.DATA_CHECK.getIcon());
            checkToolCusBar.setCallback("invokeAction");
            checkToolCusBar.setInvokeAction(CallBackEnum.DATA_CHECK.getM());
            checkToolCusBar.setDropDownType(1);
            checkToolCusBar.setItems(Lists.newArrayList((Object[])new ToolCusBarItem[]{SpreadCusToolBarHelper.dataCheck(), SpreadCusToolBarHelper.delDataCheck()}));
            toolbarItems.add(checkToolCusBar);
        } else {
            toolbarItems.add(new ToolBar(SpreadProperties.ToolbarItemNamesEnum.DataValidation.name()));
        }
    }

    @Override
    public String getMethodName() {
        return "setToolbarGroups";
    }

    public SetToolbarGroupsCommand(SpreadSetToolParam params) {
        super.setInitParam(params);
    }
}

