/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.business.spread.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.HideRbForConfigCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SpreadBatchInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.PageTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.properties.SpreadProperties;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;

public final class SpreadCommandHelper {
    private static final Log LOG = LogFactory.getLog(SpreadCommandHelper.class);

    private SpreadCommandHelper() {
    }

    public static Map<String, Object> getRangeMap(Cell cell) {
        HashMap rangeMap = Maps.newHashMapWithExpectedSize((int)4);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), cell.getRow());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), cell.getCol());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), 1);
        return rangeMap;
    }

    public static Map<String, Object> getRangeMap(SpreadSelector spreadSelector) {
        HashMap rangeMap = Maps.newHashMapWithExpectedSize((int)4);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), spreadSelector.getStartRow());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), spreadSelector.getStartCol());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), spreadSelector.getSpanRow());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), spreadSelector.getSpanCol());
        return rangeMap;
    }

    public static void initSpreadApForGetNum(SpreadModelParam spreadParam) {
        String spreadJson = SpreadCommandHelper.getSpreadJsonByPView(spreadParam.getView().getParentView());
        JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress(spreadJson);
        JSONObject blankSpreadJson = SpreadJsonHelper.getBlankSpreadJson(spreadJsonObject);
        String blankSpreadJsonStr = GzipTools.compressJson(blankSpreadJson.toJSONString());
        SpreadClientInvoker.invokeSetSpreadJsonMethod(spreadParam.getProxy(), spreadParam.getSpreadKey(), blankSpreadJsonStr);
        SpreadCommandHelper.genSheetManagerByView(spreadParam.getView(), blankSpreadJson);
        SpreadClientInvoker.invokeCloseToolBar(spreadParam.getProxy(), spreadParam.getSpreadKey());
        SpreadClientInvoker.invokeLockAllToolbarItems(spreadParam.getProxy(), spreadParam.getSpreadKey(), true);
        HideRbForConfigCommand hideCommand = new HideRbForConfigCommand(PageTypeEnum.RPTTPL.getNum());
        hideCommand.setInitParam(null);
        String selectStr = (String)spreadParam.getView().getFormShowParameter().getCustomParam("spread_selector");
        SheetManager sheetManager = spreadParam.getSheetManager();
        SetAreaCommand setAreaCommand = new SetAreaCommand(MapInitHelper.ofMap(sheetManager.areaConf(AreaSettingEnum.SYS_AUTO_NUM), Collections.singletonList(GzipTools.deSerializedBytes(selectStr))));
        SpreadBatchInvoker.getInstance(spreadParam.getProxy(), spreadParam.getSpreadKey(), Lists.newArrayList((Object[])new SpreadCommand[]{hideCommand, setAreaCommand})).call();
    }

    public static void initSpreadApForFormula(SpreadModelParam spreadParam) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String spreadJson = SpreadCommandHelper.getSpreadJsonByPView(spreadParam.getView().getParentView());
        String uncompressJson = GzipTools.uncompressJson(spreadJson);
        SpreadClientInvoker.invokeSetSpreadJsonMethod(spreadParam.getProxy(), spreadParam.getSpreadKey(), uncompressJson);
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        LOG.info("SpreadCommandHelper.initSpreadApForFormula load milliseconds = {}", (Object)elapsed);
    }

    public static void genSheetManagerByView(IFormView view, String compressSpreadJson) {
        String uncompressJson = GzipTools.uncompressJson(compressSpreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        SpreadCommandHelper.genSheetManagerByView(view, spreadJsonObject);
    }

    public static void genSheetManagerByView(IFormView view, JSONObject spreadJsonObject) {
        String sheetName = null;
        if (view.getModel().getDataEntity().containsProperty("number")) {
            sheetName = view.getModel().getDataEntity().getString("number");
        }
        if (HRStringUtils.isEmpty(sheetName) && HRStringUtils.isEmpty((String)(sheetName = SpreadJsonHelper.getSelectedSheetName(spreadJsonObject)))) {
            sheetName = "Sheet1";
        }
        SheetManager sheet = Objects.nonNull(spreadJsonObject) ? new SheetManager(sheetName, spreadJsonObject) : new SheetManager(sheetName, "base64H4sIAAAAAAAAA6VUXY7TMBC+ysrPZZWWBUHe2LYrKrEUteUJocqNJ62pY0f2pD9b7Ql45B7cgNvAPRjbSbtRu7xQKY09P9/8fDM5sA1YJ41mKeveXPeuX7MO40qZ7WcHdmD5cmBNydKcKwcdtpLLlaIHR3rDlRQDjpylaCuovQZ7zQuZvbOW7xuFRLAc5Qb6XGWVoqPR93wni6oYRZXRjqXdJKlB+qbcf+IOYbjLQE1xr+CYQTAY7hC0CCYTrpfQRMoax/fABdhxWUMTcFY5NMUH6ZClX77SXcny1nArjkYvO8ytAJCOBzaZzR8UgsN5ZpSCDOdJcvPWa6g+ivecAVXrpuDvIJqsrK+o0hT4la8w862YmG285tY8gJ5ZLpXUSxJPUWbrmRmKU1ltm75RVaEvmOEKQmrjPJcZUCoisHMI7xlf+C4eWHL8c7GxB5YbnxzTxhZcXbVf3V65uyLi5MJK9kg/goWcVwo99x+NgEtQwevPz++/f/1gdWJ3UXNrxJ5EymRr36HAakClLkXWBk3W/whzhhggiIn/hVCQYx+UGmkBuzA4aMq2wAV648zUnbQNmyequyEdlr6Ih1raS0IMvcQVmcSqxxUSrRDQaFUK5wc0VkM8P6ulnKbIMWjo7p6cTfSJg3Kcb6/hFZp7sMu4NiOdGxfXobRSo7/7OCUvwU7lQ+jTVgqf7Btf3gr87lPmYVfXUgtfxaN3NxibcgoXV3UCjoBorl3rOxHFMcO2ZqTpw4NnDlF8yWFAfOB5hCi+5HAnaXFtSzQUEseLb1RC27Tu/hn4+GmHaxW1QdZDQqP0F9LgFm1ZBQAA");
        sheet.setSheetCache(view.getPageCache());
    }

    public static void generateBookManagerByView(IFormView view, JSONObject jsonObject, Map<String, String> maps) {
        SheetManager sheet;
        if (!Objects.isNull(jsonObject)) {
            ComboEdit comboEdit = (ComboEdit)view.getControl("sheetcombo");
            List<ComboItem> comboItems = SpreadJsonHelper.getSheetComboList(jsonObject, maps);
            if (!comboItems.isEmpty()) {
                comboEdit.setComboItems(comboItems);
            }
            if (comboItems.isEmpty() || comboItems.size() == 1) {
                view.setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep", "filltasknextstep"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep", "filltasknextstep"});
            }
            LOG.info("SpreadCommandHelper.generateBookManagerByView fillTaskId = {}", view.getModel().getValue("id"));
            List<String> sheetNameList = SpreadJsonHelper.getSheetNameList(jsonObject);
            LOG.info("SpreadCommandHelper.generateBookManagerByView sheetNameList = {}", sheetNameList);
            sheet = new SheetManager(sheetNameList, jsonObject);
        } else {
            sheet = new SheetManager("Sheet1", false);
        }
        sheet.setSheetCache(view.getPageCache());
    }

    public static String getSpreadJsonByPView(IFormView parentView) {
        if (null == parentView) {
            return "";
        }
        return parentView.getPageCache().getBigObject("spreadap");
    }

    public static void setSpreadJsonByPView(IFormView parentView, String spreadJson) {
        if (null == parentView) {
            return;
        }
        if (HRStringUtils.isEmpty((String)spreadJson)) {
            parentView.getPageCache().removeBigObject("spreadap");
        } else {
            parentView.getPageCache().putBigObject("spreadap", spreadJson);
        }
    }
}

