/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.business.spread.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import org.apache.commons.lang3.tuple.Pair;

public final class SpreadJsonHelper {
    public static final String SHEETS = "sheets";
    public static final String DATA_TABLE = "dataTable";
    public static final String NAMED_STYLES = "namedStyles";
    public static final String BACK_COLOR = "backColor";
    public static final String COLOR = "color";
    public static final String STD_BACK_COLOR = "rgb(255, 255, 255)";
    public static final String BORDER = "border";
    public static final String STD_COLOR = "#000000";
    public static final String SHEET_COUNT = "sheetCount";
    public static final String PARENT_NAME = "parentName";
    public static final String IS_SELECTED = "isSelected";
    public static final String INDEX = "index";
    public static final String ACTIVE_SHEET_INDEX = "activeSheetIndex";
    private static final Log LOG = LogFactory.getLog(SpreadJsonHelper.class);

    private SpreadJsonHelper() {
    }

    public static JSONObject getSpreadJsonByUncompress(String compressSpreadJson) {
        String uncompressJson = GzipTools.uncompressJson(compressSpreadJson);
        return JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static JSONObject getDataTable(JSONObject object, String sheetName) {
        JSONObject sheetDataBySheetName = SpreadJsonHelper.getSheetDataBySheetName(object, sheetName);
        JSONObject data = (JSONObject)sheetDataBySheetName.get((Object)"data");
        return (JSONObject)data.get((Object)DATA_TABLE);
    }

    public static JSONObject getSheetDataBySheetName(JSONObject object, String sheetName) {
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetName)) {
            sheet = (JSONObject)sheets.get((Object)sheetName);
        }
        return sheet;
    }

    public static Pair<JSONObject, JSONArray> getFromJsonDataTableByName(JSONObject spreadJsonObject, String sheetName) {
        JSONArray nameStyles = spreadJsonObject.getJSONArray(NAMED_STYLES);
        JSONObject dataTable = SpreadJsonHelper.getDataTable(spreadJsonObject, sheetName);
        return Pair.of((Object)dataTable, (Object)nameStyles);
    }

    public static List<String> getSheetNameList(JSONObject object) {
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        List<String> keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue(INDEX))).collect(Collectors.toList());
        return keyNameList;
    }

    public static List<ComboItem> getSheetComboList(JSONObject object, Map<String, String> maps) {
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        List<String> keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue(INDEX))).collect(Collectors.toList());
        ArrayList comboItems = Lists.newArrayListWithCapacity((int)keyNameList.size());
        keyNameList.forEach(key -> {
            ComboItem comboItem = new ComboItem();
            String name = maps.containsKey(key) ? (String)maps.get(key) : key;
            comboItem.setCaption(new LocaleString(name));
            comboItem.setValue(key);
            comboItems.add(comboItem);
        });
        return comboItems;
    }

    public static JSONObject getFirstSheetJson(String spreadJson) {
        String uncompressJson = GzipTools.uncompressJson(spreadJson);
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        if (Objects.isNull(object)) {
            return null;
        }
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        return (JSONObject)sheets.values().iterator().next();
    }

    public static SheetManager getSpreadSheet(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String sheetStr = pageCache.get("spread_table_data_cache");
        if (HRStringUtils.isEmpty((String)sheetStr)) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.DATA_ERROR.getName(), "initParam")});
        }
        SheetManager sheetManager = SheetManager.getSheetFromJsonStr(sheetStr);
        if (Objects.isNull(sheetManager)) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.DATA_ERROR.getName(), "initParam")});
        }
        return sheetManager;
    }

    public static JSONObject getBlankSpreadJson(JSONObject spreadJsonObject, String sheetNumber) {
        JSONObject dataTable = SpreadJsonHelper.getDataTable(spreadJsonObject, sheetNumber);
        JSONArray nameStyles = spreadJsonObject.getJSONArray(NAMED_STYLES);
        if (Objects.nonNull(nameStyles)) {
            for (Object nameStyle : nameStyles) {
                JSONObject styleJsonObj = (JSONObject)nameStyle;
                styleJsonObj.put(BACK_COLOR, null);
            }
        }
        for (Map.Entry entry : dataTable.entrySet()) {
            JSONObject valueJson = (JSONObject)entry.getValue();
            for (Map.Entry valueEntry : valueJson.entrySet()) {
                String backColor;
                JSONObject value = (JSONObject)valueEntry.getValue();
                Object styleObj = value.get((Object)"style");
                if (Objects.isNull(styleObj) || styleObj instanceof String) continue;
                JSONObject style = (JSONObject)styleObj;
                if (style.containsKey((Object)BACK_COLOR) && !HRStringUtils.equals((String)(backColor = style.getString(BACK_COLOR)), (String)STD_BACK_COLOR)) {
                    style.put(BACK_COLOR, (Object)STD_BACK_COLOR);
                }
                Set keys = style.keySet();
                for (String key : keys) {
                    String color;
                    JSONObject border;
                    if (!key.startsWith(BORDER) || Objects.isNull(border = style.getJSONObject(key)) || HRStringUtils.equals((String)(color = border.getString(COLOR)), (String)STD_COLOR)) continue;
                    border.put(COLOR, (Object)STD_COLOR);
                }
            }
        }
        return spreadJsonObject;
    }

    public static JSONObject getBlankSpreadJson(JSONObject spreadJsonObject) {
        return SpreadJsonHelper.getBlankSpreadJson(spreadJsonObject, "Sheet1");
    }

    public static String addTarSheetToSrcSheets(String tarCurrentJson, String srcSpreadJson, String newSheetName) {
        String srcUncompressJson = GzipTools.uncompressJson(srcSpreadJson);
        String tarUncompressJson = GzipTools.uncompressJson(tarCurrentJson);
        JSONObject tarSpreadObject = JSONObject.parseObject((String)tarUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject tarSheets = (JSONObject)tarSpreadObject.get((Object)SHEETS);
        JSONObject tarFirstSheet = (JSONObject)tarSheets.values().iterator().next();
        tarFirstSheet.put(IS_SELECTED, (Object)true);
        JSONObject srcSheetJson = JSONObject.parseObject((String)srcUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        if (!srcSheetJson.getJSONObject(SHEETS).containsKey((Object)tarFirstSheet.getString("name"))) {
            Integer sheetCount = srcSheetJson.getInteger(SHEET_COUNT);
            sheetCount = null == sheetCount ? Integer.valueOf(2) : Integer.valueOf(sheetCount + 1);
            srcSheetJson.getJSONObject(SHEETS).forEach((name, sheet) -> {
                JSONObject tarSheet = (JSONObject)sheet;
                tarSheet.put(IS_SELECTED, (Object)false);
            });
            srcSheetJson.put(SHEET_COUNT, (Object)sheetCount);
            tarFirstSheet.put(INDEX, (Object)(sheetCount - 1));
            srcSheetJson.put(ACTIVE_SHEET_INDEX, (Object)(sheetCount - 1));
            if (tarSpreadObject.containsKey((Object)NAMED_STYLES)) {
                JSONArray tarNameStyles = tarSpreadObject.getJSONArray(NAMED_STYLES);
                JSONArray srcNameStyle = srcSheetJson.getJSONArray(NAMED_STYLES);
                if (HRCollUtil.isEmpty((Collection)srcNameStyle)) {
                    srcSheetJson.put(NAMED_STYLES, (Object)tarNameStyles);
                } else {
                    srcNameStyle.addAll((Collection)tarNameStyles);
                }
            }
            JSONObject sheets = (JSONObject)srcSheetJson.get((Object)SHEETS);
            sheets.put(newSheetName, (Object)tarFirstSheet);
            JSONObject srcFirstSheet = (JSONObject)sheets.values().iterator().next();
            srcFirstSheet.put(IS_SELECTED, (Object)false);
            String result = srcSheetJson.toJSONString();
            return GzipTools.compressJson(result);
        }
        srcSheetJson.getJSONObject(SHEETS).forEach((name, sheet) -> {
            if (tarFirstSheet.getString("name").equals(name)) {
                JSONObject tarSheet = (JSONObject)sheet;
                tarSheet.put(IS_SELECTED, (Object)true);
                srcSheetJson.put(ACTIVE_SHEET_INDEX, (Object)tarSheet.getInteger(INDEX));
            } else {
                JSONObject tarSheet = (JSONObject)sheet;
                tarSheet.put(IS_SELECTED, (Object)false);
            }
        });
        String result = srcSheetJson.toJSONString();
        return GzipTools.compressJson(result);
    }

    public static String displaySelSheet(String srcSpreadJson, String sheetName) {
        String srcUncompressJson = GzipTools.uncompressJson(srcSpreadJson);
        JSONObject srcSheetJson = JSONObject.parseObject((String)srcUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        srcSheetJson.getJSONObject(SHEETS).forEach((name, sheet) -> {
            if (sheetName.equals(name)) {
                JSONObject tarSheet = (JSONObject)sheet;
                tarSheet.put(IS_SELECTED, (Object)true);
                srcSheetJson.put(ACTIVE_SHEET_INDEX, (Object)tarSheet.getInteger(INDEX));
            } else {
                JSONObject tarSheet = (JSONObject)sheet;
                tarSheet.put(IS_SELECTED, (Object)false);
            }
        });
        String result = srcSheetJson.toJSONString();
        return GzipTools.compressJson(result);
    }

    public static String addRptsToSrcSpread(Map<String, String> rptTplMaps, String tarSpreadJson, String rptTplNumber) {
        String tarUncompressJson = GzipTools.uncompressJson(tarSpreadJson);
        JSONObject tarSheetJson = JSONObject.parseObject((String)tarUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject tarSheets = (JSONObject)tarSheetJson.get((Object)SHEETS);
        JSONObject newTarSheets = new JSONObject();
        Set<String> rptTplNumbers = rptTplMaps.keySet();
        List<String> orderSheetNames = SpreadJsonHelper.getOrderSheetNames(tarSheetJson);
        HashSet sheetNames = Sets.newHashSet(orderSheetNames);
        sheetNames.remove(rptTplNumber);
        if (rptTplNumbers.equals(sheetNames)) {
            LOG.info("SpreadJsonHelper.addRptsToSrcSpread not need merge...");
            return tarSpreadJson;
        }
        tarSheets.forEach((name, sheet) -> {
            JSONObject tarSheet = (JSONObject)sheet;
            if (tarSheet.getInteger(INDEX) == 0) {
                tarSheet.put(IS_SELECTED, (Object)false);
                newTarSheets.put(name, (Object)tarSheet);
            }
        });
        tarSheetJson.put(SHEETS, (Object)newTarSheets);
        if (!HRMapUtils.isEmpty(rptTplMaps)) {
            int sheetCount = rptTplMaps.size() + 1;
            tarSheetJson.put(SHEET_COUNT, (Object)sheetCount);
            tarSheetJson.put(ACTIVE_SHEET_INDEX, (Object)0);
            int index = 1;
            for (Map.Entry<String, String> rptTplEntry : rptTplMaps.entrySet()) {
                String spreadJson = rptTplEntry.getValue();
                String queryNumber = rptTplEntry.getKey();
                LOG.info("SpreadJsonHelper.addRptsToSrcSpread add rptTplNumber = {}", (Object)queryNumber);
                JSONObject srcSheetJson = SpreadJsonHelper.getFirstSheetJson(spreadJson);
                if (Objects.isNull(srcSheetJson)) continue;
                srcSheetJson.put(INDEX, (Object)index);
                srcSheetJson.put(IS_SELECTED, (Object)false);
                ++index;
                newTarSheets.put(queryNumber, (Object)srcSheetJson);
            }
        } else {
            tarSheetJson.remove((Object)SHEET_COUNT);
            LOG.info("SpreadJsonHelper.addRptsToSrcSpread only has self...");
        }
        String result = tarSheetJson.toJSONString();
        return GzipTools.compressJson(result);
    }

    public static JSONObject getSheets(JSONObject spreadJsonObject) {
        return (JSONObject)spreadJsonObject.get((Object)SHEETS);
    }

    public static String getSelectedSheetName(JSONObject spreadJsonObject) {
        if (Objects.isNull(spreadJsonObject)) {
            return "";
        }
        JSONObject sheets = spreadJsonObject.getJSONObject(SHEETS);
        if (Objects.isNull(sheets)) {
            return "";
        }
        Optional<Map.Entry> isSelected = sheets.entrySet().stream().filter(sheet -> ((JSONObject)sheet.getValue()).getBoolean(IS_SELECTED)).findFirst();
        if (isSelected.isPresent()) {
            return (String)isSelected.get().getKey();
        }
        return "";
    }

    public static List<String> getOrderSheetNames(JSONObject spreadJsonObject) {
        JSONObject sheets = spreadJsonObject.getJSONObject(SHEETS);
        if (Objects.isNull(sheets)) {
            return Collections.emptyList();
        }
        return sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue(INDEX))).collect(Collectors.toList());
    }

    public static JSONObject genNewOneSheetJson(String uncompressJson, String sheetName) {
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject splitSheetContent = SpreadJsonHelper.getSheetDataBySheetName(spreadJsonObject, sheetName);
        splitSheetContent.put(IS_SELECTED, (Object)true);
        splitSheetContent.put(INDEX, (Object)0);
        spreadJsonObject.put(SHEETS, MapInitHelper.ofMap(sheetName, splitSheetContent));
        spreadJsonObject.remove((Object)SHEET_COUNT);
        spreadJsonObject.remove((Object)ACTIVE_SHEET_INDEX);
        return spreadJsonObject;
    }

    public static Map<String, JSONObject> sheetNameMapDataTable(JSONObject spreadJsonObject) {
        JSONObject sheets = (JSONObject)spreadJsonObject.get((Object)SHEETS);
        HashMap<String, JSONObject> datatableMap = new HashMap<String, JSONObject>();
        List<String> keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue(INDEX))).collect(Collectors.toList());
        keyNameList.forEach(sheetName -> {
            JSONObject sheet = sheets.getJSONObject(sheetName);
            JSONObject data = sheet.getJSONObject("data");
            JSONObject datatable = data.getJSONObject(DATA_TABLE);
            datatableMap.put((String)sheetName, datatable);
        });
        return datatableMap;
    }

    public static void refreshRptTplNumber(JSONObject spreadJsonObject, String newRptTplNumber, String oldRptTplNumber) {
        JSONObject sheets = spreadJsonObject.getJSONObject(SHEETS);
        JSONObject oldRptTpl = sheets.getJSONObject(oldRptTplNumber);
        if (null == oldRptTpl) {
            return;
        }
        oldRptTpl.put("name", (Object)newRptTplNumber);
        sheets.put(newRptTplNumber, (Object)oldRptTpl);
        sheets.remove((Object)oldRptTplNumber);
    }
}

