/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.enums;

import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;

public enum DataTypeEnum {
    DEFAULT(new MultiLangEnumBridge("\u9ed8\u8ba4", "DataTypeEnum_0", "sihc-soehrr-common"), "0"),
    CURRENCY(new MultiLangEnumBridge("\u8d27\u5e01", "DataTypeEnum_1", "sihc-soehrr-common"), "1"),
    UNCURRENCY(new MultiLangEnumBridge("\u6570\u503c", "DataTypeEnum_2", "sihc-soehrr-common"), "2"),
    TXT(new MultiLangEnumBridge("\u6587\u672c", "DataTypeEnum_3", "sihc-soehrr-common"), "3"),
    DATETP(new MultiLangEnumBridge("\u65e5\u671f", "DataTypeEnum_4", "sihc-soehrr-common"), "4"),
    PROPORTION(new MultiLangEnumBridge("\u6bd4\u4f8b", "DataTypeEnum_5", "sihc-soehrr-common"), "5"),
    ENUMTP(new MultiLangEnumBridge("\u679a\u4e3e", "DataTypeEnum_6", "sihc-soehrr-common"), "6");

    public final String index;
    private int code;
    private MultiLangEnumBridge bridge;

    private DataTypeEnum(MultiLangEnumBridge bridge, String index) {
        this.bridge = bridge;
        this.index = index;
        this.code = Integer.parseInt(index);
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public final String getOIndex() {
        return this.index;
    }

    public int getCode() {
        return this.code;
    }

    public static DataTypeEnum getDataTypeEnumByIndex(String index) {
        int lookupCode;
        try {
            lookupCode = Integer.parseInt(index);
        }
        catch (Exception ex) {
            return TXT;
        }
        for (DataTypeEnum dt : DataTypeEnum.values()) {
            if (dt.getCode() != lookupCode) continue;
            return dt;
        }
        return TXT;
    }

    public static DataTypeEnum valueOfBy(String index) {
        int lookupCode = Integer.parseInt(index);
        for (DataTypeEnum dt : DataTypeEnum.values()) {
            if (dt.getCode() != lookupCode) continue;
            return dt;
        }
        throw new KDBizException(String.format("not fount dataType %s", index));
    }
}

