/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.report.dto;

import com.google.common.collect.Lists;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;

public class AreaSettingDto
extends ReportCacheDto {
    private static final long serialVersionUID = -43162072543388208L;
    private AreaSettingEnum areaSetting;
    private String otherAreaPoint;
    protected String areaPoint;
    protected CollectTypeEnum collectType;
    protected RptTypeEnum rptTplType;

    public AreaSettingDto(SpreadSelector spreadSelector, DynamicObject reportConf, AreaSettingEnum areaSetting) {
        this.areaPoint = spreadSelector.getStartRow() + ":" + spreadSelector.getStartCol() + ":" + spreadSelector.getSpanRow() + ":" + spreadSelector.getSpanCol();
        this.areaSetting = areaSetting;
        this.entityId = "soehrr_rpttplarea";
        this.operate = OperateEnum.ADD;
        this.reportId = (Long)reportConf.getPkValue();
        DynamicObject queryRptTpl = super.queryNowEntryEntity(this.reportId);
        this.repEntryId = HRObjectUtils.isEmpty((Object)queryRptTpl) ? 0L : this.getCurrentEntryId(queryRptTpl);
        if (Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.FILL, AreaSettingEnum.DYNAMIC_SUMMARY}).contains((Object)areaSetting)) {
            this.collectType = CollectTypeEnum.getByType(reportConf.getString("collecttype"));
            this.rptTplType = RptTypeEnum.getByType(reportConf.getString("rpttype"));
        }
    }

    public AreaSettingDto(SpreadSelector spreadSelector, AreaSettingEnum areaSetting) {
        this.areaPoint = spreadSelector.getStartRow() + ":" + spreadSelector.getStartCol() + ":" + spreadSelector.getSpanRow() + ":" + spreadSelector.getSpanCol();
        this.areaSetting = areaSetting;
        this.entityId = "soehrr_rpttplarea";
        this.operate = OperateEnum.ADD;
    }

    public AreaSettingDto() {
    }

    @Override
    public DynamicObject convertDynamicObject() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)super.getEntityId());
        dynamicObject.set("reportconfid", (Object)this.reportId);
        dynamicObject.set("repentryid", (Object)this.repEntryId);
        dynamicObject.set("areapoint", (Object)this.areaPoint);
        dynamicObject.set("areatype", (Object)String.valueOf(this.areaSetting.getValue()));
        dynamicObject.set("srcareapoint", (Object)this.otherAreaPoint);
        dynamicObject.set("id", (Object)this.id);
        return dynamicObject;
    }

    @Override
    public ReportCacheDto dyConvert2Dto(DynamicObject dynamicObject) {
        this.areaPoint = dynamicObject.getString("areapoint");
        this.entityId = dynamicObject.getDataEntityType().getName();
        if (this.operate == null) {
            this.operate = OperateEnum.QUERY;
        }
        DynamicObject rptTpl = dynamicObject.getDynamicObject("reportconfid");
        this.areaSetting = AreaSettingEnum.forValue(dynamicObject.getInt("areatype"));
        if (!HRObjectUtils.isEmpty((Object)rptTpl)) {
            this.reportId = rptTpl.getLong("id");
            this.rptTplNumber = rptTpl.getString("number");
            this.rptTplName = rptTpl.getString("name");
            if (Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.FILL, AreaSettingEnum.DYNAMIC_SUMMARY}).contains((Object)this.areaSetting)) {
                this.collectType = CollectTypeEnum.getByType(rptTpl.getString("collecttype"));
                this.rptTplType = RptTypeEnum.getByType(rptTpl.getString("rpttype"));
            }
        }
        this.repEntryId = dynamicObject.getLong("repentryid");
        this.id = dynamicObject.getLong("id");
        this.otherAreaPoint = dynamicObject.getString("srcareapoint");
        return this;
    }

    public SpreadSelector convert2Selector() {
        String[] areaArr = this.areaPoint.split(":");
        int r = Integer.parseInt(areaArr[0]);
        int c = Integer.parseInt(areaArr[1]);
        int rc = Integer.parseInt(areaArr[2]);
        int cc = Integer.parseInt(areaArr[3]);
        int endR = rc + r - 1;
        int endC = cc + c - 1;
        SpreadSelector selector = new SpreadSelector(r, c, endR, endC, rc, cc);
        return selector;
    }

    public AreaSettingEnum getAreaSetting() {
        return this.areaSetting;
    }

    public void setAreaSetting(AreaSettingEnum areaSetting) {
        this.areaSetting = areaSetting;
    }

    public boolean equals(Object obj) {
        SpreadSelector thisSelector;
        if (!(obj instanceof AreaSettingDto)) {
            return false;
        }
        AreaSettingDto objArea = (AreaSettingDto)obj;
        SpreadSelector selector = objArea.convert2Selector();
        return selector.equals(thisSelector = this.convert2Selector()) && this.getAreaSetting() == objArea.getAreaSetting();
    }

    public String getOtherAreaPoint() {
        return this.otherAreaPoint;
    }

    public void setOtherAreaPoint(String otherAreaPoint) {
        this.otherAreaPoint = otherAreaPoint;
    }

    public String getAreaPoint() {
        return this.areaPoint;
    }

    public void setAreaPoint(String areaPoint) {
        this.areaPoint = areaPoint;
    }

    public CollectTypeEnum getCollectType() {
        return this.collectType;
    }

    public void setCollectType(CollectTypeEnum collectType) {
        this.collectType = collectType;
    }

    public RptTypeEnum getRptTplType() {
        return this.rptTplType;
    }

    public void setRptTplType(RptTypeEnum rptTplType) {
        this.rptTplType = rptTplType;
    }
}

