/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.report.dto;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.report.autogetnum.ColIndex;
import kd.sdk.sihc.soehrr.common.report.autogetnum.RowDim;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;

public class AutoAreaSettingDto
extends AreaSettingDto {
    private static final long serialVersionUID = 9182456618608020844L;
    private long analyseObjectId;
    private List<RowDim> rowDims;
    private List<ColIndex> colIndexList;
    private long fillOrgId;
    private long datePeriod;

    @Override
    public DynamicObject convertDynamicObject() {
        DynamicObject entry;
        DynamicObject dynamicObject = super.convertDynamicObject();
        dynamicObject.set("analyseobject", (Object)this.analyseObjectId);
        dynamicObject.set("fillorg", (Object)this.fillOrgId);
        dynamicObject.set("dateperiod", (Object)this.datePeriod);
        DynamicObjectCollection rowEntryEntity = dynamicObject.getDynamicObjectCollection("rowentryentity");
        DynamicObjectCollection colEntryEntity = dynamicObject.getDynamicObjectCollection("colentryentity");
        for (RowDim rowDim : this.rowDims) {
            entry = new DynamicObject(rowEntryEntity.getDynamicObjectType());
            entry.set("rowno", (Object)rowDim.getRowNo());
            entry.set("groupitems", (Object)rowDim.getGroupItem());
            entry.set("groupv", (Object)rowDim.getGroupValue());
            entry.set("row", (Object)rowDim.getRow());
            entry.set("groupentry", (Object)rowDim.getGroupEntryId());
            rowEntryEntity.add((Object)entry);
        }
        for (ColIndex colIndex : this.colIndexList) {
            entry = new DynamicObject(colEntryEntity.getDynamicObjectType());
            entry.set("colno", (Object)colIndex.getColNo());
            entry.set("colv", (Object)colIndex.getColValue());
            entry.set("col", (Object)colIndex.getCol());
            colEntryEntity.add((Object)entry);
        }
        return dynamicObject;
    }

    @Override
    public ReportCacheDto dyConvert2Dto(DynamicObject dynamicObject) {
        DynamicObject datePeriodField;
        super.dyConvert2Dto(dynamicObject);
        this.analyseObjectId = dynamicObject.getLong("analyseobject.id");
        DynamicObject fillOrgField = dynamicObject.getDynamicObject("fillorg");
        if (!HRObjectUtils.isEmpty((Object)fillOrgField)) {
            this.fillOrgId = fillOrgField.getLong("id");
        }
        if (!HRObjectUtils.isEmpty((Object)(datePeriodField = dynamicObject.getDynamicObject("dateperiod")))) {
            this.datePeriod = datePeriodField.getLong("id");
        }
        DynamicObjectCollection rowEntryEntity = dynamicObject.getDynamicObjectCollection("rowentryentity");
        DynamicObjectCollection colEntryEntity = dynamicObject.getDynamicObjectCollection("colentryentity");
        this.rowDims = Lists.newArrayListWithExpectedSize((int)rowEntryEntity.size());
        for (DynamicObject entry : rowEntryEntity) {
            RowDim rowDim = new RowDim();
            rowDim.setRowNo(entry.getString("rowno"));
            String groupV = entry.getString("groupv");
            if (HRStringUtils.isEmpty((String)groupV)) {
                this.rowDims.add(null);
                continue;
            }
            rowDim.setGroupValue(groupV);
            rowDim.setGroupEntryId(entry.getLong("groupentry"));
            rowDim.setRow(entry.getInt("row"));
            rowDim.setGroupItem(entry.getString("groupitems"));
            this.rowDims.add(rowDim);
        }
        this.colIndexList = Lists.newArrayListWithExpectedSize((int)colEntryEntity.size());
        for (DynamicObject entry : colEntryEntity) {
            ColIndex colIndex = new ColIndex();
            String colValue = entry.getString("colv");
            if (HRStringUtils.isEmpty((String)colValue)) {
                this.colIndexList.add(null);
                continue;
            }
            colIndex.setColValue(colValue);
            colIndex.setColNo(entry.getString("colno"));
            colIndex.setCol(entry.getInt("col"));
            this.colIndexList.add(colIndex);
        }
        return this;
    }

    public long getAnalyseObjectId() {
        return this.analyseObjectId;
    }

    public void setAnalyseObjectId(long analyseObjectId) {
        this.analyseObjectId = analyseObjectId;
    }

    public List<RowDim> getRowDims() {
        return this.rowDims;
    }

    public void setRowDims(List<RowDim> rowDims) {
        this.rowDims = rowDims;
    }

    public List<ColIndex> getColIndexList() {
        return this.colIndexList;
    }

    public void setColIndexList(List<ColIndex> colIndexList) {
        this.colIndexList = colIndexList;
    }

    public long getFillOrgId() {
        return this.fillOrgId;
    }

    public void setFillOrgId(long fillOrgId) {
        this.fillOrgId = fillOrgId;
    }

    public long getDatePeriod() {
        return this.datePeriod;
    }

    public void setDatePeriod(long datePeriod) {
        this.datePeriod = datePeriod;
    }
}

