/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.report.dto;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.Cell;

public class RepRuntimeVar
extends ReportCacheDto {
    private static final long serialVersionUID = -4162155685134856876L;
    private long insertValId;
    protected String point;

    public long getInsertValId() {
        return this.insertValId;
    }

    public void setInsertValId(long insertValId) {
        this.insertValId = insertValId;
    }

    public RepRuntimeVar(Cell cell, DynamicObject reportConf, DynamicObject rptClassifyVar) {
        this.point = cell.getRow() + ":" + cell.getCol();
        this.insertValId = rptClassifyVar.getLong("id");
        this.entityId = "soehrr_rpttplvar";
        this.operate = OperateEnum.ADD;
        this.reportId = (Long)reportConf.getPkValue();
        DynamicObject queryRptTpl = super.queryNowEntryEntity(this.reportId);
        this.repEntryId = HRObjectUtils.isEmpty((Object)queryRptTpl) ? 0L : this.getCurrentEntryId(queryRptTpl);
    }

    public RepRuntimeVar() {
    }

    public RepRuntimeVar(RepRuntimeVar delVar) {
        this.entityId = delVar.getEntityId();
        this.operate = OperateEnum.ADD;
        this.insertValId = delVar.getInsertValId();
        this.entityId = "soehrr_rpttplvar";
    }

    @Override
    public DynamicObject convertDynamicObject() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)super.getEntityId());
        dynamicObject.set("reportvar", (Object)this.insertValId);
        dynamicObject.set("reportconfid", (Object)this.reportId);
        dynamicObject.set("repentryid", (Object)this.repEntryId);
        dynamicObject.set("point", (Object)this.point);
        dynamicObject.set("id", (Object)this.id);
        return dynamicObject;
    }

    @Override
    public ReportCacheDto dyConvert2Dto(DynamicObject runtimeVar) {
        this.point = runtimeVar.getString("point");
        this.insertValId = runtimeVar.getLong("reportvar.id");
        this.entityId = runtimeVar.getDataEntityType().getName();
        this.operate = OperateEnum.QUERY;
        this.reportId = runtimeVar.getDynamicObject("reportconfid").getLong("id");
        this.rptTplNumber = runtimeVar.getDynamicObject("reportconfid").getString("number");
        this.rptTplName = runtimeVar.getDynamicObject("reportconfid").getString("name");
        this.repEntryId = runtimeVar.getLong("repentryid");
        this.id = runtimeVar.getLong("id");
        return this;
    }

    public Cell getCell() {
        String point = this.getPoint();
        if (HRStringUtils.isEmpty((String)point)) {
            return null;
        }
        String[] splitPoint = point.split(":");
        Cell cell = new Cell();
        cell.setRowAndCol(Integer.parseInt(splitPoint[0]), Integer.parseInt(splitPoint[1]));
        return cell;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepRuntimeVar)) {
            return false;
        }
        RepRuntimeVar var = (RepRuntimeVar)obj;
        Cell varCell = var.getCell();
        Cell thisCell = this.getCell();
        return varCell.equals(thisCell);
    }

    public void updateRowAndCol(Cell varCell) {
        this.point = varCell.getRow() + ":" + varCell.getCol();
    }

    public String getPoint() {
        return this.point;
    }

    public void setPoint(String point) {
        this.point = point;
    }
}

