/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.report.invoker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.BatchCacheInvoker;

public class ReportCacheInvoker
extends BatchCacheInvoker {
    private static final long serialVersionUID = -2211204754251608194L;

    public ReportCacheInvoker() {
        super(null);
    }

    public ReportCacheInvoker(List<ReportCacheDto> cacheDtoList) {
        super(cacheDtoList);
    }

    @Override
    public void delete() {
        Map<String, List<ReportCacheDto>> entityIdMap = this.getAllDelete();
        for (Map.Entry<String, List<ReportCacheDto>> entry : entityIdMap.entrySet()) {
            String entityId = entry.getKey();
            List<ReportCacheDto> groupDtoList = entry.getValue();
            List<Long> ids = groupDtoList.stream().map(ReportCacheDto::getId).collect(Collectors.toList());
            HRBaseServiceHelper dao = new HRBaseServiceHelper(entityId);
            dao.delete((Object[])ids.toArray(new Long[0]));
        }
    }

    @Override
    public List<ReportCacheDto> getDelete(String entityId) {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.DELETE && HRStringUtils.equals((String)dto.getEntityId(), (String)entityId)).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<ReportCacheDto>> getAllDelete() {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.DELETE).collect(Collectors.groupingBy(ReportCacheDto::getEntityId));
    }

    @Override
    public void add(DynamicObject reportConf) {
        for (ReportCacheDto cacheDto : this.cacheDtoList) {
            if (cacheDto.getOperate() != OperateEnum.ADD) continue;
            cacheDto.setReportId(reportConf.getLong("id"));
            long repEntryId = cacheDto.getRepEntryId();
            if (repEntryId != 0L) continue;
            repEntryId = cacheDto.getCurrentEntryId(reportConf);
            cacheDto.setRepEntryId(repEntryId);
        }
        this.add();
    }

    @Override
    public void add() {
        Map<String, List<ReportCacheDto>> entityIdMap = this.getAllAdd();
        for (Map.Entry<String, List<ReportCacheDto>> entry : entityIdMap.entrySet()) {
            String entityId = entry.getKey();
            List<ReportCacheDto> groupDtoList = entry.getValue();
            List<DynamicObject> dyList = groupDtoList.stream().map(ReportCacheDto::convertDynamicObject).collect(Collectors.toList());
            HRBaseServiceHelper dao = new HRBaseServiceHelper(entityId);
            dao.save(dyList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public List<ReportCacheDto> getAdd(String entityId) {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.ADD && HRStringUtils.equals((String)dto.getEntityId(), (String)entityId)).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<ReportCacheDto>> getAllAdd() {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.ADD).collect(Collectors.groupingBy(ReportCacheDto::getEntityId));
    }

    @Override
    public List<ReportCacheDto> query(String entityId) {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.QUERY && HRStringUtils.equals((String)dto.getEntityId(), (String)entityId)).collect(Collectors.toList());
    }

    @Override
    public List<ReportCacheDto> query() {
        return this.cacheDtoList.stream().filter(dto -> dto.getOperate() == OperateEnum.QUERY).collect(Collectors.toList());
    }

    @Override
    public List<ReportCacheDto> getAllByEntityId(String entityId) {
        return this.cacheDtoList.stream().filter(dto -> HRStringUtils.equals((String)dto.getEntityId(), (String)entityId)).collect(Collectors.toList());
    }

    @Override
    public List<ReportCacheDto> getAllEnableByEntityId(String entityId) {
        List<ReportCacheDto> allByEntityId = this.getAllByEntityId(entityId);
        return allByEntityId.stream().filter(dto -> dto.getOperate() != OperateEnum.DELETE).collect(Collectors.toList());
    }

    @Override
    public void clearQuery(String entityId) {
        this.cacheDtoList.removeIf(dto -> dto.getOperate() == OperateEnum.QUERY && HRStringUtils.equals((String)dto.getEntityId(), (String)entityId));
    }

    @Override
    public void clearAdd(String entityId) {
        this.cacheDtoList.removeIf(dto -> dto.getOperate() == OperateEnum.ADD && HRStringUtils.equals((String)dto.getEntityId(), (String)entityId));
    }

    @Override
    public void queryConvertAdd() {
        List<ReportCacheDto> cacheDtos = this.query();
        ArrayList newAddDtos = Lists.newArrayListWithExpectedSize((int)cacheDtos.size());
        for (ReportCacheDto cacheDto : cacheDtos) {
            ReportCacheDto addDto = cacheDto.queryConvertAdd();
            newAddDtos.add(addDto);
            this.clearQuery(cacheDto.getEntityId());
        }
        this.setCacheDtoList((List)newAddDtos);
    }
}

