/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.spread;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.kingdee.util.TypeConversionUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.DataTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.CellData;
import kd.sdk.sihc.soehrr.common.spread.CellStyle;
import kd.sdk.sihc.soehrr.common.spread.SpanInfo;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.variant.Variant;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.HrrStrUtil;

public class Cell
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CellData cellData;
    private CellStyle cellStyle;
    private String formula;
    private SpanInfo spanInfo;
    private boolean isChangeVal = false;
    protected boolean isMdDataDomain = false;
    private int row = -1;
    private int col = -1;
    @JsonIgnore
    private transient DataTypeEnum cellDataType;
    @JsonIgnore
    private transient Object newValue;
    private String sheetNumber;

    public String getSheetNumber() {
        return this.sheetNumber;
    }

    public void setSheetNumber(String sheetNumber) {
        this.sheetNumber = sheetNumber;
    }

    public Cell() {
        this.cellData = new CellData();
    }

    public CellData getCellData() {
        return this.cellData;
    }

    public Cell setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
        return this;
    }

    public Cell(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setRowAndCol(String rAndC) {
        if (HRStringUtils.isEmpty((String)rAndC)) {
            return;
        }
        Object[] rcArr = rAndC.split(":");
        if (HRArrayUtils.isEmpty((Object[])rcArr) || rcArr.length < 1) {
            return;
        }
        this.row = Integer.parseInt((String)rcArr[0]);
        this.col = Integer.parseInt((String)rcArr[1]);
    }

    public String getRowAndCol() {
        return this.row + ":" + this.col;
    }

    @Deprecated
    public void setRow(int row) {
        this.row = row;
    }

    @Deprecated
    public void setCol(int col) {
        this.col = col;
    }

    public int hashCode() {
        if (this.row > Short.MAX_VALUE && this.col > Short.MAX_VALUE) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u7684\u884c\uff0c\u5217\u7ec4\u5408\u6570\u91cf\u8d85\u8fc7\u4e86\uff1a%s", (String)"Cell_0", (String)"fi-bcm-common", (Object[])new Object[0]), Integer.MAX_VALUE));
        }
        int _cachedHashCode = this.row << 16 ^ this.col;
        return _cachedHashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof Cell && ((Cell)obj).row == this.row && ((Cell)obj).col == this.col;
    }

    public boolean setValue(Object val) {
        boolean oldValIsNull;
        Variant temp = this.convert2Variant(val);
        Variant oldCellData = this.cellData.getData();
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        if (oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && (this.cellData.getData().getVt() != temp.getVt() || !temp.equals(oldCellData))) {
            this.isChangeVal = true;
            this.cellData.setData(temp);
        }
        return this.isChangeVal;
    }

    private Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant((BigDecimal)val);
        }
        if (val instanceof Long) {
            return new Variant(new BigDecimal((Long)val));
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public Object getValue() {
        return this.cellData.getData().getValue();
    }

    public Variant getVariant() {
        return this.cellData.getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public SpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(SpanInfo spanInfo) {
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return StringUtils.isNotEmpty((String)this.formula);
    }

    public boolean isMdDataDomain() {
        return this.isMdDataDomain;
    }

    public void setMdDataDomain(boolean isMdDataDomain) {
        this.isMdDataDomain = isMdDataDomain;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos(this.col, this.row);
    }

    public String valueToString() {
        Variant val = this.cellData.getData();
        if (val == null) {
            return "";
        }
        if (val.isNumber()) {
            return val.toString();
        }
        if (val.isDate()) {
            return TypeConversionUtils.objToDate((Object)val).toString();
        }
        return val.toString();
    }

    @JsonIgnore
    public void overrideCellDataWithNewData() {
        this.setValue(this.newValue);
    }

    @JsonIgnore
    public Object getNewValue() {
        return this.newValue;
    }

    @JsonIgnore
    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @JsonIgnore
    public DataTypeEnum getCellDataType() {
        return this.cellDataType;
    }

    @JsonIgnore
    public void setCellDataType(DataTypeEnum cellDataType) {
        this.cellDataType = cellDataType;
    }

    @JsonIgnore
    public boolean isOnRowOrColSetting() {
        boolean isOnRowOrColSetting = true;
        return isOnRowOrColSetting;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("value", (Object)this.cellData.getData()).add("formula", (Object)this.formula).add("isChangeVal", this.isChangeVal).add("isMDData", this.isMdDataDomain).add("row", this.row).add("col", this.col).toString();
    }

    public boolean isNullValue() {
        return this.getValue() == null || HrrStrUtil.trim(this.getValue().toString()).isEmpty();
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public SpreadSelector toSelector() {
        return new SpreadSelector(this.getRow(), this.getCol(), this.getRow(), this.getCol(), 1, 1);
    }
}

