/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.spread;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.BorderTypeEnum;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.report.invoker.ReportCacheInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.CellStyle;
import kd.sdk.sihc.soehrr.common.util.SupportGZip;

public class DataTableManager
implements Serializable,
SupportGZip {
    private static final long serialVersionUID = -1997959415348003562L;
    private List<List<Cell>> table;
    public static final long MAX_SIZE = 999999L;
    private CacheObjInvoker invoker;
    private String sheetName;

    public CacheObjInvoker getInvoker() {
        return this.invoker;
    }

    public DataTableManager(String sheetName) {
        this.sheetName = sheetName;
        this.invoker = new ReportCacheInvoker(null);
    }

    public void parseJsonTableData(JSONObject spreadJsonObject, JSONArray nameStyles) {
        JSONObject dataTable = SpreadJsonHelper.getDataTable(spreadJsonObject, this.sheetName);
        this.parseJsonData(dataTable, nameStyles);
    }

    public final void parseJsonData(JSONObject dataTable, JSONArray nameStyles) {
        this.loadTable();
        if (Objects.isNull(dataTable)) {
            return;
        }
        this.table.clear();
        Set rowSet = dataTable.keySet();
        ArrayList rows = Lists.newArrayList((Iterable)rowSet);
        int startRow = Integer.parseInt((String)rows.get(0));
        int endRow = Integer.parseInt((String)rows.get(rows.size() - 1));
        Collection colsList = dataTable.values();
        int maxCol = 0;
        int minCol = 0;
        for (Object cols : colsList) {
            JSONObject jsonCols = (JSONObject)cols;
            Set colSet = jsonCols.keySet();
            ArrayList colNos = Lists.newArrayList((Iterable)colSet);
            int thisMinCol = Integer.parseInt((String)colNos.get(0));
            int thisMaxCol = Integer.parseInt((String)colNos.get(colNos.size() - 1));
            minCol = Math.min(minCol, thisMinCol);
            maxCol = Math.max(maxCol, thisMaxCol);
        }
        Map<String, Object> stylesMap = DataTableManager.nameStyleToStyle(nameStyles);
        for (int i = startRow; i <= endRow; ++i) {
            JSONObject row = (JSONObject)dataTable.get((Object)String.valueOf(i));
            ArrayList cols = Lists.newArrayListWithExpectedSize((int)endRow);
            if (row == null) {
                this.table.add(cols);
            }
            for (int j = minCol; j <= maxCol; ++j) {
                if (null == row) {
                    cols.add(null);
                    continue;
                }
                JSONObject colVal = (JSONObject)row.get((Object)String.valueOf(j));
                if (null == colVal) {
                    cols.add(null);
                    continue;
                }
                Object styleObject = colVal.get((Object)"style");
                String formula = colVal.getString("formula");
                Object cellVal = colVal.get((Object)"value");
                Cell cell = new Cell();
                cell.setRowAndCol(i, j);
                cell.setValue(cellVal);
                cell.setFormula(formula);
                cols.add(cell);
                if (Objects.isNull(styleObject)) continue;
                JSONObject style = null;
                CellStyle cellStyle = new CellStyle();
                String parentName = null;
                if (styleObject instanceof JSONObject) {
                    style = (JSONObject)styleObject;
                    parentName = style.getString("parentName");
                    if (HRStringUtils.isNotEmpty((String)parentName)) {
                        style = (JSONObject)stylesMap.get(parentName);
                        cellStyle.setParentName(parentName);
                    }
                } else if (styleObject instanceof String && HRStringUtils.isNotEmpty((String)(parentName = (String)styleObject))) {
                    style = (JSONObject)stylesMap.get(parentName);
                    cellStyle.setParentName(parentName);
                }
                if (!Objects.nonNull(style)) continue;
                JSONObject borderLeft = style.getJSONObject("borderLeft");
                JSONObject borderRight = style.getJSONObject("borderRight");
                JSONObject borderTop = style.getJSONObject("borderTop");
                JSONObject borderBottom = style.getJSONObject("borderBottom");
                String[] borderStyles = DataTableManager.getBorderStyle(borderTop, borderRight, borderBottom, borderLeft);
                cellStyle.setBorderStyles(borderStyles);
                String[] borderColors = DataTableManager.getColorStyle(borderTop, borderRight, borderBottom, borderLeft);
                cellStyle.setBorderColors(borderColors);
                cellStyle.setBackColor(style.getString("backColor"));
                if (HRStringUtils.isNotEmpty((String)parentName)) {
                    cellStyle.setBorderTop(borderTop);
                    cellStyle.setBorderRight(borderRight);
                    cellStyle.setBorderBottom(borderBottom);
                    cellStyle.setBorderLeft(borderLeft);
                }
                cell.setCellStyle(cellStyle);
            }
            this.table.add(cols);
        }
    }

    public static Map<String, Object> nameStyleToStyle(JSONArray nameStyles) {
        HashMap stylesMap = Maps.newHashMapWithExpectedSize((int)(HRCollUtil.isNotEmpty((Collection)nameStyles) ? nameStyles.size() : 16));
        if (HRCollUtil.isNotEmpty((Collection)nameStyles)) {
            for (Object nameStyle : nameStyles) {
                JSONObject styleJson = (JSONObject)nameStyle;
                stylesMap.put(styleJson.getString("name"), styleJson);
            }
        }
        return stylesMap;
    }

    public static String[] getColorStyle(JSONObject borderTop, JSONObject borderRight, JSONObject borderBottom, JSONObject borderLeft) {
        String[] borderColors = new String[4];
        DataTableManager.setSideBorderColor(borderColors, borderTop, 0);
        DataTableManager.setSideBorderColor(borderColors, borderRight, 1);
        DataTableManager.setSideBorderColor(borderColors, borderBottom, 2);
        DataTableManager.setSideBorderColor(borderColors, borderLeft, 3);
        return borderColors;
    }

    public static String[] getBorderStyle(JSONObject borderTop, JSONObject borderRight, JSONObject borderBottom, JSONObject borderLeft) {
        String[] borderStyles = new String[4];
        DataTableManager.setSideBorderStyle(borderStyles, borderTop, 0);
        DataTableManager.setSideBorderStyle(borderStyles, borderRight, 1);
        DataTableManager.setSideBorderStyle(borderStyles, borderBottom, 2);
        DataTableManager.setSideBorderStyle(borderStyles, borderLeft, 3);
        return borderStyles;
    }

    private static void setSideBorderStyle(String[] borderStyles, JSONObject oneBorder, int index) {
        borderStyles[index] = Objects.isNull(oneBorder) || oneBorder.getInteger("style") == null ? BorderTypeEnum.EMPTY.getType() : BorderTypeEnum.getBorderTypeByStyle(oneBorder.getInteger("style")).getType();
    }

    private static void setSideBorderColor(String[] borderColors, JSONObject oneBorder, int index) {
        borderColors[index] = Objects.isNull(oneBorder) || HRStringUtils.isEmpty((String)oneBorder.getString("color")) ? "#00000000" : oneBorder.getString("color");
    }

    public Cell getCell(int row, int col) {
        return this.getCell(row, col, true);
    }

    public Cell getCell(int row, int col, boolean isCreated) {
        Cell cell = null;
        if (Objects.isNull(this.table)) {
            return null;
        }
        if (isCreated) {
            this.ensureCapacity(row, col);
            cell = this.table.get(row).get(col);
            if (cell == null) {
                if (isCreated) {
                    cell = this.createCell(true);
                    this.table.get(row).set(col, cell);
                    cell.setRowAndCol(row, col);
                }
            } else {
                cell.setRowAndCol(row, col);
            }
        } else if (row <= this.table.size() - 1) {
            List<Cell> cells = this.table.get(row);
            if (cells == null || cells.isEmpty()) {
                return cell;
            }
            if (col <= cells.size() - 1 && (cell = cells.get(col)) != null) {
                cell.setRowAndCol(row, col);
            }
        }
        return cell;
    }

    private Cell createCell(boolean isCreated) {
        return isCreated ? new Cell() : null;
    }

    private void ensureCapacity(int row, int col) {
        int maxrow = this.getMaxRowCount();
        int maxcol = this.getMaxColumnCount();
        if (row > maxrow - 1) {
            this.autoGrowRows(row - maxrow + 1);
        }
        if (col > maxcol - 1) {
            this.autoGrowCols(col - maxcol + 1);
        }
    }

    private void autoGrowRows(int rowCount) {
        this.addRows(rowCount);
    }

    private void autoGrowCols(int colCount) {
        this.addColumns(colCount);
    }

    public void addColumns(int colCount) {
        for (List<Cell> row : this.table) {
            for (int i = 0; i < colCount; ++i) {
                row.add(this.createCell(false));
            }
        }
        this.checkSize();
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
        this.checkSize();
    }

    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    public void checkSize() {
        int col;
        int row;
        if (!this.table.isEmpty() && (long)(row = this.table.size()) * (long)(col = this.table.get(0).size()) > 999999L) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u91cf\u8d85\u8fc7\u8bbe\u7f6e\u4e0a\u9650%s\u5355\u5143\u683c,\u65e0\u6cd5\u52a0\u8f7d\u8bf7\u786e\u8ba4\u573a\u666f\u662f\u5426\u5408\u7406\u3002", (String)"SheetManager_1", (String)"sihc-soehrr-common", (Object[])new Object[0]), 999999L));
        }
    }

    private List<Cell> extendSameColCountAtOneRow() {
        ArrayList<Cell> cols = new ArrayList<Cell>(this.getMaxColumnCount());
        if (this.getMaxColumnCount() > 0) {
            for (int i = 0; i < this.getMaxColumnCount(); ++i) {
                cols.add(this.createCell(false));
            }
        }
        return cols;
    }

    public int getMaxRowCount() {
        return Math.max(this.table.size(), 0);
    }

    public int getMaxColumnCount() {
        return this.table.size() > 0 ? this.table.get(0).size() : 0;
    }

    public List<Cell> getRow(int rowIndex) {
        return this.getRow(rowIndex, false);
    }

    public List<Cell> getRow(int rowIndex, boolean isCreateNew) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorRowRangeCells(rowIndex, rowIndex, isCreateNew, cell -> cells.add((Cell)cell));
        return cells;
    }

    public void iteratorRowRangeCells(int fromRow, int endRow, boolean isCreateNew, Consumer<Cell> consumer) {
        for (int r = fromRow; r <= endRow; ++r) {
            int colIdx = 0;
            for (Cell cell : this.table.get(r)) {
                if (cell != null) {
                    cell.setRowAndCol(r, colIdx);
                    consumer.accept(cell);
                } else if (isCreateNew) {
                    cell = this.getCell(r, colIdx);
                    consumer.accept(cell);
                }
                ++colIdx;
            }
        }
    }

    public List<List<Cell>> getTable() {
        return this.table;
    }

    public void setTable(List<List<Cell>> table) {
        this.table = table;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void loadTable() {
        if (this.table == null) {
            this.table = Lists.newArrayListWithExpectedSize((int)10);
        }
    }

    public void deleteCol(int index) {
        if (this.table == null) {
            return;
        }
        for (List<Cell> cells : this.table) {
            Iterator<Cell> iterator = cells.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (count == index) {
                    iterator.remove();
                }
                ++count;
            }
        }
    }

    public void deleteRow(int index) {
        if (this.table == null) {
            return;
        }
        Iterator<List<Cell>> iterator = this.table.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (count == index) {
                iterator.remove();
            }
            ++count;
        }
    }

    public void insertRow(int index) {
        if (this.table == null) {
            return;
        }
        if (index >= this.table.size()) {
            this.addRows(index - this.table.size());
        } else {
            List<Cell> tableRow = this.table.get(index);
            ArrayList newRow = Lists.newArrayListWithExpectedSize((int)tableRow.size());
            for (int i = 0; i < tableRow.size(); ++i) {
                Cell newCell = new Cell();
                newRow.add(newCell);
            }
            this.table.add(index, newRow);
        }
    }

    public void insertCol(int index) {
        if (this.table == null) {
            return;
        }
        for (List<Cell> row : this.table) {
            row.add(index, new Cell());
        }
    }

    public void refreshTable() {
        for (int row = 0; row < this.table.size(); ++row) {
            List<Cell> cells = this.table.get(row);
            for (int col = 0; col < cells.size(); ++col) {
                Cell cell = cells.get(col);
                if (null == cell) {
                    cell = new Cell();
                }
                cell.setRowAndCol(row, col);
            }
        }
    }
}

