/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.spread;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.areaconf.RptAreaConfService;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.DataTableManager;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.SupportGZip;
import org.jetbrains.annotations.NotNull;

public class SheetManager
implements Serializable,
SupportGZip,
Iterable<DataTableManager> {
    private static final long serialVersionUID = -5492464289021543561L;
    private List<DataTableManager> sheets = Lists.newArrayListWithExpectedSize((int)10);
    private AreaSettingDto relationDto;
    private List<List<Cell>> highlightArea;
    private Map<AreaSettingEnum, RptAreaConf> rptAreaConfMapping = RptAreaConfService.ins().initRptAreaConf();
    private String selectNowSheetName;
    private JSONArray nameStyles;

    public SheetManager(String sheetName) {
        this.selectNowSheetName = sheetName;
        this.addSheet(sheetName);
        DataTableManager dataTableManager = this.getSheet(sheetName);
        dataTableManager.loadTable();
    }

    public SheetManager(String sheetName, boolean loadTable) {
        this.selectNowSheetName = sheetName;
        this.addSheet(sheetName);
        if (loadTable) {
            DataTableManager dataTableManager = this.getSheet(sheetName);
            dataTableManager.loadTable();
        }
    }

    public SheetManager(String sheetName, String compressSpreadJson) {
        this.addSheet(sheetName);
        DataTableManager dataTableManager = this.getSheet(sheetName);
        String uncompressJson = GzipTools.uncompressJson(compressSpreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
        dataTableManager.parseJsonTableData(spreadJsonObject, nameStyles);
        this.selectNowSheetName = sheetName;
        this.nameStyles = nameStyles;
    }

    public SheetManager(String sheetName, JSONObject spreadJsonObject) {
        this.addSheet(sheetName);
        DataTableManager dataTableManager = this.getSheet(sheetName);
        JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
        dataTableManager.parseJsonTableData(spreadJsonObject, nameStyles);
        this.selectNowSheetName = sheetName;
        this.nameStyles = nameStyles;
    }

    public SheetManager(List<String> sheetNames, JSONObject spreadJsonObject) {
        for (String sheetName : sheetNames) {
            this.addSheet(sheetName);
        }
        this.selectNowSheetName = SpreadJsonHelper.getSelectedSheetName(spreadJsonObject);
    }

    public SheetManager() {
    }

    public void selectSheet(String selectNowSheetName) {
        this.selectNowSheetName = selectNowSheetName;
    }

    public final DataTableManager getSheet(String sheetName) {
        for (DataTableManager dataTableManager : this.sheets) {
            if (!HRStringUtils.equals((String)sheetName, (String)dataTableManager.getSheetName())) continue;
            return dataTableManager;
        }
        return new DataTableManager(sheetName);
    }

    public int getSheetsCount() {
        return this.sheets.size();
    }

    public void removeDataTableManager(String sheetName) {
        this.sheets.removeIf(sheet -> HRStringUtils.equals((String)sheet.getSheetName(), (String)sheetName));
    }

    private void addSheet(String sheetName) {
        if (this.sheets.size() == 0) {
            this.selectNowSheetName = sheetName;
        }
        this.sheets.add(new DataTableManager(sheetName));
    }

    public void addSheet(String sheetName, String spreadCompressJson) {
        if (this.sheets.size() == 0) {
            this.selectNowSheetName = sheetName;
        }
        DataTableManager dataTableManager = this.getSheet(sheetName);
        String uncompressJson = GzipTools.uncompressJson(spreadCompressJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
        dataTableManager.parseJsonTableData(spreadJsonObject, nameStyles);
        this.nameStyles = nameStyles;
    }

    @Override
    @NotNull
    public Iterator<DataTableManager> iterator() {
        return this.sheets.iterator();
    }

    public String serializedStr() {
        return GzipTools.toByteSerialized(this);
    }

    public static SheetManager getSheetFromJsonStr(String compressSheetStr) {
        if (HRStringUtils.isEmpty((String)compressSheetStr)) {
            return null;
        }
        return (SheetManager)GzipTools.deSerializedBytes(compressSheetStr);
    }

    public static SheetManager getSheetFromView(IFormView formView) {
        String sheetStr = formView.getPageCache().get("spread_table_data_cache");
        return SheetManager.getSheetFromJsonStr(sheetStr);
    }

    public void setSheetCache(IPageCache pageCache) {
        pageCache.put("spread_table_data_cache", this.serializedStr());
    }

    public void setSheetCache(IFormView view) {
        view.getPageCache().put("spread_table_data_cache", this.serializedStr());
    }

    public AreaSettingDto getRelationDto() {
        return this.relationDto;
    }

    public void setRelationDto(AreaSettingDto relationDto) {
        this.relationDto = relationDto;
    }

    public void clearRelation(IFormView formView) {
        this.setRelationDto(null);
        this.setSheetCache(formView.getPageCache());
    }

    public void clearHighlightArea(IFormView formView) {
        this.setHighlightArea(null);
        this.setSheetCache(formView.getPageCache());
    }

    private void setHighlightArea(List<List<Cell>> highlightArea) {
        this.highlightArea = highlightArea;
    }

    public List<List<Cell>> getHighlightArea() {
        return this.highlightArea;
    }

    public List<List<Cell>> parseHighlightArea(SpreadSelector highlightArea) {
        DataTableManager dataTableManager = this.getSelectDataTable();
        ArrayList highlights = Lists.newArrayListWithExpectedSize((int)highlightArea.getSpanRow());
        for (int i = highlightArea.getStartRow(); i <= highlightArea.getEndRow(); ++i) {
            ArrayList row = Lists.newArrayListWithExpectedSize((int)highlightArea.getSpanCol());
            for (int j = highlightArea.getStartCol(); j <= highlightArea.getEndCol(); ++j) {
                Cell cell = dataTableManager.getCell(i, j);
                row.add(cell);
            }
            highlights.add(row);
        }
        this.highlightArea = highlights;
        return this.highlightArea;
    }

    public DataTableManager getSelectDataTable() {
        return this.getSheet(this.selectNowSheetName);
    }

    public RptAreaConf areaConf(AreaSettingEnum areaSettingEnum) {
        RptAreaConf areaConf = this.rptAreaConfMapping.get((Object)areaSettingEnum);
        if (Objects.isNull(areaConf)) {
            RptAreaConf defaultConf = new RptAreaConf();
            defaultConf.setAreaSettingEnum(areaSettingEnum);
            defaultConf.setBakColor(areaSettingEnum.getColor());
            return defaultConf;
        }
        return areaConf;
    }

    public CacheObjInvoker getInvoker() {
        DataTableManager dataTableManager = this.getSelectDataTable();
        return dataTableManager.getInvoker();
    }

    public CacheObjInvoker getInvokerByName(String sheetName) {
        DataTableManager dataTableManager = this.getSheet(sheetName);
        return dataTableManager.getInvoker();
    }

    public List<DataTableManager> getDataTableManagers() {
        return this.sheets;
    }

    public Cell getCell(int row, int col) {
        DataTableManager dataTableManager = this.getSelectDataTable();
        return dataTableManager.getCell(row, col);
    }

    public JSONArray getNameStyles() {
        return this.nameStyles;
    }

    public void setNameStyles(JSONArray nameStyles) {
        this.nameStyles = nameStyles;
    }

    public void setRptAreaConfMapping(Map<AreaSettingEnum, RptAreaConf> rptAreaConfMapping) {
        this.rptAreaConfMapping = rptAreaConfMapping;
    }

    public void updateSheetName(String oldNumber, String newNumber) {
        DataTableManager sheet = this.getSheet(oldNumber);
        if (Objects.nonNull(sheet)) {
            sheet.setSheetName(newNumber);
        }
        if (HRStringUtils.equals((String)oldNumber, (String)this.selectNowSheetName)) {
            this.selectNowSheetName = newNumber;
        }
    }

    public void parseSelectStyle(String spreadJson) {
        JSONArray nameStyles;
        DataTableManager selectDataTable = this.getSelectDataTable();
        String uncompressJson = GzipTools.uncompressJson(spreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        this.nameStyles = nameStyles = spreadJsonObject.getJSONArray("namedStyles");
        JSONObject dataTable = SpreadJsonHelper.getDataTable(spreadJsonObject, selectDataTable.getSheetName());
        selectDataTable.parseJsonData(dataTable, nameStyles);
    }

    public void removeSheetManager(IFormView view) {
        view.getPageCache().remove("spread_table_data_cache");
    }

    public void clearAllCache() {
        for (DataTableManager sheet : this.sheets) {
            sheet.getInvoker().clearCache();
        }
    }

    public List<? extends ReportCacheDto> getAllSheetRuleByEntity(String entityId) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (DataTableManager sheet : this.sheets) {
            CacheObjInvoker invoker = sheet.getInvoker();
            List<ReportCacheDto> allEnableByEntityId = invoker.getAllEnableByEntityId(entityId);
            result.addAll(allEnableByEntityId);
        }
        return result;
    }
}

