/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.spread;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.ToStringHelper;

public class SpreadSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int startRow = -1;
    private int startCol = -1;
    private int endRow = -1;
    private int endCol = -1;
    private int spanRow = -1;
    private int spanCol = -1;
    private List<Map<String, Integer>> selections;

    public SpreadSelector(int startRow, int startCol, int endRow, int endCol, int spanRow, int spanCol) {
        this.startRow = Math.max(startRow, 0);
        this.startCol = Math.max(startCol, 0);
        this.endRow = Math.max(endRow, 0);
        this.endCol = Math.max(endCol, 0);
        this.spanRow = Math.max(spanRow, 0);
        this.spanCol = Math.max(spanCol, 0);
    }

    public SpreadSelector(String areaPointStr) {
        Object[] areaArr = areaPointStr.split(":");
        if (HRArrayUtils.isEmpty((Object[])areaArr) || areaArr.length != 4) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.PARAM_ERROR.getName(), "areaPointStr")});
        }
        int r = Integer.parseInt((String)areaArr[0]);
        int c = Integer.parseInt((String)areaArr[1]);
        int rc = Integer.parseInt((String)areaArr[2]);
        int cc = Integer.parseInt((String)areaArr[3]);
        int endR = rc + r - 1;
        int endC = cc + c - 1;
        this.startRow = r;
        this.startCol = c;
        this.spanRow = rc;
        this.spanCol = cc;
        this.endRow = endR;
        this.endCol = endC;
    }

    public SpreadSelector(int startRow, int startCol, int endRow, int endCol) {
        this.startRow = startRow;
        this.startCol = startCol;
        this.endRow = endRow;
        this.endCol = endCol;
        this.spanRow = endRow - startRow + 1;
        this.spanCol = endCol - startCol + 1;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public int getSpanRow() {
        return this.spanRow;
    }

    public void setSpanRow(int spanRow) {
        this.spanRow = spanRow;
    }

    public int getSpanCol() {
        return this.spanCol;
    }

    public void setSpanCol(int spanCol) {
        this.spanCol = spanCol;
    }

    public boolean isMultiSelectCells() {
        return this.startRow != this.endRow || this.startCol != this.endCol;
    }

    public String getRangePosition() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }

    public String getEndPosition() {
        return ExcelUtils.xy2Pos(this.endCol, this.endRow);
    }

    public String getStartPosition() {
        return ExcelUtils.xy2Pos(this.startCol, this.startRow);
    }

    public boolean checkIsInArea(SpreadSelector spreadSelector) {
        return this.startRow >= spreadSelector.startRow && this.startCol >= spreadSelector.startCol && this.endRow <= spreadSelector.endRow && this.endCol <= spreadSelector.endCol;
    }

    public List<AreaSettingDto> getListInArea(List<AreaSettingDto> dataAreas) {
        ArrayList inAreaList = Lists.newArrayListWithExpectedSize((int)10);
        for (AreaSettingDto dataArea : dataAreas) {
            boolean isInArea = this.checkIsInArea(dataArea.convert2Selector());
            if (!isInArea) continue;
            inAreaList.add(dataArea);
        }
        return inAreaList;
    }

    public boolean checkIsIntersectArea(SpreadSelector spreadSelector) {
        if (this.endCol < spreadSelector.startCol || this.startCol > spreadSelector.endCol) {
            return false;
        }
        return this.endRow >= spreadSelector.startRow && this.startRow <= spreadSelector.endRow;
    }

    public boolean isAdjacentEqualSides(SpreadSelector spreadSelector) {
        if (this.startRow == spreadSelector.startRow && this.endRow == spreadSelector.endRow) {
            if (this.endCol == spreadSelector.startCol - 1) {
                return true;
            }
            if (this.startCol == spreadSelector.endCol + 1) {
                return true;
            }
        } else if (this.startCol == spreadSelector.startCol && this.endCol == spreadSelector.endCol) {
            if (this.startRow == spreadSelector.startRow - 1) {
                return true;
            }
            if (this.startRow == spreadSelector.endRow + 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isRowAdjacent(SpreadSelector spreadSelector) {
        if (this.startRow == spreadSelector.getStartRow()) {
            return true;
        }
        return this.endRow == spreadSelector.getStartRow();
    }

    public boolean checkIfSameLength(SpreadSelector spreadSelector) {
        return this.startCol == spreadSelector.getStartCol() && this.endCol == spreadSelector.getEndCol();
    }

    public boolean checkIsParallelArea(SpreadSelector spreadSelector) {
        return this.spanRow == spreadSelector.spanRow && this.spanCol == spreadSelector.spanCol;
    }

    public SpreadSelector calculateMergedRectangle(SpreadSelector spreadSelector) {
        int mergedStartRow = Math.min(this.startRow, spreadSelector.startRow);
        int mergedStartCol = Math.min(this.startCol, spreadSelector.startCol);
        int mergedEndRow = Math.max(this.endRow, spreadSelector.endRow);
        int mergedEndCol = Math.max(this.endCol, spreadSelector.endCol);
        SpreadSelector selector = new SpreadSelector(mergedStartRow, mergedStartCol, mergedEndRow, mergedEndCol, mergedEndRow - mergedStartRow + 1, mergedEndCol - mergedStartCol + 1);
        return selector;
    }

    public String getAreaPointStr() {
        return this.startRow + ":" + this.startCol + ":" + this.spanRow + ":" + this.spanCol;
    }

    public String getRect() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }

    public int hashCode() {
        return Integer.parseInt(this.startRow + "" + this.startCol + "" + this.endRow + "" + this.endCol);
    }

    public String toString() {
        return ToStringHelper.deepToString(this);
    }

    public List<Map<String, Integer>> getSelections() {
        return this.selections;
    }

    public void setSelections(List<Map<String, Integer>> selections) {
        this.selections = selections;
    }

    public Integer[] getSelectionsRows() {
        if (Objects.isNull(this.selections)) {
            return new Integer[]{this.getStartRow()};
        }
        Integer[] rows = new Integer[this.selections.size()];
        int i = 0;
        for (Map<String, Integer> select : this.selections) {
            rows[i++] = select.get("row");
        }
        return rows;
    }

    public Integer[] getSelectionsCols() {
        if (Objects.isNull(this.selections)) {
            return new Integer[]{this.getStartCol()};
        }
        Integer[] cols = new Integer[this.selections.size()];
        int i = 0;
        for (Map<String, Integer> select : this.selections) {
            cols[i++] = select.get("col");
        }
        return cols;
    }

    public boolean equals(Object obj) {
        return obj instanceof SpreadSelector && ((SpreadSelector)obj).startRow == this.startRow && ((SpreadSelector)obj).startCol == this.startCol && ((SpreadSelector)obj).endRow == this.endRow && ((SpreadSelector)obj).endCol == this.endCol;
    }

    public SpreadSelector getLeftTopPoint() {
        return new SpreadSelector(this.startRow, this.startCol, this.startRow, this.startCol, 1, 1);
    }

    public boolean isIntersectRowAndCol(Integer[] rowOrCols) {
        Integer[] integerArray = rowOrCols;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int rowOrCol = integerArray[i];
            if (this.startRow < rowOrCol || this.endRow > rowOrCol) continue;
            return true;
        }
        return false;
    }

    public List<Cell> toCellList() {
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)10);
        for (int row = this.startRow; row <= this.endRow; ++row) {
            for (int col = this.startCol; col <= this.endCol; ++col) {
                Cell cell = new Cell(row, col);
                cells.add(cell);
            }
        }
        return cells;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }

    public String getAreaPoint() {
        return this.getStartRow() + ":" + this.getStartCol() + ":" + this.getSpanRow() + ":" + this.getSpanCol();
    }
}

