/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sihc.soehrr.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class GzipTools {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog(GzipTools.class);

    public static byte[] compress(String str) {
        return GzipTools.compress(str, GZIP_ENCODE_UTF_8);
    }

    public static byte[] compress(String str, String encoding) {
        if (str != null && str.length() != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gzip = new GZIPOutputStream(out);
                gzip.write(str.getBytes(encoding));
                gzip.close();
            }
            catch (IOException var5) {
                throw new RuntimeException("gzip compress error.", var5);
            }
            return out.toByteArray();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompress(byte[] bytes) {
        if (bytes != null && bytes.length != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            GZIPInputStream ungzip = null;
            try {
                try {
                    int n;
                    ungzip = new GZIPInputStream(in);
                    byte[] buffer = new byte[256];
                    while ((n = ungzip.read(buffer)) >= 0) {
                        out.write(buffer, 0, n);
                    }
                }
                catch (IOException var6) {
                    throw new RuntimeException("gzip uncompress error.", var6);
                }
            }
            catch (RuntimeException exception) {
                LOG.error("uncompress ", (Throwable)exception);
            }
            finally {
                try {
                    out.close();
                    in.close();
                    if (ungzip != null) {
                        ungzip.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return out.toByteArray();
        }
        return null;
    }

    public static String uncompressToString(byte[] bytes) {
        return GzipTools.uncompressToString(bytes, GZIP_ENCODE_UTF_8);
    }

    public static String uncompressToString(byte[] bytes, String encoding) {
        if (bytes != null && bytes.length != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                int n;
                GZIPInputStream ungzip = new GZIPInputStream(in);
                byte[] buffer = new byte[256];
                while ((n = ungzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
                return out.toString(encoding);
            }
            catch (IOException var7) {
                throw new RuntimeException("gzip uncompress to string error.", var7);
            }
        }
        return null;
    }

    public static String uncompressJson(String json) {
        if (json.startsWith("#gzip#")) {
            json = json.substring("#gzip#".length());
        }
        if (json.length() < 6) {
            return json;
        }
        String base64 = json.substring(0, 6);
        if ("base64".equalsIgnoreCase(base64)) {
            json = json.substring(6);
        }
        long now = System.currentTimeMillis();
        String str = new String(GzipTools.uncompress(Base64.getDecoder().decode(json)));
        LOG.info("GzipTools.uncompressJson length {} use {}", (Object)json.length(), (Object)(System.currentTimeMillis() - now));
        return str;
    }

    public static String compressJson(String str) {
        long now = System.currentTimeMillis();
        String str1 = "base64" + new String(Base64.getEncoder().encode(GzipTools.compress(str)));
        LOG.info("GzipTools.uncompressJson length {} use {}", (Object)str.length(), (Object)(System.currentTimeMillis() - now));
        return str1;
    }

    public static JSONObject transSpreadJsonToObj(String json) {
        String uncompressStr = new String(GzipTools.uncompress(Base64.getDecoder().decode(json.substring(6))));
        return (JSONObject)JSON.parse((String)uncompressStr);
    }

    public static String transObjToSpreadJson(JSONObject object) {
        String json = JSON.toJSONString((Object)object);
        GzipTools.compress(Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8)));
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String toByteSerialized(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T deSerializedBytes(String serial) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String compress4GZip(String source) {
        if (StringUtils.isBlank((String)source)) {
            return source;
        }
        return "#gzip#" + GzipTools.compressJson(source);
    }
}

