/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.sit.sitbp.service.spi;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extension.ExtensionFactory;
import kd.bos.ksql.util.StringUtil;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.sdk.sit.hcsi.common.entity.basecal.BaseCalParam;
import kd.sdk.sit.sitbp.entity.Pair;

public interface SInsurCalItemUniCodeResolver {
    public static final SInsurCalItemUniCodeResolver DEFAULT = new SInsurCalItemUniCodeResolver(){

        @Override
        public String prefix() {
            return SInsurCalItemUniCodeResolver.DEFAULT_TYPE;
        }
    };
    public static final String SPLIT = "_$_";
    public static final String DEFAULT_TYPE = "$";
    public static final String PREFIX_BASE_FETCH_ITEM = "FI";
    public static final String PREFIX_BASE_INFO = "IB";
    public static final String PREFIX_EDC_EXP = "EE";
    public static final String PREFIX_EMP_EXP = "PE";
    public static final String PREFIX_SINSUR_FILE = "FB";
    public static final String PREFIX_HR_PERSON = "BP";
    public static final String PREFIX_SINSUR_ITEM = "II";
    public static final String PREFIX_JOB_LEVEL = "JL";
    public static final String PREFIX_OCC_INFO = "OC";
    public static final String PREFIX_PERSON_BASE = "IP";

    public static SInsurCalItemUniCodeResolver getResolverBy(String prefix) {
        if (StringUtil.isEmpty((String)prefix)) {
            return DEFAULT;
        }
        if (DEFAULT_TYPE.equals(prefix)) {
            // empty if block
        }
        ExtensionFactory factory = ExtensionFactory.getExtensionFacotry(SInsurCalItemUniCodeResolver.class);
        return (SInsurCalItemUniCodeResolver)factory.getExtension(prefix);
    }

    public static Pair<String, String> bizCode(String uniCode) {
        String bizCode;
        String type;
        int index = uniCode.indexOf(SPLIT);
        if (index <= 0) {
            type = DEFAULT_TYPE;
            bizCode = uniCode;
        } else {
            type = uniCode.substring(0, index);
            bizCode = uniCode.substring(index + SPLIT.length());
        }
        bizCode = SInsurCalItemUniCodeResolver.getResolverBy(type).decode(bizCode);
        return new Pair<String, String>(type, bizCode);
    }

    default public String uniCode(String bizCode) {
        return this.prefix() + SPLIT + this.encode(bizCode);
    }

    default public String encode(String bizCode) {
        return bizCode;
    }

    default public String decode(String bizCode) {
        return bizCode;
    }

    public String prefix();

    default public void fecthData(Map<String, Map<String, Object>> paramIdToParamMap, Map<Long, Map<String, String>> errMap, DynamicObjectCollection files, Set<String> fields, Date bsed) {
    }

    default public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> itemKeys, Map<String, CalItemVO> uniqueCodeCalItemMap, BaseCalParam param) {
    }

    default public String getUnicodeName(String unicode) {
        return unicode;
    }
}

