/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.swc.hcdm.common.stdtab;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(value={"stdContrastArrValue", "stdContrastData", "gradeRankRangeDBEntity"})
public class ContrastRowDataEntity
implements Cloneable {
    private int rowIndex;
    private transient List<ContrastPropEntity> props;
    @JsonIgnore
    private transient List<List<Long>> stdContrastValArr;
    @Deprecated
    private List<GradeRankKey> gradeRankKeys;
    @Deprecated
    private List<ContrastDataEntity> gradeRankDataList;
    private String gradeRankRangeDBVal;
    private String stdPropValueDBVal;
    private transient Map<Long, List<Long>> stdContrastData;
    @JSONField(serialize=false, deserialize=false)
    private transient GradeRankRangeDBEntity gradeRankRangeDBEntity;
    private int dataStatus;

    public ContrastRowDataEntity() {
    }

    public ContrastRowDataEntity(int rowIndex, List<List<Long>> stdContrastDataIds, List<GradeRankKey> gradeRankKeys, List<ContrastDataEntity> gradeRankDataList, int dataStatus) {
        this.rowIndex = rowIndex;
        this.stdContrastValArr = stdContrastDataIds;
        this.gradeRankKeys = gradeRankKeys;
        this.gradeRankDataList = gradeRankDataList;
        this.dataStatus = dataStatus;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public List<List<Long>> getStdContrastArrValue() {
        if (this.stdContrastValArr != null) {
            return this.stdContrastValArr;
        }
        Map<Long, List<Long>> stdPropValueMap = this.getStdPropValueMap();
        this.stdContrastValArr = this.props.stream().map(prop -> stdPropValueMap.getOrDefault(prop.getPropConfigId(), Lists.newArrayList())).collect(Collectors.toList());
        return this.stdContrastValArr;
    }

    public void setStdContrastArrValue(List<List<Long>> stdContrastArrValue) {
        this.stdContrastValArr = stdContrastArrValue;
    }

    public List<ContrastDataEntity> getGradeRankDataList() {
        return this.gradeRankDataList;
    }

    public void setGradeRankDataList(List<ContrastDataEntity> gradeRankDataList) {
        this.gradeRankDataList = gradeRankDataList;
    }

    public int getDataStatus() {
        return this.dataStatus;
    }

    public void setDataStatus(int dataStatus) {
        this.dataStatus = dataStatus;
    }

    public List<GradeRankKey> getGradeRankKeys() {
        return this.gradeRankKeys;
    }

    public void setGradeRankKeys(List<GradeRankKey> gradeRankKeys) {
        this.gradeRankKeys = gradeRankKeys;
    }

    public Object clone() throws CloneNotSupportedException {
        ContrastRowDataEntity rowDataEntity = new ContrastRowDataEntity();
        if (this.getStdContrastArrValue() != null) {
            ArrayList copy = Lists.newArrayListWithExpectedSize((int)this.getStdContrastArrValue().size());
            for (int i = 0; i < this.getStdContrastArrValue().size(); ++i) {
                copy.add(Lists.newArrayList((Iterable)this.getStdContrastArrValue().get(i)));
            }
            rowDataEntity.setStdContrastArrValue(copy);
        }
        rowDataEntity.setProps(this.props);
        rowDataEntity.setDataStatus(this.dataStatus);
        rowDataEntity.setRowIndex(this.rowIndex);
        rowDataEntity.setGradeRankRangeDBVal(this.gradeRankRangeDBVal);
        return rowDataEntity;
    }

    public GradeRankRangeDBEntity getGradeRankRangeDBEntity() {
        if (this.gradeRankRangeDBEntity != null) {
            return this.gradeRankRangeDBEntity;
        }
        if (StringUtils.isBlank((CharSequence)this.gradeRankRangeDBVal)) {
            return null;
        }
        this.gradeRankRangeDBEntity = (GradeRankRangeDBEntity)JSON.parseObject((String)this.gradeRankRangeDBVal, GradeRankRangeDBEntity.class);
        return this.gradeRankRangeDBEntity;
    }

    public void setGradeRankRangeDBEntity(GradeRankRangeDBEntity gradeRankRangeDBEntity) {
        this.gradeRankRangeDBEntity = gradeRankRangeDBEntity;
    }

    @JsonIgnore
    public List<GradeRankValue> getRangeCode() {
        if (this.gradeRankRangeDBEntity == null) {
            this.gradeRankRangeDBEntity = ContrastRowDataEntity.deserializeGradeRank(this.gradeRankRangeDBVal);
        }
        if (this.gradeRankRangeDBEntity == null) {
            return Collections.emptyList();
        }
        return this.gradeRankRangeDBEntity.getRuntimeRangeCodeArr();
    }

    public List<ContrastPropEntity> getProps() {
        return this.props;
    }

    public void setProps(List<ContrastPropEntity> props) {
        this.props = props;
    }

    public String getGradeRankRangeDBVal() {
        return this.gradeRankRangeDBVal;
    }

    public void setGradeRankRangeDBVal(String gradeRankRangeDBVal) {
        this.gradeRankRangeDBVal = gradeRankRangeDBVal;
    }

    public String getStdPropValueDBVal() {
        return this.stdPropValueDBVal;
    }

    public void setStdPropValueDBVal(String stdPropValueDBVal) {
        this.stdPropValueDBVal = stdPropValueDBVal;
    }

    public void setStdContrastData(Map<Long, List<Long>> stdContrastData) {
        this.stdContrastData = stdContrastData;
    }

    @JsonIgnore
    public Map<Long, List<Long>> getStdPropValueMap() {
        if (this.stdContrastData != null) {
            return this.stdContrastData;
        }
        this.stdContrastData = ContrastRowDataEntity.deserializeStdProp(this.stdPropValueDBVal);
        return this.stdContrastData;
    }

    public void setStdPropMapFromArrValue() {
        if (CollectionUtils.isNotEmpty(this.stdContrastValArr) && this.props != null && this.stdContrastValArr.size() == this.props.size()) {
            HashMap propMap = Maps.newHashMapWithExpectedSize((int)this.props.size());
            for (int i = 0; i < this.props.size(); ++i) {
                List<Long> longs = this.stdContrastValArr.get(i);
                if (!CollectionUtils.isNotEmpty(longs)) continue;
                propMap.put(this.props.get(i).getPropConfigId(), longs);
            }
            this.stdContrastData = propMap;
        }
    }

    public void saveChange() {
        this.stdPropValueSaveChange(false);
        this.gradeRankValueSaveChange();
    }

    public void saveChangeFromArr() {
        this.stdPropValueSaveChange(true);
        this.gradeRankValueSaveChange();
    }

    private void gradeRankValueSaveChange() {
        String gradeRankRange = ContrastRowDataEntity.serializeGradeRank(this.gradeRankRangeDBEntity);
        if (StringUtils.isNotBlank((CharSequence)gradeRankRange)) {
            this.gradeRankRangeDBVal = gradeRankRange;
        }
    }

    private void stdPropValueSaveChange(boolean fromArr) {
        if (fromArr) {
            this.setStdPropMapFromArrValue();
        }
        if (MapUtils.isNotEmpty(this.stdContrastData)) {
            this.stdPropValueDBVal = ContrastRowDataEntity.serializeStdProp(this.stdContrastData);
        }
    }

    public static String serializeStdProp(Map<Long, List<Long>> stdContrastData) {
        StringJoiner stringJoiner = new StringJoiner(";");
        if (stdContrastData != null) {
            for (Map.Entry<Long, List<Long>> entry : stdContrastData.entrySet()) {
                Long propId = entry.getKey();
                if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
                String valueIdStr = StringUtils.join((Iterable)entry.getValue(), (String)",");
                String onePropStr = String.format("%d#%s", propId, valueIdStr);
                stringJoiner.add(onePropStr);
            }
        }
        return stringJoiner.toString();
    }

    public static Map<Long, List<Long>> deserializeStdProp(String stdContrastDataStr) {
        if (StringUtils.isBlank((CharSequence)stdContrastDataStr)) {
            return Collections.emptyMap();
        }
        String[] split = stdContrastDataStr.split(";");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)split.length);
        for (String splitStr : split) {
            String[] oneProp = splitStr.split("#");
            String propIdStr = oneProp[0];
            String propValueArrStr = oneProp[1];
            String[] valueIdArr = propValueArrStr.split(",");
            resultMap.put(Long.parseLong(propIdStr), Arrays.stream(valueIdArr).map(Long::valueOf).collect(Collectors.toList()));
        }
        return resultMap;
    }

    public static GradeRankRangeDBEntity deserializeGradeRank(String gradeRankRangeDBVal) {
        if (StringUtils.isBlank((CharSequence)gradeRankRangeDBVal)) {
            return null;
        }
        GradeRankRangeDBEntity gradeRankRangeDBEntity = (GradeRankRangeDBEntity)JSON.parseObject((String)gradeRankRangeDBVal, GradeRankRangeDBEntity.class);
        gradeRankRangeDBEntity.getRuntimeRangeCodeArr();
        return gradeRankRangeDBEntity;
    }

    public static String serializeGradeRank(GradeRankRangeDBEntity gradeRankRangeDBEntity) {
        if (gradeRankRangeDBEntity == null) {
            return "";
        }
        gradeRankRangeDBEntity.saveChange();
        return JSON.toJSONString((Object)gradeRankRangeDBEntity);
    }
}

