/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.swc.hcdm.common.stdtab;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(value={"rangeCodeArr"})
public class GradeRankRangeDBEntity {
    private Integer gradeNum;
    private Integer rankNum;
    private String rangeCodeString;
    private transient List<GradeRankValue> rangeCodeArr;

    public Integer getGradeNum() {
        return this.gradeNum;
    }

    public void setGradeNum(Integer gradeNum) {
        this.gradeNum = gradeNum;
    }

    public Integer getRankNum() {
        return this.rankNum;
    }

    public void setRankNum(Integer rankNum) {
        this.rankNum = rankNum;
    }

    public String getRangeCodeString() {
        return this.rangeCodeString;
    }

    public void setRangeCodeString(String rangeCodeString) {
        this.rangeCodeString = rangeCodeString;
    }

    public void setRangeCodeArr(List<GradeRankValue> rangeCodeArr) {
        this.rangeCodeArr = rangeCodeArr;
    }

    public List<GradeRankValue> getRuntimeRangeCodeArr() {
        if (this.rangeCodeArr != null) {
            return this.rangeCodeArr;
        }
        if (StringUtils.isBlank((CharSequence)this.rangeCodeString)) {
            this.rangeCodeArr = new ArrayList<GradeRankValue>(10);
            return this.rangeCodeArr;
        }
        String[] ranges = this.rangeCodeString.split(";");
        this.rangeCodeArr = Lists.newArrayListWithExpectedSize((int)ranges.length);
        for (String range : ranges) {
            String[] split = range.split("-");
            String begin = split[0];
            String end = split[1];
            this.rangeCodeArr.add(new GradeRankValue(Integer.parseInt(begin), Integer.parseInt(end)));
        }
        return this.rangeCodeArr;
    }

    public void saveChange() {
        if (this.rangeCodeArr != null) {
            StringJoiner joiner = new StringJoiner(";");
            for (GradeRankValue pair : this.rangeCodeArr) {
                String oneRange = String.format("%d-%d", pair.getBeginValue(), pair.getEndValue());
                joiner.add(oneRange);
            }
            this.rangeCodeString = joiner.toString();
        }
    }
}

