/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.swc.hsas.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.swc.hsas.common.entity.ImportEntity;

public class ImportEntityRel {
    private ImportEntity mainEntity;
    private List<ImportEntity> otherEntities;
    private boolean isReverseRef = false;

    public ImportEntityRel(ImportEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public ImportEntityRel(ImportEntity mainEntity, List<ImportEntity> otherEntities) {
        this.mainEntity = mainEntity;
        this.otherEntities = Collections.unmodifiableList(otherEntities);
    }

    public ImportEntityRel(ImportEntity mainEntity, boolean isReverseRef) {
        this.mainEntity = mainEntity;
        this.isReverseRef = isReverseRef;
    }

    public ImportEntityRel(ImportEntity mainEntity, List<ImportEntity> otherEntities, boolean isReverseRef) {
        this.mainEntity = mainEntity;
        this.otherEntities = Collections.unmodifiableList(otherEntities);
        this.isReverseRef = true;
    }

    public Map<String, DynamicObjectType> getMultiEntityDyobjType() {
        LinkedHashMap<String, DynamicObjectType> multiEntityDyobjType = new LinkedHashMap<String, DynamicObjectType>(16);
        String mainEntityId = this.mainEntity.getEntityId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityId);
        multiEntityDyobjType.put(mainEntityId, (DynamicObjectType)mainEntityType);
        for (ImportEntity otherEntity : this.otherEntities) {
            String otherEntityId = otherEntity.getEntityId();
            MainEntityType otherEntityType = EntityMetadataCache.getDataEntityType((String)otherEntityId);
            multiEntityDyobjType.put(otherEntityId, (DynamicObjectType)otherEntityType);
        }
        return multiEntityDyobjType;
    }

    public List<String> getMultiEntityIds() {
        ArrayList<String> entityIds = new ArrayList<String>(10);
        entityIds.add(this.getMainEntity().getEntityId());
        for (ImportEntity otherEntity : this.getOtherEntities()) {
            entityIds.add(otherEntity.getEntityId());
        }
        return entityIds;
    }

    public Map<String, String> getEntityOpRel() {
        HashMap<String, String> rel = new HashMap<String, String>(16);
        rel.put(this.getMainEntity().getEntityId(), this.mainEntity.getEntityOp());
        for (ImportEntity otherEntity : this.otherEntities) {
            rel.put(otherEntity.getEntityId(), otherEntity.getEntityOp());
        }
        return rel;
    }

    public Map<String, String> getParentEntityIdRel() {
        HashMap<String, String> parentEntityRel = new HashMap<String, String>(16);
        for (ImportEntity otherEntity : this.otherEntities) {
            parentEntityRel.put(otherEntity.getEntityId(), otherEntity.getParentEntityId());
        }
        return parentEntityRel;
    }

    public Map<String, String> getParentFieldIdRel() {
        HashMap<String, String> parentFieldRel = new HashMap<String, String>(16);
        for (ImportEntity otherEntity : this.otherEntities) {
            parentFieldRel.put(otherEntity.getEntityId(), otherEntity.getParentFieldId());
        }
        return parentFieldRel;
    }

    public String[] getImportEntityFieldIds(String entityId) {
        if (HRStringUtils.equals((String)this.mainEntity.getEntityId(), (String)entityId)) {
            return this.mainEntity.getFieldKey();
        }
        for (ImportEntity otherEntity : this.otherEntities) {
            if (!HRStringUtils.equals((String)otherEntity.getEntityId(), (String)entityId)) continue;
            return otherEntity.getFieldKey();
        }
        return null;
    }

    public ImportEntity getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(ImportEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public List<ImportEntity> getOtherEntities() {
        return Collections.unmodifiableList(this.otherEntities);
    }

    public void setOtherEntities(List<ImportEntity> otherEntities) {
        this.otherEntities = Collections.unmodifiableList(otherEntities);
    }

    public boolean isReverseRef() {
        return this.isReverseRef;
    }

    public void setReverseRef(boolean isReverseRef) {
        this.isReverseRef = isReverseRef;
    }

    public Map<String, Map<String, String>> getOnOffMaps() {
        HashMap<String, Map<String, String>> onOffMap = new HashMap<String, Map<String, String>>(16);
        for (ImportEntity otherEntity : this.otherEntities) {
            String otherEntityId = otherEntity.getEntityId();
            String parentEntityId = otherEntity.getParentEntityId();
            String parentOnOffField = otherEntity.getParentOnOffField();
            if (!HRStringUtils.isNotEmpty((String)parentEntityId) || !HRStringUtils.isNotEmpty((String)parentOnOffField)) continue;
            HashMap<String, String> onOffInfo = new HashMap<String, String>(1);
            onOffInfo.put(otherEntityId, parentEntityId);
            onOffInfo.put(parentEntityId, parentOnOffField);
            onOffMap.put(otherEntityId, onOffInfo);
        }
        return onOffMap;
    }

    public Map<String, ImportEntity> getAllEntity() {
        LinkedHashMap<String, ImportEntity> multiEntity = new LinkedHashMap<String, ImportEntity>(16);
        String mainEntityId = this.mainEntity.getEntityId();
        multiEntity.put(mainEntityId, this.mainEntity);
        for (ImportEntity otherEntity : this.otherEntities) {
            String otherEntityId = otherEntity.getEntityId();
            multiEntity.put(otherEntityId, otherEntity);
        }
        return multiEntity;
    }
}

