/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.swc.hsas.common.enums;

import kd.bos.dataentity.utils.StringUtils;

public enum SalaryItemTypeEnum {
    ITEMSL("itemsl", "SL", "hsbs_salaryitem", "hsas_caltableentry", "salaryitem", "textvalue", "numvalue", "datevalue", "calamountvalue", ""),
    ITEMFT("itemft", "FT", "hsbs_fetchitem", "hsas_calbcentry", "fetchitem", "bctextvalue", "bcnumvalue", "bcdatevalue", "", ""),
    ITEMSP("itemsp", "SP", "hsbs_supportitem", "hsas_calspentry", "supportitem", "sptextvalue", "spnumvalue", "spdatevalue", "", ""),
    ITEMBS("itembs", "BS", "hsbs_bizitem", "hsas_calbsentry", "bizitem", "bstextvalue", "bsnumvalue", "bsdatevalue", "bscalamountvalue", "bsoriamountvalue");

    private String code;
    private String uniqueCodePrefix;
    private String entityCode;
    private String entryCode;
    private String itemFieldCode;
    private String textFieldCode;
    private String numFieldCode;
    private String dateFieldCode;
    private String calAmountFieldCode;
    private String oriAmountFieldCode;

    private SalaryItemTypeEnum(String code, String uniqueCodePrefix, String entityCode, String entryCode, String itemFieldCode, String textFieldCode, String numFieldCode, String dateFieldCode, String calAmountFieldCode, String oriAmountFieldCode) {
        this.code = code;
        this.uniqueCodePrefix = uniqueCodePrefix;
        this.entityCode = entityCode;
        this.entryCode = entryCode;
        this.itemFieldCode = itemFieldCode;
        this.textFieldCode = textFieldCode;
        this.numFieldCode = numFieldCode;
        this.dateFieldCode = dateFieldCode;
        this.calAmountFieldCode = calAmountFieldCode;
        this.oriAmountFieldCode = oriAmountFieldCode;
    }

    public static String getCodeByEntityCode(String entityCode) {
        SalaryItemTypeEnum[] values;
        for (SalaryItemTypeEnum typeEnum : values = SalaryItemTypeEnum.values()) {
            if (!typeEnum.getEntityCode().equals(entityCode)) continue;
            return typeEnum.getCode();
        }
        return "";
    }

    public static SalaryItemTypeEnum getEnumByCode(String code) {
        SalaryItemTypeEnum[] values;
        for (SalaryItemTypeEnum typeEnum : values = SalaryItemTypeEnum.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUniqueCodePrefix() {
        return this.uniqueCodePrefix;
    }

    public void setUniqueCodePrefix(String uniqueCodePrefix) {
        this.uniqueCodePrefix = uniqueCodePrefix;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public String getEntryCode() {
        return this.entryCode;
    }

    public String getItemFieldCode() {
        return this.itemFieldCode;
    }

    public String getTextFieldCode() {
        return this.textFieldCode;
    }

    public String getNumFieldCode() {
        return this.numFieldCode;
    }

    public String getDateFieldCode() {
        return this.dateFieldCode;
    }

    public String getCalAmountFieldCode() {
        return this.calAmountFieldCode;
    }

    public String getOriAmountFieldCode() {
        return this.oriAmountFieldCode;
    }

    public String getWholeValueFieldCode(String dataType) {
        String valueFieldCode;
        String pre = this.entryCode + ".";
        switch (dataType) {
            case "text": {
                valueFieldCode = pre + this.textFieldCode;
                break;
            }
            case "date": {
                valueFieldCode = pre + this.dateFieldCode;
                break;
            }
            case "num": {
                valueFieldCode = pre + this.numFieldCode;
                break;
            }
            case "amount": {
                valueFieldCode = pre + this.calAmountFieldCode;
                break;
            }
            default: {
                valueFieldCode = "";
            }
        }
        return valueFieldCode;
    }

    public String getSelectProperties() {
        StringBuilder builder = new StringBuilder("id");
        builder.append(',').append("calpersonid");
        builder.append(',').append(this.entryCode).append('.').append(this.itemFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.textFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.numFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.dateFieldCode);
        if (StringUtils.isNotEmpty((CharSequence)this.calAmountFieldCode)) {
            builder.append(',').append(this.entryCode).append('.').append(this.calAmountFieldCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.oriAmountFieldCode)) {
            builder.append(',').append(this.entryCode).append('.').append(this.oriAmountFieldCode);
        }
        return builder.toString();
    }

    public String getWholeItemFieldCode() {
        return this.entryCode + '.' + this.itemFieldCode;
    }
}

